<?php

	require_once("Control.php");
	require_once("ClientWindow.php");
	
	class DropDownList extends Control
	{
		var $OnChange;
		var $OnClick;
		
		var $TextList = array();
		var $ValueList = array ();

		function DropDownList ($name, $parent)
		{
			parent::Control($name, $parent);
		}
		
		//////////////////////////////////////////////////
		//
		//		
		//
		function Add ( $txt, $val )
		{
		 	array_push( $this->ValueList, $val );
		 	array_push( $this->TextList, $txt );
		}
		
		//////////////////////////////////////////////////
		//
		// 		On Request - This is where 'Request' is
		//			processed. Here syncronization of
		//			controls should take place from Request
		//			to variables.
		//
		function OnRequest()
		{
			$val = $_REQUEST[ $this->FullName() ];
			if ( $this->IsPostBack() == true )
			{
				$this->Text = $val;
			}
			parent::OnRequest();
		}
			
		//////////////////////////////////////////////////
		//
		// 		On Response - This is where 'Response' is
		//			processed. Here syncronization of
		//			controls should take place from variables
		//			to Response.
		//
		function OnRenderNormal()
		{
			// print ( "<span name='$this->FullName()'>$this->Text</span>" );
			$this->OnRenderEdit();
		}
			
		function OnRenderSelect()
		{
			$this->OnRenderEdit();
		}
			
		function OnRenderEdit()
		{
			$this->OnClick="DropDownHandleClick( ".$this->FullName()." );";
			print ( "<select name='".$this->FullName()."' onchange=\"".$this->OnClick."\" class=\"DropDownStyle\" />" );

			$len = count ( $this->ValueList );
			for ( $i=0; $i <$len; $i++ )
			{
				$t = $this->TextList [ $i ];
				$v = $this->ValueList [ $i ];

				print ( "<option"." " ); print ( "value='".$v."' "); 
				print ( trim( $v ) != "" /* @see bug description below */ && $v == $this->Text ? "selected" : "" ); 
				print (">");
				print ( $t );
				print ( "</option>" );
			}
			print ( "</select>" );

			//---------------------------------------------------------------
			// Bug Description
			//---------------------------------------------------------------
			// If $v and $this->Text. both are '', then don't print selected.
			// Reason is that there were more than one values with '', and
			// only last one was selected before going through the loop.
			//
		}

		function SetSelectedValue ( $pValue )
		{
			$pValue = trim ( $pValue );

			//
			// Find the value and set it's corresponding value as Text of this control
			//
			
			$len = count ( $this->ValueList );
			for ( $i=0; $i<$len; $i++ )
			{
				$value = trim ( $this->ValueList [ $i ] );
				if ( $pValue == $value )
				{
					$this->Text = $value;
				}
			}			
		}

		function SetSelectedText ( $pText )
		{
			$pText = trim ( $pText );

			//
			// Find the test and set it's corresponding text as Text of this control
			//
			
			$len = count ( $this->TextList );
			for ( $i=0; $i<$len; $i++ )
			{
				$text = trim ( $this->TextList[ $i ] );
				if ( $pValue == $text )
				{
					$this->Text = $this->ValueList[ $i ];
				}
			}			
		}

		function SetSelectedIndex ( $index )
		{
			if ( is_integer( $index ) != true )
				return;
			
			if ( $index >= count ( $this->ValueList ) || $index < 0 )
				return;
				
			$value = trim ( $this->ValueList [ $index ] );
			$this->Text = $value;
		}
	}
	
?>

<script language="JavaScript">

	function DropDownHandleClick( dropDownList )
	{
		var selectedValue = dropDownList.options[dropDownList.selectedIndex].value;

		if ( selectedValue == "" )
		{
			dropDownList.selectedIndex = 0;
			return;
		}

		setTimeout ( "DropDownReset ( document.<?php print ( CONST_FORM_MAIN() ); ?>." + dropDownList.name + ");", 3000 );
		NewWindow( selectedValue );
	}
	
	function DropDownReset ( dropDownList )
	{
		dropDownList.selectedIndex	= 0;
	}
	
</script>

<?php

	// $txtInpt0 = new DropDownList("MyList", null);
	// $txtInpt0->Add( "", "" );
	// $txtInpt0->Add( "India", "http://www.hindustantimes.com" );
	// $txtInpt0->Add( "UK", "http://www.bbc.co.uk" );
	// $txtInpt0->Add( "China", "http://www.china.com" );
	// $txtInpt0->Add( "USA", "http://www.cnn.com" );
	// $txtInpt0->OnChange="alert ('value is change');";
	// $txtInpt0->OnChange="HandleItemChange( ".$this->FullName()." );";
	// $txtInpt0->OnRenderEdit();
	
	// $txtInpt1 = new DropDownList("MyButton");
	// $txtInpt1->Text="salim";
	// print ("<br>\n");
	// $txtInpt1->Display();
	// print ("<br>\n");
	// print ( $txtInpt1->Name );
	// print ("<br>\n");
	
	// $txtInpt2 = new DropDownList("MyButton");
	// $txtInpt2->Text="uddin";
	// print ("<br>\n");
	// $txtInpt2->Display();
	// print ("<br>\n");
	// print ( $txtInpt2->Name );
	
?>