<?php

	require_once("../Util/Constant.php");
	
	session_start();	
	
	require_once(CONST_DIR_DATA_PROTECTION()."/Control/Control.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Control/Button.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Control/LinkButton.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Util/Platform.php");
?>

<!-- ----------------------------------------------------------------
---------------------------------------------------------------------
---------------------------------------------------------------------

						DIALOG BOX

---------------------------------------------------------------------
---------------------------------------------------------------------
----------------------------------------------------------------- -->

<?php

	class DialogBox extends Control
	{
		var $btnFirst;
		var $btnSecond;
		var $btnThird;
		var $message;
		var $mode; /* info, warning, error */
		
		function DialogBox($name, $parent)
		{
			parent::Control($name, $parent);
			
			$this->btnFirst = new Button("OK", $this );
			$this->btnFirst->Text = "OK";

			$this->btnSecond = new Button("Info", $this );
			$this->btnSecond->Text = "Info";
			
			$this->btnThird = new Button("Cancel", $this );
			$this->btnThird->Text = "Cancel";
		}

		function OnRequest()
		{
			parent::OnRequest();
			
			$this->btnFirst->OnRequest();
			$this->btnSecond->OnRequest();
			$this->btnThird->OnRequest();
		}
		
		function OnRender()
		{
			parent::OnRender();
			
			if ( $this->Visible==false )
				return;
			?>
				<div style="border : 1px solid gray; width:400px">
				<?php if ( BrowserPlatform()=="Mozilla" ) { // Observe width has 4 less than in other browsers ?>
					<div style="background:darkblue; color:white; font-weight: bold; padding : 3; width:394">
				<?php } else { ?>
					<div style="background:darkblue; color:white; font-weight: bold; padding : 3; width:400">
				<?php } ?>
						<?php print ( $this->Text ) ?>
					</div>
					<div style="padding:5">
						<table border="0" cellpadding="5">
							<tr>
								<td>
									<?php
										switch ( strtolower($this->Mode) )
										{
											case "info" :
												print ( "<img src='".CONST_URL_IMAGE()."/Info.png'/>" );
												break;
											case "warning" :
												print ( "<img src='".CONST_URL_IMAGE()."/Warning.png'/>" );												
												break;
											case "error" :
												print ( "<img src='".CONST_URL_IMAGE()."/Error.png'/>" );
												break;
											default:												
										}
									?>
								</td>
								<td>
									<?php
										print ( $this->Message );
									?>
								</td>
							</tr>
						</table>
					</div>
					<div style="padding:5">
						<?php
							print ( "<div align=right>");
								
								$this->btnFirst->OnRender();
								print ( " " );
								$this->btnSecond->OnRender();
								print ( " " );
								$this->btnThird->OnRender();
								
								parent::OnRender();
								
							print ("</div>");
						?>
					</div>
				</div>
			<?php
		}
	}
	
?>

<?php

	// $dialogBox = new DialogBox("download dialog", null);
	// $dialogBox->Text = "Title";
	// $dialogBox->Message = "This is cool";
	// $dialogBox->Display();

	
?>


<!-- -----------------------------------------------------------------------
		Dialog Box : Different than above and has no relationship
			with top one. Below is a client side javascript based box
------------------------------------------------------------------------ -->
<script language="JavaScript">
	
	function OpenDialog ( message )
	{
		var win = window.open("/dataprotection/Dialog.htm","Details", "toolbar=no, address=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=yes, copyhistory=no, width=800, height=400")
		
		win.document.write ( "<html>" );
		win.document.write ( "<head>" );
		
		<?php if ( BrowserPlatform() == CONST_BROWSER_INTERNET_EXPLORER() ) { ?>
			win.document.write ( "<link rel='stylesheet' type='text/css' href='../StyleSheet.css'>" );
		<?php } ?>

		win.document.write ( "<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>" );
		win.document.write ( "</head>" );	
		win.document.write ( "<body>" );		
		
		win.document.write ( message );
		win.document.write ( "<input style='detailStyle' type=button value='Close' onclick='window.close()' >" );
		
		win.document.write ( "</body>" );
		win.document.write ( "</html>" );
	
		win.focus();
	}
	
</script>