<?php

		require_once("../Util/Constant.php");
		require_once(CONST_DIR_DATA_PROTECTION()."/Util/Guid.php");
		require_once(CONST_DIR_DATA_PROTECTION()."/Util/String.php");
		require_once(CONST_DIR_DATA_PROTECTION()."/Util/SymbolTable.php");

		////////////////////////////////////////////////////////
		//
		// This is the fundamental base class of all controls.
		// All controls should inherit from this class
		//
		class Control 
		{
			var $Parent ;
			var $Name;
			var $Mode_		= 'normal';
			var $Text;
			var $Enabled 	= true;
			var $Visible 	= true;
			var $Width 		= -1;
			var $Height		= -1;
			var $IsInitialized = false;
			var $SymbolTable;
			
			function Control ($name, $parent)
			{
				$EnumMode = new Mode();
				
				$this->Name  = StrReplaceAll( $name, " ", "_" );
				$this->Parent = $parent;

				$this->Mode_ = $EnumMode->NORMAL;

				// Holds string id and value path. Use for multiple purposes
				// including translation and variable binding from code and 
				// xml. - Imran Salim
				$this->SymbolTable = new SymbolTable();
			}

			function IsPostBack()
			{
				$referrer = $_SERVER['HTTP_REFERER'];
				$self = $_SERVER['PHP_SELF'];
				
				if ( isset( $referrer ) && trim( $referrer ) != ""  && StrEndsWith ( $referrer, $self )==true )
					return true;
				else 
					return false;
			}
			
			function FullName()
			{
				if ( isset( $this->Parent ) == false || $this->Parent == null )
					return $this->Name."_"."root";
				else
					return $this->Name."_".$this->Parent->FullName();
			}

			//
			// Alias to FuillName() function. May be overridden by derived control
			//
			function InstanceName ()
			{
				return $this->FullName();
			}
		
			function Mangle()
			{
				print ( $this->InstanceName() );
			}
		

			function Display()
			{
				//
				// Initialize Control
				//
				
				// print ( __CLASS__." ".__FUNCTION__." ".$this->IsInitialized."<br/>" );
				
				if ( ! isset( $this->IsInitialized ) || $this->IsInitialized == false )
				 	$this->OnInit();
				
				// print ( __CLASS__." ".__FUNCTION__." ".$this->IsInitialized."<br/>" );
				
				if ( $this->Visible == false )
					return;
					
				$EnumMode = new Mode();
				
				//
				// Request Processing 
				// Getting data from query string to this control
				//
				$this->OnRequest();
				
				//
				// Intermediate Processing
				//
				$this->OnProcess();
				
				//
				// Response Processing
				// Writing data from control to response (in html format)
				//
				
				if ( ! isset ( $this->SymbolTable ) )
					print ( "No symbol table assigned ".$this->FullName() );

				$this->OnSymbolTable();
				$this->OnPreRender();
				$this->OnRender();				
				$this->OnPostRender();
			}

			//////////////////////////////////////////////////
			//
			// 		OnInit - This is where 'initialization' 
			//			takes place. 
			//
			function OnInit()
			{
				//
				// BUG FIX : It seems little weird as why Init() call is placed
				// on several places such as Display, Request and Resposne.
				// Reason is that calling Init() in constructor cause components
				// to be initialized but they are lost and not functional.
				// Display() method is not guaranteed to be called. Sometimes,
				// this method 'OnRequest()' is called directly. 
				// However, it is safe to assume that OnRequest will be called
				// before doing anything.
				// As a solution, Init() method can be called in Display(),
				// OnRequest() or OnResponse() methods by checking if
				// OnInit() has not already being called by checking
				// state of variable $this->IsInitialize();
				//
				
				$this->IsInitialized = true;
			}
			
			
			function BuildFromXmlNode( $xmlnode )
			{
				$this->OnBuildFromXmlNode( $xmlnode );
				$this->OnInit();
			}
		
			function OnBuildFromXmlNode ( $xmlnode )
			{
			}
			
			function OnSymbolTable ()
			{
			}
			
			//////////////////////////////////////////////////
			//
			// 		On Request - This is where 'Request' is
			//			processed. Here syncronization of
			//			controls should take place from Request
			//			to variables.
			//		Code Note : (CAUTION) Very important point for derived classes.
			//			The OnRequest() method should be the first one, in 
			//			derived class and any other statement after ward, 
			//			because Request() method extracts variables it's
			//			variables from session such as Mode, Visible, Enabled
			//			etc. If OnRequest() is called after any of these variables
			//			are modified, this method will override the modifications
			//			and populate it with old values from session. Hence it is
			//			extremely important that this is the first method in dervied
			//			class's override method, to make sure that user modifications
			//			are not over-written
			//
			function OnRequest()
			{
				// X if ( $this->IsInitialized == false )
				// X {
				// X 	$this->OnInit();
				// X 	$this->IsInitialized = true;
				// X }
				
				if ( $this->IsPostBack() == true )
				{
					if ( isset ($_SESSION[ $this->FullName().'Mode']) )
						$this->Mode_ 	= $_SESSION[ $this->FullName().'Mode'];
					if ( isset ( $_SESSION[ $this->FullName().'Visible'] ))
						$this->Visible 	= $_SESSION[ $this->FullName().'Visible'];
					if ( isset ($_SESSION[ $this->FullName().'Enabled' ]))	
						$this->Enabled 	= $_SESSION[ $this->FullName().'Enabled' ];
					if ( isset ($_SESSION[ $this->FullName().'Width' ]) )
						$this->Width   	= $_SESSION[ $this->FullName().'Width' ];
					if ( isset ($_SESSION[ $this->FullName().'Hight' ]) )
						$this->Height  	= $_SESSION[ $this->FullName().'Hight' ];
				}

				$EnumMode = new Mode();

				switch ( strtoupper($this->Mode_) )
				{
					case $EnumMode->NORMAL 	: $this->OnRequestNormal();
						break;
					case $EnumMode->SELECT 	: $this->OnRequestSelect();
						break;
					case $EnumMode->EDIT 	: $this->OnRequestEdit();
						break;
				}
			}
			
			function OnRequestNormal()
			{
			}

			function OnRequestSelect()
			{
			}

			function OnRequestEdit()
			{
			}

			//////////////////////////////////////////////////
			//
			// 		On Process - This is where calculations
			//			should be processed
			//
			function OnProcess()
			{
				$EnumMode = new Mode();

				switch ( strtoupper($this->Mode_) )
				{
					case $EnumMode->NORMAL 	: $this->OnProcessNormal();
						break;
					case $EnumMode->SELECT 	: $this->OnProcessSelect();
						break;
					case $EnumMode->EDIT 	: $this->OnProcessEdit();
						break;
					default:
					{
						// print ( "No Mode specificed for control");
					}
				}
			}

			function OnProcessNormal()
			{
			}

			function OnProcessSelect()
			{
			}

			function OnProcessEdit()
			{
			}
			
			//////////////////////////////////////////////////
			//
			// 		On Render - This is where drawing
			//		and displaying logic should reside
			//
			function OnRender()
			{
				//
				//		Initial coding and checks
				//
				
				// X if ( $this->IsInitialized == false )
				// X {
				// X 	$this->OnInit();
				// X 	$this->IsInitialized = true;
				// X }

				if ( $this->Visible == false )
					return;
			
				$EnumMode = new Mode();

				//-------------------------------------------
				//
				// 				Render
				//
			
				switch ( strtoupper($this->Mode_) )
				{
					case $EnumMode->NORMAL 	: $this->OnRenderNormal();
						break;
					case $EnumMode->SELECT 	: $this->OnRenderSelect();
						break;
					case $EnumMode->EDIT 	: $this->OnRenderEdit();
						break;
				}

				//
				//			Preserve values in session
				//
				
				// $_SESSION[ $this->FullName().'Parent' ] = $this->Parent;
				$_SESSION[ $this->FullName().'Mode'] 	= $this->Mode_;
				$_SESSION[ $this->FullName().'Text'] 	= $this->Text;
				$_SESSION[ $this->FullName().'Visible'] = $this->Visible;
				$_SESSION[ $this->FullName().'Enabled' ]= $this->Enabled;
				$_SESSION[ $this->FullName().'Width' ] 	= $this->Width;
				$_SESSION[ $this->FullName().'Hight' ] 	= $this->Height;
			}
			
			function OnPreRender()
			{
			}
			
			function OnPostRender()
			{
				// X print (__CLASS__." ".__FUNCTION__."String Table Item Count = ".$this->SymbolTable->Count()." <br/>");
			}
			
			
			function OnRenderNormal()
			{
			}
			
			function OnRenderSelect()
			{
			}
			
			function OnRenderEdit()
			{
			}
			
			//
			// Need to use Globals to hold Guid object's single
			// instance, because nethier static nor global (out
			// side current document) are supported in PHP 4.3+
			// Also globals does not seem to be accessible within
			// class itself.
			//
			function NewId()
			{
				return $GLOBALS['Guid']->NewId();
			}
			
			//
			//
			//
			function SetVisible ( $boolean )
			{
				$this->Visible = $boolean;
			}
			
			function GetVisible ()
			{
				return $this->Visible;
			}
		}			
		
		///////////////////////////////////////////////////////
		//
		//	Different modes, this control may have
		//
		class Mode
		{
			var $SELECT 	= "SELECT";			
			var $NORMAL 	= "NORMAL";
			var $EDIT 		= "EDIT";
		}
		
		$Mode = new Mode();

?>

<?php
		// $c1 = new Control("my control");
		// $c1->Display();
		// print ( $c1->Name );
		// print ( "<br/>\n" );
		
		// $c2 = new Control("my control");
		// $c2->Display();
		// print ( $c2->Nmae );
		// print ( "<br/>\n" );
?>