<?php

	require_once("Control.php");

	class CheckBox extends Control
	{
		var $IsChecked = false;
		
		function CheckBox ($name, $parent)
		{
			parent::Control($name, $parent);
		}
		
		//////////////////////////////////////////////////
		//
		// 		On Request - This is where 'Request' is
		//			processed. Here syncronization of
		//			controls should take place from Request
		//			to variables.
		//
		function OnRequest()
		{
			$val = $_REQUEST[ $this->FullName() ];
			if ( $this->IsPostBack() == true )
			{
				if ( strtolower( $val ) == "on" )
					$this->IsChecked = true;
				else 
				 	$this->IsChecked = false;
			}
			parent::OnRequest();
		}
			
		//////////////////////////////////////////////////
		//
		// 		On Response - This is where 'Response' is
		//			processed. Here syncronization of
		//			controls should take place from variables
		//			to Response.
		//

		function OnRenderNormal()
		{
			print ( "<span id='".$this->FullName()."'>$this->Text</span>" );
		}
			
		function OnRenderSelect()
		{
			$this->OnRenderEdit();
		}
			
		function OnRenderEdit()
		{
			$txtChecked = $this->IsChecked == true ? "checked" : "";
				
			print ( "<input name='".$this->FullName()."' type='checkbox' $txtChecked>" );
			print ( "&nbsp;".$this->Text );
			print ( "</input>" );
		}
	}
	
?>

<?php

?>