<?php

	require_once("Control.php");
	require_once("ClientWindow.php"); // To ensure inclusion of Client Window JavaScript
	
	class Button extends Control
	{
		var $ClickHandler;
		var $OnClick; // Javascript method to execute on client side on click event
		
		function Button($name, $parent)
		{
			parent::Control($name, $parent);
		}
		
		//////////////////////////////////////////////////
		//
		// 		On Request - This is where 'Request' is
		//			processed. Here syncronization of
		//			controls should take place from Request
		//			to variables.
		//
		function OnRequest()
		{
			parent::OnRequest();
			
			$val = $_REQUEST[ $this->FullName() ];
			if ( $val==$this->Text )
			{
				if ( isset( $this->ClickHandler )  )
				{
					$this->ClickHandler->Execute();
				}
			}
		}
		
		//////////////////////////////////////////////////
		//
		// 		On Response - This is where 'Response' is
		//			processed. Here syncronization of
		//			controls should take place from variables
		//			to Response.
		//
		function OnRenderNormal()
		{
			$this->OnRenderEdit();
		}
			
		function OnRenderSelect()
		{
			$this->OnRenderEdit();
		}
			
		function OnRenderEdit()
		{
			print ( "<input name='".$this->FullName()."' type='submit' value='$this->Text' OnClick=\"$this->OnClick\"/>" );
		}
	}
	
	class ClickHandler 
	{
		var $control;
		
		function ClickHandler ( & $control )
		{
			$this->control = & $control;
		}
		
		function Execute()
		{
			print ("ClickHandler::Execute");
		}
	}
?>
<?php

	// $btn1 = new Button("MyButton");
	// $btn1->Text="salim";
	// print ("<br>\n");
	// $btn1->Display();
	// print ("<br>\n");
	// print ( $btn1->Name );
	// print ("<br>\n");
	
	// $btn2 = new Button("MyButton");
	// $btn2->Text="uddin";
	// print ("<br>\n");
	// $btn2->Display();
	// print ("<br>\n");
	// print ( $btn2->Name );
	
?>