<?php
	require_once("../Util/Constant.php");

	require_once(CONST_DIR_DATA_PROTECTION()."/Util/Util.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Control/Button.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Control/LinkButton.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Control/TextBox.php");	
	require_once(CONST_DIR_DATA_PROTECTION()."/Control/Dialog.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Compound/DeployTool.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Compound/CompoundControl.php");
	
	class Section extends CompoundControl
	{
		var $Id;
		var $description;
		var $installLocation;
		var $txtSample;

		var $educationXmlNode;
		var $downloadXmlNode;

		var $DeployTool;
		var $Show;
		
		function Section($name, $parent)
		{
			$this->Text = ""; // Act as heading for section
			$this->description = "";
			$this->installLocation = "C:\\Program Files\\Software";
			parent::CompoundControl($name, $parent);
		}
		
		//
		// @description - Builds control from $section node of xml
		// @return - true if successfuly built, false if failed to properly build
		//
		function BuildFromXmlNode ( $section )
		{
			if ( $section->node_type() != XML_ELEMENT_NODE )
			{
				print ("Error ! unexpected xml format in Section Control.<br/>");
				return false;
			}
			
			$xmlattrLocal = $section->get_attribute("Local");
			$xmlattrRemote = $section->get_attribute("Remote");

			if ( IsRequestLocal()==true && $xmlattrLocal == "false" ) 
			{
				// undesirable condition				
				// return false;
				$this->Visible = false;
			}
			
			if ( IsRequestRemote()==true && $xmlattrRemote == "false" )
			{
				// undesirable condition				
				// return false;
				$this->Visible = false;
			}

			//
			// Todo : To be removed, after thorough testing of xml file with remote and location combinations as true and false
			// Commented By : Imran Salim
			//
			// else if ( (  $xmlattrLocal == "true" && IsRequestLocal()==true ) || ( $xmlattrRemote == "true" && IsRequestRemote()==true ) ) 
			// { 
			// 		good condition
			// }
			//

			$this->Id = $section->get_attribute("ID");
			
			$h = $section->get_elements_by_tagname("Heading");
			if ( $h != null && count ( $h ) > 0 )
			{
				$heading = $h[0];
				$this->Text 	= $heading->get_content();
			}
			
			$xmlnodeDescription = $section->get_elements_by_tagname("Description");
			if ( $xmlnodeDescription != null && count ( $xmlnodeDescription ) > 0 )
			{
				$this->description = new Description( $this, $this->SymbolTable );
				$this->description->BuildFromXmlNode ( $xmlnodeDescription[0] );
			}
			
			//
			// 		Download and DeployTool
			//
			$dnl = $section->get_elements_by_tagname("Download");
			if ( $dnl != null && count ( $dnl ) > 0 )
			{
				$download = $dnl[0];
				$this->downloadXmlNode = $download;
				
				$this->DeployTool = new DeployTool("deployTool", $this, $this->Id );
				$this->DeployTool->OnInit();
			}

			//
			// 		Education
			//
			$e = $section->get_elements_by_tagname("Education");
			if ( $e != null && count ( $e ) > 0 )
			{
				$education = $e[0];
				$this->educationXmlNode = $education;
				
				$this->Show = new SlideShow("slideShow", $this /* parent */);
				$this->Show->xmlNode = $this->educationXmlNode;
				$this->Show->OnInit();
			}

			return true;
		}
		
		//////////////////////////////////////////////////
		//
		// Handles details of Symbol Table
		//
		function OnSymbolTable()
		{
			if ( $this->DeployTool != null )
			{
				$this->DeployTool->SymbolTable = & $this->SymbolTable;
			}
			
			if ( $this->description != null )
			{
				$this->description->symbolTable = & $this->SymbolTable;
			}

			parent::OnSymbolTable();
		}

		//////////////////////////////////////////////////
		//
		// 		On Request - This is where 'Request' is
		//			processed. Here syncronization of
		//			controls should take place from Request
		//			to variables.
		//
		function OnRequest()
		{
			parent::OnRequest();
			
			if ( $this->downloadXmlNode != null )
			{
				$this->DeployTool->OnRequest();
			}

			if ( $this->educationXmlNode != null )
			{
				// $show->SetTransition("fade"); - default is random
				$this->Show->Width = '300px';
				$this->Show->Height = '275px';
			}
		}

		//////////////////////////////////////////////////
		//
		// 		On Response - This is where 'Response' is
		//			processed. Here syncronization of
		//			controls should take place from variables
		//			to Response.
		//
		function OnRender()
		{
			print ( "<table>");
				print ("<tr>");	
					print ("<td valign=top>");
					
						if ( $this->Text != null && $this->Text != '' )
							print ( "<a name='$this->Id'>");
							print ( "<div class='SectionHeadingStyle'>".$this->Text."</div>" );
							print ( "</a>" );
						
						$this->description->Print_();
						
						parent::OnRender();
						
						if ( $this->DeployTool != null )
							$this->DeployTool->Display();
						
					print ("</td>");
					print ("<td valign=top>");
						
						if ( $this->Show != null )
							$this->Show->Display();
							
					print ("</td>");
				print ("</tr>");
				
			print ( "</table>");
									
			print ( "<div align='right'>" );
				$lnkTop = new Link("lnkTop", $pageItem);
				$lnkTop->Url = "#";
				$lnkTop->DocumentName = "Top";
				$lnkTop->Label = "Top";
				$lnkTop->Display();
			print ( "</div>" );
		}
		
		//
		// Control's text is used as heading
		//
		function GetHeading()
		{
			return $this->Text;
		}
		
		//
		// Control's text is used as heading
		//
		function SetHeading($text)
		{
			$this->Text = $text;
		}
	}
			
	class Description 
	{
		var $section;
		var $textLimit;
		var $symbolTable;
		var $paragraphList = array();
		
		function Description ( $section, $symbolTable )
		{
			$this->section = $section;
			$this->symbolTable = $symbolTable;
		}
		
		function BuildFromXmlNode ( $xmlnodeDescription )
		{
			$this->textLimit = $xmlnodeDescription->get_attribute ( "TextLimit" );
			$xmlnodeParagraphList = $xmlnodeDescription->get_elements_by_tagname ("Paragraph");
			foreach ( $xmlnodeParagraphList as $xmlnodeParagraph )
			{
				$p = $xmlnodeParagraph->get_content();
				// TODO : It makes sense to Add OnSymbol table and move Evaluate Symbol, to 
				// OnSymbol. The caller has to make sure that symbol table is assigned
				// to the instance of this class ( Description ).
				// $p = $this->symbolTable->Evaluate ( $p );
				$this->Add( $p );
			}
		}

		function DoTrim()
		{
			if ( $this->textLimit == null || $this->textLimit < 0 )
				return false;
			else 
				return  true;
		}
		
		function Add ( $p )
		{
			array_add( $this->paragraphList, $p );
		}
		
		function Print_ ()
		{
			$totalLen = 0;
			$done = false;
						
			foreach ( $this->paragraphList as $paragraph )
			{
				$paragraph = $this->symbolTable->Evaluate ( $paragraph );

				$totalLen += strlen( $paragraph );
				
				// print ( "Total Len = ".$totalLen.", Limit = ".$this->textLimit." " );
				
				//
				// Prepare Text for displaying in dialog box
				//
				if ( $this->DoTrim()==true && $totalLen >= $this->textLimit )
				{
					$extraLen = $totalLen - $this->textLimit;
					$paraLen = strlen( $paragraph );
					$subParaLen = $paraLen - $extraLen;
					
					$paragraphAll = "";
					$paragraphAll .= "<hr/>";
					$paragraphAll .= "<div class='SectionHeadingStyle'>".$this->section->Text."</div>";
					$paragraphAll .= "<hr/>";
					foreach ( $this->paragraphList as $para )
					{
						$para = $this->symbolTable->Evaluate ( $para );
						$paragraphAll .= "<div>".$para."</div>"."<br/>";
					}
					$paragraphAll .= "<hr/>";
					
					$subParagraph = substr( $paragraph, 0, $subParaLen - 1 );
					
					// Bug Fix : Observe that paragraph is now sub-paragraph
					$paragraph = $subParagraph;
					$paragraph .= ". . . ";
					$paragraph .= "<a style='color:black;font-size:11;' href=# onClick=\"OpenDialog(moreText_".$this->section->InstanceName().")\"> MORE INFO </a><br/><br/>";	/* Variable passed as moreText is defined below */

					print ( "<script language=javascript>"); // place more text in javascript
					print ( "moreText_".$this->section->InstanceName()."=\"".$paragraphAll."\"" );
					print ( "</script>");
					
					$done = true;
				}

				print ( "<div class='SectionDescriptionStyle' >".$paragraph."</div>" );
				
				if ( $done == true )
					break;
			}
		}
	}
	
	class UploadClickHandler extends ClickHandler
	{
		function  UploadClickHandler ( & $control )
		{
			parent::ClickHandler( & $control );
		}
		
		function Execute()
		{
			$this->control->Mode_ = "normal";						
		}
	}

	class CancelClickHandler extends ClickHandler
	{
		function  CancelClickHandler ( & $control )
		{
			parent::ClickHandler( & $control );
		}
		
		function Execute()
		{
			$this->control->Mode_ = "normal";						
		}
	}

	class EditClickHandler extends ClickHandler
	{
		function EditClickHandler ( & $control )
		{
			parent::ClickHandler( & $control );
		}
		
		function Execute()
		{
			$this->control->Mode_ = "edit";
		}
	}
?>