<?php

	require_once("../Util/Constant.php");
	
	require_once( CONST_DIR_DATA_PROTECTION()."/Util/Platform.php");
	require_once( CONST_DIR_DATA_PROTECTION()."/Control/Control.php");
	require_once( CONST_DIR_DATA_PROTECTION()."/Compound/CompoundControl.php");
	require_once( CONST_DIR_DATA_PROTECTION()."/Compound/Section.php");
	require_once( CONST_DIR_DATA_PROTECTION()."/Compound/LinkBar.php");
	require_once( CONST_DIR_DATA_PROTECTION()."/Control/SlideShow.php");
	require_once( CONST_DIR_DATA_PROTECTION()."/Util/Log.php");
	require_once( CONST_DIR_DATA_PROTECTION()."/Util/Util.php");
	require_once( CONST_DIR_DATA_PROTECTION()."/Util/Array.php");

?>

<?php

	class Page extends CompoundControl
	{
		function Page ($name, $parent)
		{
			parent::Control($name, $parent);
		}
		
		//////////////////////////////////////////////////
		//
		// Controls
		//
		var $LeftDocNavigationBar;
		var $LeftNavigationBar;
		var $Title;
		var $SubTitle;
		var $LastUpdate;
		
		//////////////////////////////////////////////////
		//
		//
		//
		function BuildFromXmlFile ()
		{
			$dom = domxml_open_file( CONST_XML_FILE_DATA_PROTECTION() );
			$xmlnodeRoot = $dom->document_element();
			
			parent::BuildFromXmlNode( $xmlnodeRoot );
		}
		
		function OnBuildFromXmlNode ( $xmlnodeRoot )
		{
			/************************************************************
									ROOT
			************************************************************/
			
			$codeStart 			= $xmlnodeRoot->get_attribute("CodeStart");
			$codeEnd 			= $xmlnodeRoot->get_attribute("CodeEnd");
			$this->LastUpdate 	= $xmlnodeRoot->get_attribute("LastUpdate");
			$mode 				= $xmlnodeRoot->get_attribute("Mode");
			$_SESSION["Mode"] 	= $mode; // Mode for executing software - Demo or Release
			
			$xmlnodePageList = $xmlnodeRoot->get_elements_by_tagname("Page");
			foreach ( $xmlnodePageList as $xmlnodePage )
			{
				/************************************************************
										PAGE
				************************************************************/
				$id = $xmlnodePage->get_attribute("ID");
				$title = $xmlnodePage->get_attribute("Title");
				$subTitle = $xmlnodePage->get_attribute("SubTitle");
				
				//
				// Don't process the page, if it's name is not same as php's class name
				//
				if ( strcmp( $id, $this->Name) != 0 )
					continue;
					
				$this->Title = $title;
				$this->SubTitle = $subTitle;
		
				$this->LeftDocNavigationBar = new LinkBar( "leftDocumentNavigationBar", $this );
				$this->LeftDocNavigationBar->Orientation = "vertical";
				$this->LeftDocNavigationBar->FontColor = "white";
				$this->LeftDocNavigationBar->HorizontalAlign = "left";
				$this->LeftDocNavigationBar->Text = $title;

				$this->LeftNavigationBar = new LinkBar( "leftNavigationBar", $this );
				
				$xmlnodePageChildren = $xmlnodePage->child_nodes();
				foreach ( $xmlnodePageChildren as $xmlnodePageChild )
				{
					if ( $xmlnodePageChild->node_type() == XML_ELEMENT_NODE )
					{
						switch ( $xmlnodePageChild->tagname() )
						{
							/************************************************************
													SECTION
							************************************************************/
							case "Section" :
									
									$xmlnodeSection = $xmlnodePageChild;
									$id = $xmlnodeSection->get_attribute("ID");				
	
									$section = new Section( $id, null );
									$success = $section->BuildFromXmlNode( $xmlnodeSection );
									if ( $success == true )
										$this->AddControl( $section );

									break;
							
							/************************************************************
													LINK BAR
							************************************************************/
							case "LinkBar" :
									
									$xmlnodeLinkBar = $xmlnodePageChild;
									
									$linkBar = new LinkBar( "linkBar", $this );
									$linkBar->Orientation = "horizontal";
									$linkBar->HorizontalAlign = "right";
	
									$success = $linkBar->BuildFromXmlNode( $xmlnodeLinkBar );
									if ( $success == true )
										$this->AddControl( $linkBar );

									break;
		
							/************************************************************
													NAVIGATION BAR
							************************************************************/
							case "NavigationBar" :
							
									$xmlnodeNavigationBar = $xmlnodePageChild;
									$xmlnodeNavBarCategoryList = $xmlnodeNavigationBar->get_elements_by_tagname("Category");
									foreach ( $xmlnodeNavBarCategoryList as $xmlnodeNavBarCategory )
									{
										$this->LeftNavigationBar->Orientation = "vertical";
										$this->LeftNavigationBar->FontColor = "white";
										$this->LeftNavigationBar->HorizontalAlign = "left";
								
										$success = $this->LeftNavigationBar->BuildFromXmlNode( $xmlnodeNavBarCategory );
									}
									break;
									
							/************************************************************
													String Table
							************************************************************/
							case "SymbolTable" :
									
									$xmlnodeSymbolTable = $xmlnodePageChild;
									$xmlnodeSymbolTableList = $xmlnodeSymbolTable->get_elements_by_tagname("Data");
									foreach ( $xmlnodeSymbolTableList as $xmlnodeData )
									{
										$id = $xmlnodeData->get_attribute("ID");
										$val = $xmlnodeData->get_attribute("Value");
										$this->SymbolTable->Set ( $id, $val );
									}
									break;
							
							/************************************************************
													DEFAULT
							************************************************************/
							default :
								print ( "Unable to interpret Xml Tag ".$xmlnodePageChild->tagname() );
						}
					}
				}
			}
		}
		
		//////////////////////////////////////////////////
		//		
		// Handles delicacies of Symbol Table
		//
		function OnSymbolTable()
		{
			$this->LeftDocNavigationBar->SymbolTable = $this->SymbolTable;
			$this->LeftNavigationBar->SymbolTable = $this->SymbolTable;
			
			parent::OnSymbolTable();
		}
		
		//////////////////////////////////////////////////
		//		
		// Updates Xml file of Protect Your Data
		//
		function UpdateXmlContent()
		{
			//						
			// Update Xml Content using Lazy Load
			//
			// NOTE : It is best to have update content at bottom, to build
			//			page completely, and then do any updates. Also, it is a 
			//			bug fix because if downloaded xml is locked, and 
			//			update control is in middle of this page, the 
			//			remaining portions will not render, thus causing bugs
			// 			spececially in JavaScript, becuase all scripts are
			//			not loaded by browser. - Imran Salim
			// NOTE : It was previously thought that update client statements should
			//			be at the start of file, but updating is resource intensive process
			//			that blocked the images from being downloaded from server.
			//			Therefore, it was finally decided to bring it to the bottom.
			//
			
			require_once("../Util/Constant.php");
			require_once(CONST_DIR_DATA_PROTECTION()."/Xml/UpdateContent.php");
			
			$updateClient = new UpdateContent("XmlUpdateClient", null);
			$updateClient-> OnRender();
		}
		
		//////////////////////////////////////////////////
		//
		// 		On Render - This is where 'Response' is
		//			processed. Here syncronization of
		//			controls should take place from variables
		//			to Response.
		//

		function OnPreRender()
		{
			// 
			// Build left navigation bar, just before rendering
			//
			
			$len = count ( $this->LeftDocNavigationBar->arrControls );
			for ( $i=0; $i<$len; $i++ )
			{
				array_pop( $this->LeftDocNavigationBar->arrControls );
			}
			
			$len = count ( $this->Controls );
			for ( $i=0; $i<$len; $i++ )
			{
				$c = & $this->Controls[$i];
				if ( $c->Text == null || trim ( $c->Text ) == "" )
					continue;
				if ( $c->Visible == false )
					continue;
					
				$this->LeftDocNavigationBar->AddLink( "#", $c->Name, $c->Text );
			}
			
			parent::OnPreRender();
		}
		
		function OnRender()
		{
			// Calling parent's OnRender() will cause default rendering.
			// In case of Page class, we want to forward the responsibility
			// of rendering to the derived class.
			// parent::OnRender();
		}
		
		function OnPostRender()
		{
			// Update Contents of Xml
			$this->UpdateXmlContent(); 
			
			parent::OnPostRender();
		}
	}
	
?>