<?php

	require_once("../Util/Constant.php");
	
	require_once(CONST_DIR_DATA_PROTECTION()."/Control/Control.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Compound/CompoundControl.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Control/Link.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Control/DropDownList.php");

	class LinkBar extends CompoundControl
	{
		// Possible values are 'horizontal' or 'vertical'.
		// Empty string is interpreted as horizontal
		var $Orientation = "horizontal";
		// Possible value are 'left' or 'right'.
		// Empty string is interpreted as left
		var $HorizontalAlign = ""; 
		// Empty is default color
		var $FontColor;
		
		function  LinkBar($name, & $parent)
		{
			parent::Control($name, $parent);
		}
		
		function BuildFromXmlNode( $xmlnodeLinkBar )
		{
			$xmlattrHeading = $xmlnodeLinkBar->get_attribute("Name");
			$xmlattrLocal  = $xmlnodeLinkBar->get_attribute("Local");
			$xmlattrRemote = $xmlnodeLinkBar->get_attribute("Remote");
			
			if ( IsRequestLocal()==true && $xmlattrLocal == "false" ) 
			{
				// undesirable condition				
				return false;
			}
			
			if ( IsRequestRemote()==true && $xmlattrRemote == "false" )
			{
				// undesirable condition				
				return false;
			}

			$this->SetHeading( $xmlattrHeading );

			$xmlnodeLinkCollection = $xmlnodeLinkBar->child_nodes();
			foreach ( $xmlnodeLinkCollection as $xmlnodeLink )
			{
				if ( $xmlnodeLink->node_type() == XML_ELEMENT_NODE )
				switch ( $xmlnodeLink->tagname() )
				{
					case "Link" : 
						$link = $this->BuildLink( $xmlnodeLink );
						$this->AddControl( $link );
						break;
					case "DropDownList" :
						$dropDownList = $this->BuildDropDownList ( $xmlnodeLink );
						$this->AddControl( $dropDownList );
						break;
					default:
						print ( "Unrecognized Node - ".$xmlnodeLink->tagname()."<br/>" );
				}
			}
			
			return  true;
		}
		
		function BuildLink( $xmlnodeLink )
		{
			$url 		= $xmlnodeLink->get_attribute("Url");
			$name 		= $xmlnodeLink->get_attribute("Name");
			$label 		= $xmlnodeLink->get_attribute("Label");
			$newWindow 	= $xmlnodeLink->get_attribute("NewWindow");
			$tracking 	= $xmlnodeLink->get_attribute("Tracking");
			
			$link = new Link( $name, $this );
			
			if ( $newWindow == "true" )
				$link->OpenSeparateWindow = true;
			else 
			 	$link->OpenSeparateWindow = false;

			if ( $tracking == "true" )
			 	$link->Tracking = true;
			else 
				$link->Tracking = false;
			 	 
			$link->Url = $url;
			$link->DocumentName = $name;
			$link->Label = $label;
			
			return  $link;			
		}

		function BuildDropDownList ( $xmlnodeDropDownList )
		{
			$dropDownList = new DropDownList( "dropdownlist", $this );
			
			$xmlnodeLinkCollection = $xmlnodeDropDownList->get_elements_by_tagname ("Link");
			foreach ( $xmlnodeLinkCollection  as $xmlnodeLink )
			{
				$link = $this->BuildLink( $xmlnodeLink );
				
				// Force open separate window to false. We don't want it
				$link->OpenSeparateWindow = false;
							
				$href 	 = $link->BuildLinkHref();
				$content = $link->BuildLinkContent(); // not used
				$label 	 = $link->Label;
				
				$dropDownList->Add( $label, $href );
			}
			
			return  $dropDownList;
		}
		
		function AddLink ( $url, $name, $label )
		{
			$lnk = new Link( $name, $this );
			$lnk->Url = $url;
			$lnk->DocumentName = $name;
			$lnk->Label = $label;

			$this->AddControl( $lnk );
		}
		

		//////////////////////////////////////////////////
		//
		// 		On Response - This is where 'Response' is
		//			processed. Here syncronization of
		//			controls should take place from variables
		//			to Response.
		//
		function OnRender()
		{
			if ( count ( $this->Controls ) <= 0 )
				return;
				
			if ( $this->HorizontalAlign == null || strtolower( $this->HorizontalAlign )=="" )
				 $this->HorizontalAlign = "left";

			if ( $this->GetHeading() != null && trim( $this->GetHeading() ) != "" )
			{
				print ( "<div style='text-align:$this->HorizontalAlign';color:$this->FontColor;'>" );
				print ( "<b>".$this->GetHeading()."</b>" );
				print ( "</div>" );	
			}
				 
			print ( "<div style='text-align:$this->HorizontalAlign'>" );
				foreach ( $this->Controls as $link )
				{
					print ( "<span>" );
						$link->FontColor = $this->FontColor;
						$link->OnRenderNormal();
					print ( "</span>" );
					if ( strtolower ( $this->Orientation ) == "horizontal" )
						print ("&nbsp;&nbsp;&nbsp;&nbsp;");
					else if ( strtolower( $this->Orientation ) == "vertical" )
						print ("<br/>");
					else
						print ("    "); // horizontal style
				}
			print ( "</div>" );	
		}
		
		function GetHeading()
		{
			return $this->Text;
		}
		
		function SetHeading( $text )
		{
			$this->Text = $text;
		}
	}
	
?>