<?php

	require_once("../Util/Constant.php");
	
	require_once(CONST_DIR_DATA_PROTECTION()."/Util/Log.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Control/Control.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Control/Button.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Control/LinkButton.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Control/Dialog.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Control/ClientWindow.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Xml/InfoFtp.php");
				
	class DeployTool extends Control
	{
		//
		//	Attributes
		//
		
		var $sectionId;
		
		//
		// Buttons that are reused by different dialog boxes such as Download, Info, Cancel etc
		//
		
		var $btnInfo;
		var $btnCancel;
		var $lnkDownload;
		var $btnInstall;
		
		//
		//	Controls that are activated during 
		//	different states
		//
		
		var $InitialLinkButton;
		var $DownloadDialog;
		var $InstallAndReDownloadDialog;
			 	
		//
		// The text of following messages is crafted by Marketing and Nearline VASE Team
		// Please preserve the contents and don't change without permission from 
		// parties involved. - Imran Salim
		//
		
		var $MsgInfo = "Select <b>Download</b> to get software from internet. Select <b>Info</b> for additional details.";
		
		var $MsgWarning = "Select <b>Info</b> for additional details"; // if info is clicked, "Please goto http://www.hp.com for more information"
		
		var $MsgError = "No internet connection detected. Go to <font color=darkblue>www.hp.com/go/ProtectYourData</font> 
							to download applications and tools, and to get additional information about HP tape products.";
		
		var $MsgInstallInfo = "Your application has been downloaded. Select Install to invoke Setup program.
								Select Download to download application. 
								The previously downloaded application will be overwritten.";
		
		var $MsgInstallWarning = "Your application has been downloaded. Select Install to invoke Setup program.";
		
		var $MsgInstallError = "Your application has been downloaded. Select Install to invoke Setup program.";
		
		///////////////////////////////////////////////////////////////////
		//
		//					Construction
		//
			
			
		function DeployTool($name, $parent, $sectionId )
		{
			$this->sectionId = $sectionId;
			
			parent::Control($name, $parent);
		}

		///////////////////////////////////////////////////////////////////
		//
		// 		Initialize Controls
		//
		function OnInit()
		{
			if ( ! $this->IsPostBack() ) // if request is coming from somewhere else, the mode is always normal
			{	
				$EnumMode = new Mode();
				$this->Mode_ = $EnumMode->NORMAL;
			}

			$ftpInfo = FtpInfoMANAGER( $this->sectionId );
			if ( $ftpInfo == null && $ftpInfo->DownloadInfo == null )
				return;

			//--------------------------------------------------------------
			//
			//	Buttons and Links
			//
			//--------------------------------------------------------------

			$this->InitialLinkButton = new LinkButton("lnkBtnDownload", $this );
			$this->InitialLinkButton->Text = "Downloads and Product Info";
			$this->InitialLinkButton->ClickHandler = new BtnDownloadAndProductInfoClickHandler( & $this );
				
			$this->lnkDownload = new Link( "DownloadLink", & $this );
			$this->lnkDownload->Label = "Start";
			$this->lnkDownload->Url = "ftp://".$ftpInfo->url;
			$this->lnkDownload->DocumentName = $ftpInfo->remoteFilePath."/".$ftpInfo->remoteFileName;
			$this->lnkDownload->ImageSource = CONST_URL_DATA_PROTECTION()."/Image/ButtonDownload.png";

			$this->btnInfo = new LinkButton ( "btnInfo", & $this );
			$this->btnInfo->Text = "Info";
			$this->btnInfo->ImageSource = CONST_URL_IMAGE()."/ButtonInfo.png";
			$this->btnInfo->OnClick="NewWindow('http://h18006.www1.hp.com/storage/protectyourdata.html?jumpid=PYD_web')";
			
			$this->btnCancel = new LinkButton( "btnCancel", & $this );
			$this->btnCancel->Text = "Cancel";
			$this->btnCancel->ImageSource = CONST_URL_IMAGE()."/ButtonCancel.png";
			$this->btnCancel->ClickHandler = new BtnCancelClickHandler  ( & $this );
			
			$this->btnInstall = new Button( "InstallButton", & $this );
			$this->btnInstall ->Text = "Install";
			$this->btnInstall ->ClickHandler = new BtnInstallClickHandler ( & $this );

			//--------------------------------------------------------------
			//
			//	Dialog : Download Software
			//
			//--------------------------------------------------------------
			
			$this->DownloadDialog = new DialogBox("downloaddialog", $this );
			$this->DownloadDialog->Text = "Download Dialog";
			$this->DownloadDialog->btnFirst 	= & $this->lnkDownload;
			$this->DownloadDialog->btnSecond 	= & $this->btnInfo;
			$this->DownloadDialog->btnThird 	= & $this->btnCancel;

			//--------------------------------------------------------------
			//
			//	Dialog : Install And ReDownload
			//
			//--------------------------------------------------------------
			
			$this->InstallAndReDownloadDialog = new DialogBox("Installredownload", $this );
			$this->InstallAndReDownloadDialog->Text = "Install and Download Dialog";
			$this->InstallAndReDownloadDialog->btnFirst 	= & $this->btnInstall;
			$this->InstallAndReDownloadDialog->btnSecond 	= & $this->lnkDownload;
			$this->InstallAndReDownloadDialog->btnThird 	= & $this->btnCancel;
			
			parent::OnInit();
		}
		
		///////////////////////////////////////////////////////////////////
		//
		//	Handles delicacies of Symbol Table
		//
		function OnSymbolTable()
		{
			// print ( __CLASS__." ".__FUNCTION__."<br/>" );
			
			//
			// Assign symbol table to sub-controls
			//
			
			$this->InitialLinkButton->SymbolTable = $this->SymbolTable;
			$this->DownloadDialog->SymbolTable = $this->SymbolTable;
			$this->InstallAndReDownloadDialog->SymbolTable = $this->SymbolTable;

			//
			// Update text information in this control
			//
			
			$this->InitialLinkButton->Text = $this->SymbolTable->Get ( "ID_LINK_TEXT_DOWNLOAD_AND_PRODUCT" );
			$this->lnkDownload->ImageSource = CONST_URL_DATA_PROTECTION().$this->SymbolTable->Get("ID_IMG_DOWNLOAD");
			$this->btnInfo->ImageSource = CONST_URL_DATA_PROTECTION().$this->SymbolTable->Get("ID_IMG_INFO");
			$this->btnCancel->ImageSource = CONST_URL_DATA_PROTECTION().$this->SymbolTable->Get("ID_IMG_CANCEL");
			$this->lnkInstall->ImageSource = CONST_URL_DATA_PROTECTION().$this->SymbolTable->Get("ID_IMG_INSTALL");

			//
			// Update messages in this control
			//
			
			$this->MsgInfo = $this->SymbolTable->Get("ID_MSG_DOWNLOAD_AND_INFO"); 
			$this->MsgWarning = $this->SymbolTable->Get("ID_MSG_REMOTE_FILE_NOT_EXIST");
			$this->MsgError = $this->SymbolTable->Get("ID_MSG_NO_INTERNET_CONNECTION");

			$this->MsgInstallInfo = $this->SymbolTable->Get("ID_MSG_DOWNLOAD_SUCCESSFUL");
			$this->MsgInstallWarning = "\${WARNING AFTER OR BEFORE INSTALLATION}";
			$this->MsgInstallError = "\${ERROR AFTER OR BEFORE INSTALL}";

			parent::OnSymbolTable();
		}
		
		///////////////////////////////////////////////////////////////////
		//
		// 		On Request - This is where 'Request' is
		//			processed. Here syncronization of
		//			controls should take place from Request
		//			to variables.
		//
		
		function OnRequest()
		{
			parent::OnRequest();
			
			//
			// 		Process Request
			//
			
			$this->InitialLinkButton->OnRequest();
			$this->DownloadDialog->OnRequest();
			$this->InstallAndReDownloadDialog->OnRequest();
		}

		///////////////////////////////////////////////////////////////////
		//
		// 		On Response - This is where 'Response' is
		//			processed. Here syncronization of
		//			controls should take place from variables
		//			to Response.
		//
		function OnRender()
		{
			parent::OnRender();

			$EnumMode = new Mode();
			
			if ( $this->Mode_ == $EnumMode->NORMAL )
			{
				$this->InitialLinkButton->Display();
			}
			else 
			{
				$this->OnDownloadDialog();
			}	
		}

		//
		// 	Displays Download Dialog, according to present or absence of internet connection and remote file
		//
		function OnDownloadDialog()
		{
			$ftpInfo = FtpInfoMANAGER( $this->sectionId );
	
			if ( $ftpInfo->ExistInternetConnection==true )
			{
					if ( $ftpInfo->ExistRemoteFile==true )
					{
						$this->DownloadDialog->btnFirst->Visible = true;
						$this->DownloadDialog->btnSecond->Visible = true;
						$this->DownloadDialog->btnThird->Visible = true;
						
						$this->DownloadDialog->Mode = "info";
						$this->DownloadDialog->Text = $this->SymbolTable->Get("ID_TITLE_DOWNLOAD_SOFTWARE"); // "Download Software"; // Advised by marketing. Change requires their approval
						$this->DownloadDialog->Message = $this->MsgInfo;
					}
					else // $ftpInfo->ExistRemoteFile==false
					{
						$this->DownloadDialog->btnFirst->Visible = false;
						$this->DownloadDialog->btnSecond->Visible = true;
						$this->DownloadDialog->btnThird->Visible = true;
		
						$this->DownloadDialog->Mode = "warning";
						$this->DownloadDialog->Text = $this->SymbolTable->Get("ID_TITLE_WARNING"); // "Information"; // Advised by marketing. Change requires their approval
						$this->DownloadDialog->Message = $this->MsgWarning; 
					}
			}
			else // No internet connection - $ftpInfo->ExistInternetConnection==false 
			{
				$this->DownloadDialog->btnFirst->Visible = false;
				$this->DownloadDialog->btnSecond->Visible = false;
				$this->DownloadDialog->btnThird->Visible = true;
				
				$this->DownloadDialog->Mode = "error";
				$this->DownloadDialog->Text = $this->SymbolTable->Get("ID_TITLE_NO_INTERNET_CONNECTION"); // "No Internet Connection"; // Advised by marketing. Change requires their approval
				$this->DownloadDialog->Message = $this->MsgError;
			}
			
			$this->DownloadDialog->OnRender();
		}

		//
		// Shows download progress using a bar
		//
		function OnDownloadInProgress()
		{
		}
		
		//
		// Do things when download is successful
		//
		function OnDownloadSuccessful()
		{
		}
		
		//
		// Start Installation 
		//
		function OnInstallInProgress()
		{
		}

		//
		// Display execute link
		//
		function OnInstallSuccessful()
		{
		}
	}
	
?>

<?php

	//----------------------------------------------------------------
	//
	//					Handlers
	//
	//----------------------------------------------------------------
	
	class BtnDownloadAndProductInfoClickHandler extends ClickHandler 
	{
		function BtnDownloadAndProductInfoClickHandler ( & $deployTool )
		{
			parent::ClickHandler( $deployTool );
		}
		
		function Execute()
		{
			$EnumMode = new Mode();
			$this->control->Mode_ = $EnumMode->EDIT;
		}
	}
	
	class BtnStartDownloadClickHandler extends ClickHandler 
	{
		function BtnStartDownloadClickHandler ( & $deployTool )
		{
			parent::ClickHandler( $deployTool );
		}
		
		function Execute()
		{
			// Empty
		}
	}
	
	class BtnCancelClickHandler extends ClickHandler 
	{
		function BtnCancelClickHandler ( & $deployTool )
		{
			parent::ClickHandler( $deployTool );
		}
		
		function Execute()
		{
			$EnumMode = new Mode();
			$this->control->Mode_ = $EnumMode->NORMAL;
		}
	}

	class BtnInstallClickHandler extends ClickHandler 
	{
		function BtnInstallClickHandler ( & $deployTool )
		{
			parent::ClickHandler( $deployTool );
		}
		
		function Execute()
		{
			// Empty
		}
	}
	
?>

<!-- -----------------------------------------------------------------------

								TEST

------------------------------------------------------------------------ -->

<?php

	// $deployTool = new DeployTool("deploytool", null);
	// $deployTool->Display();

?>