<?php

	require_once("../Util/Constant.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Control/Control.php");

	class CompoundControl extends Control
	{
		function CompoundControl($name, $parent)
		{
			parent::Control($name, $parent);
		}
		
		var $Controls = array();

		function AddControl ( & $control )
		{
			array_push ( $this->Controls, $control );
		}
		
		function &FindControl ( $name )
		{
			$name = trim ( $name );
			
			for ( $i=0; $i< count ( $this->Controls ); $i++ )
			{
				$cname = $this->Controls[$i]->Name;
				$cname = trim( $cname );
				if ( $name == $cname )
					return $this->Controls[$i];
			}
			return null;
		}
		
		function RemoveControl ( $name )
		{
			while ( count ( $this->Controls ) > 0 )
			{
				$c = array_pop( $this->Controls );
				
				if ( isset( $c ) && trim ( $c->Name ) != trim ( $name ) )
					array_push( $this->Controls, $c );
			}
		}

		function RemoveAllControls()
		{
			while ( count ( $this->Controls ) > 0 )
			{
				array_pop( $this->Controls );
			}
		}
		
		//////////////////////////////////////////////////
		//
		//	Handling of Symbol Table
		//
		function OnSymbolTable()
		{
			for ( $i=0; $i< count ( $this->Controls ); $i++ )
			{
				$this->Controls[$i]->SymbolTable = & $this->SymbolTable;
				$this->Controls[$i]->OnSymbolTable();
			}
			
			parent::OnSymbolTable();
		}

		//////////////////////////////////////////////////
		//
		//	On Init - 
		//
		function OnInit()
		{
			$len = count ( $this->Controls );
			for ( $i=0; $i< $len; $i++ )
			{
				$this->Controls[$i]->OnInit();
			}
			parent::OnInit();
		}

		//////////////////////////////////////////////////
		//
		//	On Request - This is where fields are
		//	 populated from html request
		//
		function OnRequest()
		{
			$len = count ( $this->Controls );
			for ( $i=0; $i< $len; $i++ )
			{
				$this->Controls[$i]->OnRequest();
			}
			parent::OnRequest();
		}
		
		//////////////////////////////////////////////////
		//
		//	On Process - This is where calculations
		//	should be processed
		//
		function OnProcess()
		{
			$len = count ( $this->Controls );
			for ( $i=0; $i< $len; $i++ )
			{
				$this->Controls[$i]->OnProcess();
			}
			parent::OnProcess();
		}

		//////////////////////////////////////////////////
		//
		//	On Render - This is where drawing and displaying
		//	logic should reside. Derived class may choose
		//	to take total responsibility of rendering and
		//	not call it's base class parent::OnRender() or
		// 	it may choose to leave rendering on base class
		//	and call parent::OnRender() method.
		//
		function OnRender()
		{
			$len = count ( $this->Controls );
			for ( $i=0; $i< $len; $i++ )
			{
				$this->Controls[$i]->OnRender();
			}

			parent::OnRender();
		}
	}
	
?>