SRCS=CpqCiKlx.c CpqCiSem.c CpqCiUSl.c CpqCiPlx.c
OBJS=CpqCiKlx.o CpqCiSem.o CpqCiUSl.o CpqCiPlx.o

CC=gcc
LD=ld
AR=ar rcs

OS_MODEL=LINUX
OS_SYMBOL=1
OS_VERSION=$(shell uname -r)

BUILD_DAY_RAW=$(shell date +%-d)
BUILD_DAY=$(shell expr $(BUILD_DAY_RAW))
BUILD_MONTH_RAW=$(shell date +%-m)
BUILD_MONTH=$(shell expr $(BUILD_MONTH_RAW))
BUILD_YEAR_RAW=$(shell date +%Y)
BUILD_YEAR=$(shell expr $(BUILD_YEAR_RAW) - 1990 )


DFLAGS= -D__KERNEL__ $(OS_MUNMAP4) $(OS_MREMAP5) $(OS_TIMER2_6) -D$(OS_MODEL) -DOS_VERSION=$(OS_VERSION) -DOS_SYMBOL=$(OS_SYMBOL) -DIOCTL_GET_INFO -DBUILD_DAY=$(BUILD_DAY) -DBUILD_MONTH=$(BUILD_MONTH) -DBUILD_YEAR=$(BUILD_YEAR) -DPROC_ENTRY=2 $(OS_MACH)

DEBUGFLAGS=-O
IFLAGS=-I/lib/modules/$(OS_VERSION)/build/include -Ilinux -I.

TARGET=cpqci.o
TARGETDIR=.

#CFLAGS = $(DEBUGFLAGS) -O $(DFLAGS) $(IFLAGS) $(LINUX_HEADERS) $(OS_MEM)
CFLAGS = -O2 $(DFLAGS) $(IFLAGS) $(LINUX_HEADERS) $(OS_MEM)
    
LDFLAGS=-x -r

all: install

install: build
	mkdir -p $(TARGETDIR)
	cp -avf $(TARGET) $(TARGETDIR)/. || /bin/true
	echo $(OS_VERSION) > $(TARGETDIR)/kernel.txt

build:	$(TARGET) 

copy:	manifest.$(OS_MODEL)
	mkdir -p $(TARGETDIR)/linux
	cat manifest.$(OS_MODEL) | xargs -l1 -ix cp -av x $(TARGETDIR)/x 

cpqci.o: $(OBJS) cpqcip.o 
	$(LD) $(LDFLAGS) -o cpqci.o $(OBJS) cpqcip.o

CpqCiUSl.o:	linux/CpqCiUSl.c
	$(CC) $(CFLAGS) -c linux/CpqCiUSl.c	

CpqCiPlx.o:	linux/CpqCiPlx.c
	$(CC) $(CFLAGS) -c linux/CpqCiPlx.c	

CpqCiSem.o:	linux/CpqCiSem.c
	$(CC) $(CFLAGS) -c linux/CpqCiSem.c	

CpqCiKlx.o:	CpqCiKlx.c
	$(CC) $(CFLAGS) -c CpqCiKlx.c	

cpqcip.o:
	make -C private -f linuxk.mk -e OS_MODEL=$(OS_MODEL) OS_MACH=$(OS_MACH) TARGETDIR=.. clean all

libcpqci.so:
	make -C private -f linuxu.mk clean all

clean:
	rm -f CpqCi*.o  *~ $(TARGET)

mrproper: clean
	rm -f cpqcip.o lib*.a lib*.so*
