
################################################################
## copyright 2007 Compaq Information Technologies Group, L.P. ##
################################################################

.PHONY: all clean install

LINUX_KERN_DIRS=$(shell ls /lib/modules)
KORG_SRC=$(shell echo `pwd`/OpenIPMI)
PWD=`pwd`



ifeq "$(EFS_VER)" ""
	EFS_VER=$(LINUX_KERN_DIR)
endif


# IPMI_DEVINTF_VERSION = $(EFS_VER)
# IPMI_KCS_VERSION = $(EFS_VER)
# IPMI_MSGHANDLER_VERSION = $(EFS_VER)
# IPMI_SI_VERSION = $(EFS_VER)


    
all:	init build 

#
# For the 2.6.18+ kernels, we keep the files very closely linked to the 
# IPMI drivers in the kernel.  We are working to merge our changes into
# the kernel.org tree as we get a chance.
#
# We need to move our 2.6.18+ files to the stock ./driver and ./include directories.
#
init:
############################################
## We need to see if this is the HP Build ##
## environment.                           ##
############################################
	if [ -d OpenIPMI ]; then \
		if [ -d drivers ]; then \
			mv drivers drivers.ORIG ;\
			mv $(KORG_SRC)/drivers . ;\
		fi  ;\
		if [ -d include ]; then \
			mv include include.ORIG ;\
			mv $(KORG_SRC)/include . ;\
		fi  ;\
	fi

	for kversion in $(LINUX_KERN_DIRS); do \
		LINUX_BUILD_DIR="/lib/modules/$$kversion/build/" ;\
		echo "Initializing KERNEL VERSION $$kversion  LINUX_BUILD_DIR:  $$LINUX_BUILD_DIR"  ;\
		if [ -d $$LINUX_BUILD_DIR ]; then \
			if [ ! -f $$LINUX_BUILD_DIR/include/linux/ipmi.h.ORIG ]; then \
				mv $$LINUX_BUILD_DIR/include/linux/ipmi.h $$LINUX_BUILD_DIR/include/linux/ipmi.h.ORIG; \
			fi ;\
			if [ ! -f $$LINUX_BUILD_DIR/include/linux/ipmi_msgdefs.h.ORIG ]; then \
				mv $$LINUX_BUILD_DIR/include/linux/ipmi_msgdefs.h $$LINUX_BUILD_DIR/include/linux/ipmi_msgdefs.h.ORIG; \
			fi ;\
			if [ ! -f $$LINUX_BUILD_DIR/include/linux/ipmi_smi.h.ORIG ];  then \
				mv $$LINUX_BUILD_DIR/include/linux/ipmi_smi.h $$LINUX_BUILD_DIR/include/linux/ipmi_smi.h.ORIG; \
			fi ;\
			cp include/linux/ipmi.h $$LINUX_BUILD_DIR/include/linux/ipmi.h ;\
			cp include/linux/ipmi_msgdefs.h $$LINUX_BUILD_DIR/include/linux/ipmi_msgdefs.h ;\
			cp include/linux/ipmi_smi.h $$LINUX_BUILD_DIR/include/linux/ipmi_smi.h ;\
		fi ;\
	done



#
# Due to a quirk in the Linux 2.6 Kernel Environment, we need to clean up 
# some temporary (and hidden) files inbetween each build. NOTE:
# this is NOT a full clean and is not designed to be.
#
build:
	for kversion in $(LINUX_KERN_DIRS); do \
		LINUX_BUILD_DIR="/lib/modules/$$kversion/build/" ;\
		echo "Building  KERNEL VERSION $$kversion  LINUX_BUILD_DIR:  $$LINUX_BUILD_DIR"  ;\
		if [ -d $$LINUX_BUILD_DIR ]; then \
			mkdir -p $(PWD)/bin/$$kversion  ;\
			rm -f drivers/char/ipmi/*.o  ;\
			rm -f drivers/char/ipmi/*.ko  ;\
			rm -f drivers/char/ipmi/*.mod.c  ;\
			rm -f drivers/char/ipmi/.ipmi*.cmd  ;\
			rm -rf drivers/char/ipmi/.tmp_versions  ;\
			make -C $$LINUX_BUILD_DIR V=1 M=$(PWD)/drivers/char/ipmi modules   ;\
			if [ -f drivers/char/ipmi/ipmi_devintf.ko ]; then \
				mv -f drivers/char/ipmi/ipmi_*.ko $(PWD)/bin/$$kversion/.  ;\
			else \
				echo "BUILD ERROR: Build for  KERNEL VERSION: $$kversion  LINUX_BUILD_DIR:  $$LINUX_BUILD_DIR FAILED"  ;\
			fi  ;\
		else \
			echo "WARNING:  THIS IS NO BUILD DIRECTORY FOR VERSION:  $$kversion"  ;\
			echo "          The LINUX_BUILD_DIR resolves to:  $$LINUX_BUILD_DIR"  ;\
		fi ;\
	done

clean:
############################################
## We need to see if this is the HP Build ##
## environment.                           ##
############################################
	if [ -d OpenIPMI ]; then \
		rm -rf drivers ;\
		rm -rf include ;\
		if [ -d drivers.ORIG ]; then \
			mv drivers.ORIG drivers ;\
		fi  ;\
		if [ -d include.ORIG ]; then \
			mv include.ORIG include ;\
		fi ;\
	fi


	for kversion in $(LINUX_KERN_DIRS); do \
		LINUX_BUILD_DIR="/lib/modules/$$kversion/build/"  ;\
		echo "Cleaning  KERNEL VERSION $$kversion  LINUX_BUILD_DIR:  $$LINUX_BUILD_DIR"  ;\
		if [ $(PWD) != "/" ] ; then \
			rm -rf $(PWD)/bin/$$kversion ;\
		fi  ;\
		if [ -d $$LINUX_BUILD_DIR ]; then \
			if [ -f $$LINUX_BUILD_DIR/include/linux/ipmi.h.ORIG ]; then \
				rm $$LINUX_BUILD_DIR/include/linux/ipmi.h ;\
				mv $$LINUX_BUILD_DIR/include/linux/ipmi.h.ORIG $$LINUX_BUILD_DIR/include/linux/ipmi.h ;\
			fi ;\
			if [ -f $$LINUX_BUILD_DIR/include/linux/ipmi_msgdefs.h.ORIG ]; then \
				rm $$LINUX_BUILD_DIR/include/linux/ipmi_msgdefs.h ;\
				mv $$LINUX_BUILD_DIR/include/linux/ipmi_msgdefs.h.ORIG $$LINUX_BUILD_DIR/include/linux/ipmi_msgdefs.h ;\
			fi ;\
			if [ -f $$LINUX_BUILD_DIR/include/linux/ipmi_smi.h.ORIG ];  then \
				rm $$LINUX_BUILD_DIR/include/linux/ipmi_smi.h ;\
				mv $$LINUX_BUILD_DIR/include/linux/ipmi_smi.h.ORIG $$LINUX_BUILD_DIR/include/linux/ipmi_smi.h ;\
			fi ;\
		fi   ;\
	done


install:
ifneq "$(RPM_BUILD_ROOT)" ""
	echo "INSTALLING Files to create RPM"
	sh make_install $(RPM_MAKE_ROOT) $(RPM_BUILD_ROOT)
endif


