%define name bnx2
%define version 1.4.52d

Summary: Broadcom NetXtreme II Gigabit ethernet driver
Name: %{name}
Version: %{version}
Release: 1
Vendor: Broadcom Corporation
License: GPL
Group: System Environment/Base
Source: bnx2-%{version}.tar.bz2
BuildRoot: /var/tmp/%{name}-buildroot

%description
This package contains the Broadcom NetXtreme II Gigabit ethernet driver.

%prep
%setup -T -b 0

%build
value=%{?KVER}
if [ -z "$value" ];then
	KVER=$(uname -r)
else
	KVER=$value
fi
make KVER=$KVER

%install
value=%{?KVER}
if [ -z "$value" ];then
	KVER=$(uname -r)
else
	KVER=$value
fi

BCM_KVER=`echo $KVER | cut -c1-3 | sed 's/2\.[56]/2\.6/'`
if [ "$BCM_KVER" = "2.6" ];then
	BCM_DRV=bnx2.ko
else
	BCM_DRV=bnx2.o
fi

echo "%defattr(-,root,root)" > $RPM_BUILD_DIR/file.list.%{name}
echo "/lib/modules/$KVER/kernel/drivers/net/$BCM_DRV" >> $RPM_BUILD_DIR/file.list.%{name}
mkdir -p $RPM_BUILD_ROOT/lib/modules/$KVER/kernel/drivers/net

echo "/usr/share/man/man4/bnx2.4.*" >> $RPM_BUILD_DIR/file.list.%{name}
mkdir -p $RPM_BUILD_ROOT/usr/share/man/man4

make install PREFIX=$RPM_BUILD_ROOT KVER=$KVER

%post
depmod -a > /dev/null 2> /dev/null
exit 0

%postun
depmod -a > /dev/null 2> /dev/null
exit 0

%clean
rm -rf $RPM_BUILD_ROOT $RPM_BUILD_DIR/file.list.%{name}

%files -f ../file.list.%{name}
%doc LICENSE README.TXT RELEASE.TXT

%changelog
