/*
 * (C) Copyright 1999-2005 Hewlett-Packard Development Company, L.P.
 */
#include "../convert.h"
#include "../cridc.h"
#include "../cridw_linux.h"

//new entry
struct proc_dir_entry* crid_entry_print_crid;

void mk_buffer_print_crid(int* len, char** buf, PCRIDDATA pInstance) {
	if (*buf == NULL) {
		*buf = (char*) __get_free_pages(GFP_KERNEL, BUF_ORDER);
		memset(*buf, 0, (1<<BUF_ORDER));
		*len = crid_proc(*buf, (1<<BUF_ORDER) * PAGE_SIZE, pInstance);
	}
}

void del_buffer_print_crid(int* len, char** buf) {
	  if (*buf != NULL) {
			free_pages((unsigned long) *buf, BUF_ORDER);
			*buf = NULL;
			*len = 0;
	  }
}
//Generating function for proc entry "crid"
int crid_read_print_crid(char *Buf, char **start, off_t off, int count, int *eof, void *data, PCRIDDATA pInstance)
{
	static int scratch_len = 0;
	static char* scratch = NULL;
	int len;
	cridw_dbg(CRID_KERN_DEBUG, "print_crid off %lx count %d\n", off, count);
	if (!scratch) {
		mk_buffer_print_crid(&scratch_len, &scratch, pInstance);
	}
	if (scratch == NULL) return -EINVAL;
	len = scratch_len;
	if (len <= off+count) *eof = 1;
	len -= off;
	if (len>count) len = count;
	if (len<0) len = 0;
	if (off < scratch_len) memcpy(Buf+(off%PAGE_SIZE), scratch+off, len);
	*start = Buf + (off%PAGE_SIZE);
	if (*eof) {
		del_buffer_print_crid(&scratch_len, &scratch);
	}
	return len;
}

// print helpers
//

int print_lock(char* buffer, int bufsize, PCRIDDATA pInstance) 
{
	POSDATA pOsData = (POSDATA)pInstance->pOsData;
	int buflen = 0;
	int i;

	for (i=0; i<MAX_CRID_LOCK; i++) { 
		cridw_sprintf("lock_lines: %s: %d-%d\n",
			pOsData->crid_lock[i].file,
			pOsData->crid_lock[i].start,
			pOsData->crid_lock[i].end
			);
	}
	return buflen;

}

int print_wq(char* buffer, int bufsize, PCRIDDATA pInstance)
{
	POSDATA pOsData = (POSDATA)pInstance->pOsData;
	int buflen = 0;

	buffer_printf("wq:%x ", pOsData->get_pkt_wq);
	return buflen;

}
