/*++

(C) Copyright 2000-2005 Hewlett-Packard Development Company, L.P.

Module Name:

    CpqCiKnt.h

Abstract:

    This module contains the NT-dependent constructs for a ring-0 NT 
    driver that provides kernel mode services to an application in 
    user space.

Environment:

    Kernel mode

Revision History:

--*/

#ifndef _CPQCIxxh
#define _CPQCIxxh

typedef struct _CPQCIEXTENSIONHEADER{
    CPQCIOBJECTTYPE ObjectType;
    CPQCICHAR       ObjectName[CPQCI_OBJECT_NAME_LENGTH];
    struct _CPQCIADAPTEREXTENSION *AdapterExtension;
} CPQCIEXTENSIONHEADER;

typedef struct _CPQCIADAPTEREXTENSION {
    CPQCIEXTENSIONHEADER 		Header;
    struct _CPQCIADAPTEROBJECT*		Adapter;
    struct _CPQCICONNECTIONEXTENSION *	ConnectionList; // list of OS-created connection extensions.
    struct semaphore 			ChannelSem[2];
#if LINUX_VERSION_CODE >= 0x020300
    wait_queue_head_t 			RecvSignal[CPQCI_MAX_CHANNELS];
#else
    struct wait_queue*			RecvSignal[CPQCI_MAX_CHANNELS];
#endif
    int irq;
    struct pci_dev			*pdev;
} CPQCIADAPTEREXTENSION;

typedef struct _CPQCICONNECTIONEXTENSION {
    CPQCIEXTENSIONHEADER Header;
    CPQCICONNECTION      Connection;
    CPQCICHANNEL         Channel;
    CPQCIDRVOSMEMHANDLE	 MemHandleMalloc; //This buffer is typically NULL, see next 
    CPQCIDRVOSMEMHANDLE	 MemHandleMapped; //This buffer is typically NULL, but can be used for phys alloc in user space 
    unsigned long paddr;
    struct _CPQCICONNECTIONEXTENSION *Next;
} CPQCICONNECTIONEXTENSION;

//Shamelessly stolen from cpqrid driver.
#pragma pack(1)
typedef struct {
	char	name[50];       /*Name of the module*/
	char	revision_number[6];
	struct {
	    uint
	    day:5,
	    month:4,
	    year:23;
	} revision_date;                /*Date of most recent update of module*/
	char 	purpose[255];   /*Purpose of module*/
} module_info_type;
#pragma pack()
//Prototypes for memory mapping
static void* vma_private_data(struct vm_area_struct *vma);
static void cpqci_vma_open(struct vm_area_struct *vma);
static void cpqci_vma_close(struct vm_area_struct *vma);
#if LINUX_VERSION_CODE > 0x020300
static struct page* cpqci_vma_nopage_regular(struct vm_area_struct *vma, unsigned long address, int write);
static struct page* cpqci_vma_nopage_high(struct vm_area_struct *vma, unsigned long address, int write);
#else
static unsigned long cpqci_vma_nopage_regular(struct vm_area_struct *vma, unsigned long address, int write);
static unsigned long cpqci_vma_nopage_high(struct vm_area_struct *vma, unsigned long address, int write);
#endif
//Function prototypes
CPQCISTATUS CpqCiDrvCloseChannel(CPQCICONTEXT Context ,struct _CPQCIADAPTEROBJECT* Adapter, CPQCICONNECTION Connection, CPQCICHANNEL *pChannel);
CPQCISTATUS CpqCiDrvDeleteAdapter(CPQCICONTEXT Context,struct _CPQCIADAPTEROBJECT* Adapter);
CPQCISTATUS CpqCiDrvCreateAdapter(CPQCICONTEXT Context, CPQCIPHYSICAL RegisterBarPa, CPQCISIZE RegisterBarSize, CPQCICONNECTIONS MaxConnections,struct _CPQCIADAPTEROBJECT **pAdapter);
CPQCISTATUS CpqCiDrvCreateChannel(CPQCICONTEXT Context,struct _CPQCIADAPTEROBJECT* Adapter, CPQCIENTRIES SendPackets, CPQCISIZE SendPacketSize, CPQCIENTRIES RecvPackets, CPQCISIZE RecvPacketSize, struct _CPQCICCB *Ccb, CPQCIPRIORITY ChannelPriority, CPQCIMODE AddressMode, struct _CPQCICCB *pKey, CPQCICONNECTION *pConnection, CPQCICHANNEL *pChannel);
CPQCISTATUS CpqCiDrvOpenChannel(CPQCICONTEXT Context, struct _CPQCIADAPTEROBJECT* Adapter, CPQCIMODE AddressMode, struct _CPQCICCB *Ccb, struct _CPQCICCB *pKey, CPQCICONNECTION *pConnection, CPQCICHANNEL *pChannel);
CPQCISTATUS CpqCiDrvRegisterWaiter(CPQCICONTEXT Context, struct _CPQCIADAPTEROBJECT* Adapter, CPQCICONNECTION Connection);
int sem_ioctl(struct inode *inod, struct file *f, unsigned int cmd, unsigned long arg);
CPQCISTATUS CpqCiDrvGetPendingChannels(CPQCICONTEXT Context, struct _CPQCIADAPTEROBJECT* Adapter, CPQCICHANNEL *pChannel, CPQCICHANNELS *pChannelList, CPQCICHANNELS *pDeferredList);
CPQCISTATUS CpqCiDrvUnregisterWaiter(CPQCICONTEXT Context, struct _CPQCIADAPTEROBJECT* Adapter, CPQCICHANNEL Channel);
void CpqCiUSleep(unsigned long usecs);
int print_connection_object(char* buffer, int bufsize, struct _CPQCICONNECTIONOBJECT* obj);
struct _CPQCICONNECTIONOBJECT* get_connection_object(struct _CPQCIADAPTEROBJECT* pao, int index);
int print_channel_object(char* buffer, int bufsize, int no, struct _CPQCICHANNELOBJECT* obj);
struct _CPQCICHANNELOBJECT* get_channel_object(struct _CPQCIADAPTEROBJECT* pao, int index);
#endif // _CPQCIxxh
