#!/bin/sh

#########################################################################
# This scripts finds a USB device and mounts it to /mnt/floppy. To do this
# it finds the files under /proc/scsi/usb-storage. Each file name
# corresponds to it's Host Scsi ID (i.e. file '3' is scsi3). Then the
# /proc/scsi/scsi file is searched to find the corresponding Host Scsi ID
# For each "Host:" entry, it looks at the "Vendor:" description. If a
# "USB FDD" or "TEAC" device is found, it (the first one found) is a USB floppy  
# and is mounted to /mnt/floppy. Otherwise, assume it is a USB drive key and
# mount it to /mnt/floppy.
#
# FYI, There is a sequential cross reference to the "Host:" entries 
# (the first one listed is /dev/sda, the second is /dev/sdb, etc...
# Processor and CD-ROM entries are ignored since they don't have a 
# corresponding device)
#
# USB floppy drives must be mounted as the entire drive (i.e. /dev/sda)
# while USB drive keys are mounted as partition one (i.e. /dev/sda1)
#########################################################################

SCSI_USB_DIR="/proc/scsi/usb-storage"
PROC_SCSI_FILE="/proc/scsi/scsi"
if [ ! -f "$PROC_SCSI_FILE" ]
then
	echo "ERROR: No $PROC_SCSI_FILE found"
	exit 99
fi

USB_DEV=`ls -1 $SCSI_USB_DIR`

if [ -z "$USB_DEV" ]
then
	echo "ERROR: No USB devices found"
	exit 98
fi

RET_STAT=97
for i in $USB_DEV
do
	ID=scsi$i
	USB=`cat $PROC_SCSI_FILE | \
	awk 'BEGIN { hcnt=0 ;
		xref[1]="a"; xref[2]="b"; xref[3]="c"; xref[4]="d"; xref[5]="e";
		xref[6]="f"; xref[7]="g"; xref[8]="h"; xref[9]="i"; xref[10]="j";
		xref[11]="k"; xref[12]="l"; xref[13]="m"; xref[14]="n"; xref[15]="o";
		xref[16]="p"; xref[17]="q"; xref[18]="r"; xref[19]="s"; xref[20]="t";
		xref[21]="u"; xref[22]="v"; xref[23]="w"; xref[24]="x"; xref[25]="y";
		xref[26]="z";
		} 
	{
		if($1 == "Host:") {
			HOST=$2;
			hcnt++;
			if(hcnt > 26) { exit; }

			#print "hcnt:" hcnt $0;
			getline;
			VENDOR=$0;
			getline;
			TYPE=$0;

			if(index(TYPE,"Processor")!=0) { hcnt--;next; }
			if(index(TYPE,"CD-ROM")!=0) { hcnt--;next; }

			if(HOST != "'$ID'") { next; }

			if((index(VENDOR,"USB FDD") !=0) ||
			(index(VENDOR,"TEAC") !=0)) {
				#print "FOUND1:" hcnt $0;
				print "/dev/sd"xref[hcnt];
				exit;
			}
			else {
				#print "FOUND:" hcnt $0;
				print "/dev/sd"xref[hcnt]"1";
				exit;
			}
		}
	}'`

	#echo "USB = $USB"
	if [ ! -z "$USB" ]
	then
		echo "mount $USB /mnt/floppy"
		umount /mnt/floppy > /dev/null 2>&1
		mount $USB /mnt/floppy
		RET_STAT=$?
		if [ "$RET_STAT" = "0" ]
		then
			exit 0
		fi
	fi
done

exit $RET_STAT

