// This file is a Form that defines Strings into JavaScript variables.

// SS510p1 Translations
// Miscellaneous
PX_TAG_CONTROLLERS = "Controllers";
PX_TAG_LOADING = "Loading Array Configuration Utility...";

PX_TAG_HELP = "Help";
PX_TAG_BROWSER_FUNCTION_DISABLED = "This browser function has been disabled while running ACU.";
PX_TAG_DISCARD = "Discard Changes";
PX_TAG_DISCARD_WARNING = "Warning!\n\nContinuing will discard any changes you have made to the current controller\nsince you last saved it and refresh the controller.\n\nClick OK to continue or Cancel to return.";
PX_TAG_DISCOVERING = "Detecting Controllers...";
PX_TAG_DISCOVERY_ERRORS = "There were errors during controller detection.  ACU can not continue ";
PX_TAG_DISCOVERY_NO_CONTROLLERS = "ACU did not detect any supported controllers in your system.";
PX_TAG_EXITING = "Closing Array Configuration Utility session...";
PX_TAG_FINISH = "Finish";
PX_TAG_MAIN_MENU_WARNING = "Warning!\n\nWhen you return to the Main Menu, all unsaved changes to the current controller\nsince you last saved it will be discarded.\n\nTo save your changes before returning, click Cancel, then click Save.\nOtherwise, click OK to continue.";
PX_TAG_NO = "No";
PX_TAG_NONE = "None";
PX_TAG_REFRESH = "Refresh Controller";
PX_TAG_REFRESH_ARRAY_WARNING = "Warning!\n\nContinuing will cancel any changes you have made to the current controller\nsince you last saved it and refresh the controller.\nAll arrays which do not contain at least one logical drive will be deleted.\nAll spare drives assigned to arrays which contain only RAID 0 logical drives will be removed.\n\nClick OK to continue or Cancel to return.";
PX_TAG_SAVE = "Save";
PX_TAG_SHOW_LOGICAL = "Show Logical View";
PX_TAG_SHOW_PHYSICAL = "Show Physical View";
PX_TAG_WARNING = "WARNING!";
PX_TAG_YES = "Yes";

// Status
PX_TAG_ERROR_MSG = "Error Message #";
PX_TAG_INFO_MSG = "Info Message #";
PX_TAG_STATUS_MESSAGES = "Status Messages";
PX_TAG_VIEW_STATUS = "View Status Messages";
PX_TAG_WARNING_MSG = "Warning Message #";
PX_TAG_ERROR_DETECTED = "Error Detected!";
PX_TAG_OPERATION_FAILURE_TEXT = "ACU has encountered the following error attempting to configure your controller:";

// Tasks
PX_TAG_AM_AS_00_TEXT = "The following screens will allow you to add a spare to an array.";
PX_TAG_AM_AS_01_TEXT = "Select the array you want to add a spare to:";
PX_TAG_AM_AS_02_TEXT = "Select the spare drive you want to add to the array:";
PX_TAG_AM_CA_00_TEXT = "The following screens will allow you to create an array. Once an array is created, the unused space in the array becomes available for creating logical drives.";
PX_TAG_AM_CA_01_TEXT = "Select the physical drives that you want to use in the array:";
PX_TAG_AM_CA_02_TEXT = "Would you like to add a spare to the new array?";
PX_TAG_AM_CA_03_TEXT = "Select the spare that you want to add to the array:";
PX_TAG_CREATE_ARRAY_EMPTY = "You must select one or more physical drives to create an array.";
PX_TAG_AM_DA_00_TEXT = "The following screens will allow you to delete arrays.";
PX_TAG_AM_DA_01_TEXT = "Select the arrays you want to delete:";
PX_TAG_AM_DA_02_TEXT = "Deleting the selected arrays will cause any logical drives on them to be deleted. All data on the logical drives will be lost!";
PX_TAG_DELETE_ARRAY_NONE = "You have not selected any arrays to delete.";
PX_TAG_DELETE_ARRAY_PARTITION = "One or more of the arrays you selected to delete have one or more logical drives with partitions on them.  Deleting the arrays will cause the partitions on the logical drives to be deleted.  Any data on the logical drives should be backed up before saving this configuration.";
PX_TAG_DELETE_ARRAY_SWVR = "One or more of the arrays you selected to delete have one or more logical drives with StorageWorks Virtual Replicator information stored on them.  Any data on the logical drives should be backed up before saving this configuration.";
PX_TAG_AM_EA_00_TEXT = "The following screens will allow you to expand an array.";
PX_TAG_AM_EA_01_TEXT = "Select the array you want to expand:";
PX_TAG_AM_EA_02_TEXT = "Select the physical drives you want to add to the array:";
PX_TAG_EXPAND_ARRAY_EMPTY = "You must select one or more physical drives to expand the array.";
PX_TAG_EXPAND_ARRAY_MIGRATE_RAIDADG = "An even number of physical drives is required for this array because\nit has one or more logical drives with a fault tolerance of RAID 1+0.\nHowever, you can migrate all RAID 1+0 logical drives on this array to RAID 6 (ADG).\nPress OK to migrate all RAID 1+0 logical drives to RAID 6 (ADG).\nOtherwise, press Cancel to go back and select an even number of physical drives.";
PX_TAG_EXPAND_ARRAY_MIGRATE_RAID5 = "An even number of physical drives is required for this array because\nit has one or more logical drives with a fault tolerance of RAID 1+0.\nHowever, you can migrate all RAID 1+0 logical drives on this array to RAID 5.\nPress OK to migrate all RAID 1+0 logical drives to RAID 5.\nOtherwise, press Cancel to go back and select an even number of physical drives.";
PX_TAG_AM_RS_00_TEXT = "The following screens will allow you to remove a spare from an array.";
PX_TAG_AM_RS_01_TEXT = "Select the array you want to remove the spare from:";
PX_TAG_LB_00_TEXT = "In the following screens, you will be asked a few simple questions that will allow your controller to be configured. You will have a chance at the end to review your choices and make changes before they are saved.";
PX_TAG_LB_01_TEXT = "What fault tolerance would you like for your new logical drives?";
PX_TAG_LB_02_TEXT = "Would you like a spare assigned to your logical drives?";
PX_TAG_LB_CC00_TEXT = "In the following screens, you will be asked a few simple questions that will allow you to create additional logical drives on your controller.  You will have a chance at the end to review your choices and make changes before they are saved.";
PX_TAG_LB_CC02_TEXT = "Would you like to migrate your RAID 1+0 logical drives to RAID 5 (RAID 6 (ADG) if possible)?";
PX_TAG_LB_CONFIG_SAVED = "Your configuration was saved successfully.";
PX_TAG_LB_IS_CONFIG_OK = "Is this configuration OK?";
PX_TAG_NC_01_TEXT = "Welcome to ACU, the Array Configuration Utility.  This utility will guide you through the setup and configuration of your array controllers.";
PX_TAG_NC_SELECT_CONTROLLER = "Please select a controller on the left to begin configuration.";
PX_TAG_NU_01_NO_TASKS = "There are no configuration options for this controller.";
PX_TAG_NU_01_SELECT_TASK = "Select the method you would like to use to configure your controller:";
PX_TAG_UB_00_NO_TASKS = "There are no configuration options for this controller.";
PX_TAG_UB_00_SELECT_TASK = "Select a task to change the existing configuration:";
PX_TAG_UB_CC_00_TEXT = "The following screens will allow you to clear your controller's configuration.  All arrays, logical drives, and controller settings will be erased, and the controller will be restored to its default configuration.";
PX_TAG_UB_CC_01_TEXT = "Clearing the configuration of this controller will delete all arrays and logical drives on this controller.  Any data on these logical drives will be lost!";
PX_TAG_DELETE_CONTROLLER_PARTITION = "This controller has one or more logical drives that have partitions on them.  Clearing the configuration of this controller will cause all partitions on the logical drives of this controller to be deleted.  Any data on these logical drives should be backed up before saving this configuration.";
PX_TAG_DELETE_CONTROLLER_SWVR = "StorageWorks Virtual Replicator information is stored on one or more logical drives on this controller.  Clearing the configuration of this controller will cause this information on the logical drives of this controller to be deleted.  Any data on these logical drives should be backed up before saving this configuration.";
PX_TAG_UB_CD_00_TEXT = "The following screens will allow you to create a logical drive using the free space available from one of your arrays.  You will be able to select the size, RAID level, stripe size, max boot, and array accelerator support.";
PX_TAG_UB_CD_01_TEXT = "Select the free space to create a new logical drive:";
PX_TAG_UB_CD_02_TEXT = "Select the fault tolerance for the new logical drive:";
PX_TAG_UB_CD_03_TEXT = "Select the stripe size for the new logical drive:";
PX_TAG_UB_CD_04_TEXT = "Would you like to enable Max Boot?";
PX_TAG_UB_CD_05_TEXT = "Enter the size for the new logical drive:";
PX_TAG_UB_CD_06_TEXT = "Would you like to enable the array accelerator?";

PX_TAG_LDRIVE_SIZE_RANGE = "MB  (between <0minSize> MB and <1maxSizeMB> MB)";
PX_TAG_LDRIVE_SIZE_MAX = "MB  (<0maxSize> MB max)";
PX_TAG_CREATE_LDRIVE_MAX_PDRIVES_WARNING = " This logical drive will be created on an array that has more than 14 physical drives.\n\nExpanding the array or creating additional logical drives on this array is not recommended. Using more than 14 drives in an array with RAID 4/RAID 5 increases the likelihood of multiple drive failures. A failure of two or more drives will result in data loss for all data on the logical drive. NOTE: Using between 14 and 28 drives is a medium risk while using more than 29 drives on an array is a high risk.\n\nTo reduce the risk of multiple drive failures, assign an online spare to the array and use the controller settings screen to set the rebuild priority to high. While this will not reduce the risk of using greater than the recommended number of drives to create a single RAID 4/RAID 5 logical drive, it should reduce the risk associated with such as decision.\n\nPress OK to continue with the selected RAID, or press Cancel to select another RAID.";
PX_TAG_UB_CS_00_TEXT = "The following screens will allow you to change settings for your controller.";
PX_TAG_UB_CS_01_TEXT = "Select the desired expand priority:";
PX_TAG_UB_CS_02_TEXT = "Select the desired rebuild priority:";
PX_TAG_UB_CS_02A_TEXT ="Check logical drives to enable the array accelerator. Uncheck logical drives to disable the array accelerator.";
PX_TAG_UB_CS_03_TEXT = "Select the desired cache ratio:";
PX_TAG_UB_DD_00_TEXT = "The following screens will allow you to delete logical drives.";
PX_TAG_UB_DD_01_TEXT = "Select the logical drives you want to delete:";
PX_TAG_UB_DD_02_TEXT = "Deleting the selected logical drives will cause all data on these drives to be lost!";
PX_TAG_DELETE_LDRIVE_NONE = "You have not selected any logical drives to delete.";
PX_TAG_DELETE_LDRIVE_PARTITION = "One or more logical drives that you selected to delete have partitions on them. Any data on these logical drives should be backed up before saving this configuration.";
PX_TAG_DELETE_LDRIVE_SWVR = "StorageWorks Virtual Replicator information is stored on one or more logical drives that you selected to delete. Any data on these logical drives should be backed up before saving this configuration.";
PX_TAG_UB_MVD_00_TEXT = "The following screens will allow you to change the current level of fault tolerance and/or stripe size for your logical drive. When the fault tolerance and/or stripe size changes, you may have more or less unused space, depending on the fault tolerance and stripe size with which you started.";
PX_TAG_UB_MVD_01_TEXT = "Select the logical drive you would like to migrate:";
PX_TAG_UB_MVD_02_TEXT = "Select the new fault tolerance for the logical drive:";
PX_TAG_UB_MVD_03_TEXT = "Select the new stripe size for the logical drive:";
PX_TAG_UB_SP_00_TEXT = "The following screens will allow you to change the Selective Storage Presentation Settings. You can change the SSP connection names for the controller and the SSP access settings for logical drives.";
PX_TAG_UB_SP_01_TEXT = "Select the logical drive for which you would like to change SSP settings:";
PX_TAG_UB_SP_02_TEXT = "Enable/Disable SSP for the logical drive:";
PX_TAG_UB_SP_03_TEXT = "Set SSP access settings for the logical drive and rename connections:";

PX_TAG_SSP_ACCESS = "Access";
PX_TAG_SSP_ADAPTER_ID = "Adapter ID";
PX_TAG_SSP_CONNECTION_NAME = "Connection Name";
PX_TAG_SSP_EMPTY_WARNING = "You have not granted any connections access to the logical drive.\nThis means the logical drive will not be accessible.\nPress OK to continue, or press Cancel to go back and give some connections access.";
PX_TAG_SSP_LOCATION = "Location";
PX_TAG_SSO_REMOVED_ACCESS_WARNING = "You have denied one or more connections access to this logical drive that previously had access.  If this connection is in use by the operating system, further I/O from the adapters that are providing these connections to this logical drive will fail. Also, any writes cached by the operating system on the servers with these adapters will not be written to the logical drive.  Before saving the configuration, make sure the logical drive is not in use by the operating systems on the servers that no longer have access.";
PX_TAG_SSP_UNKNOWN = "Unknown";

PX_TAG_UB_XD_01_TEXT = "Select the logical drive you want to extend:";
PX_TAG_UB_XD_02_TEXT = "Select the new size for the extended logical drive:";

PX_TAG_PRESS_BEGIN = "Press Begin to get started.";
PX_TAG_PRESS_DELETE = "Click on Delete to continue.";
PX_TAG_PRESS_FINISH = "Click on Finish to accept your changes.";
PX_TAG_PRESS_NEXT = "Click on Next to continue.";

// Navigation
PX_TAG_BACK = "Back";
PX_TAG_BEGIN = "Begin";
PX_TAG_CANCEL = "Cancel";
PX_TAG_CLOSE_WINDOW = "Close Window";
PX_TAG_DELETE = "Delete";
PX_TAG_NEXT = "Next";
PX_TAG_OVERRIDE = "Override";
PX_TAG_RETURN_TO_SELECT_CONTROLLER = "Return to Controller Selection";

// Progress
PX_TAG_CONFIG_COMPLETE = "Configuration Complete";
PX_TAG_INTRODUCTION = "Introduction";
PX_TAG_SELECT_AA = "Set Array Accelerator";
PX_TAG_SELECT_ARRAY = "Select Array";
PX_TAG_SELECT_ARRAYS = "Select Arrays";
PX_TAG_SELECT_ARRAY_CREATION = "Select Array Creation Method";
PX_TAG_SELECT_CACHE_RATIO = "Select Cache Ratio";
PX_TAG_SELECT_EXPAND_PRIORITY = "Select Expand Priority";
PX_TAG_SELECT_FREE_SPACE = "Select Free Space";
PX_TAG_SELECT_LDRIVE = "Select Logical Drive";
PX_TAG_SELECT_LDRIVES = "Select Logical Drives";
PX_TAG_SELECT_MAX_BOOT = "Set Max Boot";
PX_TAG_SELECT_MIGRATION = "Select Migration";
PX_TAG_SELECT_PDRIVES = "Select Physical Drives";
PX_TAG_SELECT_RAID = "Select Fault Tolerance Level";
PX_TAG_SELECT_REBUILD_PRIORITY = "Select Rebuild Priority";
PX_TAG_SELECT_SAVE = "Select Save Options";
PX_TAG_SELECT_SIZE = "Set Logical Drive Size";
PX_TAG_SELECT_SPARE = "Select Spare";
PX_TAG_SELECT_STRIPE_SIZE = "Select Stripe Size";
PX_TAG_SPARE_QUESTION = "Spare Question";
PX_TAG_SSP_ENABLE_DISABLE = "SSP Enable/Disable";
PX_TAG_SSP_SETTINGS = "SSP Settings";

PX_TAG_32BIT_PCI = " 32-bit PCI ";
PX_TAG_NO_CHOICE = " No choice ";
PX_TAG_ACC_RATIO = " Accelerator Ratio ";
PX_TAG_ACC_RATIO_VALUE = " <0ReadPercent> % Read, <1WritePercent> % Write ";
PX_TAG_ACTUAL_WIDTH = " Actual Width ";
PX_TAG_ADD_NEW_ARRAYS_AND_LDRIVES = " Add new arrays and logical drives ";
PX_TAG_ADD_NEW_ARRAYS_NO_LDRIVES = " Add new arrays no logical drives ";
PX_TAG_ADD_SPARE = " Add spare ";
PX_TAG_AV_FLASH_FIRMWARE = " Flash Firmware ";
PX_TAG_AV_FLASH_FIRMWARE_DESC = " Allows you to upgrade the firmware image on the controller. ";
PX_TAG_ALL = " All ";
PX_TAG_ARRAY = " Array ";
PX_TAG_ARRAY_MANAGEMENT = " Manage Arrays ";
PX_TAG_ARRAY_MANAGEMENT_DESC = " Create and modify arrays. ";
PX_TAG_ARRAY_NAME = " Array <0id> ";
PX_TAG_ARRAY_NAME_WITH_SPARE = " Array <0id> with Spare ";
PX_TAG_AREA = " Area ";
PX_TAG_ALL_PDRIVE_ASSIGNED = " All Physical Drives Assigned ";
PX_TAG_ARBITRATED_LOOP_PHYS_ADDRESS = " Arbitrated Loop Physical Address ";
PX_TAG_ARRAY = " Array ";
PX_TAG_ARRAY_NUM = " Array Number ";
PX_TAG_ARRAY_ACCELERATOR = " Array Accelerator ";
PX_TAG_AUTO_CONFIG = " Express Configuration ";
PX_TAG_AUTO_CONFIG_DESC = " Asks you a few simple questions, then configures your controller. ";
PX_TAG_BACKGROUND_PARITY_INIT = " Background Parity Initializing ";
PX_TAG_BATTERY_COUNT = " Battery Pack Count ";
PX_TAG_BATTERY_STATUS = " Battery Status ";
PX_TAG_BAY = " Bay  ";
PX_TAG_BOX = " Box  ";
PX_TAG_BUS_INTERFACE = " Bus Interface ";
PX_TAG_CACHE_FAILURE = " Cache Failure ";
PX_TAG_CACHE_SIZE_MISMATCH = " Cache Size Mismatch ";
PX_TAG_CACHE_STATUS = " Cache Status ";
PX_TAG_CLEAR = " Clear ";
PX_TAG_CLEAR_CONFIG = " Clear Configuration ";
PX_TAG_CLEAR_CONFIG_DESC = " Reset all settings of the controller to its default status. ";
PX_TAG_COLON = "  :  ";
PX_TAG_COMPAQ_PRODUCT_ID = " Product Identifier ";
PX_TAG_COMPAQ_VENDOR_ID = " Vendor Identifier ";
PX_TAG_CONTROLLER = " Controller ";
PX_TAG_CONTROLLER_NAME_BOX = " <0controller> in <1boxname> ";
PX_TAG_CONTROLLER_NAME_WWID = " <0controller> with ID <1wwid> ";
PX_TAG_CONTROLLER_NAME_SLOT = " <0controller> in Slot <1slot> ";
PX_TAG_CONTROLLER_NAME_EMBEDDED_SLOT = " <0controller> in Embedded Slot ";
PX_TAG_CONTROLLER_NAME_UNKNOWN_SLOT = " <0controller> in Unknown Slot ";
PX_TAG_CONTROLLER_SETTINGS = " Controller Settings ";
PX_TAG_CONTROLLER_SETTINGS_DESC = " Modify controller level settings. ";
PX_TAG_CREATE_ARRAY = " Create an array ";
PX_TAG_CREATE_LDRIVE = " Create a logical drive ";
PX_TAG_CREATE_LDRIVE_DESC = " Create a new logical drive. ";
PX_TAG_CREATE_NEW_ARRAYS = " Create New Arrays ";
PX_TAG_CREATE_NEW_ARRAYS_DESC = " Uses unassigned physical drives to create new arrays and new logical drives on those arrays.  In addition, unused space on any existing arrays will also be used to create logical drives. ";
PX_TAG_CYLINDERS = " Cylinders ";
PX_TAG_DEGRADED = " Degraded ";
PX_TAG_DELETE_ARRAY = " Delete arrays ";
PX_TAG_DELETE_ARRAY_DESC = " Delete existing arrays. ";
PX_TAG_DELETE_LDRIVE = " Delete logical drives ";
PX_TAG_DELETE_LDRIVE_DESC = " Delete existing logical drives. ";
PX_TAG_DISABLE = " Disable ";
PX_TAG_DISABLED = " Disabled ";
PX_TAG_DRIVE_DISPARITY = " Drive Communication Error ";
PX_TAG_DROP_SPARE = " Drop spare ";
PX_TAG_DOMAIN = " Domain ";
PX_TAG_EMBEDDED = " Embedded ";
PX_TAG_EISA = " EISA ";
PX_TAG_EISA_DAZZLER = " SMART-2/E Controller ";
PX_TAG_EISA_JAGUAR = " Fibre Channel Host Controller/E ";
PX_TAG_ENABLE = " Enable ";
PX_TAG_ENABLED = " Enabled ";
PX_TAG_ERR_INTERNAL = " Internal Error <0id> ";
PX_TAG_EXTERNAL = " External ";
PX_TAG_EXPAND = " Expand ";
PX_TAG_EXPAND_ARRAY = " Expand an array ";
PX_TAG_EXPAND_ARRAY_DESC = " Increase capacity of an existing array. ";
PX_TAG_EXPAND_EXISTING_ARRAYS = " Expand existing arrays ";
PX_TAG_EXPAND_EXISTING_ARRAYS_DESC = " Adds unassigned drives to existing arrays and creates new logical drives in those arrays. ";
PX_TAG_EXPAND_PRIORITY = " Expand Priority ";
PX_TAG_EXPANDING = " Expanding ";
PX_TAG_EXTEND_LDRIVE = " Extend logical drive ";
PX_TAG_EXTEND_LDRIVE_DESC = " Increase capacity of an existing logical drive. ";
PX_TAG_FAILED = " Failed ";
PX_TAG_FAILED_PDRIVES = " Failed Physical Drives ";
PX_TAG_FAST_SCSI = " Fast SCSI ";
PX_TAG_FAULT_TOLERANCE = " Fault Tolerance ";
PX_TAG_FCAL = " Fibre Channel ";
PX_TAG_FIBRE_CHANNEL_HOST_CONTROLLER = " Fibre Channel Host Controller ";
PX_TAG_FIBRE_PANTHER = " RA4000/4100 Controller ";
PX_TAG_FIBRE_JAGUAR = " Fibre Jaguar ";
PX_TAG_FIRMWARE_MISMATCH = " Firmware Mismatch ";
PX_TAG_FIRMWARE_VERSION = " Firmware Version ";
PX_TAG_GB = " GB ";
PX_TAG_HARDWARE_REVISION = " Hardware Revision ";
PX_TAG_HBA_A_L_P_A = " Arbitrated Loop Physical Address (HOST) ";
PX_TAG_HBA_ADAPTER_ID = " Host Controller Adapter ID ";
PX_TAG_HBA_SLOT_NUMBER = " Host Controller Slot Number ";
PX_TAG_HEADS = " Heads ";
PX_TAG_HIGH = " High ";
PX_TAG_HIGH_EXPAND_DESC = " Expansion is performed at the expense of normal I/O.  This option will allow the expansion to complete the fastest. ";
PX_TAG_HIGH_REBUILD_DESC = " Rebuilding is performed at the expense of normal I/O.  This option will allow the drive to complete rebuild the fastest. ";
PX_TAG_HOST_CONTROLLER_ADAPTER_ID = " Host Controller Adapter ID ";
PX_TAG_HOST_CONTROLLER_SLOT_NUMBER = " Host Controller Slot Number ";
PX_TAG_HOST_CONTROLLERS_WITH_ACCESS = " Host Controllers Having Access ";
PX_TAG_ICL_NOT_ESTABLISHED = " Inter-Controller Link Error ";
PX_TAG_ID = " ID ";
PX_TAG_INTERNAL = " Internal ";
PX_TAG_INVALID_DRIVE_FOR_REDUNDANCY = " Invalid Drives Attached ";
PX_TAG_KB = " KB ";
PX_TAG_LOCAL = " Local ";
PX_TAG_LOCATION = " Location ";
PX_TAG_LOG_DRIVE_NOT_AVAILABLE = " Logical Drive Not Available ";
PX_TAG_LDRIVE = " Logical Drive ";
PX_TAG_LDRIVE_NAME = " Logical Drive <0id> (<1size>, <2raid>) ";
PX_TAG_LDRIVE_NUMBER = " Logical Drive Number ";
PX_TAG_LOW = " Low ";
PX_TAG_LOW_EXPAND_DESC = " Expansion is performed only when normal I/O is not occuring.  This option will cause the expansion to take the most time. ";
PX_TAG_LOW_REBUILD_DESC = " Rebuilding is performed only when normal I/O is not occuring.  This option will cause the rebuild to take the most time. ";
PX_TAG_LB = " Low Basic ";
PX_TAG_LB_CONFIGURED = " Low Basic Configured ";
PX_TAG_LB_UNCONFIGURED = " Low Basic Unconfigured ";
PX_TAG_MAX_BOOT_ENABLE_DESC = " Uses 63 sectors per track and allows a maximum of 8 GB boot partition. ";
PX_TAG_MAX_BOOT_DISABLE_DESC = " Uses 32 sectors per track and allows a maximum of 4 GB boot partition. ";
PX_TAG_MB = " MB ";
PX_TAG_MEDIUM = " Medium ";
PX_TAG_MEDIUM_EXPAND_DESC = " Expansion is performed with some impact on normal I/O. ";
PX_TAG_MEDIUM_REBUILD_DESC = " The drive is rebuilt with some impact on normal I/O. ";
PX_TAG_MIGRATE_IF_NECESSARY = " Migrate If Necessary ";
PX_TAG_MIGRATE_LDRIVE = " Migrate a logical drive ";
PX_TAG_MIGRATE_LDRIVE_DESC = " Change the RAID or stripe size of an existing logical drive without disturbing the data on the logical drive. ";
PX_TAG_MIGRATE_NO_RAID1_DRIVES_DESC = " New arrays will be created with unassigned drives. ";
PX_TAG_MIGRATE_RAID1_DRIVES_DESC = " RAID 1+0 logical drives on arrays with an odd number of physical drives will be migrated to RAID 5 (RAID 6 (ADG) if possible). ";
PX_TAG_MODEL = " Model ";
PX_TAG_MODEL_MISMATCH = " Model Mismatch ";
PX_TAG_MODIFY_ARRAY = " Modify Array ";
PX_TAG_MORE_INFO_FOR = " More Information for ";
PX_TAG_NARROW = " Narrow ";
PX_TAG_NEGOTIATED_WIDTH = " Negotiated Width ";
PX_TAG_NO_MIGRATION = " No Migration ";
PX_TAG_NO_SAVE_DESC = " Discard the configuration. ";
PX_TAG_NO_SPARE_DESC = " Do not assign a spare. ";
PX_TAG_NONE = " None ";
PX_TAG_NORMAL = " Normal ";
PX_TAG_NOT_CONFIGURED = " Not Configured ";
PX_TAG_NOT_READY = " Not Ready ";
PX_TAG_NUMBER_OF_ARRAYS = " Number of Arrays ";
PX_TAG_NUMBER_OF_LOGICAL_DRIVES = " Number of Logical Drives ";
PX_TAG_NUMBER_OF_PHYSICAL_DRIVES = " Number of Physical Drives ";
PX_TAG_OK = " OK ";
PX_TAG_ONLINE = " Online ";
PX_TAG_OFFLINE = " Offline ";
PX_TAG_PCI_32 = " 32-Bit PCI ";
PX_TAG_PCI_64 = " 64-Bit PCI ";
PX_TAG_PCI_BLACKCAT = " Smart Array 4200 Controller ";
PX_TAG_PCI_DAZZLER = " SMART-2/P Controller ";
PX_TAG_PCI_DAZZLER_DH = " SMART-2DH Controller ";
PX_TAG_PCI_DAZZLER_3 = " Smart Array 3100ES Controller ";
PX_TAG_PCI_DRAX = " Smart Array 221 Controller ";
PX_TAG_PCI_EULER = " SAN Access Module ";
PX_TAG_PCI_FIRECRACKER = " Smart Array 4250ES Controller ";
PX_TAG_PCI_JAGUAR = " Fibre Channel Host Controller/P ";
PX_TAG_PCI_LAPLACE = " Smart Array 431 Controller ";
PX_TAG_PCI_MAXWELL = " Smart Array 5300 Controller ";
PX_TAG_PCI_MONEYPENNY = " SMART-2SL Controller ";
PX_TAG_PCI_PHREAD = " Smart Array 3200 Controller ";
PX_TAG_PCI_PERSIAN = " StorageWorks 64-Bit/66-Mhz Fibre Host Bus Adapter ";
PX_TAG_PCI_ROC = " Integrated Smart Array Controller ";
PX_TAG_PDRIVE = " Physical Drive ";
PX_TAG_PDRIVE_AT = " Physical Drive at ";
PX_TAG_PDRIVE_NAME = " <0size> Drive at <1phydrivelocation> ";
PX_TAG_PDRIVE_NAME_SPARE = " <0size> Drive at <1phydrivelocation> (Spare) ";
PX_TAG_PDRIVE_NAME_UNASSIGNED = " <0size> Unassigned Drive at <1phydrivelocation>  ";
PX_TAG_PDRIVES_CONTAINED = " Physical Drives Contained ";
PX_TAG_PDRIVES_OF_PORT = " Physical Drives Attached to Port ";

PX_TAG_PHYS_DRV_NUM = " Physical Drive Number ";
PX_TAG_PRESENT = " Present ";
PX_TAG_PRIMARY = " Primary ";
PX_TAG_PORT = " Port  ";
PX_TAG_RAID0 = " RAID 0 ";
PX_TAG_RAID1 = " RAID 1+0 ";
PX_TAG_RAID01 = " RAID 1+0 ";
PX_TAG_RAID4 = " RAID 4 ";
PX_TAG_RAID5 = " RAID 5 ";
PX_TAG_RAIDADG = " RAID 6 (ADG) ";
PX_TAG_RAID0_DESC = " No Fault Tolerance - Offers the greatest capacity and performance without data protection. ";
PX_TAG_RAID1_DESC = " Drive Mirroring - Offers the best combination of data protection and performance. ";
PX_TAG_RAID4_DESC = " Data Guarding - Offers the best combination of data protection and usable capacity. ";
PX_TAG_RAID5_DESC = " Distributed Data Guarding - Offers the best combination of data protection and usable capacity. ";
PX_TAG_RAIDADG_DESC = " Advanced Data Guarding - Offers improved data protection. ";
PX_TAG_RAID_ADG_STATUS = " RAID 6 (ADG) status ";
PX_TAG_READ = " Read ";
PX_TAG_READ_CACHE_SIZE = " Read Cache Size ";
PX_TAG_QUEUED_FOR_EXPANSION = " Waiting for Expansion ";
PX_TAG_QUEUED_FOR_REBUILDING = " Waiting for Rebuild ";
PX_TAG_REBUILDING = " Rebuilding ";
PX_TAG_REBUILD_PRIORITY = " Rebuild Priority ";
PX_TAG_RECONFIGURE = " Reconfigure ";
PX_TAG_REDUNDANCY_STATUS = " Redundancy Status ";
PX_TAG_REDUNDANT_PATH = " Redundant Path ";
PX_TAG_REDUNDANT_SLOT = " Redundant Slot ";
PX_TAG_REDUNDANT_TYPE = " Redundant Type ";
PX_TAG_REFRESH = "Refresh";
PX_TAG_REMOVE_SPARE_ARRAY_DESC = " Remove a spare drive from an array. ";
PX_TAG_REMOTE = " Remote ";
PX_TAG_RW = " (Read \%/Write \%) ";
PX_TAG_SCSI_ID = " SCSI ID  ";
PX_TAG_SECONDARY = " Secondary ";
PX_TAG_SECTORS_PER_TRACK = " Sectors per Track ";
PX_TAG_SECZ = " Extended PCI ";
PX_TAG_SERIAL_NUMBER = " Serial Number ";
PX_TAG_SET_BOXNAME = " Set Boxname ";
PX_TAG_SET_CACHE_RATIO = " Set Cache Ratio ";
PX_TAG_SET_EXPAND_PRIORITY = " Set Expand Priority ";
PX_TAG_SET_LDRIVE_CACHE = " Set Logical Drive Cache ";
PX_TAG_SET_REBUILD_PRIORITY = " Set Rebuild Priority ";
PX_TAG_SIZE = " Size ";
PX_TAG_SLOT_NUMBER = " Slot Number ";
PX_TAG_SSP_DISABLE_DESC = " Turn off SSP so all connections will have access to the logical drive. ";
PX_TAG_SSP_ENABLE_DESC = " Turn on SSP to control access to the logical drive. ";
PX_TAG_SSP_SETTINGS = " Selective Storage Presentation ";
PX_TAG_SSP_SETTINGS_DESC = " Change SSP connection names and logical drive access settings. ";
PX_TAG_SSP_STATUS = " Selective Storage Presentation Status ";
PX_TAG_STATUS = " Status ";
PX_TAG_STRIPE_SIZE = " Stripe Size ";
PX_TAG_STRIPE_SIZE_VALUE = " <0stripesize> ";
PX_TAG_SYSTEM_BOARD = " System Board ";
PX_TAG_TAPE_AT = " Tape Device at ";
PX_TAG_TAPE_DRIVE_NAME = " Tape Device at Port <0port> : ID <1id> ";
PX_TAG_TB = " TB ";
PX_TAG_TEMP_DISABLE = " Temporarily Disabled ";
PX_TAG_TRANSFER_SPEED = " Transfer Speed ";
PX_TAG_UB = " Upper Basic ";
PX_TAG_UB_CONFIG = " Upper Basic Configuration ";
PX_TAG_ULTRA = " Ultra ";
PX_TAG_ULTRA_SCSI = " ULTRA SCSI ";
PX_TAG_ULTRA2_SCSI = " ULTRA2 SCSI ";
PX_TAG_ULTRA3_SCSI = " ULTRA3 SCSI ";
PX_TAG_ULTRA4_SCSI = " ULTRA 320 ";
PX_TAG_UNAVAILABLE = " Unavailable ";
PX_TAG_UNKNOWN_CHOICE = " Unknown  ";
PX_TAG_UNKNOWN_CONTROLLER = " Unknown Controller ";
PX_TAG_UNKNOWN_SIZE = " ??? ";
PX_TAG_UNUSED_SPACE_NAME = " Unused Space, <0size> ";
PX_TAG_UNUSED_SPACE_NAME_DETAILED = " Array <0id> (Unused Space <1size>) ";
PX_TAG_UNUSED_SPACE_ON_ARRAY = " Unused Space on this Array ";
PX_TAG_WARRIOR = " WARRIOR ";
PX_TAG_WIDE = " Wide ";
PX_TAG_WRITE = " Write ";
PX_TAG_WRITE_CACHE_SIZE = " Write Cache Size ";
PX_TAG_WRONG_DRIVE_REPLACED = " Wrong drive replaced ";
PX_TAG_YES = " Yes ";
PX_TAG_YES_SAVE_DESC = " Save the configuration. ";
PX_TAG_YES_SPARE_DESC = " Assign a spare to all possible logical drives. ";

// SS510p3 Translations
PX_TAG_NOTE_CREATE_ARRAY_MIXED_CAPACITY = "Note: To avoid wasting drive capacity, select physical drives that are the same size for the new array.";
PX_TAG_NOTE_EXPAND_ARRAY_MIXED_CAPACITY = "Note: To avoid wasting drive capacity, select physical drives that are the same size as the existing physical drives in the array.";
PX_TAG_SELECT_ALL = "Select All";
PX_TAG_FLASH = "Flash";
PX_TAG_SSP_INVALID_CONNECTION_NAME = "SSP connection names can only consist of the following characters:\r\n\t a-z A-Z 0-9 ! @ # * ( ) , - _ + : . / [space]";
PX_TAG_CONTROLLER_RESCAN = "Rescan Controllers";

// SS550p1(Phoenix) translations

PX_TAG_SELECT_SWITCH = "Select Switch to Configure";
PX_TAG_SET_SWITCH_CONFIG = "Set Switch Configuration Parameters";
PX_TAG_SWITCH_CONFIG = "Switch Configuration";
PX_TAG_SWITCH_CONFIG_DESC = "Allows you to configure the switch or switches attached to your controller";
PX_TAG_SW_00_TEXT = "In the following screens, you will be asked a few simple questions that will allow the switch on your controller to be configured. Once your changes have been entered, clicking on the Finish link will immediately save any valid changes.";
PX_TAG_SW_01_TEXT = "Select the switch you wish to configure:";
PX_TAG_SW_IS_CONFIG_OK = "Enter your switch configuration parameters:";
PX_TAG_SWITCH_STATUS = "Switch Status: ";
PX_TAG_SWITCH_POSITION = "Switch Position: ";
PX_TAG_SWITCH_NAME = "<0name>";
PX_TAG_SWITCH_SETTINGS_INVALID = "At least one field contains invalid data.\r\nPlease ensure that all IP values are in the range from 0 to 255\r\n and that all text entries do not contain any invalid characters.\r\nValid text entries contain an empty field or alphanumeric characters.";
PX_TAG_SW_02_TEXT = "Choose the Switch Task you would like to perform:";
PX_TAG_SW_UTILITY_TEXT = "Switch Configuration Utility";
PX_TAG_SW_ACUXE_CONFIG = "ACU Switch Configuration";
PX_TAG_SW_ACUXE_CONFIG_DESC = "Allows you to configure the fundamental settings of the switch.";
PX_TAG_WHICH_SWITCH_PATH = "Select Configuration Method";
PX_TAG_SWITCH_SAVED = "NOTE: Once a Switch's Configuration has been changed and successfully saved, the Switch will automatically reset.  This will take a few moments.  Once the reset is complete, rescan all controllers to see the devices behind the Switch."; 
PX_TAG_SW_SAVE_WARNING = "WARNING!\n\nBefore saving the Switch parameters by clicking on the Finish link, make sure there are no I/O operations currently being performed on any Logical Volumes/Drives connected to the controller containing the Switch that you are configuring.";
PX_TAG_SW_UTILITY_UNAVAILABLE = "This Switch's status is currently set to Inactive.\n\nThe Switch Configuration Utility cannot be used to configure your Switch until the status is set to Active.  Once the IP, Gateway, and Subnet Mask address have been successfully set on your Switch, the status will be listed as Active and the Switch Configuration Utility will be available.";

PX_TAG_MAX_BOOT = "Max Boot";
PX_TAG_CONTROLLER_INFO = "Controller Information";
PX_TAG_ARRAY_INFO = "Array Information";
PX_TAG_LDRIVE_INFO = "Logical Drive Information";
PX_TAG_PDRIVE_INFO = "Physical Drive Information";
PX_TAG_TAPE_INFO = "Tape Device Information";
PX_TAG_UNASSIGNED_INFO = "Unassigned Drive Information";
PX_TAG_ACUXE = "Array Configuration Utility";
PX_TAG_VERSION = "Version <0num>";
PX_TAG_INTERNAL_PASS = "Internal Pass <0num>";
PX_TAG_LB_CC01_TEXT = "What would you like to do with your unassigned physical drives?";
PX_TAG_CREATE_ARRAY_DESC = " Create a new array with unassigned physical drives. ";
PX_TAG_AV_CD_01_TEXT = "Set the parameters of the new logical drive:";
PX_TAG_SIZE_RANGE = "(16 MB - <0maxsize> MB)";
PX_TAG_SIZE_MAX = "(<0maxSize> MB max)";
PX_TAG_AV_00_NO_TASKS = "There are no configuration options for the selected item.";
PX_TAG_AV_00_SELECT_TASK = "Select a task for: ";
PX_TAG_AV_CONFIG_TEXT = "Select an item below to list available tasks:";
PX_TAG_MORE_INFO = "More Information";
PX_TAG_DONE = "Done";
PX_TAG_AV_00_CLICK_ITEM = "Click on an item in the configuration view to list the available tasks for that item.";
PX_TAG_AV_CREATE_ARRAY = "Create Array";
PX_TAG_AV_EXPAND_ARRAY = "Expand Array";
PX_TAG_AV_EXTEND_LDRIVE = "Extend Size";
PX_TAG_AV_REMOVE_SPARE = "Remove Spare";
PX_TAG_AV_CREATE_LDRIVE = "Create Logical Drive";
PX_TAG_AV_MIGRATE_LDRIVE = "Migrate RAID / Stripe Size";
PX_TAG_AV_CONTROLLER_SETTINGS = "Controller Settings";
PX_TAG_AV_SSP = "Selective Storage Presentation";
PX_TAG_AV_CLEAR_CONFIG = "Clear Configuration";
PX_TAG_EXPRESS_CONFIG = " Express Configuration ";
PX_TAG_EXPRESS_CONFIG_DESC = " Asks you a few simple questions, then configures your controller. ";
PX_TAG_CACHE_RATIO = " Cache Ratio ";
PX_TAG_AV_LDRIVE_ACCELERATOR_SETTINGS = "Logical Drive Array Accelerator Settings";
PX_TAG_LDRIVE_SSP_STATE = "Logical Drive SSP State";
PX_TAG_AV_PDRIVE_SELECT_FOR_ARRAY = "Select the Physical Drives for the New Array";
PX_TAG_AV_LDRIVE_SELECT_FOR_CACHE = "Select the Logical Drives to Enable the Array Accelerator";
PX_TAG_AV_PDRIVE_SELECT_FOR_EXPAND = "Select the Physical Drives to Add to the Array";
PX_TAG_EXPANSION_STATUS = "Percentage of Expansion Completed For:";
PX_TAG_REBUILDING_STATUS = "Percentage of Rebuilding Completed For:";
PX_TAG_PRINT = "Print";
PX_TAG_STATUS_WARNING = "There are status messages for this controller.\nTo view status messages, click on the status messages link in the center of the following screen.";
PX_TAG_AV_SELECT_TASK = "Select a Configuration Task:";
PX_TAG_CONFIG_CANCEL_CURRENT_TASK = "You cannot select an item in the configuration view right now\nbecause you are currently in the process of a configuration task.\nIf you want to change tasks, click on Cancel to cancel out of the current task\nand then reselect an item in the configuration view."
PX_TAG_PCI_BORG = " Smart Array 5i Controller ";
PX_TAG_PCI_FOURIER = " Smart Array 532 Controller ";
PX_TAG_PRESS_OK_TO_FINISH = "Click on OK to accept your changes.";
PX_TAG_INTERIM_RECOVERY_MODE = "Interim Recovery Mode";
PX_TAG_OK_CANCEL = "Press OK to continue, or Cancel to return.";
PX_TAG_AV_CLEAR_CONFIG_DELETE_LDRIVE = "Clearing the configuration of this controller will delete all arrays and logical drives on this controller.\nAny data on these logical drives will be lost!";
PX_TAG_AV_CLEAR_CONFIG_DELETE_LDRIVE_PARTITION = "This controller has one or more logical drives that have partitions on them.\nClearing the configuration of this controller will cause all partitions on the logical drives of this controller to be deleted.\nAny data on these logical drives should be backed up before saving the configuration.";
PX_TAG_AV_CLEAR_CONFIG_DELETE_LDRIVE_SWVR = "StorageWorks Virtual Replicator information is stored on one or more logical drives on this controller.\nClearing the configuration of this controller will cause this information on the logical drives of this controller to be deleted.\nAny data on these logical drives should be backed up before saving the configuration.";
PX_TAG_AV_DELETE_ARRAY = "Deleting the selected array will cause any logical drives on it to be deleted.\nAll data on the logical drives will be lost!";
PX_TAG_AV_DELETE_ARRAY_PARTITION = "One or more logical drives on the selected array have partitions on them.\nDeleting the array will cause the partitions on the logical drives to be deleted.\nAny data on the logical drives should be backed up before saving the configuration.";
PX_TAG_AV_DELETE_ARRAY_SWVR = "One or more logical drives on the selected array have StorageWorks Virtual Replicator information stored on them.\nAny data on the logical drives should be backed up before saving the configuration.";
PX_TAG_AV_DELETE_LDRIVE = "Deleting the selected logical drive will cause all data on the drive to be lost!";
PX_TAG_AV_DELETE_LDRIVE_PARTITION = "The selected logical drive has a partition on it.\nAll data on this logical drive should be backed up before saving the configuration.";
PX_TAG_AV_DELETE_LDRIVE_SWVR = "StorageWorks Virtual Replicator information is stored on the selected logical drive.\nAny data on the logical drive should be backed up before saving the configuration.";
PX_TAG_SAVING = "Saving Configuration...";
PX_TAG_SAVECONFIG = "Save Configuration";
PX_TAG_CONFIGVIEW = "Configuration View";
PX_TAG_NOTE_CREATE_LOGICAL_DRIVE_ALIGNMENT = "Note: The size may be automatically adjusted slightly to optimize performance.";
PX_TAG_NOTE_EXTEND_LOGICAL_DRIVE_ALIGNMENT = "Note: The size may be automatically adjusted slightly to optimize performance.";

PX_TAG_UB_SPV2_01_TEXT = "Enable/Disable SSP for the controller:";
PX_TAG_LOGICAL_DRIVE = "Logical Drive";
PX_TAG_SSP_SETTINGS2 = " Selective Storage Presentation Settings";
PX_TAG_UB_SPV2_02_TEXT = "Set SSP access settings for each logical drive and rename connections.";
PX_TAG_SSPV2_DISABLE_DESC = " Turn off SSP so all connections will have access to all logical drives on the controller. ";
PX_TAG_SSPV2_ENABLE_DESC = " Turn on SSP to control access to each logical drive on the controller. ";
PX_TAG_CONTROLLER_SSP_STATE = "Controller SSP State";

PX_TAG_SSPV2_EMPTY_WARNING = "You have not granted any connections access to any logical drives.\nThis is not a valid configuration for SSP to be enabled.\nEither give at least one connection access to a logical drive,\nor go back to the previous screen and disable SSP.";

PX_TAG_PCI_EMULEX = "StorageWorks Fibre Channel Adapter";
PX_TAG_PCI_NIGHTINGALE = "Smart Array 5312 Controller";
PX_TAG_FIBRE_VOYAGER_EL = "MSA1000 Controller";

PX_TAG_ONLINE_SPARE_DRIVE = " Online Spare Drive(s) ";
PX_TAG_SPARE_MANAGEMENT = " Spare Management ";                                                            
PX_TAG_AM_SM_00_TEXT = "The following screens will allow you to add and remove spares from an array.";                        
PX_TAG_AM_SM_01_TEXT = "Select the array you would like to add or remove a spare from.";                   
PX_TAG_AM_CA_SM_02_TEXT = "Would you like to add spare(s) to the new array?";
PX_TAG_AM_CA_SM_03_TEXT = "Check the drive(s) you would like to add to the new array:"; 
PX_TAG_REMOVE_SPARE_ARRAY = " Remove Spare ";
PX_TAG_ASSIGN_SPARE_ARRAY = " Add Spare ";                             
PX_TAG_ASSIGN_SPARE_ARRAY_DESC = " Assign a spare to an array. "; 
PX_TAG_AV_PDRIVE_SELECT_SPARE = "Assign a Spare to the Array";
PX_TAG_AV_ASSIGN_SPARE = "Add Spare";        
PX_TAG_AV_SPARE_MANAGEMENT = "Spare Management"; 

PX_TAG_EXPAND_ARRAY_EVEN_REQUIRED = "An even number of physical drives must be selected because this array\nhas one or more logical drives with a fault tolerance of RAID 1+0.\nMigration to another Raid level is either not supported by this controller or is not supported with the current configuration.";
PX_TAG_LDRIVE_INVALID_SIZE ="Invalid logical drive size entered.\nThe size of the current logical drive must consist of numerical characters\r\n and be between <0minSize> MB and <1maxSize> MB.";
PX_TAG_INACTIVE = "Inactive";
PX_TAG_ACTIVE = "Active";
PX_TAG_LEFT = "Left";
PX_TAG_RIGHT = "Right";

PX_TAG_UB_SP_03A_TEXT = "You have restricted access to this logical drive which may currently be in use by one or more servers. After saving the configuration, further I/O from the adapters that do not have access to this logical drive will fail. Also, any writes cached by the operating system on the servers with the adapters that do not have access will not be written to the logical drive.  Before saving the configuration, make sure the logical drive is not in use by the operating systems on the servers that no longer have access.";
PX_TAG_NOTE_LAST_POSSIBLE_LDRIVE_CONTROLLER = "Note: This is the last logical drive you can create on this controller. There can only be 32 logical drives on a controller.";
PX_TAG_SELECT_TASK = "Select a task below:";
PX_TAG_SWITCH_SAVE_NOTE = "Note: Saving the switch configuration may take up to 4 minutes.";
PX_TAG_FILE_NAME = "File Name";
PX_TAG_SWITCH_SLOT = "Slot <0slot>";

PX_TAG_SSP_DETAILS = "Details";
PX_TAG_SSP_LOCATION_LABEL = "Location:";
PX_TAG_SSP_STATUS_LABEL = "Status:";
PX_TAG_SSP_HBA = "Host Controller";

PX_TAG_RAD_NUMBER = " Rad Number ";
PX_TAG_PCI_BUS_NUMBER = " PCI Bus Number ";
PX_LDRIVE_OS_MAP = " Logical Drive OS Access Name ";


PX_TAG_GENERIC_HBA = "PCI Based Fibre Channel Adapter";

PX_TAG_LICENSE_KEY_CONFIG = "License Key Management";
PX_TAG_LICENSE_KEY_CONFIG_DESC = "Allows you to enter new License Keys or delete existing Keys, while displaying all License Keys currently on a Controller.";
PX_TAG_KEY_00_TEXT = "Enter your License Key parameters:";
PX_TAG_LICENSE_KEY_ENTER = "Enter License Key";
PX_TAG_LICENSE_KEY_ENTER_DESC = "Allows you to enter a License Key to enable a locked Feature on a Controller.";
PX_TAG_LICENSE_KEY_TABLE_0 = "Complete List of Existing License Keys on Controller";
PX_TAG_LICENSE_KEY_TABLE_00 = "Submitted Key Activated";
PX_TAG_LICENSE_KEY_TABLE_1 = "Existing Key";
PX_TAG_LICENSE_KEY_TABLE_VALIDATED_1 = "Validated Key";
PX_TAG_LICENSE_KEY_TABLE_2 = "Enabled Feature";
PX_TAG_LICENSE_KEY_TABLE_22 = "Status";
PX_TAG_LICENSE_KEY_TABLE_3 = "Key Entered was Valid....Welcome to your new Feature!!";
PX_TAG_SUBMIT_KEY = "Submit";
PX_TAG_LICENSE_KEY_FINISH = "License Key Entered Successfully";
PX_TAG_LICENSE_KEY_REPEAT = "Would you like to enter another Key?";
PX_TAG_LICENSE_KEY_ENTRY_FIELDS_BLANK = "One or more of the License Key Entry fields contain no data.\r\nPlease make sure to enter 5 characters in each data field before submitting\r\nfor License Key validation."
PX_TAG_VALIDATING_LICENSE_KEY = "Validating Entered License Key...";
PX_TAG_KEY_AA0_TEXT = "The following screens will allow you to either Enter or Delete a License Key on your controller.";
PX_TAG_KEY_AA1_TEXT = "Select the task you wish to perform:";
PX_TAG_LICENSE_KEY_CHOOSE_TEXT = "Choose License Key Task";
PX_TAG_LICENSE_KEY_DELETE = "Delete License Key";
PX_TAG_LICENSE_KEY_DELETE_DESC = "Allows you to delete a License Key on a Controller.";
PX_TAG_KEY_D0_TEXT = "Select the License Key or Keys you would like to delete:";
PX_TAG_DELETING_LICENSE_KEY = "Deleting Selected License Key(s)...";
PX_TAG_LICENSE_KEY_DELETE_FINISH = "License Key(s) Deleted Successfully";
PX_TAG_AVAILABLE_KEYS_TO_DELETE = "List of License Key(s) currently available for Deletion";
PX_TAG_KEY_DELETE_CHOICES_EMPTY = "Please make sure at least one License Key is marked for Deletion before clicking on Submit.";
PX_TAG_SELECT_ALL_KEYS = "Select All License Keys";
PX_TAG_LICENSE_KEY_DELETE_REPEAT = "Would you like to delete another Key?";
PX_TAG_LICENSE_KEY_DELETE_SUCCESS = "Deletion of License Key(s) has been completed."
PX_TAG_NO_LICENSE_KEY = "No License Key Present";
PX_TAG_NO_LICENSE_KEY_FNAME = "No Feature to Report";
PX_TAG_NO_LICENSE_KEY_STATUS = "No Status to Report";
PX_TAG_LICENSE_KEY_ENTRY_FIELDS_INVALID = "At least one field contains invalid data.\r\nPlease ensure that all entered values are alphanumeric\r\nand that the entries do not contain any invalid characters.\r\nValid text entries contain only alphanumeric characters:\r\n 0-9, a-z, A-Z.";


PX_TAG_FNAME_DUPLICATE = "Duplicate Feature";
PX_TAG_FNAME_UNKNOWN = "Unknown Feature";
PX_TAG_HWSN_MISMATCH = "Hardware Serial Number Mismatch";
PX_TAG_HWSERIES_MISMATCH = "Hardware Series Mismatch";

PX_TAG_REMOVE_FAILED_SPARES = "One or more spare drives are failed.\r\nIf you want to continue, you must uncheck all failed spare drives so that they will be dropped from the array.\r\nOtherwise, replace the failed spare drives.";
PX_TAG_CREATE_ARRAY_SPARE_EMPTY = "You answered Yes to add spare(s) to the array,\nhowever you have not selected any spares.\n\nClick OK to continue or Cancel to return.";

// Phoenixpass3  
PX_TAG_DEVICE_IN_USE_BY_OS = "Locked for Use by Operating System";
PX_TAG_CONFIGURE = "Configure";
PX_TAG_COMPAQ = "Compaq";
PX_TAG_KEY_EXPIRED = "Expired";
PX_TAG_AV_00_CLICK_ITEM_1 = "Click on an item in the Configuration View";
PX_TAG_AV_00_CLICK_ITEM_2 = "to list the available tasks for that item.";
PX_TAG_LICENSE_KEY_ENTRY_LENGTH_NOT_VALID = "At least one field contains invalid data.\r\nPlease make sure the required number of characters, 25, has been entered.\r\nPlease ensure that all entered values are alphanumeric\r\nand that the entries do not contain any invalid characters.\r\nValid text entries contain only alphanumeric characters:\r\n 0-9, a-z, A-Z.";
PX_TAG_STANDARD_NAV_LINK = "Navigation";
PX_TAG_STANDARD_STATE_LINKS = "Controller State";

PX_TAG_ADVANCED_CONFIG = " Standard Configuration ";
PX_TAG_ADVANCED_CONFIG_DESC = " Gives you the greatest flexibility in configuring your controller. ";

PX_TAG_MANUAL_CONFIG = " Configuration Wizards";
PX_TAG_MANUAL_CONFIG_DESC = " Allows you to configure your controller using a series of wizards which guide you through the process. ";

PX_TAG_ASSISTED_CONFIG = " Configuration Wizards ";
PX_TAG_ASSISTED_CONFIG_DESC = " Allows you to configure your controller using a series of wizards which guide you through the process. ";

PX_TAG_AV = " Standard ";
PX_TAG_AV_CONFIG = " Standard Configure ";

PX_TAG_PARITY_INITIALIZING = "Background Parity Initializing/Queued";

PX_TAG_PHYS_DRV_MISCONNECTED = " Physical Drive Failed ";

PX_TAG_SEC_RANGE_ENABLE = " Valid range: <0minScan> - <1maxScan> seconds ";
PX_TAG_SEC = " sec";
PX_TAG_SCAN_SIZE = "Surface Scan Delay";
PX_TAG_SCAN_SIZE_INVALID ="Invalid surface scan delay entered.\nThe surface scan delay entered must consist of numerical characters\r\n and be between <0minSize> and <1maxSize> seconds.";
PX_TAG_SURFACE_SCAN_DELAY = "Current Surface Scan Delay ";


// SS 6.10 Pass #1 Translations
PX_TAG_HOST_MODE = " Host Mode ";
PX_TAG_HOST_UNKNOWN = "No Host Mode";
PX_TAG_EXIT = "Exit ACU";
PX_TAG_HOST_MODE_DEFAULT = "Default";
PX_TAG_SSP_CONN_HOST_INVALID_COMBO = "To set a valid Host Mode you must first set a SSP connection name for the adapter.\r\nSSP connection names can only consist of the following characters:\r\n\t a-z A-Z 0-9 ! @ # * ( ) , - _ + : . / [space]";


PX_TAG_LDRIVE_TYPE = "Logical Drive Type";
PX_TAG_DATA_VOLUME = "Data Volume";
PX_TAG_SNAPSHOT_RESOURCE_VOLUME = "Snapshot Resource Volume";
PX_TAG_SNAPSHOT_RESOURCE_VOLUME_OWNER = "Snapshot Resource Volume Owner";
PX_TAG_SOURCE_VOLUME = "Data Volume";
PX_TAG_LDRIVE_SHORT_NAME = " Logical Drive <0id> ";
PX_TAG_TYPE = "Type";
PX_TAG_RESOURCE_VOLUME_SETTINGS = "Snapshot Resource Volume Settings";
PX_TAG_MAKE_RESOURCE_VOLUME = "Make this a Snapshot Resource Volume";
PX_TAG_RESOURCE_VOLUME_OWNER = "Resource Volume Owner";
PX_TAG_YES_RESOURCE_VOLUME = "Yes, make this logical drive a Snapshot Resource Volume for ";
PX_TAG_RESOURCE_VOLUME_NAME = "Snapshot Resource Volume for Logical Drive <0id>";
PX_TAG_NO_SOURCE_RESOURCE_ASSOCIATION    = "No Owner Association";
PX_TAG_REPLICA_STATE_OK                  = "OK";
PX_TAG_UNKNOWN_FAILURE                   = "Unknown Failure";
PX_TAG_RESOURCE_DISCONNECTED_FROM_SOURCE = "Resource Volume Disconnected";
PX_TAG_RESOURCE_CANNOT_LOCATE_SOURCE     = "Failed to Locate Owner";
PX_TAG_SOURCE_CANNOT_LOCATE_RESOURCE     = "Failed to Locate Resource Volume";
PX_TAG_SOURCE_FAILED                     = "Owner Failed";
PX_TAG_RESOURCE_FAILED                   = "Resource Volume Failed";
PX_TAG_REPLICA_STATUS                    = "Resource Volume Link Status";
PX_TAG_HAS_RESOURCE_VOLUME               = "Has Resource Volume";
PX_TAG_RESOURCE_VOLUME_NOT_AVAILABLE     = "Resource Volume Not Available";
PX_TAG_SOURCE_VOLUME_NOT_AVAILABLE       = "Owner Not Available";
PX_TAG_RESOURCE_VOLUME_OBSOLETE          = "Resource Volume Obsolete";


PX_TAG_SW_UTILITY_TEXT_DESC = "Launches the Switch Configuration Utility to setup detailed switch parameters.  Note: Once the Utility window has been spawned, the ACU portion of the task will be complete.  To use ACU again for Switch Configuration after finishing with the Utility, click on the Switch Configuration task link on the Main Menu.";
PX_TAG_SW_UTILITY_CONFIG = "Switch Configuration Utility ( <0completeIpString> )";
PX_TAG_KEY_RETURN = "Key Management Tasks";

PX_TAG_UB_XD_00_TEXT = "The following screens will allow you to extend the size of a logical drive.";
PX_TAG_AV_CREATE_RESOURCE_VOLUME = "Create Snapshot Resource Volume";
PX_TAG_CREATE_RESOURCE_VOLUME = " Create a snapshot resource volume ";
PX_TAG_CREATE_RESOURCE_VOLUME_DESC = " Create a new snapshot resource volume. ";
PX_TAG_UB_CRV_00_TEXT = "The following screens will allow you to create a snapshot resource volume using the free space available from one of your arrays. You will be able to select the resource volume owner, size, RAID level, stripe size, max boot, and array accelerator support. A snapshot resource volume is a special type of logical drive. You will be able to perform all the same operations on a snapshot resource volume that you are able to perform on a logical drive. ";
PX_TAG_UB_CRV_01_TEXT = "Select the free space to create a new snapshot resource volume:";
PX_TAG_UB_CRV_01B_TEXT = "Select the resource volume owner:";
PX_TAG_UB_CRV_02_TEXT = "Select the fault tolerance for the new snapshot resource volume:";
PX_TAG_UB_CRV_03_TEXT = "Select the stripe size for the new snapshot resource volume:";
PX_TAG_UB_CRV_04_TEXT = "Would you like to enable Max Boot?";
PX_TAG_UB_CRV_05_TEXT = "Enter the size for the new snapshot resource volume:";
PX_TAG_UB_CRV_06_TEXT = "Would you like to enable the array accelerator?";
PX_TAG_UB_CD_06A_TEXT = "Do you want this logical drive to be a Snapshot Resource Volume?";
//PX_TAG_UB_SPV2_02A_TEXT = "You have restricted access to one or more logical drives which may currently be in use by one or more servers. After saving the configuration, further I/O from the adapters that are providing these connections to logical drives will fail. Also, any writes cached by the operating system on the servers with the adapters that do not have access will not be written to the logical drives.  Before saving the configuration, make sure the logical drives are not in use by the operating systems on the servers that no longer have access. Also, if any of your logical drives that you have restricted access to are snapshot resource volumes, then you have restricted access to any snapshots on them so they will not visible to the operating system when mounted.";
PX_TAG_UB_SPV2_02A_TEXT = "You have restricted access to one or more logical drives which may currently be in use by one or more servers. After saving the configuration, further I/O from the adapters that are providing these connections to logical drives will fail. Also, any writes cached by the operating system on the servers with the adapters that do not have access will not be written to the logical drives.  Before saving the configuration, make sure the logical drives are not in use by the operating systems on the servers that no longer have access.";

// SS 620 Pass #4 Translations
PX_TAG_LICENSE_KEY_EXPIRATION_ALERT = "The License Key entered: \r\n\r\n <0keyname>\r\n\r\n will expire in <1keyexpiration> days.";
PX_TAG_DELETION_OF_DEMO_KEY_WARNING = "Note: Once a Demo Key has been entered and successfully validated, it cannot be deleted from the controller even after the Key has expired.  However, if the License Key is not a Demo Key, it can be deleted from the controller at anytime by using the Delete License Key task.";
PX_TAG_DELETION_OF_KEY_WARNING = "Note:  Please make sure you have selected the correct Key or Keys for deletion BEFORE clicking on the Delete link.  Once the Delete link has been clicked, all of the selected License Key(s) will be deleted from the controller.  If the License Key you wish to Delete is not available in the list, that Key was designated as a Demo Key and cannot be deleted from the controller even if it has expired.";
PX_TAG_RESOURCE_VOLUME_OBSOLETE_FAILED = "Resource Volume Obsolete/Failed";
PX_TAG_MEMORY_ON_CONTROLLER = " Total Memory on Controller ";
// rs20Nov02
PX_TAG_ONLINE_ACTIVE_SPARE_DRIVE = " Active ";
// rs10Jan03
PX_TAG_PCI_KEPLER = "Smart Array 6400 Controller";
PX_TAG_PCI_COPERNICUS = "Smart Array 6400 EM Controller";
PX_TAG_PDRIVE_NAME_ACTIVE_SPARE = " <0size> Drive at <1phydrivelocation> (Active Spare) ";
// PX_TAG_SSP_UNKNOWN was misspelled, Unkown, in the jpn translations. Basically this string only
// needs to be re-translated in Japanese.
PX_TAG_SSP_UNKNOWN = "Unknown";

// SS 630 pass4 translations

PX_TAG_UB_SAVE_MESSAGE = "Continuing will commit any changes you have made to the controller.\n\nAll arrays which do not contain at least one logical drive will be deleted.\n\nAll spare drives assigned to arrays which contain only RAID 0 logical\ndrives will be removed.\n\nCertain operating systems may require a reboot for changes to take effect.\n\nClick OK to continue or Cancel to return.";
PX_TAG_PCI_DARK_MATTER = "Smart Array 641 Controller";
PX_TAG_PCI_ANTI_MATTER = "Smart Array 642 Controller";

// SS 640 pass4 translations
PX_TAG_WIZARDS="Wizards";
PX_TAG_MAIN_MENU = "Exit Wizard";


// SS 700 Pass6 Translations
PX_TAG_IPF_CABINET = "Cabinet <0cabinet>";
PX_TAG_IPF_CONNECTED_CABINET = "Cabinet <0connectedcabinet>";
PX_TAG_IPF_IO_BAY = "IO Bay <0iobay>";
PX_TAG_IPF_IO_CHASSIS = "IO Chassis <0iochassis>";
PX_TAG_LOCATION_SLOT = "Slot <0slot>";
PX_TAG_IPF_CONNECTED_TO = "- Connected To -";
PX_TAG_IPF_CELL = "Cell <0cell>";
PX_TAG_CONTROLLER_NAME_LOCATION = " <0controller> in <1location> ";
PX_TAG_CONTROLLER_LOCATION_IPF = " <0ipfcabinet>, <1ipfiobay>, <2ipfiochassis>, <3ipfslot> ";
PX_TAG_CONTROLLER_LOCATION_MORE_INFO = " Controller Location ";
PX_TAG_HBA_LOCATION_MORE_INFO = " Host Controller Location ";
PX_TAG_LOCATION_SLOT_UNKNOWN = "Slot Unknown";
PX_TAG_CONTROLLER_LOCATION_ALPHA = " <0alphaslot>, <1alphabus>, <2alpharad>, <3alphahose> ";
PX_TAG_ALPHA_BUS = "PCI Bus <0bus>";
PX_TAG_ALPHA_RAD = "Rad <0rad>";
PX_TAG_ALPHA_HOSE = "Hose <0hose>";

PX_TAG_MANUAL_REORDER = " Logical Drive Reordering Wizard";                     
PX_TAG_MANUAL_REORDER_DESC = " Allows you to reorder your logical drives. ";
PX_TAG_LDRIVE_REORDERING = "Logical Drive Reordering";
PX_TAG_NO_TASKS = " No Tasks Available "

PX_TAG_CRITICAL_ERROR_TEXT = "ACU has encountered the following critical error while attempting to configure your controller:";
PX_TAG_CONTROLLER_LOCKED_TEXT = " The current array controller cannot be configured because of one of the following reasons: ";
PX_TAG_CONTROLLER_LOCKED = "Controller is locked!";
PX_TAG_AV_REENABLE_LDRIVE = "Re-enable Failed Logical Drive";

PX_TAG_AV_WARN_REENABLE_LDRIVE = "Re-enabling the selected logical drive will allow the logical drive to be used again.\r\Any previously existing data on the logical drive may not be valid or recoverable.";
PX_TAG_AM_SM_02_TEXT = "Check the drive(s) you would like to add, as a spare, to an array or Uncheck the drive(s) to remove the spare from an array:";
PX_TAG_SPACER = " ";

//SS 7.10 Pass 3 Translations
PX_TAG_PCI_GLUON = "Smart Array 6i Controller";
PX_TAG_AV_PDRIVE_SELECT_DRIVE_TYPE = "Select Drive Type of Array"; //mm29Oct03
PX_TAG_PCI_INTREPID = "MSA500 G2 Controller";
PX_TAG_SAS = "SAS";
PX_TAG_PHYSICAL_DRIVE_PARALLEL = "Parallel SCSI";
PX_TAG_DRIVE_TYPE = "Type";
PX_TAG_ARRAY_TYPE = "Array Type";
PX_TAG_FIBRE_BLACK_WIDOW = "MSA1500 CS Controller";
PX_TAG_PCI_KINGCOBRA = "MSA20 Controller";
PX_TAG_NOT_SUPPORTED = "Not Supported";
PX_TAG_SATA_LOGICAL_DRIVE = "SATA Logical";

// PENDING SS 7.20 10/11/04 TRANSLATIONS
PX_TAG_CONTROLLER_WWN = "Controller WWN";
PX_TAG_CONTROLLER_SERIAL_NUMBER = "Controller Serial Number";
PX_TAG_UNKNOWN_PHYSICAL_DRIVE = " Unknown Drive Type";
PX_TAG_SATA_PHYSICAL_DRIVE = "SATA";
PX_TAG_PCI_FLAGSTAFF = " Smart Array 6422 ";
PX_TAG_PCI_LANCER = " Smart Array V100 ";
PX_TAG_AV_SPLIT_ARRAY = "Split Mirrored Array";
PX_TAG_AV_RESYNC_ARRAY = "Re-Mirror Array";
PX_TAG_AV_SELECT_ARRAY_RESYNC = "Select Array to mirror with <0array>";
PX_TAG_AV_SELECT_SOURCE_LOGICAL_DRIVES = "Select source Logical Drives for mirror";
PX_TAG_NOTE_ARRAY_RESYNC = "All data in the selected logical drives will be retained in the array mirror. Logical drives that are not selected will be overwritten.";

PX_TAG_PDRIVE_WRITE_CACHE_SETTINGS = "Physical Drive Write Cache Settings";
PX_TAG_PDRIVE_WRITE_CACHE_STATE = "Physical Drive Write Cache State";
PX_TAG_PDRIVE_WRITE_CACHE = "Physical Drive Write Cache";
PX_TAG_PDRIVE_WRITE_CACHE_SETTINGS_NOTE = "Without the proper safety precautions, use of write cache on physical drives could cause data loss in the event of power failure.  To ensure data is properly protected, use redundant power supplies and Uninterruptible Power Supplies. Also, if you have multiple storage enclosures, all data should be mirrored across them. Use of this feature is not recommended unless these precautions are followed.";

PX_TAG_SPARE_MANAGEMENT_DESC = " Assign or remove spare(s) from an array. ";
PX_TAG_SPARE_MANAGEMENT_DESC = " Assign or remove spare(s) from an array. ";
PX_TAG_AV_PDRIVE_SPARE_MANAGEMENT = "Assign or Remove Spare(s) from the Array";

PX_TAG_EXTEND_LDRIVE_WARNING_STRONG = "Warning!\n\nExtension may not be supported on Windows 2000 with the current array controller.\n\nIf the operating system for this logical drive is Windows 2000 and this logical drive contains dynamic disks, Windows 2000 may not be able to recognize the logical drive after extension and prevent you from accessing your data. However, if this logical drive is using physical drives that have only been used in the current configuration and no other configuration, extension will work properly if you are using Windows 2000 Service Pack 3 or later.\n\nIf the operating system for this logical drive is Windows 2000 and this logical drive contains only basic disks, extension will work properly.\n\nClick OK to continue. Otherwise, click Cancel to exit this task.";
PX_TAG_EXTEND_LDRIVE_WARNING_WEAK = "Warning!\n\nExtension may not be supported on Windows 2000 unless Service Pack 3 is installed.\n\nIf the operating system for this logical drive is Windows 2000 and this logical drive contains dynamic disks, Windows 2000 may not be able to recognize the logical drive after extension and prevent you from accessing your data. However, extension will work properly with dynamic disks if you are using Windows 2000 Service Pack 3 or later.\n\nIf the operating system for this logical drive is Windows 2000 and this logical drive contains only basic disks, extension will work properly.\n\nClick OK to continue. Otherwise, click Cancel to exit this task.";
PX_TAG_EXTEND_LDRIVE_WARNING_UPGRADE_FW = "Warning!\n\nExtension may not be supported on Windows 2000 unless Service Pack 3 is installed and you upgrade your array controller firmware.\n\nIf the operating system for this logical drive is Windows 2000 and this logical drive contains dynamic disks, Windows 2000 may not be able to recognize the logical drive after extension and prevent you from accessing your data. However, extension will work properly with dynamic disks if you are using Windows 2000 Service Pack 3 or later and you upgrade your array controller firmware to version <0fwversion> or later.\n\nIf the operating system for this logical drive is Windows 2000 and this logical drive contains only basic disks, extension will work properly.\n\nClick OK to continue. Otherwise, click Cancel to exit this task.";
PX_TAG_ADVANCED_FEATURES = "Advanced Features";
PX_TAG_BACK_TO_STANDARD_TASKS = "Back to Standard Tasks";
PX_TAG_NOTE_CREATE_LDRIVE_SSP_DISABLED = "Note: Selective Storage Presentation (SSP) is currently disabled. All connections will have access to this logical drive after saving the configuration. If you want to restrict access to this logical drive, modify the settings on the SSP screen before saving the configuration.";
PX_TAG_NOTE_CREATE_LDRIVE_SSP_ENABLED = "Note: Selective Storage Presentation (SSP) is currently enabled. No connections will have access to this logical drive until the access settings are modified on the SSP screen.";


// SS 7.20 11/29/04 TRANSLATIONS
PX_TAG_PCI_REDSTONE = " Smart Array P600 ";

// SS 7.20 02/11/05 TRANSLATIONS
PX_TAG_REDUNDANT_SETTINGS = "Redundancy Settings";
PX_TAG_REDUNDANT_MODE = "Redundancy Mode";
PX_TAG_ACTIVE_ACTIVE = "Active-Active";
PX_TAG_ACTIVE_STANDBY = "Active-Standby";
PX_TAG_ACTIVE_CONTROLLER = "Active Controller";
PX_TAG_CONTROLLER_1 = "Controller 1";
PX_TAG_CONTROLLER_2 = "Controller 2";
PX_TAG_PREFERRED_PATHS = "Preferred Logical Drive Paths";
PX_TAG_PREFERRED_PATH_MODE = "Preferred Path Mode";
PX_TAG_CONTROLLER_1_PREFERRED_PATH = "Controller 1 Preferred Path";
PX_TAG_CONTROLLER_2_PREFERRED_PATH = "Controller 2 Preferred Path";
PX_TAG_MANUAL = "Manual";
PX_TAG_AUTOMATIC = "Automatic";

// SS 7.40 6/14/05 TRANSLATIONS
PX_TAG_DISABLE_STANDBY_CONTROLLER = "Disable Redundant Controller";
PX_TAG_DISABLE_STANDBY_CONTROLLER_WARNING = "Warning!\n\nContinuing will disable the non-preferred redundant controller and redundancy will no longer be enabled. \n\nAfter performing this task, save the configuration and monitor the controller's front panel display. Once the controller has been designated as disabled, you can safely remove it from your system\n\nClick OK to continue or Cancel to return.";
PX_TAG_PCI_VOYAGER_CL = "MSA500 Controller";
PX_TAG_RECHARGING = "Recharging";
PX_TAG_FAILED_REPLACE_BATTERIES = "Failed (Replace Batteries)";
PX_TAG_COMMON_TASKS = "Common Tasks";
PX_TAG_SELECT_CTRL = "Select Controller";

// SS 7.50.8.0 9/28/05 TRANSLATIONS
PX_TAG_PCI_SOYUZ  = " Smart Array P400 ";
PX_TAG_PCI_SPAWN  = " Smart Array P400 ";
PX_TAG_PCI_SPAWN_IMEZZ  = " Smart Array P400i ";
PX_TAG_PCI_STARGAZER  = " Smart Array E200 ";
PX_TAG_PCI_ROVER  = " Smart Array E200i ";
PX_TAG_UB_CS_04_TEXT = "Enter the Chassis Name for the controller:";
PX_TAG_SELECT_RAID_ARRAY_ID = "Set Chassis Name";
PX_TAG_RAID_ARRAY_ID = " Chassis Name ";
PX_TAG_CONTROLLER_SETTINGS_INVALID_RAID_ARRAY_ID = "The Chassis Name can only consist of the following characters:\r\n\t <0acceptedCharacters>";
PX_TAG_RAID_ARRAY_SERIAL_NUMBER = " Chassis Serial Number ";
PX_TAG_HOT_REMOVED = "Hot Removed";
PX_TAG_HOT_REMOVED_REPLACE_BATTERY = "Hot Removed (Replace Battery)";
PX_TAG_CONTROLLER_ONE_SERIAL_NUMBER = "Controller 1 Serial Number";
PX_TAG_REDUNDANT_CONTROLLER_SERIAL_NUMBER = "Controller 2 Serial Number";
PX_TAG_LDRIVE_UNIQUE_ID = "Logical Drive Unique ID";
PX_TAG_PCI_EXPRESS = "PCI Express";

// SS 7.50.9.0 11/3/05 Translations
PX_TAG_SPEED_ONE_DOT_FIVE_GBPS = " 1.5 Gbps ";
PX_TAG_SPEED_THREE_GBPS = " 3 Gbps ";
PX_TAG_PHY_COUNT = " PHY Count ";

// SS 7.60.12.0 6/21/06 Translations
PX_TAG_NOTE_LOGICAL_DRIVE_ABOVE_502_GB = "Note: Certain operating systems do not support logical drives greater than 502 GB or boot volumes greater than 2 TB. Check operating system documentation for details.";
PX_TAG_PCI_SATURNV = " Smart Array P800 ";
PX_TAG_PCI_SATURNV_LITE = " Smart Array P800 Lite ";
PX_TAG_TAPE_AT_PORT_BOX_BAY = " Tape Device at Port: <0port>  Box: <1box>  Bay:  <2bay>";
PX_TAG_TAPE_AT_PORT_DEVICE = " Tape Device at Port: <0port>  Device: <1device>";
PX_TAG_TAPE_AT_BOX_BAY = " Tape Device at Box: <0box>  Bay: <1bay>";
PX_TAG_DEVICE = " Device ";
PX_TAG_HBA_PORT_ID = " Host Controller Port ID ";
PX_TAG_SAS_SPITFIRE = " MSA 600/700 ";

// -----------------------------------------------------------------------------
// NEW/CHANGED FAQS TO BE TRANSLATED
//                  --- ADD NEW/CHANGED PARAGRAPHS BELOW ---
// -----------------------------------------------------------------------------
PX_TAG_LDRIVE_MESSAGES = " Logical Drive Messages ";
PX_TAG_POTENTIAL_STRIPE_SIZE_LOCKUP = " Logical Drive <0ID> (<1RAID>) has a high physical drive count as well as a high stripe size value such that a controller lock up could occur. It is recommended that the stripe size be migrated to a lower value. ";
PX_TAG_EXPAND_ARRAY_TOO_MANY_PD_SELECTED = "The maximum allowed number of physical drives for this array is <0max> due to a controller hardware limitation. Please only select this many drives before pressing OK.";
PX_TAG_FAILED_REPLACE_SPECIFIC_BATTERIES = "Failed, Replace Battery: ";
PX_TAG_PCI_BUMPER = " Smart Array E500 ";