##################################################################
# Copyright 1997-2002, Compaq Information Technologies Group, L.P. 
##################################################################
#
# Title   : linux.mk
#
# Author  : deckerj
#
##################################################################

OS_VERSION=$(shell uname -r)
OS_UP=
OS_SMP=
OS_ENT=

PROC_ENTRY=1

CRID_DAY_RAW=$(shell date +%-d)
CRID_DAY=$(shell expr $(CRID_DAY_RAW))
CRID_MONTH_RAW=$(shell date +%-m)
CRID_MONTH=$(shell expr $(CRID_MONTH_RAW))
CRID_YEAR_RAW=$(shell date +%-Y)
CRID_YEAR=$(shell expr $(CRID_YEAR_RAW) - 1990 )

ifneq "$(OS_UP)$(OS_SMP)$(OS_ENT)" ""
	LINUX_HEADERS = -D__BOOT_KERNEL_H -D__MODULE_KERNEL_i686=1 -D__BOOT_KERNEL_UP=$(OS_UP) -D__BOOT_KERNEL_SMP=$(OS_SMP) -D__BOOT_KERNEL_ENTERPRISE=$(OS_ENT) -D__BOOT_KERNEL_BIGMEM=$(OS_ENT) -D__BOOT_KERNEL_HUGEMEM=$(OS_ENT)
endif

ifneq "$(OS_DESCR)" ""
CPQRID_DESCRIPTION = -DCPQRID_DESCRIPTION="\"$(OS_DESCR)\""
endif

DFLAGS = -O -Wall -DLINUX -DEFS_VER="\"$(EFS_VER)\"" -DDRV_DAY=$(CRID_DAY) -DDRV_MON=$(CRID_MONTH) -DDRV_YEAR=$(CRID_YEAR) -DOS_VERSION=$(OS_VERSION) -DPROC_ENTRY=$(PROC_ENTRY) $(LINUX_HEADERS) $(CPQRID_DESCRIPTION) $(OS_MEM) $(OS_MACH)

IFLAGS=-I. -I/lib/modules/$(OS_VERSION)/build/include 

TARGET=cpqrid.o
TARGETLIB=.

SRCS = cridw_linux.c linux/cridw_proc.c
LIBS = cpqridp.o

include lxotmpl.mk

allex:

installex:

cleanex:

copy:	manifest.$(OS_MODEL)
	mkdir -p $(TARGETDIR)/linux
	cat manifest.$(OS_MODEL) | xargs -l1 -ix cp -av x $(TARGETDIR)/x
