#!/bin/sh
#
#  Copyright (c) 1999, by Sun Microsystems, Inc.
#  All rights reserved.
#
#pragma ident	"@(#)install.sh 1.16	99/01/01 SMI"

# script to install Driver Update diskette objects 
#

usage()
{
	echo
	echo Usage: $0 '[-l] [-i] [drv1 drv2 ...]'
	echo '    -l : list available Driver Update objects and exit'
	echo '    -i : interactively confirm each object to install'
	echo '    drv1 : add drv1 'drv1' if present'
	echo
}

yorn()
{
	read x
	if [ "$x" = "y" -o "$x" = "Y" -o "$x" = "yes" -o "$x" = "" ]; then
		return 0
	else
		return 1
	fi
}

do_pkg()
{
	mkdir -p $TMPDIR
	(
	cd $TMPDIR

	# uncompress object and un-pack cpio image
	ANAME=$$.$1
	if [ -f ${proddir}/$1.Z ]; then
		cp ${proddir}/$1.Z $TMPDIR/${ANAME}.Z
	else
		cp ${proddir}/$1.[Z\|z] $TMPDIR/${ANAME}.Z
	fi
	if uncompress ${ANAME}.Z; then
		:
	else
		mv ${ANAME}.Z ${ANAME}.z
		unpack ${ANAME}.z
	fi
	(cpio -id < ${ANAME} || tar xf ${ANAME} || unzip ${ANAME}) \
		>/dev/null 2>&1
	rm -f ${ANAME}
	if [ -x before.sh ]; then
		./before.sh
	fi
	for p in *; do
		if [ -f $p/pkginfo ]; then
			echo Installing package $p
			#
			# Attempt to install the package unconditionally
			#
			Pkg_admin=/tmp/admin.$$
			cat <<EOF > $Pkg_admin
mail=
runlevel=nocheck
conflict=nocheck
setuid=nocheck
action=nocheck
EOF
      # During OS installation or upgrade, driver
      # installation should proceed without requiring
      # user interaction.  So, force driver to be
      # installed over any pre-existing instance,
      # unless interactive mode was requested.
      if [ $iflag -ne 1 ]; then
        echo "instance=overwrite" >> $Pkg_admin
      fi
			pkgadd -a $Pkg_admin -d `pwd` -R $ROOTARG $p
			rm -f $Pkg_admin
		fi
	done
	if [ -x after.sh ]; then
		./after.sh
	fi
	)
	rm -fr $TMPDIR
}

do_patch()
{
	# found the compressed patch file
	echo Installing driver object $1
	if [ ! -d ${ROOTARG}/var/sadm/patch ]; then
		# XXX installpatch script will 
		# issue a warning if this directory
		# does not exist - fixed in patchadd.
		mkdir -p ${ROOTARG}/var/sadm/patch
	fi
	mkdir -p $TMPDIR
	(
	cd $TMPDIR
	# XXX: workaround for patchadd bug
	if [ -x ${DUroot}/patchadd ]; then
		patchcmd=${DUroot}/patchadd
	elif [ -x ${ROOTARG}/usr/sbin/patchadd ]; then
		patchcmd=${ROOTARG}/usr/sbin/patchadd
	elif [ -x /usr/sbin/patchadd ]; then
		patchcmd=/usr/sbin/patchadd
	elif [ -f ${DUroot}/patchsh.Z ]; then
		cp ${DUroot}/patchsh.Z $TMPDIR/patchsh.Z
		# get shared installpatch,backoutpatch scripts
		uncompress patchsh.Z
		cpio -id < patchsh > /dev/null 2>&1
		rm patchsh
		patchcmd=../installpatch
	elif [ -f ${DUroot}/patchsh.[Z\|z] ]; then
		cp ${DUroot}/patchsh.[Z\|z] $TMPDIR/patchsh.Z
		# get shared installpatch,backoutpatch scripts
		uncompress patchsh.Z
		cpio -id < patchsh > /dev/null 2>&1
		rm patchsh
		patchcmd=../installpatch
	else
		patchcmd=./installpatch
	fi

	# uncompress update object and un-pack cpio image.
	# change the name so that the archive can have the same
	# name as a patch it contains.
	ANAME=$$.$1
	if [ -f ${patchdir}/$1.Z ]; then
		cp ${patchdir}/$1.Z $TMPDIR/${ANAME}.Z
	else
		cp ${patchdir}/$1.[Z\|z] $TMPDIR/${ANAME}.Z
	fi
	if uncompress ${ANAME}.Z; then
		:
	else
		mv ${ANAME}.Z ${ANAME}.z
		unpack ${ANAME}.z
	fi
	(cpio -id < ${ANAME} || tar xf ${ANAME} || unzip ${ANAME}) \
		>/dev/null 2>&1
	rm -f ${ANAME}
	if [ -x before.sh ]; then
		./before.sh
	fi
	for p in "[0-9][0-9][0-9][0-9][0-9][0-9]-[0-9][0-9]"; do
		if [ -d $p ]; then
			echo "    installing patch" $p
			cd $p

			if [ ! -x $patchcmd ]; then
			  echo $myname: Cannot locate patchadd/installpatch
			  continue
			else
			  $patchcmd -R $ROOTARG -u `pwd`
			  cd ..
			fi
		fi
	done
	if [ -x after.sh ]; then
		./after.sh
	fi
	)
	rm -fr $TMPDIR
}




myname=$0
lflag=0
iflag=0
VERS="`uname -r | sed -e 's/5\./2/'`"
ISA=`uname -p`
if [ "$ISA" = "i386" ]; then
	ISA=i86pc
fi
FORCEFILE="force.lst"
ROOTARG="/"
args=
while getopts :liIR: c; do
	case $c in
	l)	lflag=1; args="$args -l";;
	i)	iflag=1; args="$args -i";;
	I)	installflag=1; args="$args -I";;
	R)	ROOTARG=$OPTARG; args="$args -R $OPTARG";;
	\?)	echo "\n$0: unknown option $OPTARG"
		usage
		exit 1;;
	esac
done
shift `expr ${OPTIND} - 1`

# list of objects to install passed in?
if [ $# -gt 0 ]; then
	inlist=1
else
	inlist=0
fi

# Determine the path to the ITOU(s)
# The top level directory is always "DU". This script lives
# in the ITOU at DU/release/arch/Tools/install.sh
if [ -d "./DU_TEST_DIR" ]; then
	DUroot=`pwd`/DU_TEST_DIR
else
	here=`pwd`
	there=`dirname $myname`
	cd ${there}/../../..
	DUroot=`pwd`
	cd ${here}
	if [ `basename $DUroot` != "DU" -a `basename $DUroot` != "du" ]; then
		echo "Cannot find path to ITOU"
		exit 1
	fi
fi
	

if [ $lflag -eq 1 ]; then
	echo
	echo "This Driver Update diskettes contains the following objects(s) for version sol_$VERS :"
	echo
	ls  ${DUroot}/sol_${VERS}/${ISA}/Product ${DUroot}/${VERS}/${ISA}/Patches
	echo
	exit 0
fi

proddir=${DUroot}/sol_${VERS}/${ISA}/Product
patchdir=${DUroot}/sol_${VERS}/${ISA}/Patches
bootdir=${DUroot}/sol_${VERS}/${ISA}/Tools/Boot
TMPDIR=${ROOTARG}/tmp/patch.$$
patch_list=$*

#
# add list of drivers which should be unconditionally installed
#
itus=${bootdir}/*/*.itu
if [ "$itus" = "" ]; then
	itus=${bootdir}/*/*.[I\|i][T\|t][U\|u]
fi
for i in $itus; do
	if [ ! -f "$i" ]; then
		break
	fi
	doinst="`tr '[A-Z]' '[a-z]' < $i | sed -n \
		-e '/^[\i ]*load_always.*=.*true/p' \
		-e '/^[	 ]*legacy_device.*=.*true/p' \
		-e '/^[	 ]*install_always.*=.*true/p'`"
	if [ "$doinst" != "" ]; then
		pname="`echo $i | tr '[A-Z]' '[a-z]'`"
		pname=`basename $pname .itu`
		skip=0
		for j in $patch_list; do
			if [ "$j" = "$pname" ]; then
				skip=1
				break
			fi
		done
		if [ "$skip" != 1 ]; then
			patch_list="$pname $patch_list"
		fi
	fi
done

#
# handle case of explicit object list passed in
#
if [ $inlist -eq 1 ]; then
	for i in $patch_list; do
		if [ -x "${bootdir}/$i/$i.sh" ]; then
			${bootdir}/$i/$i.sh $args $i
			continue
		elif [ -x "${bootdir}/$i/$i.[S\|s][H\|h]" ]; then
			${bootdir}/$i/$i.[S\|s][H\|h] $args $i
			continue
		fi

		if [ -f ${proddir}/$i.Z ]; then
			do_pkg $i
		elif [ -f ${proddir}/$i.[Z\|z] ]; then
			do_pkg $i
		fi

		if [ -f ${patchdir}/$i.Z ]; then
			do_patch $i
		elif [ -f ${patchdir}/$i.[Z\|z] ]; then
			do_patch $i
		fi
	done
	#
	# If we are called during an install, look for a force-install file
	# that contains a list of driver objects to install, one per line.
	# This allows us to squeeze required patches onto boot related
	# ITU diskette.
	#
	if [ "$installflag" -eq 1 -a -f ${patchdir}/${FORCEFILE} ]; then
		# read ITOU names 1 per line from FORCEFILE
		while read i ; do
			if [ ! -x "${bootdir}/$i/$i.sh" -a \
			     ! -x "${bootdir}/$i/$i.[S\|s][H\|h]" -a \
			     ! -f ${proddir}/${i}.Z -a \
			     ! -f ${proddir}/${i}.[Z\|z] -a \
			     ! -f ${patchdir}/${i}.Z -a \
			     ! -f ${patchdir}/${i}.[Z\|z] ]; then
				echo Patch object $i not found on diskette
				echo skipping $i
				continue
			fi
			skip=0
			for j in $patch_list; do
				if [ "$j" = $i ]; then
					continue
				fi
			done
			if [ -x "${bootdir}/$i/$i.sh" ]; then
				${bootdir}/$i/$i.sh $args $i
				continue
			elif [ -x "${bootdir}/$i/$i.[S\|s][H\|h]" ]; then
				${bootdir}/$i/$i.[S\|s][H\|h] $args $i
				continue
			fi

			if [ -f ${proddir}/$i.Z ]; then
				do_pkg $i
			elif [ -f ${proddir}/$i.[Z\|z] ]; then
				do_pkg $i
			fi

			if [ -f ${patchdir}/$i.Z ]; then
				do_patch $i
			elif [ -f ${patchdir}/$i.[Z\|z] ]; then
				do_patch $i
			fi
		done < ${patchdir}/${FORCEFILE}
	fi
	# finished arg list and forcefile list
	exit 0
fi

#
# Remaining code is to handle case where install.sh is invoked
# without explicit arguments of what objects to install.
#

if [ $iflag -eq 0 -a "$patch_list" != "" ]; then
	echo "Unconditionally installing ITUs $patch_list"
fi

# loop through all patches and build a list in $patchlist
patches="`ls ${patchdir}/*.Z ${proddir}/*.Z 2>/dev/null`"
if [ "$patches" = "" ]; then
	patches="`ls ${patchdir}/*.[Z\|z] ${proddir}/*.[Z\|z] 2>/dev/null`"
fi
for i in $patches; do
	if [ ! -f "$i" ] ; then
		# not a patch or product
		continue
	fi
	pname=`basename $i .[Z\|z]`
	skip=0
	for j in $patch_list; do
		if [ "$j" = "$pname" ]; then
			skip=1
			break
		fi
	done
	if [ "$skip" = 1 ]; then
		continue
	fi
	reply=0
	if [ $iflag -eq 1 ]; then
		echo "Install patch $pname ? [y] \c"
		yorn
		reply=$?
	fi
	if [ $reply -eq 0 ]; then
		patch_list="$patch_list $pname"
	fi
done

if [ "X$patch_list" = X ]; then
	exit 0
fi

for i in `echo $patch_list`; do
	if [ -x "${bootdir}/$i/$i.sh" ]; then
		${bootdir}/$i/$i.sh $args $i
		continue
	elif [ -x "${bootdir}/$i/$i.[S\|s][H\|h]" ]; then
		${bootdir}/$i/$i.[S\|s][H\|h] $args $i
		continue
	fi
	if [ -f ${proddir}/$i.Z ]; then
		do_pkg $i
	elif [ -f ${proddir}/$i.[Z\|z] ]; then
		do_pkg $i
	fi

	if [ -f ${patchdir}/$i.Z ]; then
		do_patch $i
	elif [ -f ${patchdir}/$i.[Z\|z] ]; then
		do_patch $i
	fi
done
