//
// base.js - base functions used by MediaShield UI
// 
// Copyright  2005 by NVIDIA Corporation.  All rights reserved.
// All information contained herein is proprietary and confidential to
// NVIDIA Corporation.  Any use, reproduction, or disclosure without the
// written permission of NVIDIA Corporation is prohibited.
//

//
// addEvent - add a listener for an object event
//

function addEvent(obj, event, func) {
    if (obj.addEventListener) {
        // W3C DOM standard
        obj.addEventListener(event, func, true);
    } else 
	if (obj.attachEvent) {
        // Microsoft
        obj.attachEvent("on" + event, func);
    }
}

//
// getElementId - get ID of a DOM element
//

function getElementId (element) {
    if (document.getElementById) {
        return document.getElementById(element);
    } else {
        return eval(element);
    }
}

//
// loadScriptById - dynamically load inline script into DOM
// 

function loadScriptById(id) {
    var newScript = document.createElement('script');
    var head = document.getElementsByTagName('head').item(0);

    newScript.setAttribute('type', 'text/javascript');

    if (newScript.canHaveChildren) {
        newScript.appendChild(document.createTextNode(id.text));
    } else {
        newScript.text = id.text;
    }

    head.appendChild(newScript);
}

//
// loadScriptByUrl - dynamically load remote script into DOM
// 

function loadScriptByUrl(url) {
    debugWrite("loadScriptByUrl not implemented !!!");
}
