//
// wizard.js - support routes for UI wizards
// 
// Copyright ?2005 by NVIDIA Corporation.  All rights reserved.
// All information contained herein is proprietary and confidential to
// NVIDIA Corporation.  Any use, reproduction, or disclosure without the
// written permission of NVIDIA Corporation is prohibited.
//

var wizardPaneId = null;
var mainPaneId = null;
var wizardName = null;
var wizardPages = null;
//var wizardPageNum;

var currentPageId = null; // set to null on wizard load

//
// wizardLoadComplete - handle completion of a wizard load operation
//

function wizardLoadComplete(req) {
    debugWrite("wizardLoadComplete is called");

    switch (req.status) {
        case 200: {
            var scriptIds;

            debugWrite("loaded " + wizardName + " wizard");

            // Load returned wizard HTML into wizard pane
	    try{
              wizardPaneId.innerHTML = req.responseText;
              //wizardPaneId.innerHTML = req.responseText;
            }catch(e){
              wizardPaneId.innerHTML = "";
            }

            // Load wizard's scripts
            scriptIds = wizardPaneId.getElementsByTagName("script");

            for (var i = 0; i < scriptIds.length; i++) {
                loadScriptById(scriptIds[i]);
            }


        } break;

        default: {
            // XXX
            wizardPaneId.innerHTML =
                "<h3>Server Error: " + req.status + "</h4>";
            
        } break;
    }
}

//
// wizardLoad - load and start wizard, hide main pane
//

function wizardLoad(name) {
    debugWrite("wizardLoad is called "+name);
    if (wizardName == null) {
	debugWrite("wizardName==null");
        // Hide main pane, disable system task menu
        mainPaneId.style.display = "none";
        systemTasksTableDisable();

        // Clear old content, then display wizard pane
        // XXX add a loading animated GIF
        wizardPaneId.innerHTML = "";
        wizardPaneId.style.display = "block";

        // Request first wizard page
        wizardName = name;
        //        wizardPageNum = 0;

	debugWrite("before wizard request");
// sometimes cgi program is not invoked by the request below in firefox, possible caching? sending post data will get around of the problem. 
// wizardRequest(wizardLoadComplete, "?page="+wizardName+".html", true);
        wizardRequest(wizardLoadComplete, "?page",true, "page="+wizardName+".html");
	debugWrite("after wizard request");
    }else{
        debugWrite("wizardName!=null");
    }
}

//
// wizardNext - show next page of current wizard
//
/*
function wizardNext() {
    var pageString;
    var pageId;
    var scriptId;

    debugWrite("wizardNext is called");
    pageString = wizardName + "Page" + wizardPageNum;

    if (wizardPageNum != 0) {
        // Execute current page's next script, if there is one
        if ((scriptId = getElementId(pageString + "NextScript")) != null) {
	    try{
            	eval(scriptId.text);
            }catch(e){
               debugWrite("scriptId.text="+scriptId.text);
            }
        } else {
            debugWrite("page has no next script");
        }

        // Hide current page
        pageId = getElementId(pageString);
        pageId.style.display = "none";
    }

    // Show next page
    wizardPageNum++;
    pageString = wizardName + "Page" + wizardPageNum;
    pageId = getElementId(pageString);
    pageId.style.display = "block";

    // Execute current page's load script, if there is one
    if ((scriptId = getElementId(pageString + "LoadScript")) != null) {
        eval(scriptId.text);
    } else {
        debugWrite("page has no load script");
    }
}
*/

//
// wizardBack - go to previous page of current wizard
//
/*
function wizardBack() {
    var pageString = wizardName + "Page";
    var pageId;

    debugWrite("wizardBack is called");
    // Hide current page
    pageId = getElementId(pageString + wizardPageNum);
    pageId.style.display = "none";

    // Show previous page
    wizardPageNum--;
    pageId = getElementId(pageString + wizardPageNum);
    pageId.style.display = "block";
}
*/

//
// wizardPageCreate - create page within wizard
//

function wizardPageCreate(id, show, cancel, button1, button2) {
    var page = new Object();

    debugWrite("wizardPageCreate is called"+id);

    if ((page.div = getElementId(id)) == null) {
        debugWrite("Bad wizard page id: " + id);
    }

    page.showFunc = show; 
    page.cancelFunc = cancel; 
    page.button1Func = button1;
    page.button2Func = button2;

    return page;
}

//
// wizardInit - initialize wizard
//

function wizardInit(pageArray) {
    var i;
    var scriptId;

    debugWrite("wizardInit is called");
    wizardPages = pageArray;
}

//
// wizardPageShow
//

function wizardPageShow(newPageNum) {
    var scriptId;
    var newPage = wizardPages[newPageNum];

    debugWrite("wizardPageShow is called");
    if (currentPageId != null) {
        // Hide current page
        currentPageId.div.style.display = "none";
    }

    // Show new page
    currentPageId = newPage;
    currentPageId.div.style.display = "block";

    // Execute page's show handler

    debugWrite("Showing page " + newPageNum + ": handler is " + currentPageId.showFunc);
    if (currentPageId.showFunc != "") {
        eval(currentPageId.showFunc);
    }
}

//
// wizardOnButton1
//

function wizardOnButton1() {
    if (currentPageId.button1 != "") {
        eval(currentPageId.button1Func);
    }
}

//
// wizardOnButton2
//

function wizardOnButton2() {
    if (currentPageId.button2 != "") {
        debugWrite("button2Func="+currentPageId.button2Func);
        
        eval(currentPageId.button2Func);
    }
}

//
// wizardFormDataGet - extract form data from wizard
//

function wizardFormDataGet(divName) {
    var div;
    var elements;
    var data = "";

    debugWrite("wizardFormDataget is called in="+divName);

    if (!(div = getElementId(divName))) {
        // XXX error path
    }

    // process select tags
    // XXX doesn't currently work, need to fix

    elements = div.getElementsByTagName("select");
   
  
    var ep1;
    for (var i = 0; i < elements.length; i++) {
        ep1 = elements[i];
        if(ep1.name.match("raidMode"))
        {
			if(ep1.selectedIndex >= 0)
			data += ep1.name + "=" + raidModeName[ep1.selectedIndex] + "&";
			else
			data += ep1.name + "=" + raidModeName[0].text + "&";
       
       }
       else
        {
			if(ep1.selectedIndex >= 0)
			data += ep1.name + "=" + ep1.options[ep1.selectedIndex].text + "&";
			else
			data += ep1.name + "=" + ep1.options[0].text + "&";
       
       }
    }
 

    // process input tags

    elements = div.getElementsByTagName("input");
    for (var i = 0; i < elements.length; i++) {

        switch (elements[i].type) {
            case "checkbox":
            case "radio":
                if(elements[i].checked){
		data += elements[i].name + "=";
		data += elements[i].value;
		data += "&";
		}
                break;
            case "text":
                if(elements[i].value!=""){
                data += elements[i].name + "=";
		data += elements[i].value;
		data += "&";
                }
                break;
            case "hidden":
            case "password":
            case "button":
                data += elements[i].name + "=";
		data += elements[i].value;
		data += "&";
                break;
            case "file":
				if(elements[i].value!="") {
				data += elements[i].name + "=";
		data += elements[i].value;
		data += "&";
				}
				break;
            default:
                debugWrite("bad input type " + elements[i].type);
		break;
        }        
    }

    data = data.substring(0,(data.length-1));

    debugWrite("data is " + data);
    return data;
}

//
// wizardCancel - handle cancel button
//

function wizardCancel() {
    var scriptId;

    debugWrite("wizardCancel is called");
    // Execute current page's cancel script, if there is one
    if (currentPageId.cancelFunc != null) {
        eval(currentPageId.cancelFunc);
    } else {
        debugWrite("page has no cancel script");
    }

    // Execute wizard's cancel script, if there is one
    /*
    if ((scriptId = getElementId(wizardName + "OnCancelScript")) != null) {
        eval(scriptId.text);
    } else {
        debugWrite("wizard has no cancel script");
    }
    */

    wizardClose();
}

//
// wizardClose - close wizard pane, show main pane
//

function wizardClose() {
    debugWrite("wizardClose is called");
    wizardPaneId.style.display = "none";
    wizardName = null;
    mainPaneOnLoad(); 
    if(prevSelected!="")
    	mainPaneDiskModify(prevSelected,"", "","regular");
    prevSelected = "";
    systemTasksOnLoad ();

    mainPaneId.style.display = "block";
    systemTasksTableEnable();
}

//
// wizardRequest - request a wizard page
//

function wizardRequest(handler, query, async, data) {

    var req;

    debugWrite("wizardRequest: query is " + query);

    if (window.XMLHttpRequest) {
        // Non-MS browser
//	debugWrite("window"+window.XMLHttpRequest);
	debugWrite("its Non-MS browser");
        if (req = new XMLHttpRequest()) {
        } else {
 //           debugWrite("Failed to allocate req");
        }
    } else if (window.ActiveXObject) {
        // MS browser
	debugWrite("its MS browser");
//	debugWrite("window"+window.ActiveXObject);
        if (req = new ActiveXObject("Microsoft.XMLHTTP")) {
        } else {
//           debugWrite("Failed to allocate req");
        }
    }

    req.onreadystatechange = function () {
        if (req.readyState == 4) {
            if (handler != null) {
                handler(req);
            }
        }
    }
// problem that is specific to firefox: sometimes page request(HTTP_REQUEST_GET) is not invoked by cgi program, 
// due to caching? Changed the page request method to use HTTP_REQUEST_POST
//    var method = ((data == null) || (data == "")) ? "GET" : "POST";
    
    req.open("POST", "/nvraid/cgi-bin/nvRaidWebExt.exe" + query, async);
    req.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
//append '\n' in the end to fix the garbage ending characters problem in the post data
    if((data == null) || (data == "")){
        req.send(data);
    }
    else{   
        data=data+"\n";
        req.send(data);
    }
    if (!async) {
        // Provide sync callback if a handler was provided
        if (handler != null) {
            handler(req);
        } else {
            if (req.status == 200) {
                return req.responseText;
            }
        }
    }
}

//
// wizardButtonDisable - set state of wizard button
//

function wizardButtonDisable(button, state) {
    var buttonId = getElementId("wizardButton" + button);
    buttonId.disabled = state;
}

//
// wizardOnLoad - 
//

function wizardOnLoad() {
    debugWrite("wizardOnLoad is called");
    wizardPaneId = getElementId("wizardPane");
    mainPaneId = getElementId("mainPane");
}

addEvent(window, "load", wizardOnLoad);

