#!/bin/sh

UTILS="/usr/local/ProLiant/Interconnect_Switch/Utilities/CGESM/version12.2.25.SEE2"
MIBDIR=$UTILS"/mibs"
IMDIR="/opt/mx"
MC="mcompile"
MXA="mxmib -a"
MXD="mxmib -d"
TMP_FILE_1="$UTILS/tmp_SIM_file1.txt"
TMP_FILE_2="$UTILS/tmp_SIM_file2.txt"

#make_tmp_file creates a file containing list of files to use
function make_tmp_file {
  cd $MIBDIR
  rm -f $TMP_FILE_1
  touch $TMP_FILE_1
  rm -f $TMP_FILE_2
  touch $TMP_FILE_2

  find . -name "*.mib" >> $TMP_FILE_1  #The HP-SWITCH-PL-MIB.mib needs to be loaded first
  find . -name "*.my" >> $TMP_FILE_1
  exec 3< $TMP_FILE_1

  while read LINE <&3 ; do
    echo "${LINE%.m*}" >> $TMP_FILE_2
  done
  rm -f $TMP_FILE_1
  touch $TMP_FILE_1
  exec 3< $TMP_FILE_2
  while read LINE <&3 ; do
  echo "${LINE#.'/'*}" >> $TMP_FILE_1
  done
}


#ok copies, deletes (un-registers), compiles, and imports (registers) files listed in $TMP_FILE_1 
function ok {
  cd $MIBDIR

  # Copy mibs to /opt/mx/mibs directory
  find -maxdepth 1 -type f | while read FILE ; do
    cp --reply=yes $FILE $IMDIR/mibs/${FILE/.m*/.mib}
  done

  make_tmp_file         #calls make_tmp_file
  exec 3< $TMP_FILE_1
  cd $IMDIR
  cd mibs

  echo "Deleting duplicate MIBs.  Ignore any error messages..."
  echo ""
  while read LINE <&3 ; do
    if test -e $LINE".mib"
    then
      $MXD $LINE".mib" 1>&2
    fi
  done

  echo ""
  echo "Compiling MIBs.  Some SNMPv2 MIBs will produce errors..."
  echo ""
  exec 3< $TMP_FILE_1
  while read LINE <&3 ; do
    if test -e $LINE".mib"
    then
      $MC $LINE".mib" 1>&2
    fi
  done

  echo ""
  echo "Importing MIBs to SIM..."
  echo ""
  # Register mibs
  exec 3< $TMP_FILE_1
  while read LINE <&3 ; do
    if test -e $LINE".cfg"
    then
      $MXA $LINE".cfg" 1>&2
    fi
  done

  echo ""
  echo "MIB compilation and SIM import complete."
  echo "The few SNMPv2 MIB errors were expected."


  rm -f $TMP_FILE_1
  rm -f $TMP_FILE_2
  errorlevel="0"
  echo ""
  echo "Restarting the Insight Manager service..."
  echo "Press ctrl-c to exit or press any key to continue..."
  read -n 1 wait
  echo ""
  echo "Stopping mx"
  mxstop
  echo "Starting mx"
  mxstart
  echo ""

}

readonly -f make_tmp_file
declare -t make_tmp_file

readonly -f ok
declare -t ok
####################################################################


####################################################################
#Body
if test -d $IMDIR
then
  ok		#calls ok function
  exit 0	#exit with no errors
fi

echo ""
echo "=========================================================="
echo "Systems Insight Manager (SIM) installation not found at:"
echo $IMDIR
echo ""
echo "If SIM is installed elsewhere, edit this file to redefine"
echo "the IMDIR variable and then rerun this script."
echo "=========================================================="
echo ""
errorlevel="1"
exit 1		#exit with errors
####################################################################

