<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/02/xpath-functions">

<!-- TODO: Do we need the enclosure number or just the name? -->

<xsl:param name="isAuthenticated" select="'true'" />
<xsl:include href="c-class.xsl" />
<xsl:include href="p-class.xsl" />

<!-- TEMPLATE TO RENDER BPV STARTS -->
<xsl:template name="renderBPV">
<xsl:param name="typeOfView"/>
<xsl:param name="deviceSubType"/>
<xsl:param name="encName"/>
<xsl:param name="subRackName"/>
<xsl:param name="enclSerialNum"/>
<xsl:param name="deviceType"/>
<xsl:param name="typeOfDisplay"/>
<xsl:param name="startU"/>
<xsl:param name="endU"/>

<!-- 
CREATE AN TABLE TO PREFECTCH THE IMAGES THAT ARE LOADED FROM THE JAVASCRIPT,
THE IMAGE WILL BE CACHED BY THE BROWSER AND WILL BE VISIBLE ONCE THE IMAGE IS LOADED FROM
JAVASCRIPT{SKIN.JS}

THE TABLE WILL NOT BE VISIBLE.
-->
<table cellpadding="0" cellspacing="0" border="0" id="cachedImages" align="left" style="display:none">
<tr><td><img><xsl:attribute name="src"><xsl:value-of select="$IMAGE_MIN"/></xsl:attribute></img><img><xsl:attribute name="src"><xsl:value-of select="$IMAGE_MAX"/></xsl:attribute></img><img><xsl:attribute name="src"><xsl:value-of select="$IMAGE_RIGHT"/></xsl:attribute></img><img><xsl:attribute name="src"><xsl:value-of select="$IMAGE_LEFT"/></xsl:attribute></img></td></tr>
</table>

<!-- SUPER TABLE THAT COVERS THE ENTIRE RACK -->
<table cellpadding="0" cellspacing="0" border="0" id="renderBPV" width="100%" align="left">

<!-- ROW WITH ENCLOSURE NAME STARTS -->
	<tr><td class="subTitle" id="enclTitle">
	<xsl:if test="$deviceType!='Rack'">
	<div>
	<xsl:attribute name="class">
	<xsl:choose>
	<xsl:when test="$typeOfView=$URACK">
	<xsl:text>subTitleIcon</xsl:text>
	</xsl:when>
	<xsl:otherwise>
	<xsl:text>subTitleIconLeft</xsl:text>
	</xsl:otherwise>
	</xsl:choose>
	</xsl:attribute>
	<xsl:if test="$typeOfView=$URACK">
	<xsl:choose>
	<xsl:when test="$typeOfDisplay = $URACK">
	<a href="javascript:void(0);">
	<xsl:element name="img">
	<xsl:attribute name="onclick">toggleEnclosureVisible('<xsl:value-of select="$enclSerialNum"/>', this,'<xsl:value-of select="//I18N/L10NMaximize"/>','<xsl:value-of select="//I18N/L10NMinimize"/>');</xsl:attribute>
	<xsl:attribute name="title"><xsl:value-of select="//I18N/L10NMinimize"/></xsl:attribute>
	<xsl:attribute name="src"><xsl:value-of select="$IMAGE_MIN"/></xsl:attribute>
	<xsl:attribute name="width">11</xsl:attribute>
	<xsl:attribute name="height">11</xsl:attribute>
	<xsl:attribute name="border">0</xsl:attribute>
	</xsl:element>
	</a>
	</xsl:when>
	<xsl:otherwise>
	<img width="11" height ="11" border="0" >
	<xsl:attribute name="src"><xsl:value-of select="$IMAGE_MIN"/></xsl:attribute>
	</img>
	</xsl:otherwise>
	</xsl:choose>
	</xsl:if>
	</div>
	</xsl:if>
	<div style="cursor:default">
	<input type="checkbox" rowselector="yes" id="enclCheckBox" >
	<xsl:attribute name="enclName">
	<xsl:value-of select="$encName" />
	</xsl:attribute>
	<xsl:attribute name="classtype">
	<xsl:value-of select="./@type"/>
	</xsl:attribute>
	<xsl:attribute name="title">
	<xsl:value-of select="//I18N/L10NEnclChkBxTitle"/>
	</xsl:attribute>
	<xsl:attribute name="guid">
	<xsl:value-of select="./Common/NodeId" />
	</xsl:attribute>
	</input>
	<xsl:variable name="status">
	<xsl:call-template name="getMember">
	<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NHealthStatus"/></xsl:with-param>
	</xsl:call-template>
	</xsl:variable>
	<xsl:call-template name="statusIcon">
	<xsl:with-param name="statusCode" select="$status" />
	<xsl:with-param name="titleMsg" select="./@titleStatus" />
	</xsl:call-template>
	<img width="5" height="1px">
	<xsl:attribute name="src">
	<xsl:value-of select="$ONE_GRAY"/>
	</xsl:attribute>
	</img>
	<font color="white">
	<xsl:value-of select="$encName" /> (<xsl:value-of select="$startU" />U to <xsl:value-of select="$endU" />U)
	</font>
	</div>
	</td></tr>
<!-- ROW WITH ENCLOSURE NAME ENDS -->
<!-- ROW WITH ENCLOSURE IMAGES AND DETAILS STARTS -->
	<tr><td>
	<xsl:element name="div">
	<xsl:attribute name="style">padding:10px;border:1px solid #000000;</xsl:attribute>
	<xsl:element name="div">
	<xsl:attribute name="id">
	<xsl:value-of select="$enclSerialNum"/>
	</xsl:attribute>
	<xsl:choose>
	<xsl:when test="$typeOfView=$URACK">
		<xsl:call-template name="renderRack" >
		<xsl:with-param name="enclSerialNum"><xsl:value-of select="$enclSerialNum"/></xsl:with-param>
		<xsl:with-param name="deviceSubType" select="$deviceSubType"/>
		<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
		</xsl:call-template>
	</xsl:when>
	<!--xsl:otherwise>
		<xsl:call-template name="renderEnclosure">
		<xsl:with-param name="enclSerialNum"><xsl:value-of select="$enclSerialNum"/></xsl:with-param>
		<xsl:with-param name="deviceSubType" select="$deviceSubType"/>
		<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
		</xsl:call-template>
	</xsl:otherwise-->
	</xsl:choose>
	</xsl:element>
	</xsl:element>
	</td></tr>
<!-- ROW WITH ENCLOSURE IMAGES AND DETAILS ENDS -->
	</table>
	</xsl:template>
<!-- TEMPLATE TO RENDER BPV ENDS -->

<!-- TEMPLATE TO RENDER RACK STARTS -->
	<xsl:template name="renderRack"><xsl:param name="enclSerialNum"/><xsl:param name="deviceSubType"/>
	<xsl:param name="typeOfDisplay"/>
<!-- TABLE TO FORMAT FRONT/REAR/DETAILS VIEW STARTS -->
	<table border="0" cellpadding="0" cellspacing="0">
	<tr>
<!-- FRONT VIEW CELL STARTS -->
	<xsl:choose>
	<xsl:when test="$deviceSubType=$ServerEnc and ./@type=$E_CLASS">
		<td width="26%" valign="top">
		<xsl:value-of select="//I18N/L10NFrontView "/>
		<xsl:call-template name="cClassEnclFrontView">
		<xsl:with-param name="enclSerialNum" select="$enclSerialNum" />
		<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
		</xsl:call-template>
		<xsl:value-of select="//I18N/L10NRearView "/><br/>
		<xsl:call-template name="renderPEClassEnclRearView">
		<xsl:with-param name="enclSerialNum" select="$enclSerialNum" />
		<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
		</xsl:call-template>
		</td>
	</xsl:when>
	<xsl:when test="$deviceSubType=$ServerEnc and not(./@type=$E_CLASS)">
		<td width="26%" valign="top">
		<xsl:value-of select="//I18N/L10NFrontView "/>
		<xsl:call-template name="cClassEnclFrontView">
		<xsl:with-param name="enclSerialNum" select="$enclSerialNum" />
		<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
		</xsl:call-template>
		</td>
	</xsl:when>
	<xsl:otherwise>
		<td width="26%" valign="top">
		<xsl:value-of select="//I18N/L10NFrontView "/>
		<xsl:call-template name="powerEnclFrontView">
		<xsl:with-param name="enclSerialNum"><xsl:value-of select="$enclSerialNum"/></xsl:with-param>
		</xsl:call-template>
		</td>
	</xsl:otherwise>
	</xsl:choose>
	<xsl:if test="not(./@type=$E_CLASS)">
		<!--SEPERATOR-->
		<td valign="top">
		<img width="10" >
		<xsl:attribute name="src">
		<xsl:value-of select="$ONE_WHITE"/>
		</xsl:attribute>
		</img>
		</td>
	</xsl:if>
<!-- FRONT VIEW CELL ENDS -->
<!-- REAR VIEW CELL STARTS -->
	<xsl:choose>
	<xsl:when test="$deviceSubType=$ServerEnc">
	<xsl:choose>
	<xsl:when test="./@type=$C_CLASS">
		<td width="26%" valign="top">
		<xsl:value-of select="//I18N/L10NRearView "/>
		<xsl:call-template name="OvrlrdEnclRearView">
		<xsl:with-param name="enclSerialNum" select="$enclSerialNum" />
		<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
		</xsl:call-template>
		</td>
	</xsl:when>
	<xsl:when test="not(./@type=$E_CLASS)">
		<td width="26%" valign="top">
		<xsl:value-of select="//I18N/L10NRearView "/>
		<xsl:call-template name="renderPEClassEnclRearView">
		<xsl:with-param name="enclSerialNum" select="$enclSerialNum" />
		<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
		</xsl:call-template>
		</td>
	</xsl:when>
	</xsl:choose>
	</xsl:when>
	<xsl:otherwise>
		<td width="26%" valign="top">
		<xsl:value-of select="//I18N/L10NRearView "/>	
		<xsl:call-template name="powerEnclRearView">
		<xsl:with-param name="enclSerialNum"><xsl:value-of select="$enclSerialNum"/></xsl:with-param>
		</xsl:call-template>
		</td>
	</xsl:otherwise>
	</xsl:choose>
<!-- REAR VIEW CELL ENDS -->
<!--SEPERATOR-->
	<td>
	<img width="10">
	<xsl:attribute name="src">
	<xsl:value-of select="$ONE_WHITE"/>
	</xsl:attribute>
	</img>
	</td>
<!-- SYSTEM INFORMATION CELL STARTS -->
	<td  valign="top">
	<xsl:call-template name="displaySystemInfo">
	<xsl:with-param name="enclSerialNum" select="$enclSerialNum"/>
	<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
	</xsl:call-template>
	</td>
<!-- SYSTEM INFORMATION CELL ENDS -->
	</tr>
	</table>
<!-- TABLE TO FORMAT FRONT/REAR/DETAILS VIEW STARTS -->
	</xsl:template>
<!-- TEMPLATE TO RENDER RACK ENDS -->

<!-- TEMPLATE TO RENDER ATTRIBUTE STARTS -->
	<xsl:template name="renderAttribute">
	<xsl:param name="typeOfDisplay" />
	<tr ><td nowrap="true" style="border-width:0 0 1 0;border-style:solid;border-color:#cccccc;">
	<xsl:value-of select="./Name" />
	</td>
	<td  nowrap="true" style="border-width:0 0 1 0;border-style:solid;border-color:#cccccc;">
	<xsl:choose>
	<xsl:when test="./@displayAsURL='true'">
	<xsl:choose>
	<xsl:when test="$typeOfDisplay = $URACK">
	<xsl:choose>
	<xsl:when test="./@dispInWindow='true'">
	<a href="javascript:void(0);">
	<xsl:attribute name="onclick"><xsl:text>openNewWindow('</xsl:text><xsl:value-of select="./@URL" /><xsl:text>')</xsl:text></xsl:attribute>
	<xsl:value-of select="./Value" />
	</a>
	</xsl:when>
	<xsl:otherwise>
	<a>
	<xsl:attribute name="href">
	<xsl:value-of select="./@URL" />
	</xsl:attribute>
	<xsl:value-of select="./Value" />
	</a>
	</xsl:otherwise>
	</xsl:choose>
	</xsl:when>
	<xsl:otherwise>
	<xsl:value-of select="./Value" />
	</xsl:otherwise>
	</xsl:choose>
	</xsl:when>
	<xsl:otherwise>
	<xsl:choose>
	<xsl:when test="./@displayAsImage='true'">
	<xsl:call-template name="statusIcon">
	<xsl:with-param name="statusCode" select="./Value" />
	<xsl:with-param name="titleMsg" select="../@titleStatus" />
	</xsl:call-template>
	</xsl:when>
	<xsl:otherwise>
	<xsl:value-of select="./Value" />
	</xsl:otherwise>
	</xsl:choose>
	</xsl:otherwise>
	</xsl:choose>
	</td></tr>
	</xsl:template>
<!-- TEMPLATE TO RENDER ATTRIBUTE ENDS -->

<!-- TEMPLATE TO DISPLAY SYSTEM INFO STARTS -->
	<xsl:template name="displaySystemInfo">
	<xsl:param name="enclSerialNum"/>
	<xsl:param name="typeOfDisplay" />
<!-- TABLE TO DISPLAY INFO STARTS -->
	<table border="0" cellspacing="0" cellpadding="0" class="pad1x10" id="AttributeTable">
	<xsl:for-each select="./Attribute[@Section='Power And Thermal' and @isMultiValued='true']">
		<xsl:attribute name="PowerRedundancyName"><xsl:value-of select="./Name"/></xsl:attribute>
		<xsl:attribute name="PowerRedundancyValue"><xsl:value-of select="./Value"/></xsl:attribute>
		<xsl:attribute name="width"><xsl:text>300</xsl:text></xsl:attribute>
	</xsl:for-each>
<!-- EMPTY ROW STARTS -->
	<tr><td>
	<img width="10">
	<xsl:attribute name="src">
	<xsl:value-of select="$ONE_WHITE"/>
	</xsl:attribute>
	</img>
	</td><td>
	<img width="10">
	<xsl:attribute name="src">
	<xsl:value-of select="$ONE_WHITE"/>
	</xsl:attribute>
	</img>
	</td></tr>
<!-- EMPTY ROW ENDS -->
<!-- DISPLAY ALL THE ATTRIBUTES BOTH IN "IDENTIFICATION" AND "SYSTEM STATUS" -->
<xsl:for-each select="./Attribute[@Section='General' and @location!='EnclosureView']">
	<xsl:call-template name="renderAttribute">
	<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
	</xsl:call-template>
</xsl:for-each>
<xsl:for-each select="./Attribute[@Section='Identification' and @location!='EnclosureView']">
	<xsl:call-template name="renderAttribute">
	<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
	</xsl:call-template>
</xsl:for-each>
<xsl:for-each select="./Attribute[@Section='System Status'  and @location!='EnclosureView']">
	<xsl:call-template name="renderAttribute">
	<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
	</xsl:call-template>
</xsl:for-each>
<xsl:for-each select="./Attribute[@Section='Power And Thermal'  and @location!='EnclosureView']">
	<xsl:call-template name="renderAttribute">
	<xsl:with-param name="typeOfDisplay" select="$typeOfDisplay"/>
	</xsl:call-template>
</xsl:for-each>
</table>
<!-- TABLE TO DISPLAY INFO ENDS -->
</xsl:template>
<!-- TEMPLATE TO DISPLAY SYSTEM INFO ENDS -->
</xsl:stylesheet>

