<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

<xsl:template name="PropertiesTable">
  		<xsl:param name="sectionName"/>
		<xsl:param name="displayName"/>
		<xsl:param name="typeOfDisplay"/>
		<xsl:variable name="LocNotAvailable">
			<xsl:value-of select="//I18N/L10NNotAvailable"/>
		</xsl:variable>
		
		<tr>
			<td>	
				   <table border="0" cellpadding="0" cellspacing="0" class="dataTable"  width="100%" >
					 <caption>
						 <xsl:value-of select="$displayName"/>
					 </caption>		
					  <xsl:for-each select="./Attribute[@Section=$sectionName and @location!='RackView'] ">			
						<xsl:element name="tr">
							<xsl:attribute name="class">
								<xsl:if test="position() mod 2 = 0">		
										altRowColor
								</xsl:if>
							</xsl:attribute>
							
								<th class="propertyName" ><xsl:value-of select="./Name"/></th>
									<td class="propertyValue" style="border-bottom:1px solid #ccc;">
										<xsl:choose>
											<xsl:when test="./@displayAsProgress='true'">
												<xsl:if test="./Value!='NotAvailable'">
														<xsl:call-template name="statusIcon">
															<xsl:with-param name="statusCode" select="./Value"/>
															<xsl:with-param name="titleMsg" select="../@titleStatus" />
														</xsl:call-template>
												 </xsl:if>
											</xsl:when>
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="./@displayAsImage='true'">
														<xsl:call-template name="statusIcon">
															<xsl:with-param name="statusCode" select="./Value"/>
															<xsl:with-param name="titleMsg" select="../@titleStatus" />
														</xsl:call-template>
													 </xsl:when>
													 

													 <xsl:when test="./@displayAsURL='true' and ($typeOfDisplay=$BPV or $typeOfDisplay=$URACK)">
															<xsl:choose>
																<xsl:when test="./@dispInWindow='true'">
																		<a href="javascript:void(0);">
																			<xsl:attribute name="style">CURSOR: pointer;</xsl:attribute>
																			<xsl:attribute name="onclick"><xsl:text>openNewWindow('</xsl:text><xsl:value-of select="./@URL" /><xsl:text>')</xsl:text></xsl:attribute>		
																			<xsl:value-of select="./Value" />	
																		</a>
																</xsl:when>
																<xsl:otherwise>
																	<a>
																		<xsl:attribute name="href"><xsl:value-of select="./@URL" /></xsl:attribute>
																		<xsl:attribute name="style">CURSOR: pointer;</xsl:attribute>
																		<xsl:value-of select="./Value" />	
																	</a>
																</xsl:otherwise>
															</xsl:choose>
													 </xsl:when>
													 
													 <xsl:when test="./@isMultiValued='true'">
														<xsl:attribute name="PowerRedundancyValue"><xsl:value-of select="./Value"/></xsl:attribute>
														<xsl:attribute name="PowerRedundancyName"><xsl:value-of select="./Name"/></xsl:attribute>
													 </xsl:when>
													 <xsl:when test="./@displayAsBarGraph='True'">
																<xsl:if test="./Value!=$NOT_AVAILABLE">
																	<xsl:call-template name="barGraph">
																		<xsl:with-param name="curValue">
																			<xsl:value-of select="./Value"/>
																		</xsl:with-param>
																		<!-- We need to pass curValue, maxValue, forecolor, backColor -->
																   </xsl:call-template>
															   </xsl:if>
															   <xsl:if test="./Value=$NOT_AVAILABLE">
																	<xsl:value-of select="./Value"/>
															   </xsl:if>
												   </xsl:when>
												   
												   <xsl:when test="./@displayAsTemp='True' and ./Value!=$LocNotAvailable">
													   <xsl:value-of select="./Value"/><xsl:text>&#176;C / </xsl:text>
													   <xsl:call-template name="getTempInFaranheit">  
															<xsl:with-param name="tempC" select="./Value"/>
														</xsl:call-template> 
														<xsl:text>&#176;F</xsl:text>
												   </xsl:when>
													<xsl:when  test="./Value=$LocNotAvailable and ./Name=//I18N/L10NRackName">
												   		<xsl:value-of select="./Value"/> 
														<div id="newaddEnclToRack" style="display:none;padding:0 0 0 2;" class="propertyValue">
												   		 (<a href="javascript:void(0);" onclick="addEnclLink()"><xsl:value-of select="//I18N/L10NAddEnclosureToRack"/></a>)</div><br/>
														<iframe frameborder="0" id="rackFrame" src="/mxportal/bladeime/crack/addToRack.jsp" width="300px" height="60px"
															style="display:none" 
														>nothing</iframe>
												   </xsl:when>
												   <!-- 
												   <xsl:when test="./Name='Rack Name'">
												   		<xsl:value-of select="./Value"/> 
												   		 (<a href="javascript:void(0);" onclick="document.getElementById('rackFrame').style.display='block';">Edit</a>)<br/>
														<iframe frameborder="0" id="rackFrame" src="/mxportal/bladeime/crack/jump1.jsp" width="200px" height="50px"
															style="display:none"
														>nothing</iframe>
												   </xsl:when>
												    -->
													 <xsl:otherwise>
														 <!-- display link next to the enclosure name as [Printable Enclosure Details] applicable for c-class only-->
														<xsl:variable name="tmpName">
															<xsl:value-of select="./Value"/>
														</xsl:variable>

														<xsl:value-of select="$tmpName"/>
																													                                  
														<xsl:if test="./Name=//I18N/L10NEnclosureName">
															<a href="javascript:void(0);">
																<xsl:attribute name="style">CURSOR: pointer;</xsl:attribute>
																<xsl:attribute name="onclick">
																	<xsl:text>showAllServersDetails('</xsl:text><xsl:value-of select="$tmpName"/><xsl:text>')</xsl:text>
																</xsl:attribute>
																[<xsl:value-of select="//I18N/L10NPrintableEnclosureDetails"/>]
															</a>																
														</xsl:if>
														<!-- end changes for displaying link next to the enclosure name -->

													 </xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
									</xsl:choose>
								</td>
					</xsl:element>
			    </xsl:for-each>
			 </table>
		 </td>	
  </tr>	
  </xsl:template>	
  
 <!--Creating Power Supply Unit temperature graphs-->
 <xsl:template name="progressBar">	
		<xsl:param name="curValue"/>
		<xsl:param name="maxValue"/>
        <xsl:param name="foreColor"/>
        <xsl:param name="bgColor"/>
        
		<xsl:variable name="barWidth">
				<xsl:call-template name="getWidth"> 
					<xsl:with-param name="curVal" select="$curValue"/>
					<xsl:with-param name="maxVal" select="$maxValue"/>
				</xsl:call-template>
		</xsl:variable>		

		
		<td width="100%" style="border-top:0px;" align="left">
		
				<div class="percentageOutline">
					<xsl:attribute name="style">
						<xsl:text>background:</xsl:text>
						<xsl:value-of select="$bgColor"/>
					</xsl:attribute>
					<div class="percentageBar">
						<xsl:attribute name="style">
							<xsl:text>width:</xsl:text>
							<xsl:value-of select="$barWidth"/><xsl:text>%</xsl:text>
							<xsl:text>;background:</xsl:text>
							<xsl:value-of select="$foreColor"/>
						</xsl:attribute>
					</div>
				</div>
			
		</td>										   									
		
 </xsl:template>
  
  
 <!-- Creating Graphs -->
 <xsl:template name="barGraph">
	<xsl:param name="curValue"/>			
	<xsl:param name="maxValue"/>			

		<table cellpadding="0" cellspacing="0" border="0" style="border-top:0px;" width="100%">
			<tbody>
				<tr>
					<td style="border-top:0px " width="35%"><xsl:value-of select="$curValue"></xsl:value-of><xsl:text> / </xsl:text><xsl:value-of select="$maxValue"></xsl:value-of></td>
					<!-- Dont Build Graph if Max Value =0 -->	
					<xsl:if test="$maxValue!=0">		
						<xsl:call-template name="progressBar">
								<xsl:with-param name="curValue" select="$curValue"/>
								<xsl:with-param name="maxValue" select="$maxValue"/>
								<xsl:with-param name="foreColor">
									<xsl:call-template name="getBgColor">
										<xsl:with-param name="curVal" select="$curValue"/>
										<xsl:with-param name="tripVal" select="$maxValue"/>
										<xsl:with-param name="failVal" select="$maxValue"/>
									</xsl:call-template>
								</xsl:with-param>	
								
								<xsl:with-param name="bgColor" select="'yellow' "/>
						</xsl:call-template>
					</xsl:if>	
				</tr>
			</tbody>
		</table> 
 </xsl:template>
 
 <!--Creating Power Supply Unit temperature graphs-->
 <xsl:template name="Bar">	
		<xsl:param name="tempC"/>
		<xsl:param name="tempF"/>
		<xsl:param name="tripTemp"/>
		<xsl:param name="finalTemp"/>
		<xsl:param name="bgColor"/>
		<xsl:param name="tripToolTip"/>
		<xsl:param name="failToolTip"/>
		
		<xsl:variable name="tempWidth"> 
			<xsl:call-template name="getWidth"> 
				<xsl:with-param name="curVal" select="$tempC"/>
				<xsl:with-param name="maxVal" select="$finalTemp"/>
			</xsl:call-template>
		</xsl:variable>

		<xsl:variable name="tripWidth"> 
			<xsl:call-template name="getWidth"> 
				<xsl:with-param name="curVal" select="$tripTemp"/>
				<xsl:with-param name="maxVal" select="$finalTemp"/>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:variable name="status">
			<xsl:call-template name="getTempStatus">
				<xsl:with-param name="curVal" select="$tempC"/>
				<xsl:with-param name="tripVal" select="$tripTemp"/>
				<xsl:with-param name="failVal" select="$finalTemp"/>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:variable name="statusTitle">
			<xsl:call-template name="getLocalisedStatus">
				<xsl:with-param name="curVal" select="$tempC"/>
				<xsl:with-param name="tripVal" select="$tripTemp"/>
				<xsl:with-param name="failVal" select="$finalTemp"/>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:variable name="foreColor">
			<xsl:call-template name="getBgColor">
				<xsl:with-param name="curVal" select="$tempC"/>
				<xsl:with-param name="tripVal" select="$tripTemp"/>
				<xsl:with-param name="failVal" select="$finalTemp"/>
			</xsl:call-template>
		</xsl:variable>
		
		
		<td align="center" width="20%" style="background:inherit;  border-top:none;">
			<xsl:call-template name="statusIcon">
				<xsl:with-param name="statusCode" select="$status"/>
				<xsl:with-param name="titleMsg" select="$statusTitle"/>
			</xsl:call-template>
        </td>
        <td align="left" width="25%" style="background:inherit;  border-top:none;">
        <xsl:value-of select='format-number($tempC, "#.##")'/><xsl:text> / </xsl:text><xsl:value-of select="$tempF"></xsl:value-of>
        </td>	
		<td align="left" width="55%" style="border-top:none;" valign="top">
			<table width="100%" cellpadding="0" cellspacing="0" border="0">
				<tr>
					<td style="border-top:none;" width="100%" align="left">
						<div class="percentageOutline">
							<xsl:attribute name="style">
								<xsl:text>background:</xsl:text>
								<xsl:value-of select="$bgColor"/>
							</xsl:attribute>
							<div class="percentageBar">
								<xsl:attribute name="style">
									<xsl:text>width:</xsl:text>
									<xsl:value-of select="$tempWidth"/><xsl:text>%</xsl:text>
									<xsl:text>;background:</xsl:text>
									<xsl:value-of select="$foreColor"/>
								</xsl:attribute>
							</div>
						</div>
					</td>
				</tr>
				<tr>
					<td style="border-top:none;">
							<table width="100%" cellpadding="0" cellspacing="0">
								<tr>
									<th	align="right">
										<xsl:attribute name="style"><xsl:text>width:</xsl:text><xsl:value-of select="$tripWidth"/><xsl:text>%</xsl:text></xsl:attribute>
										<span style="font-weight: 100"><xsl:value-of select="$tripTemp"/></span> 								
										<span style="BACKGROUND-COLOR: #ff0000"><xsl:text>&#160;</xsl:text></span>
								   </th>
									<td style="border-top:none;" width="1px" abbr="right">
									</td>
								   <th align="right" >	
										<span style="font-weight: 100"><xsl:value-of select="$finalTemp"/></span>
										<span style="BACKGROUND-COLOR: #ff0000"><xsl:text>&#160;</xsl:text></span>
								   </th>	
								 </tr>
								<tr>
									<td style="border-top:none;" height="5px">
									</td>
								</tr>
								<tr>
								 <th align="right" style="border-top:none;">
									<xsl:attribute name="style">
										<xsl:text>width:</xsl:text>
										<xsl:value-of select="$tripWidth"/><xsl:text>%</xsl:text>
									</xsl:attribute>
									<xsl:call-template name="statusIcon">
										<xsl:with-param name="statusCode" select="'Major'"/>
										<xsl:with-param name="titleMsg" select="$tripToolTip" />
									</xsl:call-template>
								</th>
								<td style="border-top:none;" width="1px" abbr="right">
								</td>
								<th align="right" style="border-top:none;">	
									<xsl:call-template name="statusIcon">
										<xsl:with-param name="statusCode" select="'Critical'"/>
										<xsl:with-param name="titleMsg" select="$failToolTip" />
									</xsl:call-template>
							   </th>	
							</tr>
					   </table>
					</td>   
				</tr>
			</table>		
	</td>										   									
 </xsl:template>

<!-- Power Supply Table -->
<xsl:template name="PowerSupplyTable">
 <tr>
 	<td>	
	 	<table style="PADDING-TOP: 3px" border="0" cellpadding="0" cellspacing="0" class="dataTable">
							<thead>
								<tr class="captionRow">
									<th align="center"><xsl:value-of select="//I18N/L10NBay"></xsl:value-of></th>
									<th align="center"><xsl:value-of select="//I18N/L10NTableHdrFrmRev"></xsl:value-of></th>
									<th align="center"><xsl:value-of select="//I18N/L10NACInput"></xsl:value-of></th>
									<th style="padding-bottom:0px;"><xsl:value-of select="//I18N/L10NInputTemperature"></xsl:value-of><br />
										<table cellpadding="0" cellspacing="0" border="0" width="100%">
											<tr class="subcaptionRow">
												<td align="center" width="10%" style=" border-right:1px solid #CCC;"><font color="#FFFFFF">
												<xsl:value-of select="//I18N/L10NStatus"></xsl:value-of></font></td>
												<td align="center" width="30%" style=" border-left:1px solid #CCC;"><font color="#FFFFFF"> 
												<xsl:text>&#176;</xsl:text><xsl:text>C / </xsl:text> <xsl:text>&#176;</xsl:text> <xsl:text>F</xsl:text></font></td>
												<td align="left" width="65%" style="border-left:1px solid #CCC;"><font color="#FFFFFF"> 
												<xsl:value-of select="//I18N/L10NGraph"></xsl:value-of></font></td>
											</tr>
										</table>
									</th>
									<th style="padding-bottom:0px;"><xsl:value-of select="//I18N/L10NOutputTemperature"></xsl:value-of><br />
										<table cellpadding="0" cellspacing="0" border="0" width="100%">
											<tr class="subcaptionRow">
												<td align="center" width="10%" style=" border-right:1px solid #CCC;"><font color="#FFFFFF">
												<xsl:value-of select="//I18N/L10NStatus"></xsl:value-of></font></td>
												<td align="center" width="30%" style=" border-left:1px solid #CCC;"><font color="#FFFFFF"> 
												<xsl:text>&#176;</xsl:text><xsl:text>C / </xsl:text> <xsl:text>&#176;</xsl:text> <xsl:text>F</xsl:text></font></td>
												<td align="left" width="65%" style="border-left:1px solid #CCC;"><font color="#FFFFFF"> 
												<xsl:value-of select="//I18N/L10NGraph"></xsl:value-of></font></td>
											</tr>
										</table>
									</th>
								</tr>
						 </thead>
					<tbody>
	    			<xsl:for-each select="//PowerSupplyEnclosure/PowerSupplyUnit">
						<xsl:if test="hasDevice=$PRESENT">
							<xsl:element name="tr">
								<xsl:attribute name="class">
			                    	<xsl:if test="position() mod 2 = 0">altRowColor</xsl:if>
								</xsl:attribute>
									<td align="center"><xsl:value-of select="./BayNumber" /></td>
									<td align="center"><xsl:value-of select="./FrmRev"/></td>
									<td align="center"><xsl:value-of select="./ACInput"/></td> 
									<!-- Input Temperature-->
									<td style="padding-top:3px; padding-right:5px; padding-bottom:2px; padding-left:5px;">
										<table align="center" cellpadding="0" cellspacing="0" border="0" width="100%">
											<tr>
												<xsl:call-template name="Bar">
													<xsl:with-param name="tempC" select="./InputTempC"/>
													<xsl:with-param name="tempF"> 
														<xsl:call-template name="getTempInFaranheit">  
															<xsl:with-param name="tempC" select="./InputTempC"/>
														</xsl:call-template> 
													</xsl:with-param>
													<xsl:with-param name="tripTemp" select="./InTempTripC"/>
													<xsl:with-param name="finalTemp" select="./InTempFailC"/>
													<xsl:with-param name="bgColor"><xsl:text>yellow</xsl:text></xsl:with-param>
													<xsl:with-param name="tripToolTip">
														<xsl:value-of select="//L10NTrip"/><xsl:text> </xsl:text><xsl:value-of select="//L10NTemp"/>
													</xsl:with-param>
													<xsl:with-param name="failToolTip"> 
														<xsl:value-of select="//L10NFail"/><xsl:text> </xsl:text><xsl:value-of select="//L10NTemp"/>
													</xsl:with-param>
												</xsl:call-template>
											 </tr>
									 </table>
						  </td>
							  <!-- Output Temperature -->
						  <td style="padding-top:3px; padding-right:5px; padding-bottom:2px; padding-left:5px;">
								<table align="center" cellpadding="0" cellspacing="0" border="0" width="100%">
									<tr>
										<xsl:call-template name="Bar">
											<xsl:with-param name="tempC" select="./OutTempC"/>
											<xsl:with-param name="tempF">
												<xsl:call-template name="getTempInFaranheit">  
													<xsl:with-param name="tempC" select="./OutTempC"/>
												</xsl:call-template> 
											</xsl:with-param>
											<xsl:with-param name="tripTemp" select="./OutputTempTripC"/>
											<xsl:with-param name="finalTemp" select="./OutTempFailC"/>
											<xsl:with-param name="bgColor"><xsl:text>yellow</xsl:text></xsl:with-param>
											<xsl:with-param name="tripToolTip">
												<xsl:value-of select="//L10NTrip"/><xsl:text> </xsl:text><xsl:value-of select="//L10NTemp"/>
											</xsl:with-param>
											<xsl:with-param name="failToolTip"> 
												<xsl:value-of select="//L10NFail"/><xsl:text> </xsl:text><xsl:value-of select="//L10NTemp"/>
											</xsl:with-param>
											
										</xsl:call-template>	
									</tr>
								</table>
							</td>
				</xsl:element>			
			</xsl:if>
	</xsl:for-each>
</tbody>
</table>
</td>	
 </tr>		
</xsl:template>

<xsl:template name="renderProperties">
<xsl:param name="typeOfDisplay"/>
		<table width="100%" border="0" cellpadding="0" cellspacing="0" id="renderPropertiesTable">
			<tbody>
				<xsl:for-each select="/*">
					<xsl:call-template name="PropertiesTable">
						<xsl:with-param name="sectionName"><xsl:text>System Status</xsl:text></xsl:with-param>
						<xsl:with-param name="typeOfDisplay"><xsl:value-of select="$typeOfDisplay"/></xsl:with-param>
						<xsl:with-param name="displayName"><xsl:value-of select="//I18N/L10NSystemStatus"></xsl:value-of></xsl:with-param>
					</xsl:call-template>
					<tr>
						<td><br></br></td>
					</tr>	
					<xsl:call-template name="PropertiesTable">
						<xsl:with-param name="sectionName"><xsl:text>Identification</xsl:text></xsl:with-param>
					 	<xsl:with-param name="displayName"><xsl:value-of select="//I18N/L10NIdentification"></xsl:value-of></xsl:with-param>
						<xsl:with-param name="typeOfDisplay"><xsl:value-of select="$typeOfDisplay"/></xsl:with-param>
					</xsl:call-template>
					<tr>
						<td><br></br></td>
					</tr>	
					<xsl:if test="//PowerSupplyEnclosure/PowerSupplyUnit/hasDevice=$PRESENT">
						<xsl:if test="name(.)='PowerSupplyEnclosure'">
							
							<xsl:call-template name="PropertiesTable">              
								<xsl:with-param name="sectionName"><xsl:text>Power And Thermal</xsl:text></xsl:with-param>
								<xsl:with-param name="displayName"><xsl:value-of select="//I18N/L10NPowerAndThermal"/></xsl:with-param>
								<xsl:with-param name="typeOfDisplay"><xsl:value-of select="$typeOfDisplay"/></xsl:with-param>
							</xsl:call-template>
							<tr>
								<td ></td>
							</tr>	
							<xsl:call-template name="PowerSupplyTable"/>
						</xsl:if>
					</xsl:if>	
				</xsl:for-each>
				
					<xsl:if test="//@type=$C_CLASS">
						
						<xsl:if test="//PowerSupplyUnit/hasDevice=$PRESENT">
							<xsl:call-template name="PropertiesTable">
								<xsl:with-param name="sectionName"><xsl:text>Power And Thermal</xsl:text></xsl:with-param>
								<xsl:with-param name="displayName"><xsl:value-of select="//I18N/L10NPowerAndThermal"/></xsl:with-param>
								<xsl:with-param name="typeOfDisplay"><xsl:value-of select="$typeOfDisplay"/></xsl:with-param>
							</xsl:call-template>
							<xsl:call-template name="renderEnclosureTemperature"/>
							<tr>
								<td ></td>
							</tr>	
							<xsl:call-template name="rendercPowerUnit"/>
						</xsl:if>	
						<tr>
							<td><br></br></td>
						</tr>				
						<xsl:if test="//FANS/hasDevice=$PRESENT">
							<xsl:call-template name="rendercFans"/>
						</xsl:if>	
						
				</xsl:if>			
			</tbody>
		</table>
</xsl:template>

<xsl:template name="renderEnclosureTemperature">
		<tr>
			<td>	
				   <table border="0" cellpadding="0" cellspacing="0" class="dataTable" width="100%">
						<xsl:element name="tr">
								<th class="propertyName" style="border-top:1px solid #CCC;" > <xsl:value-of select="//I18N/L10NEnclosureAmbientTemp"/></th>
									<td>
										<table align="center" cellpadding="0" cellspacing="0" border="0" width="100%">
											<tr>
												<td colspan="2" style="background-color:#968F89">
													<table cellpadding="0" cellspacing="0" border="0" width="100%">
														<tr>
															<td align="center" width="14%" style="background-color:#968F89; border-right:1px solid #CCC;border-top:0px "><font color="#FFFFFF">
															<xsl:value-of select="//I18N/L10NStatus"></xsl:value-of></font></td>
															<td align="left" width="17%" style="background-color:#968F89; border-left:1px solid #CCC;  border-right:1px solid #CCC; border-top:0px"><font color="#FFFFFF"> 
															<xsl:text>&#176;</xsl:text><xsl:text>C / </xsl:text> <xsl:text>&#176;</xsl:text> <xsl:text>F</xsl:text></font></td>
															<td align="left" width="73%" style="background-color:#968F89; border-left:1px solid #CCC; border-top:0px"><font color="#FFFFFF"> 
															<xsl:value-of select="//I18N/L10NGraph"></xsl:value-of></font></td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td>
													<table cellpadding="0" cellspacing="0" border="0" width="75%">
														<tbody>
															<tr>
																<xsl:call-template name="Bar">
																	<xsl:with-param name="tempC" select="//Temperature/Current"/>
																	<xsl:with-param name="tempF"> 
																		<xsl:call-template name="getTempInFaranheit">  
																			<xsl:with-param name="tempC" select="//Temperature/Current"/>
																		</xsl:call-template> 
																	</xsl:with-param>
																	<xsl:with-param name="tripTemp" select="//Temperature/Threshold/Caution"/>
																	<xsl:with-param name="finalTemp" select="//Temperature/Threshold/Critical"/>
																	<xsl:with-param name="bgColor"><xsl:text>yellow</xsl:text></xsl:with-param>
																	<xsl:with-param name="tripToolTip">
																		<xsl:value-of select="//I18N/L10NCautionStatus"/><xsl:text> </xsl:text><xsl:value-of select="//L10NTemp"/>
																	</xsl:with-param>
																	<xsl:with-param name="failToolTip"> 
																		<xsl:value-of select="//I18N/L10NCriticalStatus"/><xsl:text> </xsl:text><xsl:value-of select="//L10NTemp"/>
																	</xsl:with-param>
																</xsl:call-template>
															</tr>
													</tbody>
												</table>
											</td>
										</tr>
									 </table>
								  </td>
						</xsl:element>
				</table>
			</td>
		</tr>					 
</xsl:template>							

<xsl:template name="getTempInFaranheit">
<xsl:param name="tempC"/>
	<xsl:variable name="returnVal">
		<xsl:value-of select=" number($tempC) * number(1.8) + 32 "/>
	</xsl:variable>
	<!-- Returns the value wih 2 digits after decimal point -->
	<xsl:value-of select='format-number($returnVal, "#.##")'/>
</xsl:template>


<xsl:template name="getWidth">
<xsl:param name="curVal"/>
<xsl:param name="maxVal"/>
	<xsl:choose>
		<xsl:when test=" number($curVal) &gt; number($maxVal)"> <xsl:value-of select="'100'"/></xsl:when>
		<xsl:otherwise> <xsl:value-of select=" (number($curVal) div number($maxVal)) * number(100)"/>    </xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="getTempStatus">
	<xsl:param name="curVal"/>
	<xsl:param name="tripVal" />
	<xsl:param name="failVal" />
	
	<xsl:choose>
		<xsl:when test="$curVal &lt; $tripVal"> <xsl:value-of select="'Normal'"/></xsl:when>
		<xsl:when test="$curVal &gt;= $tripVal and $curVal &lt; $failVal"> <xsl:value-of select="'Major'"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="'Critical'"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="getLocalisedStatus">
	<xsl:param name="curVal"/>
	<xsl:param name="tripVal" />
	<xsl:param name="failVal" />
	
	<xsl:choose>
		<xsl:when test="$curVal &lt; $tripVal"> <xsl:value-of select="//I18N/L10NNormalStatus"/></xsl:when>
		<xsl:when test="$curVal &gt;= $tripVal and $curVal &lt; $failVal"> <xsl:value-of select="//I18N/L10NMajorStatus"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="//I18N/L10NCriticalStatus"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="getBgColor">
	<xsl:param name="curVal"/>
	<xsl:param name="tripVal" />
	<xsl:param name="failVal" />
	
	<xsl:choose>
		<xsl:when test="$curVal &lt; $tripVal"> <xsl:value-of select="'limegreen'"/></xsl:when>
		<xsl:when test="$curVal &gt;= $tripVal and $curVal &lt; $failVal"> <xsl:value-of select="'orange'"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="'red'"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name="rendercFans">
	 <tr>
		<td>	
			<table style="PADDING-TOP: 3px" border="0" cellpadding="0" cellspacing="0" class="dataTable">
				 <caption>
					 <xsl:value-of select="//I18N/L10NFANS"/>
				 </caption>		
				<thead>
					<tr class="centerCaptionRow">
						<th align="center" width="10%"><xsl:value-of select="//I18N/L10NBay"></xsl:value-of></th>
						<th align="center" width="15%" ><xsl:value-of select="//I18N/L10NHealthStatus"></xsl:value-of></th>
						<th align="center" width="25%"><xsl:value-of select="//I18N/L10NPartNumber"></xsl:value-of></th>
						<th align="center" width="25%"><xsl:value-of select="//I18N/L10NPowerUsed "></xsl:value-of> <xsl:text>  ( </xsl:text><xsl:value-of select="//I18N/L10NWatts"/> <xsl:text>  )</xsl:text></th>
						<th align="center" ><xsl:value-of select=" //I18N/L10NCurSpeedRPM "></xsl:value-of></th>
						
					</tr>
				</thead>
				<tbody>
				<xsl:for-each select="//FANS">
						<xsl:if test="./hasDevice=$PRESENT">
							<xsl:element name="tr">
								<xsl:attribute name="class">
			                    	<xsl:if test="position() mod 2 = 0">		
										    altRowColor
									</xsl:if>
								</xsl:attribute>
									<td align="center" width="10%"><xsl:value-of select="./BayNumber" /></td>
									<td align="center">
											<xsl:call-template name="statusIcon">
												<xsl:with-param name="statusCode" select="Status/UID" />
												<xsl:with-param name="titleMsg" select="Status/Title" />
											</xsl:call-template>
									</td> 
									<td align="center"><xsl:value-of select="./PartNumber" /></td>
									<td align="center"><xsl:value-of select="./PowerUsed" /></td>
									<td align="center"><xsl:value-of select="./Speed" /></td>
								</xsl:element>	
					</xsl:if>	
					</xsl:for-each>
						
				</tbody>
			</table>
		</td>
	</tr>
</xsl:template>

<xsl:template name="rendercPowerUnit">
	 <tr>
		<td>	
			<table style="PADDING-TOP: 3px" border="0" cellpadding="0" cellspacing="0" class="dataTable">
				<thead>
					<tr class="captionRow">
						<th align="center" width="10%" ><xsl:value-of select="//I18N/L10NBay"></xsl:value-of></th>
						<th align="center" width="10%"><xsl:value-of select="//I18N/L10NTableHdrFrmRev"></xsl:value-of></th>
						<th align="center" width="14%"><xsl:value-of select="//I18N/L10NACInput"></xsl:value-of></th>
						<!-- <th align="center" ><xsl:value-of select="//I18N/L10NPhase"></xsl:value-of></th> -->
						<th align="center" width="10%"><xsl:value-of select="//I18N/L10NSerialNumber"></xsl:value-of></th>
						<th align="center" width="13%"><xsl:value-of select="//I18N/L10NPartNumber"></xsl:value-of></th>
						<th style="padding-bottom:0px;" width="50%"><xsl:value-of select="//I18N/L10NPowerConsumption"/> <xsl:text>  ( </xsl:text><xsl:value-of select="//I18N/L10NWatts"/> <xsl:text>  )</xsl:text><br />
							<table cellpadding="0" cellspacing="0" border="0" width="100%">
								<tr>
									<td align="left" width="35%" style="background-color:#968F89; border-right:1px solid #CCC;"><font color="#FFFFFF">
									<xsl:value-of select="//I18N/L10OUPCAP"/></font></td>
									<td align="left" width="65%" style="background-color:#968F89; border-left:1px solid #CCC;"><font color="#FFFFFF"> 
									<xsl:value-of select="//I18N/L10NGraph"/></font></td>
								</tr>
							</table>
						</th>
					</tr>
				</thead>
				<tbody>
				<xsl:for-each select="//PowerSupplyUnit">
						<xsl:if test="./hasDevice=$PRESENT">
							<xsl:element name="tr">
								<xsl:attribute name="class">
			                    	<xsl:if test="position() mod 2 = 0">		
										    altRowColor
									</xsl:if>
								</xsl:attribute>
									<td align="center">	                  								
										<xsl:value-of select="./BayNumber" />			            				
									</td>
									<td align="center">
										<xsl:call-template name="getMember">
											<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NFirmwareRevision"/></xsl:with-param>
										</xsl:call-template>
									</td>
									<td align="center">
										<xsl:value-of select="ACInput"/>
									</td> 
									<!-- <td align="center">
										<xsl:value-of select="Attribute[Name='Phase']/Value" />
									</td> -->
									<td align="center">
										<xsl:call-template name="getMember">
											<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NSerialNumber"/></xsl:with-param>
										</xsl:call-template>
									</td>
									<td align="center">
										<xsl:call-template name="getMember">
											<xsl:with-param name="memberName"><xsl:value-of select="//I18N/L10NPartNumber"/></xsl:with-param>
										</xsl:call-template>
									</td>
									<td align="center">
										<table cellpadding="0" cellspacing="0" border="0" width="100%">
											<tr>
												<th width="100%" height="10px" id="powerConsumption">
												<xsl:variable name="pwrAvail"><xsl:value-of select="./Power/PowerAvailable" /></xsl:variable>
												<xsl:variable name="pwrUsed"><xsl:value-of select="./Power/PowerUsed" /></xsl:variable>
												<xsl:variable name="curValue">
														<xsl:if test="($pwrAvail !='' and $pwrAvail !=$NOT_AVAILABLE and $pwrUsed !='' and $pwrUsed !=$NOT_AVAILABLE ) ">
															<xsl:value-of select="number($pwrUsed)"/>		
														</xsl:if>
												</xsl:variable>
												<xsl:choose>
													<xsl:when test="$curValue!='' and $curValue!=$NOT_AVAILABLE">
														<xsl:call-template name="barGraph">
															<xsl:with-param name="curValue">
																<xsl:value-of select="$curValue"/>
															</xsl:with-param>
															<xsl:with-param name="maxValue">
																<xsl:value-of select="$pwrAvail"/>
															</xsl:with-param>
														</xsl:call-template>	
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="//I18N/L10NOTAVAILABLE"/>
													</xsl:otherwise>
												</xsl:choose>	
												</th>
												
											</tr>
										</table>
									</td>
								</xsl:element>	
						</xsl:if>
				</xsl:for-each>
				
			</tbody>
		</table>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>

