<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="2.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:fn="http://www.w3.org/2005/02/xpath-functions"
        xmlns:hpoa="hpoa.xsd">

    <xsl:include href="PortMapConstants.xsl" />
    <xsl:include href="PortStatusTemplates.xsl" />
	
<xsl:template match="*">
<head>
<link href="/mxportal/bladeime/skin/portMapping/css/default.css" type="text/css" rel="stylesheet"/>
<script language="Javascript" src="/mxportal/bladeime/skin/js/Skin.js" type="text/javascript">Skinnable view scripts</script>
</head>
		
		<table border="0" cellpadding="0" cellspacing="0"  width="550" style="border:1px solid #968F89;border-top-width:0px;border-collapse:collapse;">
			<thead>
				<tr class="captionRow">
					<th> <xsl:value-of select="//I18N/L10NInterConnect"></xsl:value-of>
                    <br><xsl:value-of select="//I18N/L10NBayPort"></xsl:value-of> </br></th>
					<th><xsl:value-of select="//I18N/L10NPortStatus"></xsl:value-of></th>
					<th><xsl:value-of select="//I18N/L10NServerBay"></xsl:value-of></th>
					<th><xsl:value-of select="//I18N/L10NMezzPort"></xsl:value-of></th>
				</tr>
			</thead>
			<tbody>
			<xsl:choose>
				
			 <xsl:when test="InterConnectDevice/HasPortMapInfo=$PORTMAP_INFO_ABSENT">
				<tr>
				<td align="center">
					<xsl:attribute name="colspan">
						<xsl:value-of select="$NUM_COLS_SWITCHPORTMAP"/>
					</xsl:attribute>
					<xsl:value-of select="//I18N/L10NNotAvailable"></xsl:value-of>
					</td>
				</tr>
			</xsl:when>
			<xsl:otherwise>
			
				<xsl:for-each select="InterConnectDevice/InterConnectSlot/InterConnectTrayPort">
				<!-- This is to sort the Port numbers -->
					<xsl:sort data-type="number" select="PortNumber"/>
					<xsl:variable name="bladeBayNumber" select="ServerBay" />
					<xsl:variable name="bladeMezzNumber" select="ServerMezzslot" />
					<xsl:variable name="bladeMezzPortNumber" select="ServerMezzPort" /> 
					<xsl:variable name="mezzName" select="ServerMezzName"/>

					<xsl:element name="tr">

						<xsl:if test="PortStatus/PortStatusString=$STATUS_MISMATCH">
							<xsl:attribute name="class">mismatchRow</xsl:attribute>
						</xsl:if>

						<td class="nested1 sorted" style="    background-color:#dfdfdf;border-top:1px solid #ccc;vertical-align:top;padding:2px 5px 1px 5px;">
							<xsl:value-of select="PortNumber"/>
						</td>
						<td style="    background-color:#f5f5f5;border-top:1px solid #ccc;vertical-align:top;padding:2px 5px 1px 5px;">
							<xsl:choose>
								<xsl:when test="PortStatus/PortStatusString=$STATUS_OK or PortStatus/PortStatusString=$STATUS_MISMATCH">
									<xsl:call-template name="getStatusLabel">
										<xsl:with-param name="statusCode" select="PortStatus/PortStatusString" />
									</xsl:call-template>
									&#160;<xsl:value-of select="PortStatus/PortStatusValue"></xsl:value-of>&#160;
									<xsl:if test="PortStatus/PortStatusString=$STATUS_OK">
											<xsl:value-of select="//I18N/L10NConnected" ></xsl:value-of>
									</xsl:if>
								</xsl:when>
								<xsl:otherwise>
										<xsl:value-of select="//I18N/L10NNoConnection"></xsl:value-of>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td style="    background-color:#f5f5f5;border-top:1px solid #ccc;vertical-align:top;padding:2px 5px 1px 5px;">
							<xsl:if test="$bladeBayNumber != 0">
								<xsl:value-of select="//I18N/L10NBay"></xsl:value-of>
								&#160;<xsl:value-of select="ServerBay"/>
							</xsl:if>
						</td>
						<td style="    background-color:#f5f5f5;border-top:1px solid #ccc;vertical-align:top;padding:2px 5px 1px 5px;">
							<xsl:if test="$bladeMezzPortNumber != 0">
							<xsl:value-of select="//I18N/L10NPort"></xsl:value-of>
							<xsl:value-of select="$bladeMezzPortNumber"/>
							</xsl:if>
						</td>
					</xsl:element>

				</xsl:for-each>
				</xsl:otherwise>
				</xsl:choose>
			</tbody>
		</table>
	</xsl:template>
</xsl:stylesheet>