<%
/*************************************************************************************************
 ** File         : LastUpdateLinkTemplate.jsp
 ** Dependencies :  
 ** Description  : This JSP is responsible for creating last updated time link. 
				   This is a template and can be plugged into any JSPs
 ** @author      : Prakash C Rao (prakash.rao@hp.com)
 ** @created     : Oct 19, 2005
 ** (C) Copyright 2001-2006, Hewlett-Packard Company, All Rights Reserved.
 *************************************************************************************************
 */
%>

<%@ page import="com.hp.mx.html.core.MxHtmlUtil"%>
<%@ page import="com.hp.mx.portal.ui.MxPortalRender"%>
<%@ page import="com.hp.mx.portal.utils.LastUpdateLinkBean"%>

<jsp:useBean id="overviewBundle" class="com.hp.mx.portal.res.MxResourceBean" scope="session" />
<jsp:useBean id="loginBean" class="com.hp.mx.portal.ui.MxLoginBean" scope="session" />

<script language="javascript" type="text/javascript">
	function updateLink(linkUrl, isRefreshRequired)
	{
		document.location.replace(linkUrl + "&isRefreshRequired="+isRefreshRequired+"&updateLinkSelected=true");
	}

	function writeTime(lastUpdatedTime)
	{
		var timeTd = document.getElementById('timetd').rows;
		var cells = timeTd[0].cells;
		cells[1].innerHTML=lastUpdatedTime;
	}
</script>

<%
	MxHtmlUtil.dumpHeadBegin(out); 
	MxPortalRender.dumpHeadContent(out);
	MxHtmlUtil.dumpHeadEnd(out);

	/** 
		Initialize overview.properties. This is required to retrieve refresh.label. 
	*/	
	overviewBundle.init(loginBean, "Overview");	
	
	/** 
		This will be set to true only if a node is deleted in the view.
		Clicking on last update link will set this to false 
	*/
	String isRefreshRequired = request.getParameter("isRefreshRequired");

	/**  
		This will be set only if last update link is selected. 
		 SIM/F5 Browser refresh will not fetch the latest information.
	*/
	String updateLinkSelected = request.getParameter("updateLinkSelected");

	/**  
		GUID of the selected container. 
	*/
	String target = request.getParameter("target");

	/** 
		This will have url of the JSP, which is including this template. 
	*/
	String linkUrl = request.getParameter("linkUrl");

	/** 
		Unique Bean Id for pages. BPV, Performance Page and Port Mapping Pages 
		will have Unique bean ids.
	*/	
	String beanId = request.getParameter("beanId");

	/** 
		Get last updated bean for beanId specified. Create one at session 
		level and attach it to beanId if it is not present yet.
	*/		
	LastUpdateLinkBean  lastUpdateLinkBean = 
		(LastUpdateLinkBean)pageContext.getAttribute(beanId, PageContext.SESSION_SCOPE);
	if (lastUpdateLinkBean == null)
	{
		lastUpdateLinkBean = new LastUpdateLinkBean();
		pageContext.setAttribute(beanId, lastUpdateLinkBean, PageContext.SESSION_SCOPE);
	}

	/** 
		Check whether the page is expired. ExpiredFlag will be set to true 
		only if the below are satisfied.
		1. The visited container page is a new page. 
		2. If a node is deleted in a Rack/Enclosure View.
		3. Last Update link is selected and the page is expired. The expiry 
		   time is set to 5 minutes.
		Note that SIM/F5 Browser refresh will not fetch the latest information.
	*/
	lastUpdateLinkBean.checkExpired(target, isRefreshRequired, updateLinkSelected, loginBean);
%>

<td><a href=javascript:updateLink("<%=MxHtmlUtil.encodeHtmlEntities(linkUrl)%>",false)>
	<%=overviewBundle.getString("refresh.label")%>
	</a>:
</td>
<td>
</td>
	
<script>
	writeTime("<%=lastUpdateLinkBean.getLastUpdatedTime()%>");
</script>
