
function ButtonManager() {

}


ButtonManager.prototype.getWrapperReference = function(btnWrapperObj) {
    if (btnWrapperObj == null)
        return;

    var ob = btnWrapperObj;
    var className = ob.className;
    while (className.indexOf("bWrapper")==-1) {
        ob = ob.parentNode;
        className = ob.className;
    }
    return ob;
}

ButtonManager.prototype.hpButtonOver = function(btnWrapperObj) {
    if (btnWrapperObj == null)
        return;

    if (!this.getButtonChild(btnWrapperObj).disabled) {
        var ob = this.getWrapperReference(btnWrapperObj);
        if (ob.className.indexOf("bEmphasized")!=-1) {
            ob.className = "bWrapperOver bEmphasized";
        }
        else {
            ob.className = "bWrapperOver";
        }
    }
}

ButtonManager.prototype.hpButtonUp = function(btnWrapperObj) {
    if (btnWrapperObj == null)
        return;

    if (!this.getButtonChild(btnWrapperObj).disabled) {
        var ob = this.getWrapperReference(btnWrapperObj);
        if (ob.className.indexOf("bEmphasized")!=-1) {
            ob.className = "bWrapperUp bEmphasized";
        }
        else {
            ob.className = "bWrapperUp";
        }

    }
}

ButtonManager.prototype.hpButtonDown = function(btnWrapperObj) {
    if (btnWrapperObj == null)
        return;

    var ob = this.getWrapperReference(btnWrapperObj);
    var childButton = this.getButtonChild(btnWrapperObj);
    if (!childButton.disabled) {
        if (ob.className.indexOf("bEmphasized")!=-1) {
            ob.className = "bWrapperDown bEmphasized";
        }
        else {
            ob.className = "bWrapperDown";
        }
        childButton.focus();
    }
}

ButtonManager.prototype.resizeButton = function(btnObj) {
    if (btnObj == null)
        return;

    //this if may not be needed anymore, width reset should remain
    if(btnObj.style.width)
        btnObj.style.width = "";

    var wrapper = this.getWrapperReference(btnObj);

    // looking up to see if we're in a vertical button set.
    var lookingForVerticalButtonSet = wrapper;
    while ((lookingForVerticalButtonSet) && (lookingForVerticalButtonSet.className!="verticalButtonSet")) {
            lookingForVerticalButtonSet = lookingForVerticalButtonSet.parentNode;
    }
    if (lookingForVerticalButtonSet) {
                btnObj.style.width = "100%";
    }
    else if (!btnObj.getAttribute("disableminimumwidth")){

        // setting widths based on which size button this is to be.
        // tempting to use CSS property min-width and  accept that it only works on mozilla. However mozilla forces align left in this case, which does more harm than good to the design.
        if (btnObj.className.indexOf("hpButtonSmall")!=-1) {
            if (btnObj.offsetWidth < 47) btnObj.style.width = "47px";
        }
        else if (btnObj.className.indexOf("hpButtonVerySmall")!=-1) {
            // these are tiny buttons with no minimum width, like the help button on the pagetitle bar.
        }

        // catchall
        //  This line causes some mozilla problems with the vertical buttons btw, although it is no longer used by them.
        else if (btnObj.offsetWidth < 83) btnObj.style.width = "83px";
    }
}

ButtonManager.prototype.resizeButtonById = function(btnId) {
    var btnObj = document.getElementById(btnId);
    this.resizeButton(btnObj);
}

ButtonManager.prototype.setButtonOnclick = function(btnObj, onclickFun) {
    if (btnObj == null)
        return;

    var wrapper = this.getWrapperReference(btnObj);
    eval("wrapper.onclick = function() { " + onclickFun + "; }");
}

ButtonManager.prototype.setButtonOnclickById = function(btnId, onclickFun) {
    var btnObj = document.getElementById(btnId);
    this.setButtonOnclick(btnObj, onclickFun);
}

ButtonManager.prototype.setButtonLabel = function(btnObj, newLabel) {
    if (btnObj == null)
        return;

    if (btnObj.childNodes) {
        btnObj.childNodes[0].nodeValue = newLabel;
    } else {
        btnObj.innerHTML = newLabel;
    }

    //resize the button
    this.resizeButton(btnObj);

}

ButtonManager.prototype.setButtonLabelById = function(btnId, newLabel) {
    var btnObj = document.getElementById(btnId);
    this.setButtonLabel(btnObj, newLabel);
}

ButtonManager.prototype.disableButton = function(btnObj) {
    if (btnObj == null)
        return;

    btnObj.disabled = true;
    var wrapper = this.getWrapperReference(btnObj);
    wrapper.onmousedown= null;
    wrapper.onmouseup=  null;
    wrapper.onmouseover=  null;
    wrapper.onmouseout=  null;

    if (wrapper.onclick) {
        wrapper.previousonclick = wrapper.onclick;
        wrapper.onclick = null;
    }

    if (wrapper.className.indexOf("bEmphasized")!=-1) {
        wrapper.className = "bWrapperDisabled bEmphasized";
    }
    else {
        wrapper.className = "bWrapperDisabled";
    }
}

ButtonManager.prototype.enableButton = function(btnObj) {
    if (btnObj == null)
        return;

    btnObj.disabled = false;
    var wrapper = this.getWrapperReference(btnObj);
    if (wrapper.className.indexOf("bEmphasized")!=-1) {
        wrapper.className = "bWrapperUp bEmphasized";
    }
    else {
        wrapper.className = "bWrapperUp";
    }
    var wrapper = this.getWrapperReference(btnObj);
    wrapper.onmousedown= function() {ourButtonManager.hpButtonDown(this);}
    wrapper.onmouseup= function() {ourButtonManager.hpButtonOver(this);}
    wrapper.onmouseover= function() {ourButtonManager.hpButtonOver(this);}
    wrapper.onmouseout= function() {ourButtonManager.hpButtonUp(this);}

    if(wrapper.previousonclick) {
        wrapper.onclick = wrapper.previousonclick;
        wrapper.previousonclick = null;
    }
}

ButtonManager.prototype.disableButtonById = function(btnId) {
    var btnObj = document.getElementById(btnId)
    this.disableButton(btnObj);
}

ButtonManager.prototype.enableButtonById = function(btnId) {
    var btnObj = document.getElementById(btnId)
    this.enableButton(btnObj);
}

ButtonManager.prototype.getButtonChild = function(divObj) {
    if (divObj == null)
        return;

    var obj = divObj
    while ((obj.childNodes[0]!=null) && ((obj.tagName!="BUTTON") && (obj.tagName!="INPUT"))  &&  (obj.tagName!="A") && (obj.tagName!="SUBMIT") ) {
        obj = obj.childNodes[0];
    }
    return obj;
}

ButtonManager.prototype.initButton = function(btnObj) {
    if (btnObj == null)
        return;

    this.resizeButton(btnObj);

    var btnWrapper = this.getWrapperReference(btnObj);

    // this effectively transfers the onclick up to the level of the div.
    // this makes the entire div+button structure effectively into the 'button', and moreover covers cases when the user clicks only one of the the right or bottom borders.
    if (btnObj.onclick) {
        btnWrapper.onclick = btnObj.onclick;
        btnObj.onclick = null;
    }

    if (!btnObj.disabled) {
        btnWrapper.onmousedown= function() {ourButtonManager.hpButtonDown(this);}
        btnWrapper.onmouseup= function() {ourButtonManager.hpButtonOver(this);}
        btnWrapper.onmouseover= function() {ourButtonManager.hpButtonOver(this);}
        btnWrapper.onmouseout= function() {ourButtonManager.hpButtonUp(this);}

        var buttonChildren = btnWrapper.getElementsByTagName("BUTTON");
        var inputChildren = btnWrapper.getElementsByTagName("INPUT");
        for (var j=0;j<buttonChildren.length;j++) {

            buttonChildren[j].onfocus = function() {ourButtonManager.hpButtonDown(this);}
            buttonChildren[j].onblur = function() {ourButtonManager.hpButtonUp(this);}
        }
        for (var j=0;j<inputChildren.length;j++) {
            inputChildren[j].onfocus = function() {ourButtonManager.hpButtonDown(this);}
            inputChildren[j].onblur = function() {ourButtonManager.hpButtonUp(this);}
        }
    }
    else {

        this.disableButton(btnObj);

    }


}

ButtonManager.prototype.initButtonById = function (btnId)
{   var btnObj = document.getElementById(btnId);
    this.initButton(btnObj);
}

ButtonManager.prototype.init  = function() {
    var divs = document.getElementsByTagName("DIV");
    for (var i=0;i<divs.length;i++) {

        if (divs[i].className.indexOf("bWrapper")!=-1) {

            // some button styles might have two nested divs, making a 2px border, or three.  therefore we have to be careful when we look down inside the divs looking for the buttons.
            var button = this.getButtonChild(divs[i]);

            this.initButton(button);

        }
    }
}

//long and complex function to make a button
ButtonManager.prototype.makeMxButtonLong = function(bId, bLabel, bOnclick, bMargins, bSecondary, bTertiary, bDisabled, bSelected, bType, bFloat) {

    var szId = "";
    if (bId)
        szId = " id='" + bId + "'";

    var szLabel = "";
    if (bLabel)
        szLabel = bLabel;

    var szOnclick = "";
    if (bOnclick)
        szOnclick = " onclick='" + bOnclick + "'";

    szFloat = "";
    if (bFloat == "left")
        szFloat = "float:left;";
    else if (bFloat == "none")
        szFloat = "float:none;";

    var szStyle = "";
    if (bMargins != null && bMargins.length == 4)
        szStyle = " style='" + szFloat
                    + "margin-top:" + (bMargins[0] + 3) + "px;"
                    + "margin-right:" + bMargins[1] + "px;"
                    + "margin-bottom:"+ bMargins[2] + "px;"
                    + "margin-left:" + (bMargins[3] + 3) + "px"
                    + "'";

    var szInnerClass = "hpButton";
    if(bSecondary)
        szInnerClass = "hpButtonSmall";
    else if (bTertiary)
        szInnerClass = "hpButtonVerySmall";

    var szDisabled = "";
    if (bDisabled)
        szDisabled = " disabled";

    var szType = "";
    if (bType == "submit")
        szType = " type='submit'";
    else
        szType = " type='button'";

    var szClass = "bWrapperUp";
    if (bSelected)
        szClass += " bEmphasized";

    var button = "<div class='" + szClass +"'" + szStyle + "><div><div>"
                + "<button" + szType + szDisabled + " class='" + szInnerClass + "'" + szOnclick + szId + ">"
                + szLabel
                + "</button>"
                + "</div></div></div>";

    return button;
}

//simple function to make primary, secondary, or tertiary button with option to start off disabled
ButtonManager.prototype.makeMxButtonMed = function(bId, bLabel, bOnclick, bSecondary, bTertiary, bDisabled) {

    if (document.all)
        return this.makeMxButtonLong(bId, bLabel, bOnclick, [0,0,0,1], bSecondary, bTertiary, bDisabled, false, 'button', 'left');
    else
        return this.makeMxButtonLong(bId, bLabel, bOnclick, [0,0,0,5], bSecondary, bTertiary, bDisabled, false, 'button', 'left');
}

//simple function to make a primary button with default parameters
ButtonManager.prototype.makeMxButton = function (bId, bLabel, bOnclick) {

    if (document.all)
        return this.makeMxButtonLong(bId, bLabel, bOnclick, [0,0,0,1], false, false, false, false, 'button', 'left');
    else
        return this.makeMxButtonLong(bId, bLabel, bOnclick, [0,0,0,5], false, false, false, false, 'button', 'left');

}
