<%@page errorPage = "OAConfigErrorHandler.jsp"%>
<%@page import="com.hp.mx.core.tools.datacollection.soap.oa.SOAPCustomHandler,
				com.hp.mx.core.tools.datacollection.soap.oa.OACommunicationIntf,
				com.hp.mx.core.tools.datacollection.soap.oa.OAFileHandler,
				com.hp.mx.portal.ui.MxOptions,
				com.hp.mx.utilities.DebugSubsystem,
				com.hp.mx.core.tools.datacollection.soap.oa.OAConstants,
				com.hp.mx.core.tools.datacollection.soap.oa.UploadConfigFile,				
				java.io.File,
				java.io.InputStream,
				java.net.SocketException,
				java.net.URL,
				java.io.ByteArrayOutputStream,
				java.net.UnknownHostException,
				java.net.MalformedURLException,
				java.net.ConnectException,
				java.io.PrintStream,
				java.io.IOException,
				java.util.Vector,
				com.hp.mx.portal.i18n.MonteroResourceManager,
				com.hp.mx.portal.ui.MxBean"
%>
<jsp:useBean id="loginBean" class="com.hp.mx.portal.ui.MxLoginBean" scope="session" />
<jsp:useBean class="com.hp.mx.core.tools.datacollection.soap.oa.OACommunicatorSessionBean" id="OACommunicatorSessionBean" scope="session"/>
<jsp:useBean id="rbPortal" class="com.hp.mx.portal.res.MxResourceBean" scope="session" />

<link type='text/css' rel='stylesheet' href='<%=MxOptions.URL_BASE%>/css/MxTools.css'>
<link rel="stylesheet" type=text/css href="<%=MxOptions.URL_BASE%>/bladeime/skin/css/default.css">

<%
	MxBean.jspInit(request, response);
	rbPortal.init(loginBean, "MxPortal");
	String reqType				= request.getParameter("reqType");
	String selFiles[] 			= request.getParameterValues("chkFilePath");
	String selSingleFile		= request.getParameter("chkFilePath");
	String fileName				= request.getParameter("fileName");
	String OAIPAddress			= request.getParameter("ipAddress");
	OAFileHandler fileHandler 	= new OAFileHandler();		
	String configFileContents	= "";
	OACommunicationIntf	OACommunicator = OACommunicatorSessionBean.getOACommunicator(OAIPAddress);	
	DebugSubsystem LOGGER = new DebugSubsystem(OAProcessConfigRequest_jsp.class);
	String errorMsg = "";
	String causeMsg = "";
	String actionMsg = "";
	ByteArrayOutputStream  baos = new ByteArrayOutputStream();
	Vector  errorVect = new Vector();

	try
	{
		if(reqType != null)
		{
			//delete selected cfg files
			if(reqType.equals(OAConstants.DELETE_REQ_TYPE))
				fileHandler.deleteFile(selFiles);					
			
			//delete all files
			if(reqType.equals(OAConstants.DELETE_ALL_REQ_TYPE))
				fileHandler.deleteAllFiles(selFiles);	
			
			//save cfg file 
			if (reqType.equals(OAConstants.SAVE_REQ_TYPE))
				OACommunicator.saveConfigurationScript(fileName);	 
					
			//restore OA with selected cfg content
			if(reqType.equals(OAConstants.RESTORE_REQ_TYPE))
			{		
				ServletContext context = this.getServletConfig().getServletContext();
				
				//copy cfg file from CMS config area to web app area
				String absoluteFilePath = context.getRealPath("/OAProcessConigRequest.jsp");
				File tmpFile = new File(absoluteFilePath);
				String webappDir = tmpFile.getParent();
				webappDir =	webappDir + "/mxportal/bladeime/oaconfig/";			
				fileHandler.copyFileToWebappFromConfigDir(selSingleFile, webappDir);
				
				//comment restore soap call
				//OACommunicator.restoreConfiguration();			
				//make a cgi call since oa does n't support https
				UploadConfigFile uploadObj = new UploadConfigFile();
				String fileToUpload = webappDir + OAConstants.TMP_CONFIG_FILE_NAME;
				URL cgiUploadUrl = new URL("https://" + OAIPAddress + "/cgi-bin/uploadFile/");
				String configResponse = uploadObj.sendRequest(cgiUploadUrl, OACommunicator.getSessionKey(), "CONFIG_SCRIPT", fileToUpload);
				//throw error since return code is not ok
				if(configResponse == null || (configResponse.indexOf("returnCodeOk")) == -1)
				{
					throw new IOException();
				}
				File tmpCfgFile = new File(fileToUpload);
				if(tmpCfgFile != null) tmpCfgFile.delete();
			}
		}
	%>
		<jsp:forward page="OAConfiguration.jsp"/>
<%
}
catch(UnknownHostException e) //if unreachable ipaddress is supplied
{
	errorMsg = OAFileHandler.getErrorMsg(reqType, loginBean) + "<br><br>";
	causeMsg = MonteroResourceManager.getInstance().getString("oaconfig.cause.oa", loginBean.getLocale()) + " " + OAIPAddress + MonteroResourceManager.getInstance().getString("oaconfig.cause.notReachable", loginBean.getLocale()) + "<br><br>";
	actionMsg=MonteroResourceManager.getInstance().getString("oaconfig.action.ensure", loginBean.getLocale()) + " \"" + OAIPAddress + "\" " + MonteroResourceManager.getInstance().getString("oaconfig.action.reachable", loginBean.getLocale()) + "<br>";
	e.printStackTrace(new PrintStream(baos));
	LOGGER.panic("Error in OAProcessConfiguration.jsp \n " + errorMsg + baos.toString());
}
catch(ConnectException e) //when timeout occurs
{
	errorMsg = OAFileHandler.getErrorMsg(reqType, loginBean);
	if(e.toString().trim().indexOf("HTTP response code: 500") == -1)
	{
		causeMsg = MonteroResourceManager.getInstance().getString("oaconfig.err.reasons", loginBean.getLocale()) + " \"" + OAIPAddress + "\" " + MonteroResourceManager.getInstance().getString("oaconfig.cause.standByOa", loginBean.getLocale()) + "<br><br>";
		actionMsg = MonteroResourceManager.getInstance().getString("oaconfig.action.privilegeActionStep", loginBean.getLocale()) +" \"" + OAIPAddress + "\" " + MonteroResourceManager.getInstance().getString("oaconfig.action.multiActions", loginBean.getLocale()) + "<br><br>";
	}
	else
	if(e.toString().trim().indexOf("HTTP response code: 500") != -1)
	{
		causeMsg = MonteroResourceManager.getInstance().getString("oaconfig.cause.oa", loginBean.getLocale()) +" \"" + OAIPAddress + "\" " + MonteroResourceManager.getInstance().getString("oaconfig.cause.standByOa", loginBean.getLocale()) + "<br><br>";
		actionMsg= MonteroResourceManager.getInstance().getString("oaconfig.action.activeOa", loginBean.getLocale()) + "<br>";
	}
	e.printStackTrace(new PrintStream(baos));
	LOGGER.panic("Error in OAProcessConfiguration.jsp \n " + errorMsg + baos.toString());
}
catch(SocketException e)
{	
	errorMsg = OAFileHandler.getErrorMsg(reqType, loginBean);
	e.printStackTrace(new PrintStream(baos));
	LOGGER.panic("Error in OAProcessConfiguration.jsp \n " + errorMsg + baos.toString());
	causeMsg = MonteroResourceManager.getInstance().getString("oaconfig.cause.httpsDisabled", loginBean.getLocale()) + "<br><br> ";
	actionMsg = MonteroResourceManager.getInstance().getString("oaconfig.action.enableHTTPs", loginBean.getLocale()) + "<br>";
}
catch(MalformedURLException e) //when hpoa is invalid
{
 	errorMsg = OAFileHandler.getErrorMsg(reqType, loginBean) + "<br><br> URL \"https://" + OAIPAddress + ":443/hpoa\" " + MonteroResourceManager.getInstance().getString("oaconfig.causeUrlNotAccessible", loginBean.getLocale()) + "<br><br>";
	e.printStackTrace(new PrintStream(baos));
	LOGGER.panic("Error in OAProcessConfiguration.jsp \n " + errorMsg + baos.toString());
}
catch(IOException e) //when invalid user details are supplied
{
	errorMsg = OAFileHandler.getErrorMsg(reqType, loginBean);
	if(e.toString().trim().indexOf("HTTP response code: 500") == -1)
	{
		causeMsg = MonteroResourceManager.getInstance().getString("oaconfig.err.reasons", loginBean.getLocale()) + " \"" + OAIPAddress + "\" " + MonteroResourceManager.getInstance().getString("oaconfig.cause.standByOa", loginBean.getLocale()) + "<br><br>";
		actionMsg = MonteroResourceManager.getInstance().getString("oaconfig.action.privilegeActionStep", loginBean.getLocale()) +" \"" + OAIPAddress + "\" " + MonteroResourceManager.getInstance().getString("oaconfig.action.multiActions", loginBean.getLocale()) + "<br><br>";
	}
	else
	if(e.toString().trim().indexOf("HTTP response code: 500") != -1)
	{
		causeMsg = MonteroResourceManager.getInstance().getString("oaconfig.cause.oa", loginBean.getLocale()) +" \"" + OAIPAddress + "\" " + MonteroResourceManager.getInstance().getString("oaconfig.cause.standByOa", loginBean.getLocale()) + "<br><br>";
		actionMsg= MonteroResourceManager.getInstance().getString("oaconfig.action.activeOa", loginBean.getLocale()) + "<br>";
	}
	e.printStackTrace(new PrintStream(baos));
	LOGGER.panic("Error in OAProcessConfiguration.jsp \n " + errorMsg + baos.toString());
}

	//when reached here, indicates problem with save/restore
	errorVect.add(errorMsg);
	errorVect.add(causeMsg);
	errorVect.add(actionMsg);

	//store all the i18n error msgs in the session 
	session.setAttribute("errorVector",errorVect);
	response.sendRedirect("OAConfigErrorHandler.jsp?isCfgError=yes");
%>
	<script>
		//hide the progress bar and load the actual page
		if(parent.hideLoading)
		{
			parent.hideLoading();
		}
	</script>