<%@page errorPage = "/mxportal/bladeime/BladeIMEErrorHandlerPage.jsp"%>
<%@ page import="com.hp.mx.portal.i18n.MonteroResourceManager,
                 com.hp.mx.core.nodemanager.MxNode,
				 java.io.File,
                 com.hp.mx.html.core.MxHtmlUtil,
                 com.hp.mx.portal.ui.MxOptions,
				 com.hp.mx.portal.ui.MxBean,
    			 com.hp.mx.core.nodemanager.DeviceTypesIfc,
				 com.hp.mx.portal.ui.MxDateAndTime,
				 com.hp.mx.database.GlobalSettings"
				%>
<jsp:useBean id="monteroBean" class="com.hp.mx.portal.MonteroBean" scope="session" />
<jsp:useBean id="loginBean" class="com.hp.mx.portal.ui.MxLoginBean" scope="session" />
<jsp:useBean id="deviceBundle" class="com.hp.mx.portal.res.MxResourceBean" scope="session" />
<jsp:useBean id="deviceInfoBean" class="com.hp.mx.portal.performance.DeviceInfoBean" scope="session" />
<jsp:useBean id="portMappingSkinBean" class="com.hp.mx.portal.skin.PortMappingSkin" scope="session"/>

<%
 MxBean.jspInit(request, response);
 if (loginBean.checkLogoutConditionForWebPage(pageContext) == true)
  {
      return;
  }
  deviceBundle.init(loginBean, "MxDeviceBundle");
  int devKey = Integer.parseInt(request.getParameter("devId"));
  monteroBean.initialize(loginBean);
  deviceInfoBean.initialize(monteroBean,devKey);
  MxNode node = deviceInfoBean.getMxNode();
  MxDateAndTime dateAndTime = new MxDateAndTime(loginBean.getLocalePreferred(), loginBean.getTimeZone());
  String isHttpEnabledOnGlobalScale = GlobalSettings.getProperty("http_check_state", "checked");
 %>

<html>
    <head>
        <SCRIPT src="/mxportal/js/MxPortalApi.js" language="JavaScript" type="text/javascript"></SCRIPT>
		<script src="<%=MxOptions.URL_BASE%>/bladeime/skin/js/Skin.js" language="JavaScript" type="text/javascript"></script>
	
		<link type='text/css' rel='stylesheet' href='<%=MxOptions.URL_BASE%>/bladeime/skin/css/default.css'>
        <% MxHtmlUtil.dumpHeadBegin(out); %>
        <% MxHtmlUtil.dumpHeadEnd(out); %>
		<%
				String sIndex = request.getParameter("index");

				int tabIndex = 0;
				if ( sIndex != null )
				{
					Integer tempIndex = new Integer(sIndex);
					tabIndex = tempIndex.intValue();
				}
		%>
        <script language="javascript" type="text/javascript">

        function myOnLoad()
        {
			isLoaded = true;

			//hide the progress bar
			if(parent.hideLoading)
			{
				parent.hideLoading();
			}

			//Setting the context-sensitive help for port mapping tab in the System page for c-Class servers/switches.
            MxPortalWorkspaceSetHelpTopicEx("bladeime","bladeIME_portMappingTab");

			var dimentions = getDimentions("PORTMAPPING_PAGE");
			var h = eval(dimentions[1]);
			var div_id_wrkSpace = parent.parent.document.getElementById("ID_WORKSPACE");

			//get the height of the timetd 
			var timetdId = document.getElementById("timetd");
			if(timetdId != null) 
			{
				var timeTdHt = timetdId.offsetHeight;
				h = eval(h + "+ " + timeTdHt);
			}

			//get the height of the tool text 
			var toolTextId = document.getElementById("toolText");
			if(toolTextId != null) 
			{
				var toolTextHt = toolTextId.offsetHeight;
				h = eval(h + "+ " + toolTextHt);				
			}


			if(div_id_wrkSpace != null)
			{
				div_id_wrkSpace.style.height = h;
				div_id_wrkSpace.style.width  = eval(dimentions[0]);
			}
        }

		function getDimentions(id)
		{
			//Setting the context-sensitive help for Picture View in HP Blade Sytemes page.
			bpvDimentions = new Array();
			var h = document.getElementById(id).offsetHeight;
			var w = document.getElementById(id).offsetWidth;

			if (h == 0) {
				h = window.outerHeight;
			}

			if (w == 0)
			{
				w = window.outerWidth;
			}
			
			bpvDimentions[0] = w;
			bpvDimentions[1] = h;
			return bpvDimentions;
		}

        </script>
    </head>
    <body style="margin: 0px; padding: 0px;">
	<%
		//iframe to contain the refreshed data
		if(request.getParameter("isAutoRefresh") == null)
		{
	%>
			<iframe id="refreshFrame" SRC="<%=MxHtmlUtil.getBlankSrc(request)%>" style="display:none"></iframe> 
	<%
		}
	%>
	<div ID="toolText" style="position:absolute;top:0;z-index:999;left:0;visibility:hidden;border:solid #336699 1px; background-color:#FFFFCC;padding:2 2 2 2;white-space: nowrap"></div> 
    <div id="PORTMAPPING_PAGE">
			<table align="right"  border="0" cellpadding="0" cellspacing="0">  
				<tr><td><div id="timetd">&nbsp;</div></td></tr> 
			</table>		
			<br><br>
		<%if(isHttpEnabledOnGlobalScale.equalsIgnoreCase("checked"))
		{
		%>
			<table border="0" cellpadding="0" cellspacing="0" width="90%" id="innerPortMapTable">
			<tr>
			  <td>
			  <%			
					portMappingSkinBean.initializeNode(node,out,loginBean);
					//pass true since it should query the actual device
					portMappingSkinBean.applyPortMappingSkin(true);
				%>		 			    
			  </td>
			</tr>
		  
		  <%
			if(node.getDeviceType().equalsIgnoreCase(DeviceTypesIfc.DEVICE_PRODUCTTYPE_SWITCH_STR))
			{
				MonteroResourceManager manager=MonteroResourceManager.getInstance();
				String url = portMappingSkinBean.getSSOLinkToOA();
				if(url!=null)
				{
		  %>
				  <tr align='left'> <td><br>
					<%=manager.getString("PortMap.Switch",loginBean.getLocale()) %>
					<b><a href=<%=url%> TARGET="RESOURCE WINDOW" ><%=manager.getString("PortMap.OALink",loginBean.getLocale())%></a></b>
					</td>
				  </tr>
		  <%
		  		}
			}
		  %>
		  </table>

	<%
	}
	else //http is not enabled
	{
		String errorMsg  = MonteroResourceManager.getInstance().getString("error.NO_PORT_MAPPING_DATA", loginBean.getLocale());
		String causeMsg  = MonteroResourceManager.getInstance().getString("cause.HTTP_DISABLED", loginBean.getLocale());
		String actionMsg = MonteroResourceManager.getInstance().getString("action.ENABLE_HTTP_STEPS", loginBean.getLocale());
	%>
		<p class="error-instruction">
			<%=errorMsg%><br><br>
			<%=causeMsg%><br><br>
			<%=actionMsg%><br>
		</p>
	<%
	}
	%>
			 

	</div>
	<script>
		var updateTime = "<%=dateAndTime.getCurrentDateTimeStringSIMFormatWithSeconds()%>";
		document.getElementById("timetd").innerHTML = 
			'<%=MonteroResourceManager.getInstance().getString("Updated",loginBean.getLocale())%> ' + updateTime;
		var refreshFrame = document.getElementById("refreshFrame");
		var isLoaded = false;
		<%
			String linkUrl = 
			MxOptions.URL_BASE + "/bladeime/DevicePortMappingData.jsp?index=" + tabIndex + "&devId=" + devKey + "&target=" + node.getGUID();
		%>		
		var linkUrl = "<%=linkUrl%>" + "&isRefreshRequired=true&updateLinkSelected=true&isAutoRefresh=true";	
		
		myOnLoad();

		//initiate the refresh timer
		if(refreshFrame != null)
		{
			// don't auto refresh if http is disabled
			if("<%=isHttpEnabledOnGlobalScale%>" == "checked")
			{
				setTimeout("autoRefreshMontero()", MONTERO_REFRESH_INTERVAL);
			}
		}
		

		//refresh the display area
		function resetDisplayOnAutoRefresh()
		{			
			document.getElementById("PORTMAPPING_PAGE").innerHTML = 		refreshFrame.contentWindow.document.getElementById("PORTMAPPING_PAGE").innerHTML;	
			
			document.getElementById("toolText").innerHTML =	refreshFrame.contentWindow.document.getElementById("toolText").innerHTML;

			updateRefreshTimeStamp();
			setTimeout("autoRefreshMontero()", MONTERO_REFRESH_INTERVAL);
		}	
	</script>
</body>
</html>
