
PRODNAME="HP BladeSystem Integrated Manager 2.4"
HPSIMNAME="HP Systems Insight Manager 5.1"

####################################
#
# file and directory locations
#
####################################
SIM_BIN="/opt/mx/bin"
SIM_LIB="/opt/mx/lib"
SIM="/opt/mx"
SIM2="/var/opt/mx"
SIM3="/etc/opt/mx"
SIM_TOOLS="/var/opt/mx/tools"
SIM_PORTAL="/opt/hpwebadmin/webapps/ROOT/mxportal"
SIM_QUERY="/etc/opt/mx/config/rackable"
SIMLOGS="/var/opt/mx/logs/"
MXVERSION="${SIM_BIN}/mxversion"
MXTOOL="${SIM_BIN}/mxtool -l f -t BogusToolName"
MXSTOP="${SIM_BIN}/mxstop"
MXSTART="${SIM_BIN}/mxstart"
SLEEP=/bin/sleep
EXPR=expr

####################################
#
# version strings for matching
#
####################################
VERSION_51="51050100"


#############################################################
#
# Function: GetSIMStatus()
#
# Checks to see if HP SIM is running
#
# Returns 0 if HP SIM is running and 1 if it is not
#
#############################################################

GetSIMStatus()
{
    $MXTOOL > /dev/null 2>&1

    # if return value of 200, we know that HP SIM is not started
    if [ $? = 200 ]
    then
        return 1
    fi

    return 0
}

#############################################################
#
# Main: start of the main script execution
#
#############################################################

echo
echo
echo  "==============================================="
echo  HP BladeSystem Integrated Manager 2.4
echo 
echo  This product is an enhanced management plug-in for
echo  ${HPSIMNAME}.  The installation
echo  will stop and restart ${HPSIMNAME}
echo  if it is currently running.
echo 
echo  Enter "'y'" to continue this installation.
echo  "===================================================="

read x
if [ "$x" != 'y' -a "$x" != 'Y' ]; then
	echo "Installation was not chosen.  No changes being made."
	exit 50
fi

echo 

# Check to see if the user is the root user
user=`whoami`
if [ "$user" != "root" ] 
then
    echo "This patch must be run by the root user.  No changes being made."
    exit 100
fi

# Check if the "mxversion" utility can be found
if [ ! -e "${MXVERSION}" ]
then
    echo "${HPSIMNAME} not found.  No changes being made."
    exit 200
fi

# execute "mxversion" and store the result
simVersion=`$MXVERSION`

echo $cmsOS

# if "mxversion" failed to execute properly then exit
if [ $? -ne 0 ]
then
    echo "Failed to execute $MXVERSION .  No changes being made."
    exit 300
fi

# extract the version string from the "mxversion" output
cmsOS=$(uname -s)
verString="$(echo $simVersion | tr -d '.[:alpha:][:blank:][:punct:]'| cut -c1-8)"
echo $verString

# Check to see if we can recognize the version of SIM
if [ "$verString" != "$VERSION_51" ]
then 
    echo "${HPSIMNAME} not found.  No changes being made."
    exit 500
fi

echo
echo "${HPSIMNAME} found."

# Check to see if HP SIM was started
wasSIMStarted="FALSE"
GetSIMStatus

# if HP SIM was running then stop it
if [ $? = 0 ]
then
    # Stop the HP SIM services
    echo
    echo "Stopping the ${HPSIMNAME} daemons..."
    $MXSTOP  
    # Remember that HP SIM was running so we can restart it at the end
    wasSIMStarted="TRUE"
fi

# Delay 30 seconds
x=0
while [ $x -lt 10 ]; do
	echo -n .
	$SLEEP 3
	x=`$EXPR $x + 1`
done
echo 

# install new files
x=`pwd`
cd ${SIM_LIB}

if [ ! -e ${SIM}/bsimbackup/lib/bladeime.bck ]
then
   	mkdir -p ${SIM}/bsimbackup/lib
	# Backup the current bladeSystem files
        echo "Starting Backup up of existing files..."
	#echo "BACKUP bladeime.jar"
	cp ${SIM_LIB}/bladeime.jar ${SIM}/bsimbackup/lib/bladeime.bck            
	#echo "BackUP Tools"
	cp -R ${SIM2}/tools ${SIM}/bsimbackup/
	#echo "BackUP Actions"
        cp -R ${SIM2}/actions ${SIM}/bsimbackup/
	#echo "BackUP config"
        cp -R ${SIM3}/config ${SIM}/bsimbackup/
	
	#echo "BackUP /opt/hpwebadmin/webapps/ROOT/mxportal/bladeime"
	mkdir -p ${SIM}/bsimbackup/webapps/ROOT/mxportal

	cp -R ${SIM_PORTAL}/bladeime ${SIM}/bsimbackup/webapps/ROOT/mxportal/
	
	#echo "BackUP /hpwebadmin/webapps/ROOT/mxportal/DevicePage"
        cp -R ${SIM_PORTAL}/DevicePage ${SIM}/bsimbackup/webapps/ROOT/mxportal/	
	
	#echo "BackUP /hpwebadmin/webapps/ROOT/mxportal/home"
        cp -R ${SIM_PORTAL}/home ${SIM}/bsimbackup/webapps/ROOT/mxportal/

	#echo "BackUP /hpwebadmin/webapps/ROOT/data"
        cp -R /opt/hpwebadmin/webapps/ROOT/data ${SIM}/bsimbackup/webapps/ROOT/
	
	#echo "BackUP Help Documents 
	cp -R /opt/hpwebadmin/webapps/mxhelp/bladeime/* ${SIM}/bsimbackup/
	
	echo "BackUP Complete..."

        # Copy New BladeSystem Manager Files
        echo "Starting Copy of new files..."
        echo "Copying bladeime.jar..."
        cp "$x"/lib/bladeime.jar ${SIM_LIB}
	
	echo "Copying Tools..."
        cp -R "$x"/tools ${SIM2}/
        echo "Copying Actions..."
        cp -R "$x"/actions ${SIM2}/
        echo "Copying config..."
        cp -R "$x"/config ${SIM3}/

        echo "Copying WebApps..."
        cp -R "$x"/webapps /opt/hpwebadmin/

	echo "Copying HOTFIX..."
	cp -R "$x"/HOTFIX51_003.jar ${SIM}/patch
	
	echo "Copying Help docs..."
        cp -R "$x"/en /opt/hpwebadmin/webapps/mxhelp/bladeime/
	cp -R "$x"/ja /opt/hpwebadmin/webapps/mxhelp/bladeime/
	
	echo "deleting the compiled JSP pages so that they can be rebuilt"
	rm -rf /opt/mx/jboss/server/hpsim/work/jboss.web/localhost/_/org/apache/jsp/mxportal/bladeime/*

else	
	# Copy New BladeSystem Manager Files
        echo "Starting Copy of new files..."
        echo "Copying bladeime.jar..."
        cp "$x"/lib/bladeime.jar ${SIM_LIB}

        echo "Copying Tools..."
        cp -R "$x"/tools ${SIM2}/
        echo "Copying Actions..."
        cp -R "$x"/actions ${SIM2}/
        echo "Copying config..."
        cp -R "$x"/config ${SIM3}/

        echo "Copying WebApps..."
        cp -R "$x"/webapps /opt/hpwebadmin/

        echo "Copying HOTFIX..."
        cp -R "$x"/HOTFIX51_003.jar ${SIM}/patch

	echo "Copying Help docs..."
        cp -R "$x"/en /opt/hpwebadmin/webapps/mxhelp/bladeime/
        cp -R "$x"/ja /opt/hpwebadmin/webapps/mxhelp/bladeime/
        
	#echo "deleting the compiled JSP pages so that they can be rebuilt"
        rm -rf /opt/mx/jboss/server/hpsim/work/jboss.web/localhost/_/org/apache/jsp/mxportal/bladeime/*	
fi

	echo "Copying files complete..." 
	echo "Restarting ${HPSIMNAME} daemons...."
	echo "This would take couple of minutes...."
	$MXSTART
	sleep 120
	cd ${SIM_TOOLS}
	if [ -e bladeimeVersion.xml ] 
		then
		#cp bladeimeVersion.xml ${SIM}/bsimbackup/tools/bladeimeVersion.bck
	 	#cp "$x"/tools/bladeimeVersion.xml . 
	 	#echo "HP BLADESYSTEM INTERAGTED MANAGER VERSION FILE COPIED"
	   
	  	if [ -e ${SIM_BIN}/mxtool ] 
	  		then
	   	        ${SIM_BIN}/mxtool -r -f ${SIM_TOOLS}/bladeimeVersion.xml
		        ${SIM_BIN}/mxtool -a -f ${SIM_TOOLS}/bladeimeVersion.xml

			echo "Updating all links and tree View..."
			${SIM_BIN}/mxtoolbox -a -f ${SIM_TOOLS}/iLOToolBox.xml
			${SIM_BIN}/mxtool -a -f ${SIM_TOOLS}/telnetTool.xml
			${SIM_BIN}/mxtool -a -f ${SIM_TOOLS}/OAConfig.xml
			${SIM_BIN}/mxtool -a -f ${SIM_TOOLS}/iLO2Links.xml
			
			${SIM_BIN}/mxquery -a -f ${SIM_QUERY}/allRackableEnclosures.xml
			${SIM_BIN}/mxcollection -m mem -f ${SIM_QUERY}/modifyHPBS.xml
	   	        echo "HP BLADESYSTEM INTEGRATED MANAGER 2.4 UPDATE COMPLETE. YOU CAN DELETE THE EXTRACTED FOLDER." 
	  	else
		    	echo "MXTOOL DOES NOT EXIST"	
		    	echo "HP BLADESYSTEM INTEGRATED MANAGER 2.4 UPDATE FAILED."
		exit			
		fi	
				  
	else
		echo "HP BLADESYSTEM INTEGRATED MANAGER 2.4 UPDATE FAILED"
        exit
	fi		

