/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.utils;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class MonteroVMUtils {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MonteroVMUtils.class);
    Vector associatedHPVmGuestKeys = null;
    Vector associatedVmGuestKeys = null;
    String subTypeStrESX = "VMWARE_ESX_VMHost";
    String asscType1 = "HPVMGuestToHPVMHost";
    String asscType2 = "VMGuestToVMHost";

    public boolean isVmHost(MxNode node) {
        LOGGER.enter("MonteroVMUtils.isVmHost(MxNode)");
        boolean isVmHost = false;
        if (node != null && (node.getDeviceSubTypes().contains(NodeSubTypeMapper.HPVMHOST_SUBTYPE.toString()) || node.getDeviceSubTypes().contains(NodeSubTypeMapper.VMHOST_SUBTYPE.toString()))) {
            isVmHost = true;
        }
        LOGGER.exit("MonteroVMUtils.isVmHost - " + isVmHost);
        return isVmHost;
    }

    public boolean isVmESXHost(MxNode node) {
        LOGGER.enter("MonteroVMUtils.isVmESXHost()");
        if (node != null) {
            if (node.getDeviceSubTypes().contains(this.subTypeStrESX)) {
                LOGGER.fine("MonteroVMUtils.isVmESXHost - true");
                return true;
            }
            LOGGER.fine("fetch subtypes from the db");
            List lst = this.getSubTypesFromDb(node.getDeviceKey());
            if (lst.contains(this.subTypeStrESX)) {
                LOGGER.fine("MonteroVMUtils.isVmESXHost - true (fetched from DB)");
                return true;
            }
        }
        LOGGER.exit("MonteroVMUtils.isVmESXHost - false");
        return false;
    }

    public int getVMGuestCount(MxNode hostNode) {
        LOGGER.enter("MonteroVMUtils.getVMGuestCount()");
        int vmGuestCount = 0;
        try {
            NodeAssociationsManager myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            if (hostNode != null) {
                if (hostNode.getDeviceSubTypes().contains(NodeSubTypeMapper.HPVMHOST_SUBTYPE.toString())) {
                    this.associatedHPVmGuestKeys = myNodeRelationshipManager.getAssociatedDevicesUsingATNs(hostNode.getDeviceKey(), this.asscType1);
                    vmGuestCount = this.associatedHPVmGuestKeys.size();
                    LOGGER.fine("MonteroVMUtils.getVMGuestCount()- hpvmGuestCount  :" + vmGuestCount);
                }
                if (hostNode.getDeviceSubTypes().contains(NodeSubTypeMapper.VMHOST_SUBTYPE.toString())) {
                    this.associatedVmGuestKeys = myNodeRelationshipManager.getAssociatedDevicesUsingATNs(hostNode.getDeviceKey(), this.asscType2);
                    LOGGER.fine("MonteroVMUtils.getVMGuestCount()- vmGuestCount  :" + this.associatedVmGuestKeys.size());
                    LOGGER.fine("MonteroVMUtils.getVMGuestCount()- total vmGuestCount  :" + (vmGuestCount += this.associatedVmGuestKeys.size()));
                }
            }
        }
        catch (MxException e) {
            LOGGER.exception("Exception in MonteroVMUtils.getVMGuestCount()" + (Object)((Object)e));
        }
        LOGGER.exit("MonteroVMUtils.getVMGuestCount");
        return vmGuestCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getSubTypesFromDb(Integer devKey) {
        LOGGER.enter("MonteroVMUtils.getSubTypesFromDb " + devKey);
        ArrayList<String> lst = new ArrayList<String>();
        Connection myConnection = null;
        Statement myStatement = null;
        ResultSet myResultSet = null;
        try {
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("NodeRepositoryManager.loadAllNodesFromDb()");
            myStatement = myConnection.createStatement();
            myResultSet = myStatement.executeQuery("select subType2,subType3,subType4,subType5,subType6,subType7,subType8 from devices where deviceKey=" + devKey);
            if (myResultSet != null) {
                myResultSet.next();
                for (int i = 1; i <= 7; ++i) {
                    String subType = myResultSet.getString(i);
                    if (subType != null) {
                        subType = subType.trim();
                    }
                    LOGGER.fine("sub type at position " + i + " is " + subType + ".");
                    lst.add(subType);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.panic("Error retrieving subtypes from the db " + e.toString());
        }
        finally {
            try {
                if (myResultSet != null) {
                    myResultSet.close();
                }
                if (myStatement != null) {
                    myStatement.close();
                }
                if (myConnection != null) {
                    DatabaseManager.getDefaultDatabase().releaseConnection(myConnection);
                }
            }
            catch (SQLException e) {
                LOGGER.panic("Finally clause clean up failure" + e.toString());
            }
        }
        LOGGER.exit("MonteroVMUtils.getSubTypesFromDb " + devKey);
        return lst;
    }
}

