/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.tools;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.client.MxQueryClient;
import com.hp.mx.core.client.MxSessionClient;
import com.hp.mx.core.controllers.MxJobController;
import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.controllers.MxToolController;
import com.hp.mx.core.controllers.TaskController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.jobmanager.MxJob;
import com.hp.mx.core.jobmanager.MxJobManager;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.objectmodel.MxObjectID;
import com.hp.mx.core.objectmodel.MxObjectName;
import com.hp.mx.core.querymanager.TreeViewDeviceObject;
import com.hp.mx.core.taskmanager.CommandToolParameters;
import com.hp.mx.core.taskmanager.MxInvalidRunnableTaskException;
import com.hp.mx.core.taskmanager.MxRunnableTask;
import com.hp.mx.core.taskmanager.MxRunnableTaskFactory;
import com.hp.mx.core.taskmanager.TaskUserParameters;
import com.hp.mx.core.toolmanager.MxTool;
import com.hp.mx.core.toolmanager.MxToolName;
import com.hp.mx.core.toolmanager.MxUndefinedToolException;
import com.hp.mx.core.tools.discovery.DiscoverTheCMSLocalHost;
import com.hp.mx.dtf.MxDTFIfc;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.html.core.MxButtons;
import com.hp.mx.html.core.MxDefaultTag;
import com.hp.mx.html.core.MxTag;
import com.hp.mx.portal.list.MxSystemsListRenderer;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import com.hp.mx.utilities.rmi.MxRMIUtil;
import java.io.IOException;
import java.io.Writer;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.jsp.JspWriter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class ModifyRackName {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(ModifyRackName.class);
    private MxNode iloNode = null;
    private String myRackName = "";
    private String myPassword = "";
    private String myUsername = "";
    private String myRackdevicekey = "";
    private boolean isSshJobCreated = false;
    private boolean isRackJobCreated = false;
    private String newRackJobId = null;
    private String newSshJobId = null;
    private MxButtons m_buttons = new MxButtons();
    private MxRunnableTask runSshTool = null;
    private MxRunnableTask runTool = null;
    private MxJob sshJob = null;
    private MxJob rackJob = null;
    private boolean isRacknameUpdated = false;
    private String rackGuid = "";
    protected MxSessionClient mySession = null;
    protected MxLoginBean myLoginBean = null;

    public void initialize(MxLoginBean loginBean) {
        if (this.myLoginBean == null) {
            this.myLoginBean = loginBean;
        }
    }

    public boolean isILOPresent(int rackDeviceKey) {
        LOGGER.enter("ModifyRackName.isILOPresent(" + rackDeviceKey + ")");
        boolean iloPresent = false;
        NodeAssociationsManager nodeAssociationsManager = null;
        Vector enclosureDeviceKeyList = null;
        MxNode enclosureMxNode = null;
        MxNode iloMxNode = null;
        if (rackDeviceKey != -1) {
            try {
                this.rackGuid = MxNodeController.getDefaultController().getNodeByKey(rackDeviceKey).getGUID().toString();
                nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
                enclosureDeviceKeyList = nodeAssociationsManager.getAssociatedDevicesUsingATNs(rackDeviceKey, "EnclosureToRack");
            }
            catch (Exception e) {
                LOGGER.fine("Exception in ModifyRackName.isILOPresent : " + e);
            }
            if (enclosureDeviceKeyList != null) {
                for (int i = 0; i < enclosureDeviceKeyList.size(); ++i) {
                    int encDeviceKey = (Integer)enclosureDeviceKeyList.get(i);
                    LOGGER.fine("ModifyRackName.isILOPresent : ENC DEVICEKEY " + encDeviceKey);
                    try {
                        enclosureMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(encDeviceKey);
                    }
                    catch (MxException me) {
                        LOGGER.exception("MxException in ModifyRackName.isILOPresent : " + (Object)((Object)me));
                        continue;
                    }
                    if (!enclosureMxNode.getDeviceSubTypes().contains("ServerEnc")) continue;
                    LOGGER.fine("ModifyRackName.isILOPresent : SERVENC DEVICEKEY " + encDeviceKey);
                    Vector bladeDeviceKeyList = nodeAssociationsManager.getAssociatedDevicesUsingATNs(encDeviceKey, "ServerToEnclosure");
                    if (bladeDeviceKeyList == null) continue;
                    for (int j = 0; j < bladeDeviceKeyList.size(); ++j) {
                        int bladeDeviceKey = (Integer)bladeDeviceKeyList.get(j);
                        LOGGER.fine("ModifyRackName.isILOPresent : BLADE DEVICEKEY " + bladeDeviceKey);
                        Vector iloDeviceKeyList = nodeAssociationsManager.getAssociatedDevicesUsingATNs(bladeDeviceKey, "MgmtProcToServer_Ilo");
                        for (int k = 0; k < iloDeviceKeyList.size(); ++k) {
                            int iloDeviceKey = (Integer)iloDeviceKeyList.get(k);
                            LOGGER.fine("ModifyRackName.isILOPresent : ILO DEVICEKEY " + iloDeviceKey);
                            float maxFwri = -1.0f;
                            try {
                                iloMxNode = MxNodeController.getDefaultController().getNodeByKey(iloDeviceKey);
                                if (iloMxNode == null || !iloMxNode.getModel().toLowerCase().equals("integrated lights-out (ilo)")) continue;
                                float fwri = Float.parseFloat(iloMxNode.getClientAttribute("compaq.device.firmwareRevision"));
                                if (fwri > maxFwri) {
                                    maxFwri = fwri;
                                    LOGGER.fine("ModifyRackName.isILOPresent : MaxFWRI " + maxFwri);
                                    this.iloNode = iloMxNode;
                                    LOGGER.fine("ModifyRackName.isILOPresent : MaxFWILO" + this.iloNode.getNameString());
                                    iloPresent = true;
                                }
                                LOGGER.fine("ModifyRackName.isILOPresent :" + iloPresent);
                                continue;
                            }
                            catch (Exception e) {
                                LOGGER.exception("Exception in ModifyRackName.isILOPresent : " + e);
                            }
                        }
                    }
                }
            }
        }
        return iloPresent;
    }

    public String getIloNodeName() {
        LOGGER.enter("ModifyRackName.getIloNodeName()");
        String iloName = "No ILO Discovered";
        if (this.iloNode != null) {
            if (this.iloNode.getHostName().trim() == null || this.iloNode.getHostName().trim().equals("null") || this.iloNode.getHostName().trim().equals("")) {
                iloName = this.iloNode.getWorkingAddress();
                LOGGER.fine("ModifyRackName.getIloNodeName : iloIp " + iloName);
            } else {
                iloName = this.iloNode.getHostName();
                LOGGER.fine("ModifyRackName.getIloNodeName : iloHostname " + iloName);
            }
        }
        LOGGER.exit("ModifyRackName.getIloNodeName : iloName " + iloName);
        return iloName;
    }

    public boolean isRackNamePresent(MxLoginBean loginBean, String newRackName) {
        LOGGER.enter("ModifyRackName.isRackNamePresent()");
        boolean isRackNameExist = false;
        MxQueryClient qClient = loginBean.getQueryClient();
        DefaultMutableTreeNode queryTreeRoot = null;
        MxNodeClient nodeClient = loginBean.getNodeClient();
        try {
            int m_allDeviceQueryId = qClient.getQuery("ALL RACKS").getQueryId();
            queryTreeRoot = qClient.runQueryWithTreeResults(m_allDeviceQueryId);
            Enumeration<TreeNode> enumeration = queryTreeRoot.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode childTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                TreeViewDeviceObject o = (TreeViewDeviceObject)childTreeNode.getUserObject();
                MxObjectID obId = o.getObjectID();
                int devKey = obId.getKey();
                LOGGER.fine("Device found with deviceKey :" + devKey);
                MxNode childNode = nodeClient.getNodeByKey(devKey, false);
                LOGGER.fine("ModifyRackName.isRackNamePresent() :RackName " + childNode.getNameString());
                if (newRackName.equals(childNode.getNameString())) {
                    isRackNameExist = true;
                    this.myRackName = childNode.getAgentUUID() != "" & childNode.getAgentUUID().length() > 0 ? this.myRackName.concat("_" + childNode.getAgentUUID()) : this.myRackName.concat("_" + childNode.getSerialNumber());
                }
                LOGGER.fine("ModifyRackName.isRackNamePresent() :NewRackName " + this.myRackName);
            }
        }
        catch (Exception e) {
            LOGGER.fine("Exception in ModifyRackName.isRackNamePresent: " + e);
        }
        return isRackNameExist;
    }

    private void runRackChangeTool() throws MxException {
        MxTransaction myTransaction = null;
        MxJobController myJobController = null;
        LOGGER.enter("ModifyRackName.runRackChangeTool()");
        MxToolName toolName = new MxToolName("Change RackName");
        MxTool tool = MxToolController.getDefaultController().getTool(new MxObjectID((MxObjectName)toolName));
        try {
            this.runTool = MxRunnableTaskFactory.getInstance((MxTool)tool);
        }
        catch (MxUndefinedToolException e) {
            LOGGER.fine("MxUndefinedToolException in ModifyRackName.runRackChangeTool : " + (Object)((Object)e));
            MxInvalidRunnableTaskException ne = new MxInvalidRunnableTaskException(3);
            throw ne;
        }
        this.runTool.addRawTarget(this.iloNode.getObjectID());
        CommandToolParameters toolParams = new CommandToolParameters();
        toolParams.addArgumentValue(this.myRackName);
        this.runTool.setToolParameters((TaskUserParameters)toolParams);
        try {
            myTransaction = this.myLoginBean.getMxSessionManager().getSession().getNextTransaction();
            this.runTool.setTransaction(myTransaction);
            this.runTool.setCreatedBy(this.myLoginBean.getUser());
            LOGGER.fine("ModifyRackName.runRackChangeTool : Toolname " + this.runTool.getName());
            this.newRackJobId = TaskController.getDefaultController().addRunNowTask(myTransaction, this.runTool);
        }
        catch (Throwable e) {
            LOGGER.fine("Exception in ModifyRackName.runRackChangeTool : " + e);
        }
        LOGGER.fine("ModifyRackName.runRackChangeTool : newRackJobId " + this.newRackJobId);
        if (this.newRackJobId != null && !this.newRackJobId.equals("")) {
            this.isRackJobCreated = true;
            try {
                myJobController = MxJobController.getDefaultController();
                boolean myJobDone = false;
                do {
                    myJobDone = myJobController.isJobDone(myTransaction, this.newRackJobId);
                    this.rackJob = MxJobManager.getJob((String)this.newRackJobId);
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.fine("InterruptedException in ModifyRackName.runRackChangeTool : " + ex);
                    }
                } while (!myJobDone);
            }
            catch (Exception e) {
                LOGGER.fine("Exception in ModifyRackName.runRackChangeTool : " + e);
            }
        }
    }

    private void runDeploySshTool() throws MxException {
        MxTransaction myTransaction = null;
        MxJobController myJobController = null;
        LOGGER.enter("ModifyRackName.runDeploySshTool()");
        if (this.iloNode != null) {
            MxToolName toolName = new MxToolName("Deploy SSH Public Key To ILO");
            MxTool tool = MxToolController.getDefaultController().getTool(new MxObjectID((MxObjectName)toolName));
            try {
                this.runSshTool = MxRunnableTaskFactory.getInstance((MxTool)tool);
            }
            catch (MxUndefinedToolException e) {
                LOGGER.fine("MxUndefinedToolException in ModifyRackName.runDeploySshTool : " + (Object)((Object)e));
                MxInvalidRunnableTaskException ne = new MxInvalidRunnableTaskException(3);
                throw ne;
            }
            MxNode cms = DiscoverTheCMSLocalHost.getTheXeDevice();
            this.runSshTool.addRawTarget(cms.getObjectID());
            LOGGER.fine("ModifyRackName.runDeploySshTool : CMS OS NAME " + cms.getOSName());
            CommandToolParameters toolParams = new CommandToolParameters();
            LOGGER.fine("ModifyRackName.runDeploySshTool : ILO NODE NAME " + this.getIloNodeName());
            toolParams.addArgumentValue(this.getIloNodeName());
            LOGGER.fine("ModifyRackName.runDeploySshTool : USERNAME " + this.myUsername);
            toolParams.addArgumentValue(this.myUsername);
            toolParams.addArgumentValue(this.getencodePwd());
            this.runSshTool.setToolParameters((TaskUserParameters)toolParams);
            try {
                myTransaction = this.myLoginBean.getMxSessionManager().getSession().getNextTransaction();
                this.runSshTool.setTransaction(myTransaction);
                this.runSshTool.setCreatedBy(this.myLoginBean.getUser());
                this.newSshJobId = TaskController.getDefaultController().addRunNowTask(myTransaction, this.runSshTool);
                LOGGER.fine("ModifyRackName.runDeploySshTool : newSshJodId " + this.newSshJobId);
                if (this.newSshJobId != null && !this.newSshJobId.equals("")) {
                    this.isSshJobCreated = true;
                    LOGGER.fine("ModifyRackName.runDeploySshTool : isSshJobCreated " + this.isSshJobCreated);
                    try {
                        myJobController = MxJobController.getDefaultController();
                        boolean mySshJobDone = false;
                        do {
                            mySshJobDone = myJobController.isJobDone(myTransaction, this.newSshJobId);
                            this.sshJob = MxJobManager.getJob((String)this.newSshJobId);
                            try {
                                Thread.sleep(1500L);
                            }
                            catch (InterruptedException ex) {
                                LOGGER.fine("InterruptedException in ModifyRackName.runDeploySshTool : " + ex);
                            }
                        } while (!mySshJobDone);
                    }
                    catch (Exception e) {
                        LOGGER.fine("Exception in ModifyRackName.runRackChangeTool : " + e);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.fine("Exception in ModifyRackName.runDeploySshTool : " + e);
            }
        }
    }

    public void runAllRackTools() {
        LOGGER.enter("ModifyRackName.runAllRackTools()");
        try {
            this.runDeploySshTool();
            LOGGER.fine("ModifyRackName.runAllRackTools : Executed SSH Tool");
            if (this.isSshJobCreated) {
                this.runRackChangeTool();
                LOGGER.fine("ModifyRackName.runAllRackTools : Executed Rack Tool");
            }
        }
        catch (MxException e) {
            LOGGER.fine("MxException in ModifyRackName.runAllRackTools : " + (Object)((Object)e));
        }
        if (this.getRackJobState().toLowerCase().equals("complete")) {
            LOGGER.fine("ModifyRackName.runAllRackTools : JobState " + this.getRackJobState());
            this.updateRackNode();
            this.isRacknameUpdated = true;
        }
    }

    public boolean isRackNameChanged() {
        LOGGER.enter("ModifyRackName.isRackNameChanged()");
        return this.isRacknameUpdated;
    }

    public void setRackname(String rackname) {
        LOGGER.enter("ModifyRackName.setRackname(" + rackname + ")");
        this.myRackName = rackname;
    }

    public String getRackname() {
        LOGGER.enter("ModifyRackName.getRackname()");
        return this.myRackName;
    }

    public void setUsername(String username) {
        LOGGER.enter("ModifyRackName.setUsername(" + username + ")");
        this.myUsername = username;
    }

    public String getUsername() {
        LOGGER.enter("ModifyRackName.getUsername()");
        return this.myUsername;
    }

    public void setPassword(String password) {
        LOGGER.enter("ModifyRackName.setPassword(" + password + ")");
        this.myPassword = password;
    }

    public String getPassword() {
        LOGGER.enter("ModifyRackName.getPassword()");
        return this.myPassword;
    }

    public void setRackdevicekey(String rdevicekey) {
        LOGGER.enter("ModifyRackName.setRackdevicekey(" + rdevicekey + ")");
        this.myRackdevicekey = rdevicekey;
    }

    public String getRackdevicekey() {
        LOGGER.enter("ModifyRackName.getRackdevicekey()");
        return this.myRackdevicekey;
    }

    private MxDTFIfc getSshClientIfc() {
        LOGGER.enter("ModifyRackName.getSshClientIfc()");
        MxDTFIfc passwordServer = null;
        try {
            passwordServer = (MxDTFIfc)MxRMIUtil.getIfc((String)"MX_DTFServer", null, (int)20);
        }
        catch (NotBoundException e) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return passwordServer;
    }

    private String getencodePwd() {
        LOGGER.enter("ModifyRackName.getencodePwd()");
        MxDTFIfc mxpw = this.getSshClientIfc();
        String encodedPswd = "";
        try {
            encodedPswd = mxpw.encodePW(this.myPassword);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return encodedPswd;
    }

    public boolean isDeploySSHKeyInfoValid() {
        LOGGER.enter("ModifyRackName.isDeploySSHKeyInfoValid()");
        boolean retval = false;
        if (!(this.getUsername() == null || this.getencodePwd() == null || this.getRackname() == null || this.getUsername().equals("") || this.getencodePwd().equals("") || this.getRackname().equals(""))) {
            retval = true;
        }
        return retval;
    }

    public void updateRackNode() {
        LOGGER.enter("ModifyRackName.updateRackNode()");
        try {
            MxNode rackNode = MxNodeController.getDefaultController().getReadOnlyNodeObject(Integer.parseInt(this.getRackdevicekey()));
            rackNode.setDeviceName(this.getRackname().toString());
            MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), rackNode, false);
        }
        catch (Exception e) {
            LOGGER.fine("Exception in ModifyRackName.updateRackNode : " + e);
        }
    }

    public String getSshJobState() {
        LOGGER.enter("ModifyRackName.getSshJobState()");
        return this.sshJob.getStateStr();
    }

    public String getRackJobState() {
        LOGGER.enter("ModifyRackName.getRackJobState()");
        return this.rackJob.getStateStr();
    }

    public boolean isRackJobCreated() {
        LOGGER.enter("ModifyRackName.isRackJobCreated()");
        return this.isRackJobCreated;
    }

    public boolean isSshJobCreated() {
        LOGGER.enter("ModifyRackName.isSshJobCreated()");
        return this.isSshJobCreated;
    }

    public String getSshJobID() {
        LOGGER.enter("ModifyRackName.getSshJobID()");
        return this.sshJob.getJobID();
    }

    public String getRackJobID() {
        LOGGER.enter("ModifyRackName.getRackJobID()");
        return this.rackJob.getJobID();
    }

    public String getSshToolName() {
        LOGGER.enter("ModifyRackName.getSshToolName()");
        return this.sshJob.getToolName();
    }

    public String getRackToolName() {
        LOGGER.enter("ModifyRackName.getRackToolName()");
        return this.rackJob.getToolName();
    }

    public String getSshToolExecuteAsUser() {
        LOGGER.enter("ModifyRackName.getSshToolExecuteAsUser()");
        return this.sshJob.getExecuteAsUser();
    }

    public String getRackToolExecuteAsUser() {
        LOGGER.enter("ModifyRackName.getRackToolExecuteAsUser()");
        return this.rackJob.getExecuteAsUser();
    }

    public void createButtons(MxSystemsListRenderer listRenderer, String submit, String clear, String picture) {
        LOGGER.enter("ModifyRackName.createButtons(" + listRenderer + ")");
        this.m_buttons.setPadding(new int[]{6, 6, 6, 6});
        this.m_buttons.setId("ID_BOTTOM_BUTTON_ROW");
        this.addMxTag("ID_DELETE_BUTTON", submit, "submitButtonClicked()", "true");
        this.addMxTag("ID_CLEAR_BUTTON", clear, "clearButtonClicked()", "true");
        this.addMxTag("ID_PRINT_BUTTON", picture, "pictureButtonClicked()", "false");
    }

    public void createCloseButton(MxSystemsListRenderer listRenderer, String picture) {
        LOGGER.enter("ModifyRackName.createCloseButton(" + listRenderer + "," + picture + ")");
        this.m_buttons.setPadding(new int[]{6, 6, 6, 6});
        this.m_buttons.setId("ID_BOTTOM_BUTTON_ROW");
        this.addMxTag("ID_DELETE_BUTTON", picture, "pictureButtonClicked()", "false");
    }

    public String getRackPictureURL() {
        String url = "/mxportal/drilldown/MxDrillDown.jsp?deviceGUID=" + this.rackGuid + "&drillDownType=DrillDownType-DeviceName&globalselection=true";
        return url;
    }

    public void addMxTag(String id, String label, String URL2, String disabled) {
        LOGGER.enter("ModifyRackName.addMxTag(" + id + label + URL2 + disabled + ")");
        MxDefaultTag btnTag = new MxDefaultTag(id, label, URL2);
        btnTag.setAttr("disabled", (Object)disabled);
        this.m_buttons.addMxTag((MxTag)btnTag);
    }

    public void dumpButtons(JspWriter out) throws IOException {
        LOGGER.enter("ModifyRackName.dumpButtons()");
        this.m_buttons.dumpButtons((Writer)out);
        this.m_buttons.clearMxTags();
    }
}

