/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.skin;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OAHelper;
import com.hp.mx.core.tools.datacollection.http.oa.OLDevice;
import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.portMapping.DevicePortMapping;
import com.hp.mx.portal.skin.SkinParser;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import javax.servlet.jsp.JspWriter;

public class PortMappingSkin {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(PortMappingSkin.class);
    MxNode m_node = null;
    JspWriter m_out = null;
    MxLoginBean m_loginBean;
    String m_portMapXml = null;

    public void initializeNode(MxNode node, JspWriter out, MxLoginBean loginBean) {
        this.m_node = node;
        LOGGER.fine("Node initialized in the PortMappingSkin is:" + this.m_node);
        this.m_out = out;
        this.m_loginBean = loginBean;
    }

    public void applyPortMappingSkin(boolean isExpired) {
        LOGGER.enter("PortMapping.applyPortMappingSkin(isExpired " + isExpired);
        DevicePortMapping devicePortMapping = new DevicePortMapping(this.m_loginBean, this.m_node);
        String PORTMAP2 = "PortMap";
        int enclDeviceKey = -1;
        if (this.m_node.getDeviceType().equalsIgnoreCase("Server")) {
            try {
                if (isExpired) {
                    enclDeviceKey = NodeAssociationsManager.getDefaultManager().getAssociatedDeviceKey(this.m_node.getDeviceKey(), "ServerToEnclosure");
                    LOGGER.fine("the Page is expired.So Update the Port Mapping information from Underdog");
                    OLDevice olDevice = this.getLatestPortMappingInfo(enclDeviceKey);
                    this.m_portMapXml = devicePortMapping.renderXMLForBlade(olDevice);
                }
            }
            catch (NodeAssociationsPersistenceException e) {
                LOGGER.fine("NodeAssociationsPersistenceException in PortMappingSkin.applyPortMappingSkin" + (Object)((Object)e));
            }
            LOGGER.fine("The device type:Server");
            this.applyXSL("ServerPortMap");
        } else if (this.m_node.getDeviceType().equalsIgnoreCase("Switch")) {
            try {
                if (isExpired) {
                    enclDeviceKey = NodeAssociationsManager.getDefaultManager().getAssociatedDeviceKey(this.m_node.getDeviceKey(), "SwitchToEnclosure");
                    LOGGER.fine("The Page is expired.So Update the Port Mapping information from Underdog");
                    OLDevice olDevice = this.getLatestPortMappingInfo(enclDeviceKey);
                    this.m_portMapXml = devicePortMapping.renderXMLForSwitch(olDevice);
                }
            }
            catch (NodeAssociationsPersistenceException e) {
                LOGGER.fine("NodeAssociationsPersistenceException in PortMappingSkin.applyPortMappingSkin" + (Object)((Object)e));
            }
            LOGGER.fine("The device type:Switch");
            this.applyXSL("SwitchPortMap");
        }
        LOGGER.exit("PortMapping.applyPortMappingSkin(isExpired " + isExpired);
    }

    private void applyXSL(String nameOfXSL) {
        try {
            SkinParser skinParser = new SkinParser();
            skinParser.configure(nameOfXSL);
            if (this.m_portMapXml != null) {
                skinParser.parseXML(this.m_portMapXml, this.m_out);
            } else {
                LOGGER.fine("The XML For Port Mapping is null");
            }
        }
        catch (BladeSystemException e) {
            e.printStackTrace();
        }
    }

    public String getSSOLinkToOA() {
        LOGGER.enter("PortMappingSkin.getSSOLinkToOA");
        try {
            NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.m_node.getDeviceKey());
            MxNode enclNode = nodeAssociations.getParent();
            String ssoURL = "/mxportal/bladeime/bpv/EnclosureManagerProxy.jsp?enclSerialNum=" + enclNode.getSerialNumber() + "&deviceType=OA";
            LOGGER.fine("ssoURL:" + ssoURL);
            LOGGER.exit("PortMappingSkin.getSSOLinkToOA");
            return ssoURL;
        }
        catch (NodeAssociationsPersistenceException e) {
            LOGGER.fine("NodeAssociationsPersistenceException in PortMappingSkin.getSSOLinkToOA" + (Object)((Object)e));
            LOGGER.exit("PortMappingSkin.getSSOLinkToOA");
            return null;
        }
    }

    private OLDevice getLatestPortMappingInfo(int enclDeviceKey) {
        LOGGER.enter("PortMappingSkin.getLatestPortMappingInfo(int " + enclDeviceKey + ")");
        OLDevice olDevice = null;
        try {
            MxNode enclMxNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclDeviceKey);
            olDevice = OAHelper.getOAHelper().refreshDeviceData(enclMxNode, this.m_node.getDeviceKey());
            LOGGER.fine("Displaying latest port mapping information.");
        }
        catch (OAException oe) {
            LOGGER.fine("Unbale to obtain a physical OA , Port mapping information will not be shown." + oe);
        }
        catch (MxUndefinedNodeException e) {
            LOGGER.fine("Unbale to obtain a physical OA because enclosure Node was not found with device key:" + enclDeviceKey + " ,Port mapping information " + "will not be shown." + (Object)((Object)e));
        }
        LOGGER.exit("PortMappingSkin.getLatestPortMappingInfo(int " + enclDeviceKey + ")");
        return olDevice;
    }
}

