/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.portMapping;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.tools.datacollection.http.oa.OLBlade;
import com.hp.mx.core.tools.datacollection.http.oa.OLBladePortMap;
import com.hp.mx.core.tools.datacollection.http.oa.OLDevice;
import com.hp.mx.core.tools.datacollection.http.oa.OLSwitch;
import com.hp.mx.core.tools.datacollection.http.oa.OLSwitchPortMap;
import com.hp.mx.core.tools.identification.associations.SnmpProtocolDataHandler;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.portMapping.xsd.OAPortMappingJaxb.InterConnectDevice;
import com.hp.mx.portal.portMapping.xsd.OAPortMappingJaxb.InterConnectDeviceType;
import com.hp.mx.portal.portMapping.xsd.OAPortMappingJaxb.InterConnectSlot;
import com.hp.mx.portal.portMapping.xsd.OAPortMappingJaxb.InterConnectSlotType;
import com.hp.mx.portal.portMapping.xsd.OAPortMappingJaxb.MEZZDevice;
import com.hp.mx.portal.portMapping.xsd.OAPortMappingJaxb.MezzPort;
import com.hp.mx.portal.portMapping.xsd.OAPortMappingJaxb.ObjectFactory;
import com.hp.mx.portal.portMapping.xsd.OAPortMappingJaxb.PortMapping;
import com.hp.mx.portal.portMapping.xsd.OAPortMappingJaxb.PortStatus;
import com.hp.mx.portal.portMapping.xsd.OAPortMappingJaxb.ServerDevice;
import com.hp.mx.portal.portMapping.xsd.OAPortMappingJaxb.ServerDeviceType;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;

public class DevicePortMapping {
    ObjectFactory m_objFactory = new ObjectFactory();
    private MonteroResourceManager m_manager = MonteroResourceManager.getInstance();
    private MxLoginBean m_loginBean;
    private MxNode m_node;
    HashMap macAddrMap;
    private static final DebugSubsystem LOGGER = new DebugSubsystem(DevicePortMapping.class);

    public DevicePortMapping(MxLoginBean loginBean, MxNode node) {
        this.m_loginBean = loginBean;
        this.m_node = node;
    }

    public String renderXMLForBlade(OLDevice olDevice) {
        LOGGER.enter("DevicePortMapping.renderXMLForBlade(MxNode " + this.m_node);
        try {
            PortMapping serverPortMappingJaxb = this.m_objFactory.createPortMapping();
            ServerDevice bladePortMapJaxb = this.m_objFactory.createServerDevice();
            this.createHeadersForBladePortMap(bladePortMapJaxb);
            OLBlade bladeDevice = (OLBlade)olDevice;
            if (bladeDevice == null || bladeDevice.getOLBladePortMap().getMezzTypeList().size() == 0) {
                bladePortMapJaxb.setHasPortMapInfo("Absent");
            } else {
                List<OLBladePortMap.MezzType> bladeMezzList = bladeDevice.getOLBladePortMap().getMezzTypeList();
                List jaxbMezzDeviceList = bladePortMapJaxb.getMEZZDevice();
                SnmpProtocolDataHandler snmpdh = new SnmpProtocolDataHandler(this.m_node);
                this.macAddrMap = MonteroSNMPUtils.getMIBData("1.3.6.1.2.1.2.2.1.6[0]", snmpdh, false);
                bladePortMapJaxb.setHasPortMapInfo("Present");
                this.renderInfoForMezz(bladeMezzList, jaxbMezzDeviceList);
            }
            serverPortMappingJaxb.setServerDevice(bladePortMapJaxb);
            return this.renderPortMappingXML(serverPortMappingJaxb);
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in DevicePortMapping.renderXMLForBlade" + (Object)((Object)e));
            return null;
        }
    }

    private void createHeadersForBladePortMap(ServerDevice bladePortMapJaxb) {
        LOGGER.fine("DevicePortMapping.createHeadersForBladePortMap");
        try {
            ServerDeviceType.I18NType i18N = this.m_objFactory.createServerDeviceTypeI18NType();
            i18N.setL10NMezzSlot(this.m_manager.getString("PortMap.MezzSlot", this.m_loginBean.getLocale()));
            i18N.setL10NDevicePort(this.m_manager.getString("PortMap.MezzDevicePort", this.m_loginBean.getLocale()));
            i18N.setL10NPortStatus(this.m_manager.getString("PortMap.Port Status", this.m_loginBean.getLocale()));
            i18N.setL10NInterConnect(this.m_manager.getString("PortMap.Interconnect", this.m_loginBean.getLocale()));
            i18N.setL10NBayPort(this.m_manager.getString("PortMap.Bay Port", this.m_loginBean.getLocale()));
            i18N.setL10NDeviceID(this.m_manager.getString("portMap.DeviceID", this.m_loginBean.getLocale()));
            i18N.setL10NMezzanine(this.m_manager.getString("portMap.Mezzanine", this.m_loginBean.getLocale()));
            i18N.setL10NBay(this.m_manager.getString("PortMap.Bay", this.m_loginBean.getLocale()));
            i18N.setL10NNotAvailable(this.m_manager.getString("NOT_AVAILABLE", this.m_loginBean.getLocale()));
            i18N.setL10NENET(this.m_manager.getString("portMap.ENET", this.m_loginBean.getLocale()));
            i18N.setL10NPort(this.m_manager.getString("portMap.Port", this.m_loginBean.getLocale()));
            i18N.setL10NMezzDeviceName(this.m_manager.getString("portMap.MezzanineDevice", this.m_loginBean.getLocale()));
            i18N.setL10NInterfaceName(this.m_manager.getString("portMap.InterfaceName", this.m_loginBean.getLocale()));
            i18N.setL10NNormalStatus(this.m_manager.getString("xml.Normal", this.m_loginBean.getLocale()));
            i18N.setL10NMisMatchStatus(this.m_manager.getString("xml.PortMisMatch", this.m_loginBean.getLocale()));
            i18N.setL10NUnknownStatus(this.m_manager.getString("xml.Unknown", this.m_loginBean.getLocale()));
            bladePortMapJaxb.setI18N(i18N);
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in DevicePortMapping.createHeadersForBladePortMap" + (Object)((Object)e));
        }
    }

    private void renderInfoForMezz(List mezzDeviceInfoList, List mezzDeviceJaxbList) {
        LOGGER.enter("DevicePortMapping.renderMezzInfoForFixedNics");
        try {
            int mezzDeviceInfoSize = mezzDeviceInfoList.size();
            LOGGER.fine("Number of Mezzanine devices present in the server:" + mezzDeviceInfoSize);
            OLBladePortMap.MezzType mezzTypeInfo = null;
            MEZZDevice mezzJaxbDevice = null;
            OLBladePortMap.MezzType.DeviceType mezzDeviceType = null;
            for (int i = 0; i < mezzDeviceInfoSize; ++i) {
                mezzTypeInfo = (OLBladePortMap.MezzType)mezzDeviceInfoList.get(i);
                mezzDeviceType = mezzTypeInfo.getDeviceType();
                LOGGER.fine("The DeviceType for the Mezzanine Device is:" + mezzDeviceType);
                mezzJaxbDevice = this.m_objFactory.createMEZZDevice();
                if (mezzDeviceType.getType().equalsIgnoreCase("MEZZ_SLOT_TYPE_FIXED") || mezzDeviceType.getType().equalsIgnoreCase("MEZZ_DEV_TYPE_FIXED")) {
                    mezzJaxbDevice.setMezzSlot(this.m_manager.getString("portMap.ENET", this.m_loginBean.getLocale()));
                } else {
                    mezzJaxbDevice.setMezzSlot(mezzTypeInfo.getNumber());
                }
                this.renderMezzInfo(mezzTypeInfo, mezzJaxbDevice, mezzDeviceJaxbList);
            }
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in DevicePortMapping.renderMezzInfoForFixedNics" + (Object)((Object)e));
        }
        LOGGER.exit("DevicePortMapping.renderMezzInfoForFixedNics");
    }

    private void renderMezzInfo(OLBladePortMap.MezzType mezzTypeInfo, MEZZDevice mezzJaxbDevice, List mezzDeviceJaxbList) {
        LOGGER.enter("DevicePortMapping.renderMezzInfo");
        OLBladePortMap.MezzType.DeviceType mezzDeviceTypeInfo = mezzTypeInfo.getDeviceType();
        OLBladePortMap.MezzType.SlotType mezzSlotTypeInfo = mezzTypeInfo.getSlotType();
        String deviceName = mezzDeviceTypeInfo.getName();
        LOGGER.fine("The Mezz Device Name from OA:" + deviceName);
        if (deviceName == null || deviceName.equalsIgnoreCase("")) {
            deviceName = this.m_manager.getString("PortMap.NoDevice", this.m_loginBean.getLocale());
        }
        mezzJaxbDevice.setMezzSlotName(deviceName);
        mezzJaxbDevice.setMezzSlotType(mezzDeviceTypeInfo.getType());
        this.renderMezzPortInfo(mezzSlotTypeInfo.getPortTypeList(), mezzDeviceTypeInfo.getPortTypeList(), mezzJaxbDevice);
        mezzDeviceJaxbList.add(mezzJaxbDevice);
        LOGGER.enter("DevicePortMapping.renderMezzInfo");
    }

    private void renderMezzPortInfo(List mezzSlotPortList, List mezzDevicePortList, MEZZDevice mezzJaxbDevice) {
        LOGGER.enter("DevicePortMapping.renderMezzPortInfo");
        try {
            int noOfSlotPorts = mezzSlotPortList.size();
            List jaxbMezzPortList = mezzJaxbDevice.getMezzPort();
            MezzPort jaxbMezzPort = null;
            OLBladePortMap.MezzType.SlotType.PortType mezzSlotPort = null;
            OLBladePortMap.MezzType.DeviceType.PortType mezzDevicePort = null;
            LOGGER.fine("Number of Ports present for this slot:" + noOfSlotPorts);
            List portsList = this.getPortsListFromMezzDevice(mezzDevicePortList);
            String portNumber = null;
            for (int i = 0; i < noOfSlotPorts; ++i) {
                mezzSlotPort = (OLBladePortMap.MezzType.SlotType.PortType)mezzSlotPortList.get(i);
                portNumber = mezzSlotPort.getNumber();
                LOGGER.fine("portNumber:" + portNumber);
                mezzDevicePort = this.getMezzDeviceForPort(portNumber, portsList, mezzDevicePortList);
                if (mezzDevicePort != null) {
                    LOGGER.fine("mezzDevicePort.getWWPN():" + mezzDevicePort.getWWPN());
                    LOGGER.fine("mezzDevicePort.getStatus():" + mezzDevicePort.getStatus());
                    if (mezzDevicePort.getStatus().equalsIgnoreCase("UNKNOWN") || mezzDevicePort.getWWPN().trim().length() <= 0 || mezzDevicePort.getWWPN().equalsIgnoreCase("empty")) continue;
                    jaxbMezzPort = this.m_objFactory.createMezzPort();
                    jaxbMezzPort.setMezzDevicePort(portNumber);
                    jaxbMezzPort.setInterConnectBay(mezzSlotPort.getTrayBayNumber());
                    jaxbMezzPort.setInterConnectBayPort(this.m_manager.getString("portMap.Port", this.m_loginBean.getLocale()) + mezzSlotPort.getTrayPortNumber());
                    jaxbMezzPort.setDeviceID(mezzDevicePort.getWWPN());
                    jaxbMezzPort.setPortStatus(this.renderPortStatus(mezzDevicePort.getStatus()));
                    jaxbMezzPort.setInterConnectTrayType(mezzDevicePort.getType());
                    jaxbMezzPort.setInterfaceName(this.getInterfaceName(mezzDevicePort));
                    jaxbMezzPortList.add(jaxbMezzPort);
                    continue;
                }
                jaxbMezzPort = this.m_objFactory.createMezzPort();
                jaxbMezzPort.setMezzDevicePort(portNumber);
                jaxbMezzPort.setInterConnectBay(mezzSlotPort.getTrayBayNumber());
                jaxbMezzPort.setInterConnectBayPort(this.m_manager.getString("portMap.Port", this.m_loginBean.getLocale()) + mezzSlotPort.getTrayPortNumber());
                jaxbMezzPort.setPortStatus(this.renderPortStatus("UNKNOWN"));
                jaxbMezzPortList.add(jaxbMezzPort);
            }
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in DevicePortMapping.renderMezzPortInfo" + (Object)((Object)e));
        }
        LOGGER.exit("DevicePortMapping.renderMezzPortInfo");
    }

    private List getPortsListFromMezzDevice(List mezzDevicePortList) {
        LOGGER.enter("DevicePortMapping.getPortsListFromMezzDevice");
        int mezzDevicePortSize = mezzDevicePortList.size();
        OLBladePortMap.MezzType.DeviceType.PortType mezzDevicePort = null;
        ArrayList<String> portList = new ArrayList<String>();
        for (int i = 0; i < mezzDevicePortSize; ++i) {
            mezzDevicePort = (OLBladePortMap.MezzType.DeviceType.PortType)mezzDevicePortList.get(i);
            portList.add(mezzDevicePort.getNumber());
        }
        LOGGER.exit("DevicePortMapping.getPortsListFromMezzDevice");
        return portList;
    }

    private OLBladePortMap.MezzType.DeviceType.PortType getMezzDeviceForPort(String portNumber, List portList, List mezzDevicePortList) {
        if (portNumber != null && portList.contains(portNumber)) {
            return (OLBladePortMap.MezzType.DeviceType.PortType)mezzDevicePortList.get(portList.indexOf(portNumber));
        }
        return null;
    }

    private PortStatus renderPortStatus(String status) {
        LOGGER.enter("DevicePortMapping.renderPortStatus");
        try {
            PortStatus portStatus = this.m_objFactory.createPortStatus();
            portStatus.setPortStatusString(status);
            portStatus.setPortStatusValue(this.getStatusValue(status));
            LOGGER.exit("DevicePortMapping.renderPortStatus");
            return portStatus;
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in DevicePortMapping.renderPortStatus" + (Object)((Object)e));
            LOGGER.exit("DevicePortMapping.renderPortStatus");
            return null;
        }
    }

    private String getStatusValue(String statusStr) {
        LOGGER.enter("DevicePortMapping.getStatus(String " + statusStr + ")");
        if (statusStr.equalsIgnoreCase("OK")) {
            return this.m_manager.getString("PortMap.Ok", this.m_loginBean.getLocale());
        }
        if (statusStr.equalsIgnoreCase("MISMATCH")) {
            return this.m_manager.getString("PortMap.Mismatch", this.m_loginBean.getLocale());
        }
        return "UNKNOWN";
    }

    private String renderPortMappingXML(PortMapping jaxbPortMapObj) {
        LOGGER.enter("DevicePortMapping.renderPortMappingXML");
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.hp.mx.portal.portMapping.xsd.OAPortMappingJaxb");
            Marshaller xmlMarshaller = jc.createMarshaller();
            xmlMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter xmlString = new StringWriter(3000);
            xmlMarshaller.marshal((Object)jaxbPortMapObj, (Writer)xmlString);
            LOGGER.fine("PortMapping XML:" + xmlString);
            LOGGER.exit("DevicePortMapping.renderPortMappingXML");
            return xmlString.toString();
        }
        catch (PropertyException e) {
            LOGGER.fine("PropertyException in DevicePortMapping.renderPortMappingXML" + (Object)((Object)e));
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in DevicePortMapping.renderPortMappingXML" + (Object)((Object)e));
        }
        return null;
    }

    public String renderXMLForSwitch(OLDevice olDevice) {
        LOGGER.enter("DevicePortMapping.renderXMLForSwitch");
        try {
            PortMapping switchPortMappingJaxb = this.m_objFactory.createPortMapping();
            InterConnectDevice switchJaxbDevice = this.m_objFactory.createInterConnectDevice();
            this.createHeadersForSwitchPortMap(switchJaxbDevice);
            OLSwitch switchType = (OLSwitch)olDevice;
            if (switchType == null || switchType.getOLSwitchPortMap().getSlotTypeList().size() == 0) {
                LOGGER.fine("The Port Mapping information is not present.So add ABSENT to the Switch Port mapping XML");
                switchJaxbDevice.setHasPortMapInfo("Absent");
            } else {
                switchJaxbDevice.setHasPortMapInfo("Present");
                this.renderInterconnectSlotInfo(switchType.getOLSwitchPortMap().getSlotTypeList(), switchJaxbDevice);
            }
            switchPortMappingJaxb.setInterConnectDevice(switchJaxbDevice);
            LOGGER.exit("DevicePortMapping.renderXMLForSwitch");
            return this.renderPortMappingXML(switchPortMappingJaxb);
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in DevicePortMapping.renderXMLForSwitch" + (Object)((Object)e));
            LOGGER.exit("DevicePortMapping.renderXMLForSwitch");
            return null;
        }
    }

    private void createHeadersForSwitchPortMap(InterConnectDevice jaxbSwitchDevice) {
        LOGGER.enter("DevicePortMapping.createHeadersForSwitchPortMap");
        try {
            InterConnectDeviceType.I18NType i18N = this.m_objFactory.createInterConnectDeviceTypeI18NType();
            i18N.setL10NInterConnect(this.m_manager.getString("PortMap.Interconnect", this.m_loginBean.getLocale()));
            i18N.setL10NBayPort(this.m_manager.getString("PortMap.Bay Port", this.m_loginBean.getLocale()));
            i18N.setL10NPortStatus(this.m_manager.getString("PortMap.Port Status", this.m_loginBean.getLocale()));
            i18N.setL10NServerBay(this.m_manager.getString("portMap.Server Bay", this.m_loginBean.getLocale()));
            i18N.setL10NMezzPort(this.m_manager.getString("portMap.Mezz Port", this.m_loginBean.getLocale()));
            i18N.setL10NBay(this.m_manager.getString("PortMap.Bay", this.m_loginBean.getLocale()));
            i18N.setL10NPort(this.m_manager.getString("portMap.Port", this.m_loginBean.getLocale()));
            i18N.setL10NConnected(this.m_manager.getString("PortMap.Connected", this.m_loginBean.getLocale()));
            i18N.setL10NNoConnection(this.m_manager.getString("PortMap.NoConnection", this.m_loginBean.getLocale()));
            i18N.setL10NNotAvailable(this.m_manager.getString("NOT_AVAILABLE", this.m_loginBean.getLocale()));
            i18N.setL10NNormalStatus(this.m_manager.getString("xml.Normal", this.m_loginBean.getLocale()));
            i18N.setL10NMisMatchStatus(this.m_manager.getString("xml.PortMisMatch", this.m_loginBean.getLocale()));
            i18N.setL10NUnknownStatus(this.m_manager.getString("xml.Unknown", this.m_loginBean.getLocale()));
            jaxbSwitchDevice.setI18N(i18N);
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in DevicePortMapping.createHeadersForSwitchPortMap" + (Object)((Object)e));
        }
        LOGGER.exit("DevicePortMapping.createHeadersForSwitchPortMap");
    }

    private void renderInterconnectSlotInfo(List switchSlotTypeList, InterConnectDevice jaxbSwitchDevice) {
        LOGGER.enter("DevicePortMapping.renderInterconnectSlotInfo");
        try {
            int switchSlotSize = switchSlotTypeList.size();
            List jaxbSwitchSlotsList = jaxbSwitchDevice.getInterConnectSlot();
            InterConnectSlot jaxbSwitchSlot = null;
            OLSwitchPortMap.SlotType switchSlotType = null;
            LOGGER.fine("The Number of slots for the switch:" + switchSlotSize);
            for (int i = 0; i < switchSlotSize; ++i) {
                switchSlotType = (OLSwitchPortMap.SlotType)switchSlotTypeList.get(i);
                jaxbSwitchSlot = this.m_objFactory.createInterConnectSlot();
                jaxbSwitchSlot.setInterConnectSlotNumber(switchSlotType.getNumber());
                List<OLSwitchPortMap.SlotType.PortType> switchPortTypeList = switchSlotType.getPortTypeList();
                this.renderInterConnectTrayPortInfo(switchPortTypeList, jaxbSwitchSlot);
                jaxbSwitchSlotsList.add(jaxbSwitchSlot);
            }
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in DevicePortMapping.renderInterconnectSlotInfo" + (Object)((Object)e));
        }
        LOGGER.exit("DevicePortMapping.renderInterconnectSlotInfo");
    }

    private void renderInterConnectTrayPortInfo(List switchPortTypeList, InterConnectSlot jaxbSwitchSlot) {
        LOGGER.enter("DevicePortMapping.renderInterConnectTrayPortInfo");
        try {
            int switchPortSize = switchPortTypeList.size();
            List jaxbSwitchPortsList = jaxbSwitchSlot.getInterConnectTrayPort();
            OLSwitchPortMap.SlotType.PortType switchPortType = null;
            InterConnectSlotType.InterConnectTrayPortType jaxbSwitchPort = null;
            LOGGER.fine("The Number of ports for the Switch:" + switchPortSize);
            for (int i = 0; i < switchPortSize; ++i) {
                switchPortType = (OLSwitchPortMap.SlotType.PortType)switchPortTypeList.get(i);
                jaxbSwitchPort = this.m_objFactory.createInterConnectSlotTypeInterConnectTrayPortType();
                jaxbSwitchPort.setPortNumber(switchPortType.getNumber());
                jaxbSwitchPort.setServerBay(switchPortType.getBladeBayNumber());
                jaxbSwitchPort.setServerMezzSlot(switchPortType.getBladeMezzNumber());
                jaxbSwitchPort.setServerMezzPort(switchPortType.getBladeMezzPortNumber());
                jaxbSwitchPort.setPortStatus(this.renderPortStatus(switchPortType.getStatus()));
                jaxbSwitchPortsList.add(jaxbSwitchPort);
            }
        }
        catch (JAXBException e) {
            LOGGER.fine("Exception in DevicePortMapping.renderInterConnectTrayPortInfo" + (Object)((Object)e));
        }
        LOGGER.exit("DevicePortMapping.renderInterConnectTrayPortInfo");
    }

    private String getInterfaceName(OLBladePortMap.MezzType.DeviceType.PortType mezzDevicePort) {
        LOGGER.enter("DevicePortMapping.getInterfaceName()");
        LOGGER.fine("Node Name:" + this.m_node.getNameString());
        String interfaceName = MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_loginBean.getLocale());
        if (!mezzDevicePort.getType().equalsIgnoreCase("INTERCONNECT_TYPE_ETH")) {
            return " ";
        }
        String oid = (String)this.macAddrMap.get(mezzDevicePort.getWWPN().toUpperCase());
        LOGGER.fine("oid:" + oid);
        if (oid == null) {
            LOGGER.fine("interfaceName:" + interfaceName);
            LOGGER.fine("End:getInterfaceName()");
            return interfaceName;
        }
        oid = "1.3.6.1.2.1.2.2.1.2." + oid.substring(oid.lastIndexOf(".") + 1) + "[0]";
        LOGGER.fine("New oid oid:" + oid);
        interfaceName = MonteroSNMPUtils.getMIBDataValue(oid, this.m_node);
        if (interfaceName == null || interfaceName.length() == 0) {
            interfaceName = MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_loginBean.getLocale());
        }
        LOGGER.fine("interfaceName:" + interfaceName);
        LOGGER.exit("DevicePortMapping.getInterfaceName()");
        return interfaceName;
    }
}

