/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.performance;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.portal.MonteroBean;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;

public class DeviceInfoBean {
    private static final DebugSubsystem m_log = new DebugSubsystem(DeviceInfoBean.class);
    private MxNode m_node = null;
    MonteroBean m_MonteroBean = null;
    private int m_deviceKey = -1;
    private int m_numLogicalDrives = 0;

    public void initialize(MonteroBean monteroBean, int deviceKey) {
        m_log.enter("DeviceInfoBean.initialize(" + monteroBean + "," + deviceKey + ")");
        m_log.fine("Start: Initializing the MonteroDeviceBean for nodeId:" + deviceKey);
        this.m_deviceKey = deviceKey;
        this.m_MonteroBean = monteroBean;
        try {
            this.m_node = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(deviceKey);
            this.m_numLogicalDrives = this.getDiskDrivesFromDb();
        }
        catch (Exception e) {
            m_log.error("Error initializing deviceinfoBean: ", new Object[]{e});
        }
        m_log.exit("DeviceInfoBean.initialize(" + monteroBean + "," + deviceKey + ")");
    }

    public MxNode getMxNode() {
        return this.m_node;
    }

    public int getNumberLogicalDrives() {
        return this.m_numLogicalDrives;
    }

    public String friendlyCPUSpeed(String strSpeed) {
        int speed;
        m_log.enter("DeviceInfoBean.friendlyCPUSpeed(" + strSpeed + ")");
        StringBuffer sb = new StringBuffer();
        try {
            speed = Integer.parseInt(strSpeed);
        }
        catch (NumberFormatException ex) {
            speed = 0;
            m_log.fine("Default CPU speed assumed", new Object[]{ex});
        }
        if (speed > 0) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMinimumFractionDigits(0);
            nf.setMaximumFractionDigits(2);
            if ((double)speed >= 1000.0) {
                sb.append(nf.format((double)speed / 1000.0));
            } else {
                sb.append(nf.format(speed));
            }
            sb.append(" ");
            sb.append(MonteroResourceManager.getInstance().getString("cpu.abbreviation.mhz", this.m_MonteroBean.getLoginBean().getLocale()));
        }
        m_log.fine("friendlyCPUSpeed:" + sb);
        m_log.exit("DeviceInfoBean.friendlyCPUSpeed(" + strSpeed + ")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int getDiskDrivesFromDb() {
        int count;
        block27: {
            Connection conn;
            Statement sqlNumDrivesQuery;
            ResultSet resultSet;
            block26: {
                m_log.enter("DeviceInfoBean.getDiskDrivesFromDb()");
                resultSet = null;
                sqlNumDrivesQuery = null;
                conn = null;
                count = 0;
                String numDrivesQuery = "select count(*) FROM CIM_LogicalDisk WHERE NodeId = ?";
                conn = DatabaseManager.getDefaultDatabase().getConnection("DeviceInfoBean.getDiskDrivesFromDb()");
                sqlNumDrivesQuery = conn.prepareStatement(numDrivesQuery.toString());
                sqlNumDrivesQuery.setInt(1, this.m_node.getDeviceKey());
                resultSet = sqlNumDrivesQuery.executeQuery();
                if (!resultSet.next()) break block26;
                count = resultSet.getInt(1);
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (sqlNumDrivesQuery != null) {
                    sqlNumDrivesQuery.close();
                }
                if (conn != null) {
                    DatabaseManager.getDefaultDatabase().releaseConnection(conn);
                }
                break block27;
            }
            catch (SQLException sqlException) {
                m_log.error("DeviceInfoBean.getDiskDrivesFromDb().Finally clause cleanup failure", new Object[]{sqlException});
            }
            break block27;
            catch (SQLException sqlException) {
                m_log.error("DeviceInfoBean.getCpuInfoFromDb()", new Object[]{sqlException});
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (sqlNumDrivesQuery != null) {
                        sqlNumDrivesQuery.close();
                    }
                    if (conn != null) {
                        DatabaseManager.getDefaultDatabase().releaseConnection(conn);
                    }
                }
                catch (SQLException sqlException2) {
                    m_log.error("DeviceInfoBean.getDiskDrivesFromDb().Finally clause cleanup failure", new Object[]{sqlException2});
                }
            }
            catch (Exception ex) {
                m_log.error("DeviceInfoBean.getCpuInfoFromDb():" + ex);
                {
                    catch (Throwable throwable) {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (sqlNumDrivesQuery != null) {
                                sqlNumDrivesQuery.close();
                            }
                            if (conn != null) {
                                DatabaseManager.getDefaultDatabase().releaseConnection(conn);
                            }
                        }
                        catch (SQLException sqlException2) {
                            m_log.error("DeviceInfoBean.getDiskDrivesFromDb().Finally clause cleanup failure", new Object[]{sqlException2});
                        }
                        throw throwable;
                    }
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (sqlNumDrivesQuery != null) {
                        sqlNumDrivesQuery.close();
                    }
                    if (conn != null) {
                        DatabaseManager.getDefaultDatabase().releaseConnection(conn);
                    }
                }
                catch (SQLException sqlException3) {
                    m_log.error("DeviceInfoBean.getDiskDrivesFromDb().Finally clause cleanup failure", new Object[]{sqlException3});
                }
            }
        }
        m_log.fine("Number of drives:" + count);
        m_log.exit("DeviceInfoBean.getDiskDrivesFromDb()");
        return count;
    }

    public MonteroBean getMonteroBean() {
        return this.m_MonteroBean;
    }
}

