/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.nodedelete.handlers;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.event.MxEvent;
import com.hp.mx.core.event.MxEventListener;
import com.hp.mx.core.event.MxEventType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;
import java.rmi.RemoteException;
import java.util.List;

public class ILONodeDeleteHandler
implements MxEventListener,
MxEventType_t.Values {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(ILONodeDeleteHandler.class);

    public void processEvent(MxEvent event) throws RemoteException {
        LOGGER.enter("ILONodeDeleteHandler.processEvent(" + event + ")");
        Object payLoadObj = event.getPayload();
        MxEventType_t eType = event.getEventType();
        if (!(payLoadObj instanceof MxNode) || !eType.equals((Object)OBJECT_REMOVED_EVENT)) {
            LOGGER.fine("This is not a Node delete event.");
            return;
        }
        MxNode iLODeletedNode = (MxNode)payLoadObj;
        this.removeILOClientAttributesOnServer(iLODeletedNode);
        LOGGER.exit("ILONodeDeleteHandler.processEvent(" + event + ")");
    }

    private void removeILOClientAttributesOnServer(MxNode iLODeletedNode) {
        LOGGER.enter("ILONodeDeleteHandler.removeILOClientAttributesOnServer(" + iLODeletedNode + ")");
        List allServers = MxNodeController.getDefaultControllerNoEx().getListOfNodesThatHaveThisProperty("iloDeviceKey", String.valueOf(iLODeletedNode.getDeviceKey()));
        for (int i = 0; i < allServers.size(); ++i) {
            MxNode serverMxNode = null;
            try {
                serverMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(Integer.parseInt(allServers.get(i).toString()));
            }
            catch (MxUndefinedNodeException nodeExcep) {
                LOGGER.fine("MxNode with key does not exists.:" + allServers.get(i));
                LOGGER.fine("Looking for the next storage deviceKey in the vector, if available.");
                continue;
            }
            serverMxNode.removeClientAttribute("iloDeviceKey");
            serverMxNode.removeClientAttribute("ILOTypeAssociated");
            try {
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), serverMxNode, false);
                continue;
            }
            catch (MxException e) {
                LOGGER.fine("ILONodeDeleteHandler.removeILOClientAttributesOnServer : Failed. Device Serial Number is " + serverMxNode.getSerialNumber() + " MxException " + (Object)((Object)e));
                LOGGER.exception((Throwable)e);
            }
        }
        LOGGER.exit("ILONodeDeleteHandler.removeILOClientAttributesOnServer(" + iLODeletedNode + ")");
    }
}

