/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.license;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.portal.lm.lmBean;
import com.hp.mx.utilities.DebugSubsystem;

abstract class LicenseManager {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(LicenseManager.class);
    protected lmBean m_lmBean;
    protected String m_proCode;
    protected String m_proVerCode;
    protected String m_proPresName;
    protected String m_proPresVerCode;
    private String m_sUseSeats = "0";
    private String m_sKeyDisp = "3";
    private String m_sLock = "0";
    private String m_sAcceptKeyType = "1";

    LicenseManager() {
    }

    protected boolean isNodeLicensed(int deviceKey) {
        LOGGER.enter("LicenseManager.isNodeLicensed(" + deviceKey + ")");
        boolean isLicensed = false;
        try {
            MxNode devNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(deviceKey);
            String[] lRet = this.m_lmBean.lmIsLicensed(devNode.getNameString(), devNode.getSerialNumber(), this.m_proCode, this.m_proVerCode, this.m_proPresName, this.m_proPresVerCode, this.m_sUseSeats, this.m_sKeyDisp, this.m_sLock, this.m_sAcceptKeyType);
            int retVal = Integer.parseInt(lRet[0]);
            LOGGER.fine("lcount value for device " + retVal);
            LOGGER.fine("Node Name:" + devNode.getNameString());
            switch (retVal) {
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: {
                    isLicensed = true;
                    break;
                }
                default: {
                    isLicensed = false;
                    break;
                }
            }
        }
        catch (MxUndefinedNodeException e) {
            isLicensed = false;
            LOGGER.fine("Node is not defined, deviceKey" + deviceKey + "Exception:" + (Object)((Object)e));
        }
        LOGGER.fine("Device Licensed:" + isLicensed);
        LOGGER.exit("End:LicenseManager.isNodeLicensed(" + deviceKey + ")");
        return isLicensed;
    }
}

