/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.DeviceAssociationObject;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.objectmodel.MxObjectID;
import com.hp.mx.core.tools.datacollection.http.iLO.BladeEnclosure;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.bpv.MxBPVContainer;
import com.hp.mx.portal.bpv.MxBPVContainerObjectFactory;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVException;
import com.hp.mx.portal.bpv.MxBPVObjectFactory;
import com.hp.mx.portal.bpv.MxBPVTyphoonSlot;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import com.sun.xml.bind.JAXBObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;

public abstract class MxBPVServerEnclosure
extends MxBPVContainer {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MxBPVServerEnclosure.class);
    BladeEnclosure m_BladeEnclosure;

    public static MxBPVServerEnclosure create(MxNode enclNode, MxBPVElement rackElement, MxLoginBean loginBean) throws Exception {
        LOGGER.fine("Start:MxBPVServerEnclosure.create(" + enclNode + "," + rackElement + "," + loginBean + ")");
        MxBPVServerEnclosure serverEnclosure = null;
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(enclNode.getKey());
        int numSlots = nodeAssociations.getMaxNumItems();
        String enclSubType = MxBPVServerEnclosure.getEnclosureSubType(enclNode);
        MxBPVContainerObjectFactory containerObject = MxBPVContainerObjectFactory.getContainerFactoryInstance();
        serverEnclosure = containerObject.getContainerObject(enclSubType, numSlots, enclNode, rackElement, loginBean);
        LOGGER.fine("MxBPVContainerObjectFactory of ServerEnclosure" + serverEnclosure.getName());
        LOGGER.exit("MxBPVServerEnclosure.create(" + enclNode + "," + rackElement + "," + loginBean + ")");
        return serverEnclosure;
    }

    protected MxBPVServerEnclosure(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws Exception {
        super(node, parent, loginBean);
        this.deviceType = "ServerEnc";
    }

    public abstract int getNumSlots();

    public abstract int getFirstSlotNumber();

    public Element renderXML() throws MxBPVException {
        LOGGER.enter("MxBPVServerEnclosure.renderXML()");
        BPVXML bpvXml = BPVXML.getInstance();
        Element serverEncl = bpvXml.createBladeEnclosure(this, this.loginBean);
        Iterator iter = this.iterator();
        MxBPVElement childElement = null;
        while (iter.hasNext()) {
            Object elementList = iter.next();
            if (elementList instanceof MxBPVElement) {
                childElement = (MxBPVElement)elementList;
                this.renderDevice(childElement, serverEncl);
                continue;
            }
            ArrayList switchList = (ArrayList)elementList;
            if (switchList == null) continue;
            for (int i = 0; i < switchList.size(); ++i) {
                childElement = (MxBPVElement)switchList.get(i);
                this.renderDevice(childElement, serverEncl);
            }
        }
        bpvXml.createRearView(this, serverEncl, this.loginBean);
        LOGGER.exit("MxBPVServerEnclosure.renderXML()");
        return serverEncl;
    }

    private void renderDevice(MxBPVElement childElement, Element serverEncl) throws MxBPVException {
        LOGGER.enter("MxBPVServerEnclosure.renderDevice(" + childElement + "," + serverEncl);
        LOGGER.fine("ElemntName" + childElement.getName() + ",ServerEnc Name:" + serverEncl.getName());
        if (childElement != null) {
            if (childElement instanceof MxBPVTyphoonSlot) {
                LOGGER.fine("Rendering " + childElement.getName());
                ((MxBPVTyphoonSlot)childElement).renderXML(serverEncl);
            } else {
                LOGGER.fine("Rendering " + childElement.getName());
                Element device = childElement.renderXML();
                serverEncl.addContent((Content)device);
            }
        }
        LOGGER.exit("MxBPVServerEnclosure.renderDevice(" + childElement + "," + serverEncl);
    }

    protected ArrayList getElementsForSlot(MxNodeClient nodeClient, NodeAssociations nodeAssociations, int slotNumber) {
        LOGGER.enter("MxBPVServerEnclosure.getVectorElementForSlot(" + nodeClient + "," + nodeAssociations + ",{SlotNumber:}" + slotNumber + ")");
        ArrayList deviceMxNodeList = MxBPVServerEnclosure.getDeviceAtSlotNumber(this.getKey(), slotNumber);
        ArrayList<MxBPVElement> deviceElementList = new ArrayList<MxBPVElement>();
        for (int i = 0; i < deviceMxNodeList.size(); ++i) {
            deviceElementList.add(this.getElementForSlot(nodeClient, nodeAssociations, (MxNode)deviceMxNodeList.get(i)));
        }
        LOGGER.exit("MxBPVServerEnclosure.getVectorElementForSlot(" + nodeClient + "," + nodeAssociations + ",{SlotNumber:}" + slotNumber);
        return deviceElementList;
    }

    protected MxBPVElement getElementForSlot(MxNodeClient nodeClient, NodeAssociations nodeAssociations, MxNode device) {
        LOGGER.enter("MxBPVServerEnclosure.getElementForSlot(" + nodeClient + "," + nodeAssociations + "," + device + ")");
        if (device == null) {
            LOGGER.fine("Returning null as there wasnt any MxNode object at this slot,this might be an empty slot or we have issues.");
            LOGGER.exit("MxBPVServerEnclosure.getElementForSlot(" + nodeClient + "," + nodeAssociations + "," + device + ")");
            return null;
        }
        try {
            MxNode node = nodeClient.getNodeByKey(device.getDeviceKey(), false);
            ArrayList<MxObjectID> nodeIDs = new ArrayList<MxObjectID>();
            nodeIDs.add(node.getObjectID());
            List authorizedTools = this.getLoginBean().getMxSessionManager().getToolClient().getToolsForSessionUserAndNodes(nodeIDs);
            LOGGER.fine("authorizedTools size:" + authorizedTools.size());
            if (authorizedTools.size() > 0) {
                LOGGER.fine("The user is authorized to run tools on the deviceTrying to get the MxBPVElement for the device at this slot");
                LOGGER.exit("MxBPVServerEnclosure.getElementForSlot(" + nodeClient + "," + nodeAssociations + "," + device + ")");
                MxBPVObjectFactory factory = new MxBPVObjectFactory();
                return factory.createObject(device, this, this.getLoginBean());
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception,MxBPVServerEnclosure.getElementForSlot()", new Object[]{e});
        }
        LOGGER.error("Returning null as the user is not autorized to use any tools on this server or there is an exception.Name:" + this.node.getNameString());
        LOGGER.exit("MxBPVServerEnclosure.getElementForSlot(" + nodeClient + "," + nodeAssociations + "," + device + ")");
        return null;
    }

    public static ArrayList getDeviceAtSlotNumber(int enclDeviceKey, int slotNumber) {
        LOGGER.enter("MxBPVServerEnclosure.getDeviceAtSlotNumber({enclDeviceKey:}" + enclDeviceKey + ",{SlotNumber:}" + slotNumber);
        DeviceAssociationObject dao = null;
        ArrayList<MxNode> deviceList = new ArrayList<MxNode>();
        try {
            NodeAssociationsManager myNodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            Vector bladeVec = myNodeAssociationsManager.getDevicesThatHaveAssociations(enclDeviceKey, true);
            NodeAssociations na = null;
            LOGGER.fine("bladeVec size:" + bladeVec.size());
            for (int i = 0; i < bladeVec.size(); ++i) {
                dao = (DeviceAssociationObject)bladeVec.elementAt(i);
                MxNode tmpDev = null;
                try {
                    tmpDev = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(dao.getDeviceKey());
                }
                catch (MxUndefinedNodeException ex) {
                    LOGGER.error("Node does not exists,DeviceKey:" + dao.getDeviceKey());
                }
                LOGGER.fine("MxNode of the device @ index " + i + ":" + tmpDev);
                if (tmpDev == null) continue;
                na = myNodeAssociationsManager.getNodeAssociations(dao.getDeviceKey());
                LOGGER.fine("The node associations object of device with key: " + dao.getDeviceKey() + ":" + na);
                LOGGER.fine("Slot number in the node associations object:" + na.getSlotNumber());
                LOGGER.fine("Slot number we are quering:" + slotNumber);
                if (na == null || na.getSlotNumber() != slotNumber) continue;
                LOGGER.fine("Found the Mxnode so add it to the list: " + tmpDev);
                deviceList.add(tmpDev);
            }
        }
        catch (NodeAssociationsPersistenceException nape) {
            LOGGER.error("Exception:MxBPVServerEnclosure.getDeviceAtSlot()", new Object[]{nape});
        }
        LOGGER.fine("The device list that this method returns.Size:" + deviceList.size());
        for (int i = 0; i < deviceList.size(); ++i) {
            LOGGER.fine("The device object:" + deviceList.get(i));
        }
        LOGGER.exit("MxBPVServerEnclosure.getDeviceAtSlotNumber({enclDeviceKey:}" + enclDeviceKey + ",{SlotNumber:}" + slotNumber);
        return deviceList;
    }

    protected MxBPVElement getElementForSlot(MxNodeClient nodeClient, NodeAssociations nodeAssociations, int slotNumber) {
        LOGGER.enter("Start:MxBPVServerEnclosure.getElementForSlot(+" + nodeClient + "," + nodeAssociations + ",{slotNumber:}" + slotNumber);
        MxNode device = nodeAssociations.getDeviceBySlotNumber(slotNumber);
        if (device == null) {
            LOGGER.fine("Returning null as getDeviceBySlotNumber() returned null,this might be an empty slot or we have issues.");
            LOGGER.fine("NodeAssociations device Key:" + nodeAssociations.getDeviceKey());
            LOGGER.exit("MxBPVServerEnclosure.getElementForSlot(+" + nodeClient + "," + nodeAssociations + ",{slotNumber:}" + slotNumber + ")");
            return null;
        }
        try {
            MxNode node = nodeClient.getNodeByKey(device.getDeviceKey(), false);
            ArrayList<MxObjectID> nodeIDs = new ArrayList<MxObjectID>();
            nodeIDs.add(node.getObjectID());
            List authorizedTools = this.getLoginBean().getMxSessionManager().getToolClient().getToolsForSessionUserAndNodes(nodeIDs);
            LOGGER.fine("authorizedTools size:" + authorizedTools.size());
            if (authorizedTools.size() > 0) {
                LOGGER.fine("The user is authorized to run tools on the deviceTrying to get the MxBPVElement for the device at this slot");
                LOGGER.exit("MxBPVServerEnclosure.getElementForSlot(+" + nodeClient + "," + nodeAssociations + ",{slotNumber:}" + slotNumber + ")");
                MxBPVObjectFactory factory = new MxBPVObjectFactory();
                return factory.createObject(device, this, this.getLoginBean());
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception:MxBPVServerEnclosure.getElementForSlot()", new Object[]{e});
        }
        LOGGER.error("Returning null as the user is not autorized to use any tools on this server or there is an exception.Name:" + this.node.getNameString());
        LOGGER.exit("End:MxBPVServerEnclosure.getElementForSlot(+" + nodeClient + "," + nodeAssociations + ",{slotNumber:}" + slotNumber + ")");
        return null;
    }

    public JAXBObject renderJAXBXML() {
        return null;
    }

    public static String getEnclosureSubType(MxNode srvEnclNode) {
        LOGGER.enter("MxBPVServerEnclosure.setDeviceSubTypeOfEncl(" + srvEnclNode.getName() + ")");
        String subTypeOfEncl = null;
        List enclSubTypeList = srvEnclNode.getDeviceSubTypes();
        if (enclSubTypeList.contains(NodeSubTypeMapper.PCLASS_SUBTYPE.toString())) {
            subTypeOfEncl = NodeSubTypeMapper.PCLASS_SUBTYPE.toString();
        } else if (enclSubTypeList.contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
            subTypeOfEncl = NodeSubTypeMapper.CCLASS_SUBTYPE.toString();
        } else if (enclSubTypeList.contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
            subTypeOfEncl = NodeSubTypeMapper.ECLASS_SUBTYPE.toString();
        } else {
            MxNode rackNode;
            subTypeOfEncl = NodeSubTypeMapper.PCLASS_SUBTYPE.toString();
            if (srvEnclNode != null && (rackNode = BPVXML.getRackNode(srvEnclNode)) != null) {
                List rackSubTypeList = rackNode.getDeviceSubTypes();
                if (rackSubTypeList.contains(NodeSubTypeMapper.PCLASS_SUBTYPE.toString())) {
                    subTypeOfEncl = NodeSubTypeMapper.PCLASS_SUBTYPE.toString();
                } else if (rackSubTypeList.contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
                    subTypeOfEncl = NodeSubTypeMapper.CCLASS_SUBTYPE.toString();
                } else if (rackSubTypeList.contains(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
                    subTypeOfEncl = NodeSubTypeMapper.ECLASS_SUBTYPE.toString();
                } else {
                    LOGGER.fine("The sub-type of server enclosure is not set in the rack node also and we were not able to obtain thedeviceSubtype from the server enclosure so we are setting it to P-Class to avoid any NullPointerExceptions.");
                    subTypeOfEncl = NodeSubTypeMapper.PCLASS_SUBTYPE.toString();
                }
            }
        }
        LOGGER.fine("subTypeOfEncl:" + subTypeOfEncl);
        LOGGER.exit("mxBPVServerEnclosure.setDeviceSubTypeOfEncl(" + srvEnclNode.getName() + ")");
        return subTypeOfEncl;
    }

    public MxBPVElement getElementForSlot(int enclDeviceKey, int slotNumber, String deviceType) {
        LOGGER.enter("MxBPVServerEnclosure.getElementForSlot({enclDeviceKey:}" + enclDeviceKey + ",{SlotNumber:}" + slotNumber + ",{deviceType}:" + deviceType);
        try {
            NodeAssociationsManager myNodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            Vector devices = this.getDevicesVector(enclDeviceKey, deviceType);
            NodeAssociations na = null;
            LOGGER.fine("Device Vector size:" + devices.size());
            Integer devKey = null;
            for (int i = 0; i < devices.size(); ++i) {
                devKey = (Integer)devices.get(i);
                LOGGER.fine("devKey:" + devKey);
                MxNode device = MxNodeController.getDefaultControllerNoEx().getNodeByKey(devKey);
                if (device == null) continue;
                na = myNodeAssociationsManager.getNodeAssociations(device.getDeviceKey());
                LOGGER.fine("The node associations object of device with key: " + device.getDeviceKey() + ":" + na);
                LOGGER.fine("Slot number in the node associations object:" + na.getSlotNumber());
                if (na == null || na.getSlotNumber() != slotNumber) continue;
                LOGGER.fine("The MxNode at the SlotNumber:" + slotNumber + " is:" + device);
                return this.getDeviceElement(device);
            }
        }
        catch (NodeAssociationsPersistenceException nape) {
            LOGGER.fine("Exception:MxBPVServerEnclosure.getDeviceAtSlot()" + (Object)((Object)nape));
        }
        return null;
    }

    private Vector getDevicesVector(int enclDeviceKey, String deviceType) {
        LOGGER.enter("MxBPVServerEnclsoure.getDevicesVector(enclDeviceKey " + enclDeviceKey + ",deviceType " + deviceType + ")");
        Vector devices = new Vector();
        try {
            NodeAssociationsManager myNodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            String ATN = deviceType + "ToEnclosure";
            devices = myNodeAssociationsManager.getAssociatedDevicesUsingATNs(enclDeviceKey, ATN);
        }
        catch (NodeAssociationsPersistenceException e) {
            e.printStackTrace();
        }
        LOGGER.exit("MxBPVServerEnclsoure.getDevicesVector(enclDeviceKey " + enclDeviceKey + ",deviceType " + deviceType + ")");
        return devices;
    }

    private MxBPVElement getDeviceElement(MxNode device) {
        LOGGER.enter("MxBPVServerEnclosure.getDeviceElement(device:" + device.getNameString() + ")");
        ArrayList<MxObjectID> nodeIDs = new ArrayList<MxObjectID>();
        nodeIDs.add(device.getObjectID());
        try {
            List authorizedTools = this.getLoginBean().getMxSessionManager().getToolClient().getToolsForSessionUserAndNodes(nodeIDs);
            LOGGER.fine("authorizedTools size:" + authorizedTools.size());
            if (authorizedTools.size() > 0) {
                MxBPVObjectFactory factory = new MxBPVObjectFactory();
                return factory.createObject(device, this, this.getLoginBean());
            }
        }
        catch (MxException e) {
            e.printStackTrace();
        }
        catch (BladeSystemException e) {
            e.printStackTrace();
        }
        LOGGER.exit("MxBPVServerEnclosure.getDeviceElement(device:" + device.getNameString() + ")");
        return null;
    }

    public BladeEnclosure getBladeEnclosure() {
        return this.m_BladeEnclosure;
    }
}

