/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.bpv.MxBPVContainer;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVException;
import com.hp.mx.portal.bpv.MxBPVPowerSupplyEnclosure;
import com.hp.mx.portal.bpv.MxBPVServerEnclosure;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import com.sun.xml.bind.JAXBObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MxBPVRack
extends MxBPVContainer {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MxBPVRack.class);

    public MxBPVRack(MxNode node, MxLoginBean loginBean) throws Exception {
        super(node, null, loginBean);
        this.deviceType = "Rack";
    }

    @Override
    public Element renderXML() throws MxBPVException {
        LOGGER.enter("MxBPVRack.renderXML()");
        BPVXML bpvXml = BPVXML.getInstance();
        Iterator iter = this.iterator();
        Element root = bpvXml.createRack(this, this.loginBean, iter.hasNext());
        LOGGER.fine("Iterator:" + iter.toString());
        while (iter.hasNext()) {
            MxBPVElement childElement = (MxBPVElement)iter.next();
            Element device = childElement.renderXML();
            LOGGER.fine("The childElement Document:" + device.getDocument());
            if (device.getDocument() != null) {
                LOGGER.fine("The Child Element is already having the document.So clone the contents to add to the Root element");
                root.addContent((Content)((Element)device.clone()));
                continue;
            }
            LOGGER.fine("Add the child element contents to the Root");
            root.addContent((Content)device);
        }
        LOGGER.exit("MxBPVRack.renderXML()");
        return root;
    }

    @Override
    public void populateAll() throws Exception {
        LOGGER.enter("MxBPVRack.populateAll()");
        MxNodeClient nodeClient = this.getLoginBean().getNodeClient();
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.getKey());
        DefaultMutableTreeNode rack = nodeAssociations.getContainerDeviceTree();
        List<DefaultMutableTreeNode> rackableDevices = this.sortRackableObjectsOnStartU(rack);
        for (DefaultMutableTreeNode enclosureNode : rackableDevices) {
            MxBPVContainer enclosureElement;
            Integer devKey = (Integer)enclosureNode.getUserObject();
            LOGGER.fine("devKey:" + devKey);
            MxNode childNode = nodeClient.getNodeByKey(devKey.intValue(), false);
            if (!childNode.getDeviceType().equals("Enclosure")) continue;
            List subTypes = childNode.getDeviceSubTypes();
            if (subTypes.contains("PowerEnc")) {
                LOGGER.fine("Adding Power enclosure");
                enclosureElement = new MxBPVPowerSupplyEnclosure(childNode, this, this.getLoginBean());
                this.add(enclosureElement);
                continue;
            }
            LOGGER.fine("Adding Server Enclosure");
            enclosureElement = MxBPVServerEnclosure.create(childNode, this, this.getLoginBean());
            this.add(enclosureElement);
        }
        LOGGER.exit("MxBPVRack.populateAll()");
    }

    public List<DefaultMutableTreeNode> sortRackableObjectsOnStartU(DefaultMutableTreeNode rack) {
        LOGGER.enter("MxBPVRack.sortEnclOnStartU");
        Enumeration<TreeNode> enumeration = rack.children();
        ArrayList<DefaultMutableTreeNode> lstEnclosures = new ArrayList<DefaultMutableTreeNode>();
        MxNodeClient nodeClient = this.getLoginBean().getNodeClient();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode rackableNode = (DefaultMutableTreeNode)enumeration.nextElement();
            lstEnclosures.add(rackableNode);
        }
        Collections.sort(lstEnclosures, new Comparator<DefaultMutableTreeNode>(){

            @Override
            public int compare(DefaultMutableTreeNode o1, DefaultMutableTreeNode o2) {
                int start1;
                MxNode mx2 = new MxNode();
                int start2 = 0;
                try {
                    MxNode mx1 = MxBPVRack.this.getLoginBean().getNodeClient().getNodeByKey(Integer.parseInt(o1.getUserObject().toString()), false);
                    start1 = Integer.parseInt(mx1.getClientAttribute("enclStartU"));
                }
                catch (Exception e) {
                    start1 = 0;
                }
                try {
                    mx2 = MxBPVRack.this.getLoginBean().getNodeClient().getNodeByKey(Integer.parseInt(o2.getUserObject().toString()), false);
                    start2 = Integer.parseInt(mx2.getClientAttribute("enclStartU"));
                }
                catch (Exception e) {
                    start1 = 0;
                }
                return start2 - start1;
            }
        });
        return lstEnclosures;
    }

    @Override
    public JAXBObject renderJAXBXML() {
        return null;
    }
}

