/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.tools.datacollection.http.iLO.ILOHelper;
import com.hp.mx.core.tools.datacollection.http.iLO.PowerEnclosure;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.bpv.MxBPVContainer;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import com.sun.xml.bind.JAXBObject;
import org.jdom.Element;

public class MxBPVPowerSupplyEnclosure
extends MxBPVContainer {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MxBPVPowerSupplyEnclosure.class);
    private String m_typeOfEnc;
    private PowerEnclosure m_PowerEnclosure;

    public MxBPVPowerSupplyEnclosure(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws Exception {
        super(node, parent, loginBean);
        this.deviceType = "PowerEnc";
    }

    public void populateAll() throws Exception {
        LOGGER.enter("MxBPVPowerEnclosure.populateAll()");
        LOGGER.fine("Enclosure Name:" + this.node.getNameString());
        LOGGER.fine("Collecting latest data for the enclosure.");
        this.m_PowerEnclosure = ILOHelper.getILOHelper().refreshPowerEnclosure(this.node.getDeviceKey());
        MxNode powerEnclNode = this.getNode();
        String prodId = powerEnclNode.getProductId();
        LOGGER.fine("PowerEnclosure ProductId:" + prodId);
        if (prodId.equalsIgnoreCase("3")) {
            this.m_typeOfEnc = "3U";
        } else if (prodId.equalsIgnoreCase("5")) {
            this.m_typeOfEnc = "1U";
        } else {
            this.m_typeOfEnc = "3U";
            LOGGER.fine("Product ID of the power supply enclosure is not set.");
            LOGGER.fine("Value of prodId:" + prodId);
            LOGGER.fine("Value of m_typeOfEnc:" + this.m_typeOfEnc);
        }
        LOGGER.fine("PowerEnclosure ProdId:" + prodId);
        LOGGER.fine("PowerEnclosure Type:" + this.m_typeOfEnc);
        LOGGER.exit("MxBPVPowerEnclosure.populateAll()");
    }

    public PowerEnclosure getPowerEnclosure() {
        return this.m_PowerEnclosure;
    }

    public Element renderXML() {
        LOGGER.enter("MxBPVPowerSupplyEnclosure.renderXML()");
        BPVXML bpvXml = BPVXML.getInstance();
        Element powerSupply = bpvXml.createPowerSupplyEnclosure(this, this.loginBean);
        LOGGER.exit("MxBPVPowerSupplyEnclosure.renderXML()");
        return powerSupply;
    }

    public String getTypeOfEnclosure() {
        return this.m_typeOfEnc;
    }

    public JAXBObject renderJAXBXML() {
        return null;
    }
}

