/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OAHelper;
import com.hp.mx.core.tools.datacollection.http.oa.OnboardAdministrator;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVOverlordEnclosure;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.Device;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.DeviceType;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.ObjectFactory;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.SlotsUsed;
import com.hp.mx.portal.bpv.xsd.OABPVXmlJaxb.Status;
import com.hp.mx.portal.core.MxDrillDown;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import com.sun.xml.bind.JAXBObject;
import javax.xml.bind.JAXBException;
import org.jdom.Element;

public class MxBPVOnboardAdministrator
extends MxBPVElement {
    private int numSlotsUsedXDir;
    private int numSlotsUsedYDir;
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MxBPVOnboardAdministrator.class);
    ObjectFactory m_objFactory = new ObjectFactory();

    public MxBPVOnboardAdministrator(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws NodeAssociationsPersistenceException {
        super(node, parent, loginBean);
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.getKey());
        this.slotNumber = nodeAssociations.getSlotNumber();
        this.numSlotsUsedXDir = nodeAssociations.getNumBladeSlotsUsedXDir();
        this.numSlotsUsedYDir = nodeAssociations.getNumBladeSlotsUsedYDir();
    }

    public Element renderXML() {
        return null;
    }

    String getDrillDownURL() {
        LOGGER.enter("MxBPVOnboardAdministrator.getDrillDownURL()");
        return "/mxportal/bladeime/bpv/BladeIMENodeCheck.jsp?deviceId=" + this.getKey() + "&drillDownType=" + MxDrillDown.DEVICE_NAME_DRILL_DOWN + "&globalsetting=true";
    }

    public JAXBObject renderJAXBXML() {
        LOGGER.enter("MxBPVOnboardAdministrator:renderJAXBXML");
        try {
            Device device = this.m_objFactory.createDevice();
            device.setBayType("MgmtProc");
            device.setLocation("Rear");
            this.setSlotsInfoForDevice(device);
            this.setCommonInfoForDevice(device);
            Status status = this.m_objFactory.createStatus();
            String deviceStatus = this.getStatus();
            LOGGER.fine("Device Status:" + deviceStatus);
            if (deviceStatus == null) {
                deviceStatus = "Unknown";
            }
            String deviceStatTitle = MonteroResourceManager.getInstance().getString("xml." + deviceStatus, this.getLoginBean().getLocale());
            status.setUID(deviceStatus);
            status.setTitle(deviceStatTitle);
            device.setStatus(status);
            return (JAXBObject)device;
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in MxBPVOnboardAdministrator:renderJAXBXML" + (Object)((Object)e));
            return null;
        }
    }

    private void setSlotsInfoForDevice(DeviceType device) {
        LOGGER.enter("MxBPVOnboardAdministrator:setSlotsInfoForDevice");
        try {
            device.setSlotNumber(this.slotNumber);
            device.setHasDevice("PRESENT");
            SlotsUsed slots = this.m_objFactory.createSlotsUsed();
            LOGGER.finer("X direction:" + this.numSlotsUsedXDir);
            LOGGER.finer("Y Direction:" + this.numSlotsUsedYDir);
            slots.setXDirection(this.numSlotsUsedXDir);
            slots.setYDirection(this.numSlotsUsedYDir);
            device.setSlotsUsed(slots);
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in MxBPVOnboardAdministrator:setSlotsInfoForDevice" + (Object)((Object)e));
        }
        LOGGER.exit("MxBPVOnboardAdministrator:setSlotsInfoForDevice");
    }

    private void setCommonInfoForDevice(DeviceType device) {
        LOGGER.enter("MxBPVOnboardAdministrator.setCommonInfoForDevice");
        try {
            DeviceType.CommonType common = this.m_objFactory.createDeviceTypeCommonType();
            common.setName(BPVXML.checkValue(this.node.getNameString(), this.loginBean));
            common.setProduct(BPVXML.checkValue(this.node.getModel(), this.loginBean));
            common.setNodeId(this.node.getGUID().toString());
            common.setDrillDownURL(this.getDrillDownURL());
            common.setSerialNumber(BPVXML.checkValue(this.node.getSerialNumber(), this.loginBean));
            common.setIPAddress(BPVXML.checkValue(this.node.getWorkingAddress(), this.loginBean));
            common.setHomePageURL("/mxportal/bladeime/bpv/EnclosureManagerProxy.jsp?enclSerialNum=" + this.getParent().getNode().getSerialNumber() + "&deviceType=" + NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString() + "&urlType=homepage" + "&guid=" + this.node.getGUID().toString());
            String oaFWRI = MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.loginBean.getLocale());
            String isPrimary = MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.loginBean.getLocale());
            MxBPVOverlordEnclosure parent = (MxBPVOverlordEnclosure)this.getParent();
            OAHelper oaHelper = OAHelper.getOAHelper();
            try {
                OnboardAdministrator oAObj = (OnboardAdministrator)oaHelper.getOLDevice(parent.m_enclosureObj, this.node.getDeviceKey());
                oaFWRI = oAObj.getFWRI();
                isPrimary = String.valueOf(oAObj.getIsPrimary());
            }
            catch (OAException e) {
                LOGGER.fine("Unable to find the OA device from the OA XML,Setting oaFWRI as NotAvail andisPrimary as false" + e);
            }
            LOGGER.fine("OA Firmware Version:" + oaFWRI);
            common.setFirmware(oaFWRI);
            device.setCommon(common);
            device.setIsPrimary(isPrimary);
            device.setFirmware(oaFWRI);
        }
        catch (JAXBException e) {
            LOGGER.fine("JAXBException in MxBPVOnboardAdministrator:setCommonInfoForDevice" + (Object)((Object)e));
        }
    }
}

