/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVServerEnclosure;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

public class MxBPVObjectFactory {
    private Properties m_classes = null;
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MxBPVObjectFactory.class);

    public MxBPVElement createObject(MxNode device, MxBPVServerEnclosure enclosure, MxLoginBean login) throws BladeSystemException {
        String className;
        LOGGER.enter("MxBPVObjectFactory:createObject(MxNode " + device.getNameString() + ",MxBPVServerEnclosure " + enclosure.getName() + ",MxLoginBean " + login);
        String type = device.getDeviceType();
        if (this.m_classes == null) {
            this.m_classes = new Properties();
            try {
                this.m_classes.load(this.getClass().getResourceAsStream("bpvelements.properties"));
            }
            catch (IOException e1) {
                LOGGER.fine("Exception:" + e1);
                e1.printStackTrace();
            }
        }
        if ((className = this.m_classes.getProperty(type)) == null) {
            className = this.m_classes.getProperty("Server");
        }
        LOGGER.fine("className:" + className);
        try {
            Class<?> bpvElement = Class.forName(className);
            Class[] argArray = new Class[]{MxNode.class, MxBPVElement.class, MxLoginBean.class};
            Constructor<?> constructor = null;
            try {
                constructor = bpvElement.getConstructor(argArray);
            }
            catch (SecurityException e2) {
                LOGGER.fine("Exception:" + e2);
                e2.printStackTrace();
            }
            catch (NoSuchMethodException e2) {
                LOGGER.fine("Exception:" + e2);
                e2.printStackTrace();
            }
            Object[] objArray = new Object[]{device, enclosure, login};
            Object object = null;
            try {
                object = constructor.newInstance(objArray);
            }
            catch (IllegalArgumentException e1) {
                LOGGER.fine("Exception:" + e1);
                e1.printStackTrace();
            }
            catch (InvocationTargetException e1) {
                LOGGER.fine("Exception:" + e1);
                e1.printStackTrace();
            }
            LOGGER.exit("MxBPVObjectFactory:createObject(MxNode " + device.getNameString() + ",MxBPVServerEnclosure " + enclosure.getName() + ",MxLoginBean " + login);
            return object;
        }
        catch (InstantiationException e) {
            LOGGER.fine("Exception:" + e);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            LOGGER.fine("Exception:" + e);
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            LOGGER.fine("Exception:" + e);
            e.printStackTrace();
        }
        LOGGER.fine("Throwing BladeSystemException");
        LOGGER.exit("MxBPVObjectFactory:createObject(MxNode " + device.getNameString() + ",MxBPVServerEnclosure " + enclosure.getName() + ",MxLoginBean " + login);
        throw new BladeSystemException("Error creating BPV element");
    }
}

