/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.objectmodel.MxObjectID;
import com.hp.mx.core.protocol.snmp.SnmpResponse;
import com.hp.mx.core.protocol.snmp.SnmpResponseVarBind;
import com.hp.mx.core.tools.identification.associations.SnmpProtocolDataHandler;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.bpv.MxBPVDesktop;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVEmptySlot;
import com.hp.mx.portal.bpv.MxBPVServer;
import com.hp.mx.portal.bpv.MxBPVServerEnclosure;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class MxBPVGardianServerEnclosure
extends MxBPVServerEnclosure {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MxBPVGardianServerEnclosure.class);
    private final int numSlots = 20;
    private final int firstSlotNumber = 1;

    public MxBPVGardianServerEnclosure(MxNode node, MxBPVElement parent, MxLoginBean loginBean) throws Exception {
        super(node, parent, loginBean);
    }

    public int getNumSlots() {
        return 20;
    }

    public int getFirstSlotNumber() {
        return 1;
    }

    public void populateAll() throws Exception {
        LOGGER.enter("MxBPVGardianServerEnclosure.populateAll()");
        LOGGER.fine("Refreshing the data.");
        this.refreshEnclosureData();
        MxNodeClient nodeClient = this.getLoginBean().getNodeClient();
        NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(this.getKey());
        this.setSize(this.getFirstSlotNumber() + this.getNumSlots());
        int slotNumber = this.getFirstSlotNumber();
        while (slotNumber < this.getFirstSlotNumber() + this.getNumSlots()) {
            LOGGER.fine("slotNumber:" + slotNumber);
            boolean foundSomethingInSlot = false;
            MxNode device = nodeAssociations.getDeviceBySlotNumber(slotNumber);
            if (device != null) {
                MxNode childNode = nodeClient.getNodeByKey(device.getDeviceKey(), false);
                ArrayList<MxObjectID> nodeIDs = new ArrayList<MxObjectID>();
                nodeIDs.add(childNode.getObjectID());
                List authorizedTools = this.getLoginBean().getMxSessionManager().getToolClient().getToolsForSessionUserAndNodes(nodeIDs);
                if (authorizedTools.size() > 0) {
                    if (childNode.getDeviceType().equals("Server")) {
                        MxBPVServer serverElement = new MxBPVServer(childNode, this, this.getLoginBean());
                        this.set(slotNumber, serverElement);
                        slotNumber += serverElement.getNumSlotsUsed();
                        foundSomethingInSlot = true;
                        LOGGER.fine("Creating a server");
                    } else if (childNode.getDeviceType().equals("Desktop")) {
                        MxBPVDesktop desktopElement = new MxBPVDesktop(childNode, this, this.getLoginBean());
                        this.set(slotNumber, desktopElement);
                        ++slotNumber;
                        foundSomethingInSlot = true;
                        LOGGER.fine("Creating a desktop");
                    }
                }
            }
            if (foundSomethingInSlot) continue;
            this.set(slotNumber, new MxBPVEmptySlot(false, slotNumber, 1, 1));
            ++slotNumber;
            LOGGER.fine("Creating a empty slot");
        }
        LOGGER.exit("MxBPVGardianServerEnclosure.populateAll()");
    }

    private void refreshEnclosureData() {
        LOGGER.enter("MxBPV.refreshEnclosureData()");
        MxNode enclosureNode = this.node;
        try {
            NodeAssociationsManager myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            LOGGER.fine("enclosureNode.getDeviceKey():" + enclosureNode.getDeviceKey());
            Vector iaDeviceKeyVector = myNodeRelationshipManager.getAssociatedDevicesUsingATNs(enclosureNode.getDeviceKey(), "MgmtProcToEnclosure");
            if (iaDeviceKeyVector.size() != 0) {
                Integer vectKey = (Integer)iaDeviceKeyVector.elementAt(0);
                int theIADeviceKey = vectKey;
                LOGGER.fine("theIADeviceKey:" + theIADeviceKey);
                MxNode theIADevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theIADeviceKey);
                LOGGER.fine("MxBPV.getPowerSupplyDetails : IANODE(" + theIADevice + ") " + "Node Name: " + theIADevice.getNameString());
                Vector powerDetails = this.getRackPowerSupplyDetailsAndSetOnEncl(theIADevice);
                if (powerDetails.size() > 0) {
                    this.setPowerDetailsOnEnclosure(powerDetails, enclosureNode);
                }
            }
        }
        catch (MxException e) {
            LOGGER.fine("MxBPV.getPowerSupplyDetailsFromIA :exception:" + (Object)((Object)e));
            LOGGER.fine("Exception while updating the e-Class enclosure with latest data.The data shown will be stale.");
        }
        LOGGER.enter("MxBPV.refreshEnclosureData()");
    }

    private Vector getRackPowerSupplyDetailsAndSetOnEncl(MxNode IANode) {
        LOGGER.enter("MxBPV.getRackPowerSupplyDetailsAndSetOnEncl()");
        boolean endOfTable = false;
        String enclSerNoOID = null;
        String powerSupplyIndexOID = null;
        String powerSupplySerialNumOID = null;
        String powerSupplyPosOID = null;
        int counter = 0;
        Vector PowerDetails = new Vector();
        SnmpProtocolDataHandler snmpPdh = new SnmpProtocolDataHandler(IANode);
        snmpPdh.getSnmpRequest().setAsn1Numbers("1.3.6.1.4.1.232.22.2.5.1.1.1.3[0],1.3.6.1.4.1.232.22.2.5.1.1.1.5[1],1.3.6.1.4.1.232.22.2.5.1.1.1.11[2],1.3.6.1.4.1.232.22.2.5.1.1.1.18[3]");
        while (!endOfTable) {
            snmpPdh.getSnmpRequest().SnmpGetNext();
            SnmpResponse curResp = snmpPdh.getSnmpRequest().getResponseVarbinds();
            SnmpResponseVarBind vb0 = curResp.findById(0);
            if (vb0 == null || vb0.isError()) break;
            powerSupplyIndexOID = vb0.getOid();
            LOGGER.fine("The powerSupplyIndexOID : " + powerSupplyIndexOID);
            SnmpResponseVarBind vb1 = curResp.findById(1);
            if (vb1 == null || vb1.isError()) break;
            powerSupplySerialNumOID = vb1.getOid();
            LOGGER.fine(" The powerSupplySerialNumOID : " + powerSupplySerialNumOID);
            SnmpResponseVarBind vb2 = curResp.findById(2);
            if (vb2 == null || vb2.isError()) break;
            powerSupplyPosOID = vb2.getOid();
            LOGGER.fine(" powerSupplyPosOID: " + powerSupplyPosOID);
            SnmpResponseVarBind vb3 = curResp.findById(3);
            if (vb3 == null || vb3.isError()) break;
            enclSerNoOID = vb3.getOid();
            LOGGER.fine(" The enclSerNoOID: " + enclSerNoOID);
            if (enclSerNoOID.startsWith("1.3.6.1.4.1.232.22.2.5.1.1.1.18.")) {
                Vector<String> tplgy = new Vector<String>();
                String enclosureSerialNumber = vb3.getValue();
                LOGGER.fine("enclosureSerialNumber:" + enclosureSerialNumber);
                if (enclosureSerialNumber != null && enclosureSerialNumber.trim().length() > 0 && enclosureSerialNumber.trim().length() >= 10 && !enclosureSerialNumber.trim().equalsIgnoreCase("unknown")) {
                    tplgy.add(enclosureSerialNumber);
                } else {
                    tplgy.add("");
                }
                String powerSupplyIndex = vb0.getValue();
                LOGGER.fine("powerSupplyIndex:" + powerSupplyIndex);
                if (powerSupplyIndex != null) {
                    tplgy.add(powerSupplyIndex);
                } else {
                    tplgy.add("");
                }
                String powerSupplySerialNum = vb1.getValue();
                LOGGER.fine("powerSupplySerialNum:" + powerSupplySerialNum);
                if (powerSupplySerialNum != null) {
                    tplgy.add(powerSupplySerialNum);
                } else {
                    tplgy.add("");
                }
                String powerSupplyPos = vb2.getValue();
                if (powerSupplyPos != null) {
                    tplgy.add(powerSupplyPos);
                } else {
                    tplgy.add("");
                }
                PowerDetails.add(tplgy);
                ++counter;
                snmpPdh.getSnmpRequest().clearSnmpReqInfo();
                snmpPdh.getSnmpRequest().addSnmpGetVarbind(powerSupplyIndexOID, "0");
                snmpPdh.getSnmpRequest().addSnmpGetVarbind(powerSupplySerialNumOID, "1");
                snmpPdh.getSnmpRequest().addSnmpGetVarbind(powerSupplyPosOID, "2");
                snmpPdh.getSnmpRequest().addSnmpGetVarbind(enclSerNoOID, "3");
                continue;
            }
            LOGGER.fine("enclosure serial number oid was not correct" + enclSerNoOID);
            break;
        }
        LOGGER.exit("MxBPV.getRackPowerSupplyDetailsAndSetOnEncl()");
        return PowerDetails;
    }

    private void setPowerDetailsOnEnclosure(Vector powerDetails, MxNode enclosureNode) {
        LOGGER.enter("MxBPV.setPowerDetailsOnEnclosure()");
        boolean leftPowerSupPresent = false;
        boolean rightPowerSupPresent = false;
        for (int i = 0; i < powerDetails.size(); ++i) {
            Vector tplgy = (Vector)powerDetails.elementAt(i);
            String powerSupIndex = (String)tplgy.elementAt(1);
            String powerSupSerialNum = (String)tplgy.elementAt(2);
            LOGGER.fine("powerSupIndex:" + powerSupIndex);
            LOGGER.fine("powerSupSerialNum:" + powerSupSerialNum);
            if (powerSupIndex.equals("00000001") && powerSupSerialNum != null && powerSupSerialNum != "") {
                leftPowerSupPresent = true;
            }
            if (!powerSupIndex.equals("00000002") || powerSupSerialNum == null || powerSupSerialNum == "") continue;
            rightPowerSupPresent = true;
        }
        LOGGER.fine("leftPowerSupPresent:" + leftPowerSupPresent);
        LOGGER.fine("rightPowerSupPresent:" + rightPowerSupPresent);
        enclosureNode.setClientAttribute("leftPowerSupply", String.valueOf(leftPowerSupPresent));
        enclosureNode.setClientAttribute("rightPowerSupply", String.valueOf(rightPowerSupPresent));
        LOGGER.exit("MxBPV.setPowerDetailsOnEnclosure()");
    }
}

