/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.client.MxNodeClient;
import com.hp.mx.core.client.MxQueryClient;
import com.hp.mx.core.client.NodeAssociationsClient;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.objectmodel.MxGUID;
import com.hp.mx.core.objectmodel.MxObjectID;
import com.hp.mx.core.querymanager.Query;
import com.hp.mx.core.querymanager.QueryType;
import com.hp.mx.core.querymanager.UndefinedQueryException;
import com.hp.mx.core.querymanager.criteria.CriteriaDataObject;
import com.hp.mx.core.querymanager.criteria.CriteriaDataObjectFactory;
import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.bpv.BPVXML;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVException;
import com.hp.mx.portal.bpv.MxBPVPowerSupplyEnclosure;
import com.hp.mx.portal.bpv.MxBPVRack;
import com.hp.mx.portal.bpv.MxBPVServerEnclosure;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class MxBPV {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MxBPV.class);
    private MxBPVElement m_element = null;
    private MxLoginBean m_loginBean = null;
    private String m_listViewURL = "";
    private String m_iconViewURL = "";
    private String m_treeViewURL = "";
    private int m_listViewId = -1;
    private int m_treeViewId = -1;
    private String m_devicesubType = null;
    private String m_discoveredName = null;

    public void initialize(String guid, MxLoginBean loginBean) throws BladeSystemException {
        block8: {
            LOGGER.enter("MxBPV.initialize(" + guid + "," + loginBean + ")");
            this.m_loginBean = loginBean;
            MxNode node = null;
            try {
                node = this.m_loginBean.getNodeClient().getNode(new MxObjectID(new MxGUID(guid)), false);
                if (node.getDeviceType().equals("Rack")) {
                    this.m_element = new MxBPVRack(node, this.m_loginBean);
                    break block8;
                }
                if (node.getDeviceType().equals("Enclosure")) {
                    List subTypes = node.getDeviceSubTypes();
                    if (subTypes.contains("PowerEnc")) {
                        this.m_devicesubType = "PowerEnc";
                        this.m_element = new MxBPVPowerSupplyEnclosure(node, null, this.m_loginBean);
                    } else {
                        LOGGER.fine("The subType list size:" + subTypes.size());
                        this.m_devicesubType = "ServerEnc";
                        this.m_element = MxBPVServerEnclosure.create(node, null, this.m_loginBean);
                    }
                    break block8;
                }
                LOGGER.panic("Device type of the node is not set,Unable to determineif the node is enclosure/rack, DeviceType:" + node.getDeviceType());
                throw new BladeSystemException("Selected container is neither a Rack/Enclosure");
            }
            catch (Exception e) {
                LOGGER.panic("Error initializing the BPV,Throwing BladeSystemsException");
                LOGGER.panic("Message:" + e.getMessage());
                throw new BladeSystemException("Exception while initializing MxBPV");
            }
        }
        try {
            this.getListViewURL();
            this.getIconViewURL();
            this.getTreeViewURL();
        }
        catch (Exception e) {
            LOGGER.error("Unable to get the tree/icon/table view URLs,Exception:" + e.getMessage());
        }
        LOGGER.exit("MxBPV.initialize(" + guid + "," + loginBean + ")");
    }

    public MxLoginBean getLoginBean() {
        return this.m_loginBean;
    }

    public String getEnclosureType() {
        return this.m_devicesubType;
    }

    public String getXML() throws MxBPVException {
        LOGGER.enter("MxBPV.getXML()");
        Element root = this.renderXML();
        MxNode currentNode = this.m_element.getNode();
        LOGGER.fine("Node Name " + currentNode.getNameString());
        if (!this.m_element.getDeviceType().equalsIgnoreCase("PowerEnc")) {
            String temp = "Section:NavigationURL,Selected:No,location:None,Name:" + MonteroResourceManager.getInstance().getString("viewSelector.List", this.m_loginBean.getLocale());
            Element attribute = BPVXML.createElement("Attribute", null);
            BPVXML.getInstance().setAttribute(attribute, temp, this.m_listViewURL);
            root.addContent((Content)attribute);
            temp = "Section:NavigationURL,Selected:No,location:None,Name:" + MonteroResourceManager.getInstance().getString("viewSelector.Tree", this.m_loginBean.getLocale());
            attribute = BPVXML.createElement("Attribute", null);
            BPVXML.getInstance().setAttribute(attribute, temp, this.m_treeViewURL);
            root.addContent((Content)attribute);
            temp = "Section:NavigationURL,Selected:No,location:None,Name:" + MonteroResourceManager.getInstance().getString("viewSelector.Icons", this.m_loginBean.getLocale());
            attribute = BPVXML.createElement("Attribute", null);
            BPVXML.getInstance().setAttribute(attribute, temp, this.m_iconViewURL);
            root.addContent((Content)attribute);
            temp = "Section:NavigationURL,Selected:Yes,location:None,Name:" + MonteroResourceManager.getInstance().getString("viewSelector.Picture", this.m_loginBean.getLocale());
            attribute = BPVXML.createElement("Attribute", null);
            BPVXML.getInstance().setAttribute(attribute, temp, "");
            root.addContent((Content)attribute);
        }
        Element i18n = BPVXML.createElement("I18N", null);
        i18n.addContent((Content)BPVXML.createElement("L10NFrontView", MonteroResourceManager.getInstance().getString("xml.FrontView", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NRearView", MonteroResourceManager.getInstance().getString("xml.RearView", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NAllBlades", MonteroResourceManager.getInstance().getString("xml.AllBlades", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NAllEnclosures", MonteroResourceManager.getInstance().getString("xml.AllEnclosures", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NAllRacks", MonteroResourceManager.getInstance().getString("xml.AllRacks", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NAllInterconnectSwitches", MonteroResourceManager.getInstance().getString("xml.AllInterconnectSwitches", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NPowerAndThermal", MonteroResourceManager.getInstance().getString("xml.powerAndThermal", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NViewAs", MonteroResourceManager.getInstance().getString("xml.ViewAs", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NSelect", MonteroResourceManager.getInstance().getString("xml.Select", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NIdentification", MonteroResourceManager.getInstance().getString("xml.Identification", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NSystemStatus", MonteroResourceManager.getInstance().getString("xml.SystemStatus", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NPowerSupplyUnit", MonteroResourceManager.getInstance().getString("xml.powerSupplyUnit", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NILOUpdateMessage", MonteroResourceManager.getInstance().getString("xml.iloUpdateMessage", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NILOUpdateMessageCause1", MonteroResourceManager.getInstance().getString("xml.iloUpdateMessageCause1", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NILOUpdateMessageCause2", MonteroResourceManager.getInstance().getString("xml.iloUpdateMessageCause2", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NEmptyBay", MonteroResourceManager.getInstance().getString("xml.emptyBay", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NBay", MonteroResourceManager.getInstance().getString("xml.bay", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NMinimize", MonteroResourceManager.getInstance().getString("xml.minimize", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NMaximize", MonteroResourceManager.getInstance().getString("xml.maximize", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NSlideLeft", MonteroResourceManager.getInstance().getString("xml.slideLeft", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NSlideRight", MonteroResourceManager.getInstance().getString("xml.slideRight", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NEmptyRackMessage", MonteroResourceManager.getInstance().getString("xml.EmptyRackMessage", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NTheEmptyRackMessage", MonteroResourceManager.getInstance().getString("xml.TheEmptyRackMessage", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NHealthStatus", MonteroResourceManager.getInstance().getString("xml.status", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NFirmwareRevision", MonteroResourceManager.getInstance().getString("xml.firmwareRevision", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NTableHdrFrmRev", MonteroResourceManager.getInstance().getString("xml.TableHdrFrmRev", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NACInput", MonteroResourceManager.getInstance().getString("xml.acInput", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NTemp", MonteroResourceManager.getInstance().getString("xml.Temp", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NTrip", MonteroResourceManager.getInstance().getString("xml.Trip", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NFail", MonteroResourceManager.getInstance().getString("xml.Fail", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NCF", MonteroResourceManager.getInstance().getString("xml.CF", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NStatus", MonteroResourceManager.getInstance().getString("xml.Status", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NInputTemperature", MonteroResourceManager.getInstance().getString("xml.InputTemperature", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NGraph", MonteroResourceManager.getInstance().getString("xml.Graph", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NOutputTemperature", MonteroResourceManager.getInstance().getString("xml.OutputTemperature", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NA", MonteroResourceManager.getInstance().getString("xml.BayA", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NB", MonteroResourceManager.getInstance().getString("xml.BayB", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("HWStatusToolTip", MonteroResourceManager.getInstance().getString("xml.tooltip.HWSTATUS", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("AMStatusToolTip", MonteroResourceManager.getInstance().getString("xml.tooltip.AMSTATUS", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("DetailsToolTip", MonteroResourceManager.getInstance().getString("tooltip.DetailMsg", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NPhase", MonteroResourceManager.getInstance().getString("xml.pwrUnitPhase", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NSerialNumber", MonteroResourceManager.getInstance().getString("xml.serialNumber", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NPartNumber", MonteroResourceManager.getInstance().getString("xml.partNumber", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NPowerConsumption", MonteroResourceManager.getInstance().getString("xml.PowerConsumption", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NType", MonteroResourceManager.getInstance().getString("TYPE", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NEnclosureName", MonteroResourceManager.getInstance().getString("xml.enclosureName", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NNormalStatus", MonteroResourceManager.getInstance().getString("xml.Normal", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NMajorStatus", MonteroResourceManager.getInstance().getString("xml.Major", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NCriticalStatus", MonteroResourceManager.getInstance().getString("xml.Critical", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NFANS", MonteroResourceManager.getInstance().getString("xml.Fans", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NWatts", MonteroResourceManager.getInstance().getString("xml.Watts", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10OUPCAP", MonteroResourceManager.getInstance().getString("xml.OutCap", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NEClass14Message", MonteroResourceManager.getInstance().getString("xml.eClassMessage", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NCautionStatus", MonteroResourceManager.getInstance().getString("xml.caution", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NPOWERSUPPLY", MonteroResourceManager.getInstance().getString("xml.PowerSupply", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NLeftPSU", MonteroResourceManager.getInstance().getString("xml.LeftPSU", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NRightPSU", MonteroResourceManager.getInstance().getString("xml.RightPSU", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NProductName", MonteroResourceManager.getInstance().getString("xml.Name", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NProductModel", MonteroResourceManager.getInstance().getString("xml.Model", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NRole", MonteroResourceManager.getInstance().getString("xml.Role", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NEnclChkBxTitle", MonteroResourceManager.getInstance().getString("xml.EnclChkBxTitle", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NRackChkBxTitle", MonteroResourceManager.getInstance().getString("xml.RackChkBxTitle", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NPartnerDevice", MonteroResourceManager.getInstance().getString("xml.PartnerDevice", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NNotAvailable", MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NIPAddress", MonteroResourceManager.getInstance().getString("xml.IPAddress", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NOS", MonteroResourceManager.getInstance().getString("xml.OSName", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NSerialNumber", MonteroResourceManager.getInstance().getString("xml.serialNumber", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NSysROMVersion", MonteroResourceManager.getInstance().getString("xml.SysROMVersion", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NMgmtProcFMVersion", MonteroResourceManager.getInstance().getString("xml.MgmtProcFMVersion", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NMgmtProcIP", MonteroResourceManager.getInstance().getString("xml.MgmtProcIP", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NInsightMgmtVersion", MonteroResourceManager.getInstance().getString("xml.InsightMgmtVersion", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NFMVer", MonteroResourceManager.getInstance().getString("xml.FirmwareVersion", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NMezzDevice", MonteroResourceManager.getInstance().getString("xml.MezzDevice", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NMediaType", MonteroResourceManager.getInstance().getString("xml.MediaType", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("Loading", MonteroResourceManager.getInstance().getString("page.loading", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NVmEnv", MonteroResourceManager.getInstance().getString("xml.VMEnvironment", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NVmCount", MonteroResourceManager.getInstance().getString("xml.VMCount", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NAllEMs", MonteroResourceManager.getInstance().getString("xml.EnclosureManager", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NEnclosureAmbientTemp", MonteroResourceManager.getInstance().getString("xml.ENCLAMBTEMP", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NPowerUsed", MonteroResourceManager.getInstance().getString("xml.POWERUSED", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NCurSpeedRPM", MonteroResourceManager.getInstance().getString("xml.RPMSPEED", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NFAN", MonteroResourceManager.getInstance().getString("xml.Fan", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NACTIVEOA", MonteroResourceManager.getInstance().getString("xml.activeOA", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NSTANDBYOA", MonteroResourceManager.getInstance().getString("xml.passiveOA", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NPIM", MonteroResourceManager.getInstance().getString("xml.pim", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NPrintableEnclosureDetails", MonteroResourceManager.getInstance().getString("PrintableEnclosureDetails", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NAddEnclosureToRack", MonteroResourceManager.getInstance().getString("uRack.AddEnclToaRack", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NRackName", MonteroResourceManager.getInstance().getString("xml.rName", this.m_loginBean.getLocale())));
        i18n.addContent((Content)BPVXML.createElement("L10NInsightDisplay", MonteroResourceManager.getInstance().getString("insight.Display", this.m_loginBean.getLocale())));
        root.addContent((Content)i18n);
        Document xmlDoc = root.getDocument();
        if (xmlDoc == null) {
            xmlDoc = new Document(root);
        }
        String nodeXml = null;
        try {
            XMLOutputter serializer = new XMLOutputter();
            serializer.setFormat(Format.getPrettyFormat());
            serializer.getFormat().setLineSeparator(System.getProperty("line.separator"));
            nodeXml = serializer.outputString(xmlDoc);
        }
        catch (Exception e) {
            LOGGER.panic("Unable to render the XML,Exception" + e.getMessage());
        }
        LOGGER.exit("MxBPV.getXML()");
        return nodeXml;
    }

    private Element renderXML() throws MxBPVException {
        LOGGER.enter("MxBPV.renderXML()");
        if (this.m_element != null) {
            LOGGER.fine("Name of Element:" + this.m_element.getName());
            return this.m_element.renderXML();
        }
        LOGGER.exit("MxBPV.renderXML()");
        throw new MxBPVException("m_element is null,Exception while rendering BPV.");
    }

    public String getListViewURL() throws Exception {
        if (this.m_element == null) {
            return "";
        }
        MxNode node = this.m_element.getNode();
        if (this.m_listViewURL.equals("") || !node.getDiscoveredName().equalsIgnoreCase(this.m_discoveredName)) {
            this.m_discoveredName = node.getDiscoveredName().toString();
            MxQueryClient queryClient = this.m_loginBean.getQueryClient();
            Query query = null;
            try {
                query = queryClient.getQuery(node.getNameString() + "_bpvList");
            }
            catch (UndefinedQueryException e) {
                // empty catch block
            }
            if (query != null) {
                this.m_listViewId = query.getQueryId();
            } else {
                CriteriaDataObjectFactory criteriaFactory = queryClient.getCriteriaFactory();
                CriteriaDataObject criteria = node.getDeviceType().equals("Rack") ? criteriaFactory.getObject("CriteriaByRack") : criteriaFactory.getObject("CriteriaByEnclosure");
                criteria.addCriteriaValue(node.getNameString());
                Query newQuery = new Query(node.getNameString() + "_bpvList", QueryType.DEVICE.toString());
                newQuery.setDynamic(true);
                newQuery.addCriteriaObject(criteria, this.m_loginBean.getLocale());
                this.m_listViewId = queryClient.addQuery(newQuery, this.m_loginBean.getLocale());
            }
            this.m_listViewURL = "/ui/jsp/XeHdr.jsp?PageName=viewContentsDevices&viewid=" + Integer.toString(this.m_listViewId) + "&topMenuIndex=1&BigPictureView=" + Integer.toString(node.getKey()) + "&ViewType=DeviceViews&retainSelection=1" + "&queryDisplayName=" + node.getNameString() + "&expandAll=true" + "&noSwitchTabs=true" + "&deviceGUID=" + this.m_element.getNode().getGUID().toString();
        }
        return this.m_listViewURL;
    }

    public String getTreeViewURL() throws Exception {
        if (this.m_element == null) {
            return "";
        }
        MxNode node = this.m_element.getNode();
        int devKey = node.getDeviceKey();
        if (this.m_treeViewURL.equals("") || !node.getDiscoveredName().equalsIgnoreCase(this.m_discoveredName)) {
            this.m_discoveredName = node.getDiscoveredName().toString();
            MxQueryClient queryClient = this.m_loginBean.getQueryClient();
            Query query = null;
            try {
                query = queryClient.getQuery(node.getNameString() + "_bpvTree");
            }
            catch (UndefinedQueryException e) {
                // empty catch block
            }
            if (query != null) {
                this.m_treeViewId = query.getQueryId();
            } else {
                NodeAssociationsClient myNodeAssocClient = this.m_loginBean.getNodeAssociationsClient();
                CriteriaDataObjectFactory criteriaFactory = queryClient.getCriteriaFactory();
                DefaultMutableTreeNode root = myNodeAssocClient.getContainerDeviceTree(devKey);
                Enumeration<TreeNode> childList = root.children();
                CriteriaDataObject criteria = criteriaFactory.getObject("CriteriaByName");
                DefaultMutableTreeNode tmpNode = null;
                Object tmpUserObj = null;
                int tmpDevKey = 0;
                MxNode tmpDevNode = null;
                String szTmpDevName = "";
                boolean bHasChildren = false;
                MxNodeClient nodeClient = this.m_loginBean.getNodeClient();
                while (childList.hasMoreElements()) {
                    bHasChildren = true;
                    tmpNode = (DefaultMutableTreeNode)childList.nextElement();
                    tmpUserObj = tmpNode.getUserObject();
                    if (tmpUserObj == null || (tmpDevNode = nodeClient.getNodeByKey(tmpDevKey = ((Integer)tmpUserObj).intValue(), false)) == null) continue;
                    szTmpDevName = tmpDevNode.getDeviceName();
                    criteria.addCriteriaValue(szTmpDevName);
                }
                if (!bHasChildren) {
                    criteria.addCriteriaValue("bpvListTree_WeirdoNoName");
                }
                Query newQuery = new Query(node.getNameString() + "_bpvListTree", QueryType.DEVICE.toString());
                newQuery.setDynamic(true);
                newQuery.addCriteriaObject(criteria, this.m_loginBean.getLocale());
                this.m_treeViewId = queryClient.addQuery(newQuery, this.m_loginBean.getLocale());
            }
            this.m_treeViewURL = "/ui/jsp/XeHdr.jsp?PageName=viewContentsDevices&viewid=" + Integer.toString(this.m_listViewId) + "&treeViewId=" + Integer.toString(this.m_treeViewId) + "&topMenuIndex=1&BigPictureView=" + Integer.toString(node.getKey()) + "&ViewType=DeviceViews&retainSelection=1" + "&queryDisplayName=" + node.getNameString() + "&expandAll=true" + "&viewMode=tree" + "&noSwitchTabs=true" + "&deviceGUID=" + this.m_element.getNode().getGUID().toString();
            this.m_listViewURL = this.m_listViewURL + "&treeViewId=" + Integer.toString(this.m_treeViewId);
            this.m_iconViewURL = this.m_iconViewURL + "&treeViewId=" + Integer.toString(this.m_treeViewId);
        }
        return this.m_treeViewURL;
    }

    public String getIconViewURL() throws Exception {
        if (this.m_element == null) {
            return "";
        }
        if (this.m_iconViewURL.equals("") && !this.getListViewURL().equals("")) {
            this.m_iconViewURL = this.getListViewURL() + "&viewMode=icon";
        }
        return this.m_iconViewURL;
    }
}

