/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.tools.datacollection.http.oa.OAHelper;
import com.hp.mx.security.SsoManager;
import com.hp.mx.utilities.DebugSubsystem;

public class EMProxyBean {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(EMProxyBean.class);

    public MxNode getPrimaryOANode(String enclSerNum) throws Exception {
        LOGGER.enter("EMProxyBean.getPrimaryOAIP(" + enclSerNum + ")");
        MxNode oaMxNode = null;
        if (enclSerNum != null) {
            NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            int enclosureDeviveKey = nodeAssociationsManager.getAssociatedDeviceKey(enclSerNum, 14);
            try {
                MxNode enclosureMxNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(enclosureDeviveKey);
                oaMxNode = OAHelper.getOAHelper().getOAMxNode(enclosureMxNode);
            }
            catch (MxUndefinedNodeException e) {
                LOGGER.fine("Unbale to obtain a physical OA because enclosure Node was not found with device key:" + enclosureDeviveKey + " Exception:" + (Object)((Object)e));
            }
        }
        if (oaMxNode == null) {
            LOGGER.exit("EMProxyBean.getPrimaryOAIP(" + enclSerNum + ")");
            throw new Exception("Unable to determine primary/secondary OA, http/s is disabled or Invalid enclosure serial number");
        }
        return oaMxNode;
    }

    public String getOAURL(MxNode oaMxNode) {
        float fwri;
        String fwRevision = oaMxNode.getClientAttribute("OA_FWRI");
        float SSO_SUPPORTED_OA_FWRI = 1.2f;
        String oaURL = "https://" + oaMxNode.getWorkingAddress();
        if (fwRevision != null && fwRevision.matches("\\d*(.)?\\d*") && (fwri = Float.parseFloat(fwRevision)) >= 1.2f) {
            oaURL = SsoManager.createCmsPageSsoUrl((String)("https://" + oaMxNode.getWorkingAddress()), (MxNode)oaMxNode, (int)2, (String)"oa");
        }
        return oaURL;
    }
}

