/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal.bpv;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MgmtProtoType_t;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.objectmodel.MxObjectPersistenceException;
import com.hp.mx.core.tools.datacollection.http.iLO.BladeEnclosure;
import com.hp.mx.core.tools.datacollection.http.iLO.PowerEnclosure;
import com.hp.mx.core.tools.datacollection.http.iLO.PowerUnit;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.portal.bpv.MxBPVDesktop;
import com.hp.mx.portal.bpv.MxBPVElement;
import com.hp.mx.portal.bpv.MxBPVPowerSupplyEnclosure;
import com.hp.mx.portal.bpv.MxBPVServer;
import com.hp.mx.portal.bpv.MxBPVServerEnclosure;
import com.hp.mx.portal.bpv.MxBPVSwitch;
import com.hp.mx.portal.core.MxDrillDown;
import com.hp.mx.portal.device.MxDeviceBean;
import com.hp.mx.portal.i18n.MonteroResourceManager;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.portal.utils.MonteroVMUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPVXML {
    private static final DebugSubsystem m_logger = new DebugSubsystem(BPVXML.class);
    private static BPVXML m_bpvXml = null;
    private MonteroResourceManager manager = MonteroResourceManager.getInstance();
    private MxNode rackNode = null;

    private BPVXML() {
    }

    public static BPVXML getInstance() {
        if (m_bpvXml == null) {
            m_bpvXml = new BPVXML();
        }
        return m_bpvXml;
    }

    public Element createDevice(MxBPVElement element, boolean isEmptyBay, MxLoginBean loginBean) {
        m_logger.enter("BPVXML.createDevice(MxBPVElement " + element + "boolean" + isEmptyBay + ")");
        Element deviceEle = BPVXML.createElement("Device", null);
        String[] deviceAttr = new String[]{"location", "bayType"};
        int slotsUsedXDirection = element.getNumSlotsUsedXDir();
        int slotsUsedYDirection = element.getNumSlotsUsedYDir();
        if (!isEmptyBay) {
            MxNode node = element.getNode();
            deviceEle.addContent((Content)BPVXML.createElement("SerialNum", node.getSerialNumber()));
            deviceEle.addContent((Content)BPVXML.createElement("hasDevice", "PRESENT"));
            Element status = BPVXML.createElement("Status", null);
            status.addContent((Content)BPVXML.createElement("UID", element.getStatus()));
            status.addContent((Content)BPVXML.createElement("Title", this.manager.getString("xml." + element.getStatus(), element.getLoginBean().getLocale())));
            deviceEle.addContent((Content)status);
            Element common = BPVXML.createElement("Common", null);
            common.addContent((Content)BPVXML.createElement("Name", node.getNameString()));
            String productName = node.getModel();
            common.addContent((Content)BPVXML.createElement("Product", productName));
            common.addContent((Content)BPVXML.createElement("NodeId", node.getGUID().toString()));
            common.addContent((Content)BPVXML.createElement("IPAddress", BPVXML.checkValue(node.getWorkingAddress(), loginBean)));
            common.addContent((Content)BPVXML.createElement("SerialNumber", BPVXML.checkValue(node.getSerialNumber(), loginBean)));
            if (element instanceof MxBPVServer) {
                MxBPVServer server = (MxBPVServer)element;
                m_logger.fine("Server Status" + element.getStatus());
                common.addContent((Content)BPVXML.createElement("DrillDownURL", server.getDrillDownURL(MxDrillDown.DEVICE_NAME_DRILL_DOWN)));
                if (element.getNode().getIsProtocolSupported(MgmtProtoType_t.SMH_PROTO)) {
                    common.addContent((Content)BPVXML.createElement("HomePageURL", server.getDrillDownURL(MxDrillDown.HW_STATUS_DRILL_DOWN)));
                } else {
                    String propertyPageURL = null;
                    try {
                        boolean PROPERTY_STATUS = true;
                        MxDeviceBean devBean = new MxDeviceBean();
                        devBean.initialize(server.getGUID(), loginBean);
                        propertyPageURL = devBean.getPropertyPageUrl(loginBean, 1);
                        if (propertyPageURL != null) {
                            common.addContent((Content)BPVXML.createElement("HomePageURL", server.getPropertyPageURL("PropertyPage", propertyPageURL)));
                        }
                    }
                    catch (Throwable e) {
                        m_logger.fine("PropertyPageURL not supported on this server, Name:" + server.getName());
                    }
                }
                common.addContent((Content)BPVXML.createElement("OS", BPVXML.checkValue(node.getOSNameStr(), loginBean)));
                MxNode iLONode = BPVXML.getiLONode(node.getDeviceKey());
                if (iLONode != null) {
                    common.addContent((Content)BPVXML.createElement("iLOIP", BPVXML.checkValue(iLONode.getWorkingAddress(), loginBean)));
                } else {
                    common.addContent((Content)BPVXML.createElement("iLOIP", this.manager.getString("NOT_AVAILABLE", loginBean.getLocale())));
                }
                deviceEle.addContent((Content)common);
                Element vmHost = BPVXML.createElement("VmHost", null);
                MonteroVMUtils m_vmUtil = new MonteroVMUtils();
                if (m_vmUtil.isVmHost(node)) {
                    vmHost.addContent((Content)BPVXML.createElement("isVmHost", "Yes"));
                    vmHost.addContent((Content)BPVXML.createElement("VmGuestCount", Integer.toString(m_vmUtil.getVMGuestCount(node))));
                    if (m_vmUtil.isVmESXHost(node)) {
                        vmHost.addContent((Content)BPVXML.createElement("VmHostName", "VmWare ESX Server"));
                    } else {
                        vmHost.addContent((Content)BPVXML.createElement("VmHostName", this.manager.getString("NOT_AVAILABLE", loginBean.getLocale())));
                    }
                } else {
                    vmHost.addContent((Content)BPVXML.createElement("isVmHost", "No"));
                }
                deviceEle.addContent((Content)vmHost);
                String[] deviceValues = new String[]{"Front", "Server"};
                this.setAttributes(deviceEle, deviceAttr, deviceValues);
                Element slots = BPVXML.createElement("SlotsUsed", null);
                slots.addContent((Content)BPVXML.createElement("XDirection", "" + slotsUsedXDirection));
                slots.addContent((Content)BPVXML.createElement("YDirection", "" + slotsUsedYDirection));
                deviceEle.addContent((Content)slots);
            } else if (element instanceof MxBPVDesktop) {
                MxBPVDesktop desktop = (MxBPVDesktop)element;
                m_logger.fine("Desktop Status" + element.getStatus());
                common.addContent((Content)BPVXML.createElement("OS", BPVXML.checkValue(node.getOSNameStr(), loginBean)));
                common.addContent((Content)BPVXML.createElement("DrillDownURL", desktop.getDrillDownURL()));
                String propertyPageURL = null;
                try {
                    boolean PROPERTY_STATUS = true;
                    MxDeviceBean devBean = new MxDeviceBean();
                    devBean.initialize(desktop.getGUID(), loginBean);
                    propertyPageURL = devBean.getPropertyPageUrl(loginBean, 1);
                    if (propertyPageURL != null) {
                        common.addContent((Content)BPVXML.createElement("HomePageURL", desktop.getPropertyPageURL("PropertyPage", propertyPageURL)));
                    }
                }
                catch (Throwable e) {
                    m_logger.fine("PropertyPageURL not supported on this server, Name:" + desktop.getName());
                }
                deviceEle.addContent((Content)common);
                String[] deviceValues = new String[]{"Front", "Server"};
                this.setAttributes(deviceEle, deviceAttr, deviceValues);
                Element slots = BPVXML.createElement("SlotsUsed", null);
                slots.addContent((Content)BPVXML.createElement("XDirection", "" + slotsUsedXDirection));
                slots.addContent((Content)BPVXML.createElement("YDirection", "" + slotsUsedYDirection));
                deviceEle.addContent((Content)slots);
            } else if (element instanceof MxBPVSwitch) {
                MxBPVSwitch switches = (MxBPVSwitch)element;
                m_logger.fine("Switch Status" + element.getStatus());
                String DUKES_ATTRIBUTE = node.getClientAttribute("LOCATION");
                m_logger.fine("DUKES_ATTRIBUTE:" + DUKES_ATTRIBUTE);
                String location = "Front";
                if (DUKES_ATTRIBUTE != null && DUKES_ATTRIBUTE.equalsIgnoreCase("RearUpperCube")) {
                    m_logger.fine("Dukes Switch:" + element.getName().toString());
                    location = "Rear";
                    slotsUsedXDirection = 1;
                    slotsUsedYDirection = 1;
                }
                common.addContent((Content)BPVXML.createElement("DrillDownURL", switches.getDrillDownURL()));
                deviceEle.addContent((Content)common);
                Element slots = BPVXML.createElement("SlotsUsed", null);
                slots.addContent((Content)BPVXML.createElement("XDirection", "" + slotsUsedXDirection));
                slots.addContent((Content)BPVXML.createElement("YDirection", "" + slotsUsedYDirection));
                deviceEle.addContent((Content)slots);
                String[] deviceValues = new String[]{location, "Switch"};
                this.setAttributes(deviceEle, deviceAttr, deviceValues);
            }
        } else {
            String bayType = "Server";
            if (element.getSlotNumber() == 0 || element.getSlotNumber() == 9999) {
                bayType = "Switch";
            }
            String[] deviceValues = new String[]{"Front", bayType};
            this.setAttributes(deviceEle, deviceAttr, deviceValues);
            Element slots = BPVXML.createElement("SlotsUsed", null);
            slots.addContent((Content)BPVXML.createElement("XDirection", "" + slotsUsedXDirection));
            slots.addContent((Content)BPVXML.createElement("YDirection", "" + slotsUsedYDirection));
            deviceEle.addContent((Content)slots);
            deviceEle.addContent((Content)BPVXML.createElement("hasDevice", "ABSENT"));
        }
        deviceEle.addContent((Content)BPVXML.createElement("SlotNumber", "" + element.getSlotNumber()));
        m_logger.exit("BPVXML.createDevice(MxBPVElement " + element + "boolean" + isEmptyBay + ")");
        return deviceEle;
    }

    public Element createPowerSupplyEnclosure(MxBPVPowerSupplyEnclosure element, MxLoginBean loginBean) {
        String enclLoadBalWire;
        m_logger.enter("BPVXML.createPowerSupplyEnclosure(MxBPVElement " + element + "MxLoginBean " + loginBean);
        boolean iloPresent = false;
        MxNode powerEnclNode = element.getNode();
        PowerEnclosure powerEnclosure = element.getPowerEnclosure();
        Element powersupply = this.createRoot("PowerSupplyEnclosure");
        MxBPVPowerSupplyEnclosure powerElement = element;
        String sizeOfEnc = powerElement.getTypeOfEnclosure();
        m_logger.fine("Type of power enclosure:" + sizeOfEnc);
        iloPresent = false;
        ArrayList<String> powerLocation = new ArrayList<String>();
        ArrayList<String> pwrunitsStatus = new ArrayList<String>();
        List<PowerUnit> powerUnitList = powerEnclosure.getPowerUnitList();
        Iterator<PowerUnit> powerUnitIter = powerUnitList.iterator();
        while (powerUnitIter.hasNext()) {
            iloPresent = true;
            PowerUnit powerUnit = powerUnitIter.next();
            powersupply.addContent((Content)this.createPowerUnit(powerUnit, pwrunitsStatus, loginBean));
            powerLocation.add(powerUnit.getLocation());
        }
        Element emptyPowerSupplyUnit = null;
        for (int k = 1; k <= 6; ++k) {
            if (powerLocation.contains(new String(String.valueOf(k)))) continue;
            emptyPowerSupplyUnit = BPVXML.createElement("PowerSupplyUnit", null);
            emptyPowerSupplyUnit.addContent((Content)BPVXML.createElement("hasDevice", "ABSENT"));
            emptyPowerSupplyUnit.addContent((Content)BPVXML.createElement("BayNumber", String.valueOf(k)));
            Element status = BPVXML.createElement("Status", null);
            status.addContent((Content)BPVXML.createElement("Value", "Informational"));
            status.addContent((Content)BPVXML.createElement("Title", this.manager.getString("xml.Informational", loginBean.getLocale())));
            emptyPowerSupplyUnit.addContent((Content)status);
            pwrunitsStatus.add("Unknown");
            powersupply.addContent((Content)emptyPowerSupplyUnit);
        }
        String status = null;
        for (int i = 0; i < pwrunitsStatus.size(); ++i) {
            m_logger.fine("Power Unit Status:" + pwrunitsStatus.get(i));
        }
        status = pwrunitsStatus.contains("Critical") ? "Critical" : (pwrunitsStatus.contains("Minor") ? "Minor" : (pwrunitsStatus.contains("Normal") ? "Normal" : "Unknown"));
        this.setValuesToAttribute(powersupply, element, loginBean, false);
        String[] pwrSupplyStrings = new String[]{"name", "size", "iloPresent", "type", "titleStatus", "startU", "endU"};
        String startU = null;
        String endU = null;
        startU = element.getNode().getClientAttribute("enclStartU") != null && element.getNode().getClientAttribute("enclStartU").length() > 0 ? element.getNode().getClientAttribute("enclStartU") : "NOT AVAILABLE";
        endU = element.getNode().getClientAttribute("enclEndU") != null && element.getNode().getClientAttribute("enclEndU").length() > 0 ? element.getNode().getClientAttribute("enclEndU") : "NOT AVAILABLE";
        String[] pwrSupplyValues = new String[]{powerEnclNode.getNameString(), sizeOfEnc, iloPresent ? "Yes" : "No", NodeSubTypeMapper.PCLASS_SUBTYPE.toString(), this.manager.getString("xml." + status, loginBean.getLocale()), startU, endU};
        this.setAttributes(powersupply, pwrSupplyStrings, pwrSupplyValues);
        Element attribute = null;
        attribute = BPVXML.createElement("Attribute", null);
        String attrString = "Section:System Status,location:Both,displayAsImage:true,Name:" + this.manager.getString("xml.status", loginBean.getLocale());
        m_logger.fine("Power enclosure status:" + status);
        this.setAttribute(attribute, attrString, status);
        powersupply.addContent((Content)attribute);
        String enclPwrRedundancy = powerEnclosure.getRedundancy();
        if (enclPwrRedundancy.length() > 0) {
            String powerRedundancyStr = "Section:Power And Thermal,location:EnclosureView,isMultiValued:true,Name:" + this.manager.getString("xml.powerRedundancy", loginBean.getLocale());
            HashMap pwrRedundancy_hashmap = this.getPowerRedundancyInfo(enclPwrRedundancy, loginBean);
            StringBuffer pwrRedundancy = new StringBuffer();
            String temp_pwrRedundancy = null;
            for (int i = 1; i <= 7; ++i) {
                temp_pwrRedundancy = (String)pwrRedundancy_hashmap.get("" + i);
                if (temp_pwrRedundancy == null) continue;
                m_logger.fine(temp_pwrRedundancy.toString());
                pwrRedundancy.append(temp_pwrRedundancy);
                pwrRedundancy.append("/");
            }
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, powerRedundancyStr, pwrRedundancy.toString());
            powersupply.addContent((Content)attribute);
        }
        if ((enclLoadBalWire = powerEnclosure.getLoadBalanceWire()).length() > 0) {
            String loadBal = "Section:Power And Thermal,location:Both,Name:" + this.manager.getString("xml.loadBalWire", loginBean.getLocale());
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, loadBal, enclLoadBalWire);
            powersupply.addContent((Content)attribute);
        }
        String sideATemp = "Section:Power And Thermal,location:EnclosureView,displayAsTemp:True,Name:" + this.manager.getString("xml.sideATemp", loginBean.getLocale());
        String sideATempValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
        int enclTemperatureA = powerEnclosure.getTemperatureA();
        if (enclTemperatureA != -1) {
            sideATempValue = String.valueOf(enclTemperatureA);
        }
        attribute = BPVXML.createElement("Attribute", null);
        this.setAttribute(attribute, sideATemp, sideATempValue);
        powersupply.addContent((Content)attribute);
        String centerTemp = "Section:Power And Thermal,location:EnclosureView,displayAsTemp:True,Name:" + this.manager.getString("xml.CenterTemp", loginBean.getLocale());
        String centerTempValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
        int enclTemperature = powerEnclosure.getCenterTemperature();
        if (enclTemperature != -1) {
            centerTempValue = String.valueOf(enclTemperature);
        }
        attribute = BPVXML.createElement("Attribute", null);
        this.setAttribute(attribute, centerTemp, centerTempValue);
        powersupply.addContent((Content)attribute);
        String sideBTemp = "Section:Power And Thermal,location:EnclosureView,displayAsTemp:True,Name:" + this.manager.getString("xml.sideBTemp", loginBean.getLocale());
        String sideBTempValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
        int enclTemperatureB = powerEnclosure.getTemperatureB();
        if (enclTemperatureB != -1) {
            sideBTempValue = String.valueOf(enclTemperatureB);
        }
        attribute = BPVXML.createElement("Attribute", null);
        this.setAttribute(attribute, sideBTemp, sideBTempValue);
        powersupply.addContent((Content)attribute);
        Element common = BPVXML.createElement("Common", null);
        common.addContent((Content)BPVXML.createElement("Name", powerEnclNode.getNameString()));
        common.addContent((Content)BPVXML.createElement("Product", sizeOfEnc));
        common.addContent((Content)BPVXML.createElement("NodeId", powerEnclNode.getGUID().toString()));
        String pwrZonevalue = "NOT_AVAILABLE";
        int powerZone = powerEnclosure.getPowerZone();
        if (powerZone != -1) {
            pwrZonevalue = String.valueOf(powerZone);
        }
        common.addContent((Content)BPVXML.createElement("PowerZone", pwrZonevalue));
        powersupply.addContent((Content)common);
        m_logger.exit("BPVXML.createPowerSupplyEnclosure(MxBPVElement " + element + "MxLoginBean " + loginBean);
        return powersupply;
    }

    private Element createPowerUnit(PowerUnit powerUnit, List<String> pwrunitsStatus, MxLoginBean loginBean) {
        Element powerSupplyUnit = BPVXML.createElement("PowerSupplyUnit", null);
        powerSupplyUnit.addContent((Content)BPVXML.createElement("hasDevice", "PRESENT"));
        powerSupplyUnit.addContent((Content)BPVXML.createElement("FrmRev", powerUnit.getFWRI()));
        powerSupplyUnit.addContent((Content)BPVXML.createElement("ACInput", powerUnit.getAcInput()));
        powerSupplyUnit.addContent((Content)BPVXML.createElement("InputTempC", String.valueOf(powerUnit.getInputTemp())));
        powerSupplyUnit.addContent((Content)BPVXML.createElement("InTempTripC", String.valueOf(powerUnit.getInputTempTrip())));
        powerSupplyUnit.addContent((Content)BPVXML.createElement("InTempFailC", String.valueOf(powerUnit.getInputTempFail())));
        powerSupplyUnit.addContent((Content)BPVXML.createElement("OutTempC", String.valueOf(powerUnit.getOutputTemp())));
        powerSupplyUnit.addContent((Content)BPVXML.createElement("OutputTempTripC", String.valueOf(powerUnit.getOutputTempTrip())));
        powerSupplyUnit.addContent((Content)BPVXML.createElement("OutTempFailC", String.valueOf(powerUnit.getOutTempFail())));
        powerSupplyUnit.addContent((Content)BPVXML.createElement("BayNumber", powerUnit.getLocation()));
        String puStatus = this.getPUStatus(powerUnit.getLocation(), powerUnit.getAcInput(), true, powerUnit.getInputTemp(), powerUnit.getInputTempTrip(), powerUnit.getInputTempFail(), powerUnit.getOutputTemp(), powerUnit.getOutputTempTrip(), powerUnit.getOutTempFail());
        Element status = BPVXML.createElement("Status", null);
        status.addContent((Content)BPVXML.createElement("Value", puStatus));
        status.addContent((Content)BPVXML.createElement("Title", this.manager.getString("xml." + puStatus, loginBean.getLocale())));
        powerSupplyUnit.addContent((Content)status);
        pwrunitsStatus.add(puStatus);
        return powerSupplyUnit;
    }

    private String getPUStatus(String location, String acInput, boolean iloPresent, double pwrSupplyInputTemp, double pwrSupplyInputTempTrip, double pwrSupplyInputTempFail, double pwrSupplyOutputTemp, double pwrSupplyOutputTempTrip, double pwrSupplyOutputTempFail) {
        String status;
        m_logger.enter("BPVXML.getPUStatus()");
        m_logger.fine("Location:" + location);
        m_logger.fine("InputTemp:" + pwrSupplyInputTemp);
        m_logger.fine("InputTempTrip:" + pwrSupplyInputTempTrip);
        m_logger.fine("InputTempFail:" + pwrSupplyInputTempFail);
        m_logger.fine("OutputTemp:" + pwrSupplyOutputTemp);
        m_logger.fine("OutputTempTrip:" + pwrSupplyOutputTempTrip);
        m_logger.fine("OutputTempFail:" + pwrSupplyOutputTempFail);
        if (location != null && location.equalsIgnoreCase("-1")) {
            status = "Unknown";
        } else if (acInput.equalsIgnoreCase("Good")) {
            status = "Normal";
            if (pwrSupplyInputTemp < pwrSupplyInputTempTrip && pwrSupplyOutputTemp < pwrSupplyOutputTempTrip) {
                status = "Normal";
            } else if (pwrSupplyInputTemp > pwrSupplyInputTempTrip && pwrSupplyOutputTemp > pwrSupplyOutputTempTrip) {
                status = "Minor";
            } else if (pwrSupplyInputTemp > pwrSupplyInputTempFail && pwrSupplyOutputTemp > pwrSupplyOutputTempFail) {
                status = "Critical";
            }
        } else {
            status = !location.equalsIgnoreCase("-1") ? "Critical" : (iloPresent ? "noStatus" : "Unknown");
        }
        m_logger.fine("Status:" + status);
        m_logger.exit("BPVXML.getPUStatus()");
        return status;
    }

    public Element createBladeEnclosure(MxBPVServerEnclosure element, MxLoginBean loginBean) {
        m_logger.enter("BPVXML.createBladeEnclosure(MxBPVElement " + element + "MxLoginBean " + loginBean);
        BladeEnclosure bladeEnclosure = element.getBladeEnclosure();
        MxNode bladeEnclNode = element.getNode();
        Element bladeEncl = this.createRoot("BladeEnclosure");
        String[] bladeEnclStrings = new String[]{"type", "titleStatus", "startU", "endU"};
        String typeOfEnclosure = MxBPVServerEnclosure.getEnclosureSubType(element.getNode());
        boolean isEClassEnclosure = false;
        if (typeOfEnclosure.equalsIgnoreCase(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
            isEClassEnclosure = true;
        }
        String startU = null;
        String endU = null;
        startU = bladeEnclNode.getClientAttribute("enclStartU") != null && bladeEnclNode.getClientAttribute("enclStartU").length() > 0 ? bladeEnclNode.getClientAttribute("enclStartU") : "NOT AVAILABLE";
        endU = bladeEnclNode.getClientAttribute("enclEndU") != null && bladeEnclNode.getClientAttribute("enclEndU").length() > 0 ? bladeEnclNode.getClientAttribute("enclEndU") : "NOT AVAILABLE";
        String[] bladeEnclValues = new String[]{typeOfEnclosure, this.manager.getString("xml." + element.getStatus(), loginBean.getLocale()), startU, endU};
        this.setAttributes(bladeEncl, bladeEnclStrings, bladeEnclValues);
        this.setValuesToAttribute(bladeEncl, element, loginBean, isEClassEnclosure);
        Element attribute = BPVXML.createElement("Attribute", null);
        String attrString = "Section:System Status,location:Both,displayAsImage:true,Name:" + this.manager.getString("xml.status", loginBean.getLocale());
        m_logger.fine("Enclosure HW Status " + element.getStatus());
        String attrValue = element.getStatus();
        this.setAttribute(attribute, attrString, attrValue);
        bladeEncl.addContent((Content)attribute);
        Element common = BPVXML.createElement("Common", null);
        if (!isEClassEnclosure) {
            String temp = "Section:Identification,location:Both,Name:" + this.manager.getString("xml.Temperature", loginBean.getLocale());
            String temperature = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
            int enclTemperature = bladeEnclosure.getTemperature();
            if (enclTemperature != -1) {
                double temperatureC = (double)((int)(((double)enclTemperature * 1.8 + 32.0) * 100.0)) / 100.0;
                temperature = String.valueOf(enclTemperature) + " / " + temperatureC;
            }
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, temp, temperature);
            bladeEncl.addContent((Content)attribute);
            String pwrZonevalue = "NOT_AVAILABLE";
            int powerZone = bladeEnclosure.getPowerZone();
            if (powerZone != -1) {
                pwrZonevalue = String.valueOf(powerZone);
            }
            common.addContent((Content)BPVXML.createElement("PowerZone", pwrZonevalue));
        }
        common.addContent((Content)BPVXML.createElement("NodeId", bladeEnclNode.getGUID().toString()));
        bladeEncl.addContent((Content)common);
        m_logger.enter("BPVXML.createBladeEnclosure(MxBPVElement " + element + "MxLoginBean " + loginBean);
        return bladeEncl;
    }

    public Element createRack(MxBPVElement element, MxLoginBean loginBean, boolean hasChildren) {
        m_logger.enter("BPVXML.createRack(" + element.toString() + ")");
        this.rackNode = element.getNode();
        Element root = this.createRoot("Rack");
        List deviceSubTypes = element.getNode().getDeviceSubTypes();
        Object subtype = null;
        if (!hasChildren) {
            root.setAttribute("Empty", "true");
        } else {
            root.setAttribute("Empty", "false");
        }
        root.setAttribute("type", "rack");
        Element common = BPVXML.createElement("Common", null);
        common.addContent((Content)BPVXML.createElement("Name", this.rackNode.getNameString()));
        common.addContent((Content)BPVXML.createElement("Product", this.rackNode.getDeviceType()));
        common.addContent((Content)BPVXML.createElement("NodeId", this.rackNode.getObjectID().toString()));
        common.addContent((Content)BPVXML.createElement("DrillDownURL", "/mxportal/drilldown/MxDrillDown.jsp?deviceGUID=" + this.rackNode.getGUID().toString() + "&drillDownType=DrillDownType-DeviceName&globalselection=true"));
        root.addContent((Content)common);
        root.addContent((Content)BPVXML.createElement("SerialNum", "TODO"));
        String[] nameStrings = new String[]{"Section:General,Name:RUID", "Section:General,Name:Rack Name,location:Both", "Section:System Status,Name:Health Status,location:Both,displayAsImage:true"};
        String[] nameValues = new String[]{"TODO", this.rackNode.getNameString(), element.getStatus()};
        Element attribute = null;
        for (int i = 0; i < nameValues.length; ++i) {
            attribute = BPVXML.createElement("Attribute", "");
            this.setAttribute(attribute, nameStrings[i], nameValues[i]);
            root.addContent((Content)attribute);
        }
        m_logger.exit("BPVXML.createRack(" + element.toString() + ")");
        return root;
    }

    private void setValuesToAttribute(Element element, MxBPVElement bpvElement, MxLoginBean loginBean, boolean isEClassEnclosure) {
        m_logger.enter("BPVXML.setValuesToAttribute(Element " + element + ",MxNode " + bpvElement.getNode().getNameString() + "loginBean " + loginBean + ")");
        MxNode node = bpvElement.getNode();
        Element attribute = null;
        String enclName = "Section:Identification,URL:/mxportal/drilldown/MxDrillDown.jsp?deviceGUID=" + node.getGUID() + "&drillDownType=DrillDownType-DeviceName" + "&globalselection=true" + ",displayAsURL:true,location:RackView,Name:" + this.manager.getString("xml.enclosureName", loginBean.getLocale());
        String enclNameVal = node.getNameString();
        if (enclNameVal.equalsIgnoreCase("") || enclNameVal == null) {
            enclNameVal = MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", loginBean.getLocale());
        }
        attribute = BPVXML.createElement("Attribute", null);
        this.setAttribute(attribute, enclName, enclNameVal);
        element.addContent((Content)attribute);
        String serialNo = "Section:Identification,location:Both,Name:" + this.manager.getString("xml.serialNumber", loginBean.getLocale());
        String serialNoValue = node.getSerialNumber();
        if (serialNoValue.equalsIgnoreCase("") || serialNoValue == null) {
            serialNoValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
        }
        attribute = BPVXML.createElement("Attribute", null);
        this.setAttribute(attribute, serialNo, serialNoValue);
        element.addContent((Content)attribute);
        if (!isEClassEnclosure) {
            String enclFWRI = "";
            String enclUUIDStatus = "";
            int powerZone = -1;
            if (node.getDeviceSubTypes().contains("PowerEnc")) {
                MxBPVPowerSupplyEnclosure powerEnclosureElement = (MxBPVPowerSupplyEnclosure)bpvElement;
                PowerEnclosure powerEnclosure = powerEnclosureElement.getPowerEnclosure();
                enclFWRI = powerEnclosure.getFwri();
                enclUUIDStatus = powerEnclosure.getUuidStatus();
                powerZone = powerEnclosure.getPowerZone();
            } else {
                MxBPVServerEnclosure serverEnclosureElement = (MxBPVServerEnclosure)bpvElement;
                BladeEnclosure bladeEnclosure = serverEnclosureElement.getBladeEnclosure();
                enclFWRI = bladeEnclosure.getFWRI();
                enclUUIDStatus = bladeEnclosure.getUUIDStatus();
                powerZone = bladeEnclosure.getPowerZone();
            }
            String uuid = "Section:Identification,location:Both,Name:" + this.manager.getString("xml.uuid", loginBean.getLocale());
            String uuidValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
            uuidValue = node.getAgentUUID();
            m_logger.fine("AgentUUID:" + uuidValue);
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, uuid, uuidValue);
            element.addContent((Content)attribute);
            String FWStr = "Section:Identification,location:Both,Name:" + this.manager.getString("xml.firmwareRevision", loginBean.getLocale());
            String FWValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
            if (!enclFWRI.equalsIgnoreCase("")) {
                FWValue = enclFWRI;
            }
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, FWStr, FWValue);
            element.addContent((Content)attribute);
            String pwrZoneString = "Section:Identification,location:Both,Name:" + this.manager.getString("xml.powerZone", loginBean.getLocale());
            String pwrZonevalue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
            if (powerZone != -1) {
                pwrZonevalue = String.valueOf(powerZone);
            }
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, pwrZoneString, pwrZonevalue);
            element.addContent((Content)attribute);
            String LEDStr = "Section:Identification,location:Both,displayAsImage:false,Name:" + this.manager.getString("xml.uidStatus", loginBean.getLocale());
            String LEDValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
            if (!enclUUIDStatus.equalsIgnoreCase("")) {
                LEDValue = enclUUIDStatus;
            }
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, LEDStr, LEDValue);
            element.addContent((Content)attribute);
        }
        MxNode rackNode = BPVXML.getRackNode(node);
        String rackValue = null;
        String rackName = null;
        String rackHeight = null;
        String dataCentreId = null;
        String dataCentreLoc = null;
        String rowNumber = null;
        String posInRow = null;
        String rackHeightValue = null;
        String dataCentreIdValue = null;
        String dataCentreLocValue = null;
        int rowNumberValue = 0;
        int posInRowvalue = 0;
        if (rackNode != null) {
            rackName = "Section:Identification,URL:/mxportal/drilldown/MxDrillDown.jsp?deviceGUID=" + rackNode.getGUID().toString() + "&drillDownType=DrillDownType-DeviceName&globalselection=true" + ",displayAsURL:true,location:" + "EnclosureView,Name:" + this.manager.getString("xml.rName", loginBean.getLocale());
            rackValue = rackNode.getNameString();
            rackHeight = "Section:Identification,location:EnclosureView,Name:" + this.manager.getString("xml.rHeight", loginBean.getLocale());
            dataCentreId = "Section:Identification,location:EnclosureView,Name:" + this.manager.getString("xml.rDataCentreId", loginBean.getLocale());
            dataCentreLoc = "Section:Identification,location:EnclosureView,Name:" + this.manager.getString("xml.rDataCentreLoc", loginBean.getLocale());
            rowNumber = "Section:Identification,location:EnclosureView,Name:" + this.manager.getString("xml.rRowNumber", loginBean.getLocale());
            posInRow = "Section:Identification,location:EnclosureView,Name:" + this.manager.getString("xml.rPosInRow", loginBean.getLocale());
            rackHeightValue = rackNode.getClientAttribute("rackHeight");
            dataCentreIdValue = rackNode.getClientAttribute("DataCentreID");
            dataCentreLocValue = rackNode.getClientAttribute("DataCentreLoc");
            String rowNumberStr = rackNode.getClientAttribute("RowNumber");
            String posInRowStr = rackNode.getClientAttribute("PositionRow");
            if (rowNumberStr != null && rowNumberStr.length() > 0) {
                rowNumberValue = Integer.parseInt(rowNumberStr);
            }
            if (posInRowStr != null && posInRowStr.length() > 0) {
                posInRowvalue = Integer.parseInt(posInRowStr);
            }
        } else {
            rackName = "Section:Identification,location:EnclosureView,Name:" + this.manager.getString("xml.rName", loginBean.getLocale());
            m_logger.fine("The rack device node is not created.Server Name:" + element.getName());
        }
        if (rackValue == null || rackValue.equalsIgnoreCase("")) {
            rackValue = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
        }
        attribute = BPVXML.createElement("Attribute", null);
        this.setAttribute(attribute, rackName, rackValue);
        element.addContent((Content)attribute);
        if (rackHeightValue != null && rackHeightValue.length() > 0) {
            rackHeightValue = rackHeightValue + " " + "U";
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, rackHeight, rackHeightValue);
            element.addContent((Content)attribute);
        }
        if (dataCentreIdValue != null && dataCentreIdValue.length() > 0) {
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, dataCentreId, dataCentreIdValue);
            element.addContent((Content)attribute);
        }
        if (dataCentreLocValue != null && dataCentreLocValue.length() > 0) {
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, dataCentreLoc, dataCentreLocValue);
            element.addContent((Content)attribute);
        }
        if (rowNumberValue > 0) {
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, rowNumber, String.valueOf(rowNumberValue));
            element.addContent((Content)attribute);
        }
        if (posInRowvalue > 0) {
            attribute = BPVXML.createElement("Attribute", null);
            this.setAttribute(attribute, posInRow, String.valueOf(posInRowvalue));
            element.addContent((Content)attribute);
        }
        m_logger.exit("BPVXML.setValuesToAttribute(Element " + element + ",MxNode " + node.getNameString() + "loginBean " + loginBean + ")");
    }

    public Element createImage(String statusVal, String frontVal, String rearVal, MxLoginBean loginBean) {
        Element image = BPVXML.createElement("Image", null);
        image.addContent((Content)BPVXML.createElement("Status", statusVal));
        if (loginBean != null && !statusVal.equalsIgnoreCase("NoStatus")) {
            image.addContent((Content)BPVXML.createElement("titleStatus", this.manager.getString("xml." + statusVal, loginBean.getLocale())));
        }
        image.addContent((Content)BPVXML.createElement("Front", frontVal));
        if (rearVal != null) {
            image.addContent((Content)BPVXML.createElement("Rear", rearVal));
        }
        return image;
    }

    public static Element createElement(String name, String value) {
        Element element = new Element(name);
        if (value != null) {
            element.setText(value);
        }
        return element;
    }

    public void setAttributes(Element element, String[] attrNames, String[] attrValues) {
        for (int i = 0; i < attrNames.length; ++i) {
            element.setAttribute(attrNames[i], attrValues[i]);
        }
    }

    public void setAttribute(Element element, String attrs, String value) {
        StringTokenizer tokens = new StringTokenizer(attrs, ":,", false);
        String token = null;
        String tokenValue = null;
        while (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            tokenValue = tokens.nextToken();
            if (token.compareToIgnoreCase("Name") != 0) {
                element.setAttribute(token, tokenValue);
                continue;
            }
            element.addContent((Content)BPVXML.createElement(token, tokenValue));
            element.addContent((Content)BPVXML.createElement("Value", value));
        }
    }

    public Element createRoot(String name) {
        Element root = new Element(name);
        return root;
    }

    public void createRearView(MxBPVElement enclsoureElement, Element enclosure, MxLoginBean loginBean) {
        String typeOfEnclosure = MxBPVServerEnclosure.getEnclosureSubType(enclsoureElement.getNode());
        if (typeOfEnclosure.equalsIgnoreCase(NodeSubTypeMapper.PCLASS_SUBTYPE.toString())) {
            this.createPClassRearDevice(enclsoureElement, enclosure);
        } else if (typeOfEnclosure.equalsIgnoreCase(NodeSubTypeMapper.ECLASS_SUBTYPE.toString())) {
            this.createEClassRearView(enclsoureElement, enclosure, loginBean);
        }
    }

    public void createEClassRearView(MxBPVElement bpvEnclEle, Element xmlEnclEle, MxLoginBean loginBean) {
        m_logger.enter("BPVXML.createEClassRearView(" + bpvEnclEle + "," + xmlEnclEle + ")");
        MxNode servEncl = bpvEnclEle.getNode();
        if (servEncl == null) {
            m_logger.exit("Error: Unable to retrieve the MxNode object from MxBPVElement object of e-Class server enclosure.");
            return;
        }
        String leftPowerSupply = servEncl.getClientAttribute("leftPowerSupply");
        if (leftPowerSupply == null) {
            xmlEnclEle.setAttribute("firmwareRev", "1.3");
            m_logger.fine("The firmware revision of e-Class server enclosureis < 1.4.");
            m_logger.exit("BPVXML.createEClassRearView(" + bpvEnclEle + "," + xmlEnclEle + ")");
            return;
        }
        xmlEnclEle.setAttribute("firmwareRev", "1.4");
        Element leftPwrXMLElem = BPVXML.createElement("Device", null);
        String[] deviceAttr = new String[]{"location", "bayType"};
        String[] powerSupAttrValues = new String[]{"Rear", "PowerSupply"};
        this.setAttributes(leftPwrXMLElem, deviceAttr, powerSupAttrValues);
        leftPwrXMLElem.addContent((Content)BPVXML.createElement("position", "left"));
        if (leftPowerSupply.equalsIgnoreCase("true")) {
            leftPwrXMLElem.addContent((Content)BPVXML.createElement("hasDevice", "PRESENT"));
        } else {
            leftPwrXMLElem.addContent((Content)BPVXML.createElement("hasDevice", "ABSENT"));
        }
        xmlEnclEle.addContent((Content)leftPwrXMLElem);
        String rightPowerSupply = servEncl.getClientAttribute("rightPowerSupply");
        Element rightPwrXMLElem = BPVXML.createElement("Device", null);
        this.setAttributes(rightPwrXMLElem, deviceAttr, powerSupAttrValues);
        rightPwrXMLElem.addContent((Content)BPVXML.createElement("position", "right"));
        if (rightPowerSupply.equalsIgnoreCase("true")) {
            rightPwrXMLElem.addContent((Content)BPVXML.createElement("hasDevice", "PRESENT"));
        } else {
            rightPwrXMLElem.addContent((Content)BPVXML.createElement("hasDevice", "ABSENT"));
        }
        xmlEnclEle.addContent((Content)rightPwrXMLElem);
        int switchDevKey = 0;
        try {
            NodeAssociationsManager nodeAssocMgr = NodeAssociationsManager.getDefaultManager();
            Vector swtchDevKeyLst = nodeAssocMgr.getAssociatedDevicesUsingATNs(servEncl.getDeviceKey(), "SwitchToEnclosure");
            String[] swtchAttr = new String[]{"location", "bayType"};
            String[] swtchAttrValues = new String[]{"Rear", "Switch"};
            MxNode switchNode = null;
            for (int i = 0; i < swtchDevKeyLst.size(); ++i) {
                Element switchXMLElem = BPVXML.createElement("Device", null);
                this.setAttributes(switchXMLElem, swtchAttr, swtchAttrValues);
                switchDevKey = (Integer)swtchDevKeyLst.get(i);
                switchNode = MxNodeController.getDefaultController().getNodeByKey(switchDevKey);
                if (switchNode == null) {
                    switchXMLElem.addContent((Content)BPVXML.createElement("hasDevice", "ABSENT"));
                    xmlEnclEle.addContent((Content)switchXMLElem);
                    continue;
                }
                switchXMLElem.addContent((Content)BPVXML.createElement("hasDevice", "PRESENT"));
                switchXMLElem.addContent((Content)BPVXML.createElement("SerialNum", switchNode.getSerialNumber()));
                Element statusElem = BPVXML.createElement("Status", null);
                String status = switchNode.getOverallStatus().toString();
                status = status.charAt(0) + status.substring(1, status.length()).toLowerCase();
                statusElem.addContent((Content)BPVXML.createElement("UID", status));
                statusElem.addContent((Content)BPVXML.createElement("Title", status));
                switchXMLElem.addContent((Content)statusElem);
                Element commonElem = BPVXML.createElement("Common", null);
                commonElem.addContent((Content)BPVXML.createElement("Name", switchNode.getNameString()));
                commonElem.addContent((Content)BPVXML.createElement("Product", switchNode.getModel()));
                commonElem.addContent((Content)BPVXML.createElement("IPAddress", BPVXML.checkValue(switchNode.getWorkingAddress(), loginBean)));
                commonElem.addContent((Content)BPVXML.createElement("SerialNumber", BPVXML.checkValue(switchNode.getSerialNumber(), loginBean)));
                commonElem.addContent((Content)BPVXML.createElement("NodeId", switchNode.getGUID().toString()));
                commonElem.addContent((Content)BPVXML.createElement("DrillDownURL", "/mxportal/bladeime/bpv/BladeIMENodeCheck.jsp?deviceId=" + switchDevKey + "&drillDownType=" + MxDrillDown.DEVICE_NAME_DRILL_DOWN));
                switchXMLElem.addContent((Content)commonElem);
                xmlEnclEle.addContent((Content)switchXMLElem);
            }
            if (swtchDevKeyLst.size() == 0) {
                Element switchXMLElem = BPVXML.createElement("Device", null);
                this.setAttributes(switchXMLElem, swtchAttr, swtchAttrValues);
                switchXMLElem.addContent((Content)BPVXML.createElement("hasDevice", "ABSENT"));
                xmlEnclEle.addContent((Content)switchXMLElem);
            }
        }
        catch (NodeAssociationsPersistenceException nodePers) {
        }
        catch (MxUndefinedNodeException e) {
            e.printStackTrace();
        }
        catch (MxObjectPersistenceException e) {
            e.printStackTrace();
        }
        m_logger.exit("BPVXML.createEClassRearView(" + bpvEnclEle + "," + xmlEnclEle + ")");
    }

    public void createPClassRearDevice(MxBPVElement enclsoureElement, Element enclosure) {
        String rearLoc = "Rear";
        String switchType = "Switch";
        m_logger.enter("BPVXML.createPClassRearDevice(" + enclsoureElement + "," + enclosure);
        m_logger.fine("Enclosure Name" + enclsoureElement.getName());
        if (enclsoureElement.getNumDukesSwitches() == 0) {
            Element device1 = this.createEmptySlot(0, 1, 1, switchType, rearLoc);
            enclosure.addContent((Content)device1);
            Element device3 = this.createEmptySlot(9999, 1, 1, switchType, rearLoc);
            enclosure.addContent((Content)device3);
        } else if (enclsoureElement.getNumDukesSwitches() == 1) {
            if (enclsoureElement.getDukesSlotNumbers(0) == 1) {
                Element device3 = this.createEmptySlot(9999, 1, 1, switchType, rearLoc);
                enclosure.addContent((Content)device3);
            } else if (enclsoureElement.getDukesSlotNumbers(1) == 1) {
                Element device3 = this.createEmptySlot(0, 1, 1, switchType, rearLoc);
                enclosure.addContent((Content)device3);
            }
        }
        m_logger.fine("Number Of Dukes Switches:" + enclsoureElement.getNumDukesSwitches());
        m_logger.exit("BPVXML.createPClassRearDevice(" + enclsoureElement + "," + enclosure);
    }

    public Element createEmptySlot(int slotNumber, int slotsUsedXDirection, int slotsUsedYDirection, String bayType, String pos) {
        Element emptySlot = BPVXML.createElement("Device", null);
        String[] deviceAttr = new String[]{"location", "bayType"};
        String[] deviceValues = new String[]{pos, bayType};
        this.setAttributes(emptySlot, deviceAttr, deviceValues);
        emptySlot.addContent((Content)BPVXML.createElement("hasDevice", "ABSENT"));
        emptySlot.addContent((Content)BPVXML.createElement("SlotNumber", "" + slotNumber));
        Element slotsUsed = BPVXML.createElement("SlotsUsed", null);
        slotsUsed.addContent((Content)BPVXML.createElement("XDirection", "" + slotsUsedXDirection));
        slotsUsed.addContent((Content)BPVXML.createElement("YDirection", "" + slotsUsedYDirection));
        emptySlot.addContent((Content)slotsUsed);
        return emptySlot;
    }

    private HashMap getPowerRedundancyInfo(String redundancyBit, MxLoginBean loginBean) {
        m_logger.enter("BPVXML.getPowerRedundancyInfo(" + redundancyBit + "," + loginBean);
        String[] redundancyBit_hex = new String[]{"0000", "0001", "0002", "0004", "0008", "0010", "0020", "0040", "0080", "0100", "0200", "0400", "0800", "1000", "2000", "4000", "8000"};
        int[] redundancuBit_Dec = new int[17];
        for (int i = 0; i < redundancyBit_hex.length; ++i) {
            redundancuBit_Dec[i] = Integer.parseInt(redundancyBit_hex[i].trim(), 16);
        }
        int redundancyBit_iLO = Integer.parseInt(redundancyBit.trim(), 16);
        m_logger.fine("Decimal value for the RedundancyBit retrieved from iLO:" + redundancyBit_iLO);
        HashMap<String, String> redundancyInfo = new HashMap<String, String>();
        redundancyInfo.put("1", this.manager.getString("xml.PowerRedundancy1", loginBean.getLocale()));
        redundancyInfo.put("2", this.manager.getString("xml.PowerRedundancy2", loginBean.getLocale()));
        redundancyInfo.put("6", this.manager.getString("xml.PowerRedundancy3", loginBean.getLocale()));
        for (int j = 0; j < redundancuBit_Dec.length; ++j) {
            if (redundancyBit.equalsIgnoreCase(redundancyBit_hex[j])) {
                this.updatePowerRedundacyInfo(redundancyBit_iLO, redundancyInfo);
                continue;
            }
            int resultBit = redundancyBit_iLO & redundancuBit_Dec[j];
            if (resultBit == 0 || resultBit != redundancuBit_Dec[j]) continue;
            m_logger.fine("Value part of the redundancy bit:" + redundancyBit_hex[j]);
            this.updatePowerRedundacyInfo(Integer.parseInt(redundancyBit_hex[j]), redundancyInfo);
        }
        m_logger.fine("redundancyInfo:" + redundancyInfo);
        m_logger.exit("BPVXML.getPowerRedundancyInfo(" + redundancyBit + "," + loginBean);
        return redundancyInfo;
    }

    private void updatePowerRedundacyInfo(int redundancyBit, HashMap<String, String> redundancyInfo) {
        m_logger.enter("BPVXML.updatePowerRedundacyInfo(" + redundancyBit + "," + redundancyInfo.toString());
        ResourceBundle bundle = ResourceBundle.getBundle("com.hp.mx.portal.bpv.properties.PowerRedundancy");
        switch (redundancyBit) {
            case 1: {
                redundancyInfo.put("1", bundle.getString("0001"));
                break;
            }
            case 2: {
                redundancyInfo.put("2", bundle.getString("0002"));
                break;
            }
            case 20: {
                redundancyInfo.put("3", bundle.getString("0020"));
                break;
            }
            case 40: {
                redundancyInfo.put("4", bundle.getString("0040"));
                break;
            }
            case 80: {
                redundancyInfo.put("5", bundle.getString("0080"));
                break;
            }
            case 100: {
                redundancyInfo.put("6", bundle.getString("0100"));
                break;
            }
            case 200: {
                redundancyInfo.put("7", bundle.getString("0200"));
            }
        }
        m_logger.exit("BPVXML.updatePowerRedundacyInfo(" + redundancyBit + "," + redundancyInfo.toString());
    }

    private void createFirmWareInfo(MxNode node, Element common, MxLoginBean loginBean) {
        m_logger.enter("BPVXML.createFirmWareInfo(MxLoginBean " + loginBean + ",MxNode " + node + ",Element " + common);
        if (node != null) {
            MonteroSNMPUtils snmpUtils = new MonteroSNMPUtils(loginBean);
            snmpUtils.getFirmwareDetails(node);
            String sysROMVersion = snmpUtils.getSysROMFMVer();
            common.addContent((Content)BPVXML.createElement("SysROMFMVer", BPVXML.checkValue(snmpUtils.getSysROMFMVer(), loginBean)));
            common.addContent((Content)BPVXML.createElement("RemoteInsightROMVer", BPVXML.checkValue(snmpUtils.getRemoteInsightROMFMVer(), loginBean)));
            common.addContent((Content)BPVXML.createElement("InsightMgmtVersion", BPVXML.checkValue(snmpUtils.getInsightMgmtVersion(node), loginBean)));
        } else {
            common.addContent((Content)BPVXML.createElement("SysROMFMVer", this.manager.getString("NOT_AVAILABLE", loginBean.getLocale())));
            common.addContent((Content)BPVXML.createElement("RemoteInsightROMVer", this.manager.getString("NOT_AVAILABLE", loginBean.getLocale())));
            common.addContent((Content)BPVXML.createElement("InsightMgmtVersion", this.manager.getString("NOT_AVAILABLE", loginBean.getLocale())));
        }
        m_logger.exit("BPVXML.createFirmWareInfo");
    }

    public static String checkValue(String value, MxLoginBean loginBean) {
        if (value == null || value.equalsIgnoreCase("")) {
            return MonteroResourceManager.getInstance().getString("NOT_AVAILABLE", loginBean.getLocale());
        }
        return value;
    }

    public static MxNode getiLONode(int serverDevKey) {
        m_logger.enter("BPVXML.getiLONode(serverDevKey " + serverDevKey + ")");
        try {
            int iLOdevKey = NodeAssociationsManager.getDefaultManager().getAssociatedDeviceKey(serverDevKey, "MgmtProcToServer_Ilo");
            if (iLOdevKey > 0) {
                MxNode iLONode = MxNodeController.getDefaultController().getReadOnlyNodeObject(iLOdevKey);
                m_logger.exit("BPVXML.getiLONode");
                return iLONode;
            }
        }
        catch (MxException e) {
            m_logger.error("MxException in BPVXML.getiLONode");
        }
        m_logger.exit("BPVXML.getiLONode");
        return null;
    }

    private void addMoreToolTipInfo(MxNode node, Element common, MxLoginBean loginBean) {
        m_logger.enter("BPVXML.addMoreToolTipInfo(MxNode " + node.getNameString() + ",Element " + common + ",MxLoginBean " + loginBean);
        MxNode iLONode = BPVXML.getiLONode(node.getDeviceKey());
        if (iLONode != null) {
            common.addContent((Content)BPVXML.createElement("iLOIP", BPVXML.checkValue(iLONode.getWorkingAddress(), loginBean)));
        } else {
            common.addContent((Content)BPVXML.createElement("iLOIP", this.manager.getString("NOT_AVAILABLE", loginBean.getLocale())));
        }
        m_logger.fine("node.getWorkingAddress():" + node.getWorkingAddress());
        if (node.getWorkingAddress() != null) {
            this.createFirmWareInfo(node, common, loginBean);
        } else {
            m_logger.fine("This device is a Bare Metal blade." + iLONode);
            this.createFirmWareInfo(iLONode, common, loginBean);
        }
        m_logger.exit("BPVXML.addMoreToolTipInfo");
    }

    public static MxNode getRackNode(MxNode enclNode) {
        MxNode rackNode = null;
        m_logger.enter("BPVXML.getRackNode(MxNode" + enclNode.getNameString() + ")");
        try {
            NodeAssociationsManager nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            NodeAssociations nodeAssociations = nodeAssociationsManager.getNodeAssociations(enclNode.getDeviceKey());
            int rackDevKey = nodeAssociations.getParentDeviceKey();
            m_logger.fine("rack Device Key:" + rackDevKey);
            if (rackDevKey > 0) {
                m_logger.fine("IF stmt, rack found");
                rackNode = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(rackDevKey);
            } else {
                m_logger.fine("rack not found so get from device_associations");
                rackNode = BPVXML.getAssociatedDeviceNode(enclNode.getDeviceKey(), "EnclosureToRack");
                if (rackNode != null) {
                    m_logger.fine("rack node found with device_associations :" + rackNode.getNameString());
                }
            }
            return rackNode;
        }
        catch (MxException ex) {
            m_logger.fine("Rack not found." + (Object)((Object)ex));
            return null;
        }
    }

    public static MxNode getAssociatedDeviceNode(int enclDeviceKey, String asscType) {
        MxNode associatedDevice = null;
        NodeAssociationsManager nodeAssociationsManager = null;
        try {
            nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
        }
        catch (NodeAssociationsPersistenceException e) {
            // empty catch block
        }
        Vector associatedDeviceKeyVect = nodeAssociationsManager.getAssociatedDevicesUsingATNs(enclDeviceKey, asscType);
        int associatedDeviceKey = 0;
        if (associatedDeviceKeyVect.size() > 0) {
            Integer vectKey = (Integer)associatedDeviceKeyVect.elementAt(0);
            associatedDeviceKey = vectKey;
            try {
                associatedDevice = MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(associatedDeviceKey);
            }
            catch (MxUndefinedNodeException ex) {
                // empty catch block
            }
        }
        return associatedDevice;
    }

    private int getRackDeviceKeyFromMxNode() {
        int rackDeviceKey = -1;
        if (this.rackNode != null) {
            rackDeviceKey = this.rackNode.getDeviceKey();
        }
        m_logger.fine("Rack Device Key : " + rackDeviceKey);
        return rackDeviceKey;
    }

    public String getSwitchFirmwareVersion(MxNode node, MxLoginBean loginBean) {
        m_logger.enter("BPVXML.getSwitchFirmware version ");
        String name = MonteroResourceManager.getInstance().getString("xml.FirmwareVersion", loginBean.getLocale());
        String NOT_AVAILABLE = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
        StringBuffer strXML = new StringBuffer("<Data name='").append(name).append("' value='").append(NOT_AVAILABLE).append("'/>");
        if (node == null) {
            return strXML.toString();
        }
        try {
            String firmwareVersion = BPVXML.checkValue(MonteroSNMPUtils.getMIBDataValue("1.3.6.1.4.1.232.11.2.14.1.1.5.1[0]", node), loginBean);
            strXML = new StringBuffer("<Data name='").append(name).append("' value='").append(firmwareVersion).append("'/>");
            m_logger.enter("BPVXML.getSwitchFirmware version is " + strXML);
            return strXML.toString();
        }
        catch (Exception e) {
            strXML = new StringBuffer("<Data name='").append(name).append("' value='").append(NOT_AVAILABLE).append("'/>");
            m_logger.fine("Unable to load more tool tip info for P-Class Switch " + e.toString());
            return strXML.toString();
        }
    }

    public String getMoreToolTipInfo(MxNode node, MxLoginBean loginBean) {
        String NOT_AVAILABLE = this.manager.getString("NOT_AVAILABLE", loginBean.getLocale());
        StringBuffer strXML = new StringBuffer("<Status>Available</Status>");
        String[] attributeNames = new String[3];
        String[] attributeValues = new String[3];
        attributeNames[0] = MonteroResourceManager.getInstance().getString("xml.SysROMVersion", loginBean.getLocale());
        attributeNames[1] = MonteroResourceManager.getInstance().getString("xml.MgmtProcFMVersion", loginBean.getLocale());
        attributeNames[2] = MonteroResourceManager.getInstance().getString("xml.InsightMgmtVersion", loginBean.getLocale());
        for (int i = 0; i < 3; ++i) {
            attributeValues[i] = NOT_AVAILABLE;
        }
        try {
            if (node.getDeviceSubTypes().contains(NodeSubTypeMapper.PCLASS_SUBTYPE.toString()) && node.getDeviceType().equalsIgnoreCase("Switch")) {
                if (node == null) {
                    strXML = new StringBuffer("<Status>").append(NOT_AVAILABLE).append("</Status>");
                    return strXML.toString();
                }
                strXML.append(this.getSwitchFirmwareVersion(node, loginBean));
                return strXML.toString();
            }
            if (node.getDeviceSubTypes().contains(NodeSubTypeMapper.PCLASS_SUBTYPE.toString()) || node.getDeviceSubTypes().contains(NodeSubTypeMapper.CCLASS_SUBTYPE.toString())) {
                MxNode iLONode = BPVXML.getiLONode(node.getDeviceKey());
                m_logger.fine("node.getWorkingAddress():" + node.getWorkingAddress());
                if (node.getWorkingAddress() == null) {
                    node = iLONode;
                }
                if (node != null) {
                    MonteroSNMPUtils snmpUtils = new MonteroSNMPUtils(loginBean);
                    snmpUtils.getFirmwareDetails(node);
                    attributeValues[0] = BPVXML.checkValue(snmpUtils.getSysROMFMVer(), loginBean);
                    attributeValues[1] = BPVXML.checkValue(snmpUtils.getRemoteInsightROMFMVer(), loginBean);
                    attributeValues[2] = BPVXML.checkValue(snmpUtils.getInsightMgmtVersion(node), loginBean);
                }
                for (int i = 0; i < 3; ++i) {
                    strXML.append("<Data name='").append(attributeNames[i]).append("' value='");
                    strXML.append(attributeValues[i]).append("'/>");
                }
                m_logger.fine(" strXML is " + strXML);
                return strXML.toString();
            }
        }
        catch (Exception e) {
            m_logger.fine("Unable to load more tool tip info" + e.toString());
            strXML = new StringBuffer("<Status>Available</Status>");
            for (int i = 0; i < 3; ++i) {
                strXML.append("<Data name='").append(attributeNames[i]).append("' value='");
                strXML.append(attributeValues[i]).append("'/>");
            }
            return strXML.toString();
        }
        return "<Status>Not Available</Status>";
    }
}

