/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.portal;

import com.hp.mx.core.client.MxToolClient;
import com.hp.mx.core.daemon.MxInvalidTransactionException;
import com.hp.mx.core.subjects.usermanager.MxInvalidUserException;
import com.hp.mx.core.subjects.usermanager.MxUndefinedUserException;
import com.hp.mx.core.toolmanager.MxTool;
import com.hp.mx.exceptions.MxFailedAuthenticationException;
import com.hp.mx.portal.BladeSystemException;
import com.hp.mx.portal.ui.MxLoginBean;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.util.List;

public class MonteroBean {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(MonteroBean.class);
    private MxLoginBean m_loginBean = null;
    private MonteroSNMPUtils m_SNMPUtil = null;

    public void initialize(MxLoginBean loginBean) {
        if (this.m_loginBean == null) {
            this.m_loginBean = loginBean;
            this.m_SNMPUtil = new MonteroSNMPUtils(this.m_loginBean);
        }
    }

    public MxLoginBean getLoginBean() {
        return this.m_loginBean;
    }

    private MxTool getToolObj(String tId) throws BladeSystemException {
        LOGGER.enter("MonteroBean.getToolObj(" + tId + ")");
        MxToolClient toolClient = this.m_loginBean.getToolClient();
        try {
            List tools = toolClient.getToolsForSessionUser();
            int numTools = tools.size();
            MxTool tool = null;
            for (int i = 0; i < numTools; ++i) {
                tool = (MxTool)tools.get(i);
                if (!tool.getName().equals((Object)tId)) continue;
                LOGGER.fine("Tool object found returning");
                return tool;
            }
        }
        catch (MxInvalidTransactionException e) {
            LOGGER.fine("Error:", new Object[]{e});
        }
        catch (MxFailedAuthenticationException e) {
            LOGGER.fine("Error:", new Object[]{e});
        }
        catch (MxInvalidUserException e) {
            LOGGER.fine("Error:", new Object[]{e});
        }
        catch (MxUndefinedUserException e) {
            LOGGER.fine("Error:", new Object[]{e});
        }
        LOGGER.fine("Tool with Id not found:" + tId);
        throw new BladeSystemException("Tool with Id not found:" + tId);
    }

    public String getToolId(String tId) throws BladeSystemException {
        MxTool tool = this.getToolObj(tId);
        String toolStringID = tool.getClientAttribute("tool-id");
        String toolObjectID = tool.getObjectID().toString();
        return toolStringID == null ? toolObjectID : toolStringID;
    }

    public String getToolGUID(String tId) throws BladeSystemException {
        LOGGER.enter("MonteroBean.getToolGUID(" + tId + ")");
        MxTool tool = this.getToolObj(tId);
        return tool.getGUID().toString();
    }

    public MonteroSNMPUtils getSNMPUtil() {
        return this.m_SNMPUtil;
    }
}

