/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.polling;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.DeviceStatusSource;
import com.hp.mx.core.nodemanager.DeviceStatusType;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeStatus;
import com.hp.mx.core.nodemanager.NodeStatusManager;
import com.hp.mx.core.nodemanager.NodeStatusPersistenceException;
import com.hp.mx.core.nodemanager.NodeStatusSourceManager;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.tools.datacollection.http.oa.OADataManager;
import com.hp.mx.core.tools.datacollection.http.oa.OAException;
import com.hp.mx.core.tools.datacollection.http.oa.OLDevice;
import com.hp.mx.core.tools.datacollection.http.oa.OLEnclosure;
import com.hp.mx.core.tools.polling.HardwareStatusPollingIfc;
import com.hp.mx.core.tools.polling.HardwareStatusPollingTaskModel;
import com.hp.mx.utilities.DebugSubsystem;
import com.hp.mx.utilities.MonteroUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class StorageDevicePollingProtocol
implements HardwareStatusPollingIfc {
    public static DeviceStatusSource statusSrcHTTP;
    private static final DebugSubsystem LOGGER;

    public StorageDevicePollingProtocol() {
        statusSrcHTTP = NodeStatusSourceManager.getDefaultManager().getDeviceStatusSource("compaq.hmma.HTTPStatus");
    }

    public void initializePlugIn() {
    }

    public void startPolling(MxNode oaMxNode, HardwareStatusPollingTaskModel hsptm) {
        block8: {
            LOGGER.enter("StorageDevicePollingProtocol.startPolling()");
            LOGGER.fine("The device type :" + oaMxNode.getDeviceType());
            if (!oaMxNode.getDeviceSubTypes().contains(NodeSubTypeMapper.ONBOARD_ADMINISTRATOR_SUBTYPE.toString())) {
                LOGGER.fine("The storage hw status is polled at the time of OA.Thisdevice is not of type OA.");
                LOGGER.exit("StorageDevicePollingProtocol.startPolling()");
                return;
            }
            try {
                int enclosureDeviceKey;
                NodeAssociationsManager nam = NodeAssociationsManager.getDefaultManager();
                if (!nam.hasNodeAssociationByType("MgmtProcToEnclosure", oaMxNode.getDeviceKey()) || (enclosureDeviceKey = nam.getAssociatedDeviceKey(oaMxNode.getDeviceKey(), "MgmtProcToEnclosure")) <= 0) break block8;
                Vector serverDeviceKeys = nam.getAssociatedDevicesUsingATNs(enclosureDeviceKey, "ServerToEnclosure");
                OADataManager oaDataManager = null;
                for (int i = 0; i < serverDeviceKeys.size(); ++i) {
                    MxNode serverMxNode;
                    block9: {
                        serverMxNode = null;
                        try {
                            serverMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(Integer.parseInt(serverDeviceKeys.get(i).toString()));
                        }
                        catch (MxUndefinedNodeException nodeExcep) {
                            LOGGER.fine("MxNode with key does not exists.:" + serverDeviceKeys.get(i));
                            LOGGER.fine("Looking for the next deviceKey in the vector, if available.");
                            continue;
                        }
                        if (!serverMxNode.getDeviceType().equalsIgnoreCase("Storage")) continue;
                        try {
                            if (oaDataManager != null) break block9;
                            oaDataManager = new OADataManager(oaMxNode);
                        }
                        catch (OAException oaExcep) {
                            LOGGER.exception("Unable to fire OA XML query, Status pollingfailed for storage blades.Setting Unknown as the status.");
                            this.setStatus(DeviceStatusType.UNKNOWN.toString(), serverMxNode);
                            continue;
                        }
                    }
                    this.setStorageHwStatusUsingOAXML(oaDataManager, serverMxNode);
                }
            }
            catch (NodeAssociationsPersistenceException e) {
                LOGGER.exception("Unable to fire OA XML query, Status pollingdid failed for storage blades.");
            }
        }
        LOGGER.exit("StorageDevicePollingProtocol.startPolling()");
    }

    private void setStorageHwStatusUsingOAXML(OADataManager oaDataManager, MxNode storageMxNode) throws NodeAssociationsPersistenceException {
        LOGGER.enter("StorageDevicePollingProtocol.setStorageHwStatusUsingOAXML()");
        OLEnclosure olEnclosure = oaDataManager.getEnclosureDevice();
        List<OLDevice> bladeList = olEnclosure.getBladeList();
        OLDevice olDevice = null;
        NodeAssociations srvNodeAsscs = NodeAssociationsManager.getDefaultManager().getNodeAssociations(storageMxNode.getDeviceKey());
        int slotNumber = srvNodeAsscs.getSlotNumber();
        for (int i = 0; i < bladeList.size(); ++i) {
            olDevice = bladeList.get(i);
            if (olDevice.getDeviceSlot() != slotNumber) continue;
            String status = null;
            if (olDevice.getDeviceStatus() != null && olDevice.getDeviceStatus().length() > 0) {
                status = MonteroUtils.normaliseOAXMLSatus(olDevice.getDeviceStatus());
            }
            this.setStatus(status, storageMxNode);
            break;
        }
        LOGGER.exit("StorageDevicePollingProtocol.setStorageHwStatusUsingOAXML()");
    }

    private void setStatus(String deviceStatus, MxNode device) {
        LOGGER.enter("StorageDevicePollingProtocol.setStatus(" + deviceStatus + "," + device + ")");
        NodeStatus nodeStatus = new NodeStatus(device.getGUID());
        HashMap statusMap = new HashMap(1);
        nodeStatus.setStatusValues(statusMap);
        nodeStatus.getStatusValues().clear();
        if (deviceStatus != null) {
            nodeStatus.getStatusValues().put(statusSrcHTTP, DeviceStatusType.getStatusTypeByName((String)deviceStatus));
            LOGGER.fine("The status of " + device.getNameString() + "\tis " + DeviceStatusType.getStatusTypeByName((String)deviceStatus));
        } else {
            nodeStatus.getStatusValues().put(statusSrcHTTP, DeviceStatusType.getStatusTypeByVal((int)0));
            LOGGER.fine("The status of " + device.getNameString() + "\tis set as Unknown.");
        }
        try {
            NodeStatusManager.getDefaultManager().update(nodeStatus);
        }
        catch (NodeStatusPersistenceException e) {
            LOGGER.exception("Exception while http status polling of the storage device from OA XML");
        }
        LOGGER.exit("StorageDevicePollingProtocol.setStatus(" + deviceStatus + "," + device + ")");
    }

    static {
        LOGGER = new DebugSubsystem(StorageDevicePollingProtocol.class);
    }
}

