/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.tools.datacollection.http.iLO.Blade;
import com.hp.mx.core.tools.datacollection.http.iLO.ILO;
import com.hp.mx.core.tools.datacollection.http.iLO.ILODataManager;
import com.hp.mx.core.tools.datacollection.http.iLO.ILOException;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerUtil;
import com.hp.mx.core.tools.identification.associations.HandlerException;
import com.hp.mx.core.tools.identification.associations.IloAssociationDataHandler;
import com.hp.mx.core.utilities.UniqueIdentifierUtility;
import com.hp.mx.exceptions.MxException;
import com.hp.mx.utilities.DebugSubsystem;

public class TahitiAssociationHandler
extends IloAssociationDataHandler {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(TahitiAssociationHandler.class);

    public TahitiAssociationHandler(MxNode node) {
        super(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAssociationData(MxNode node, DeviceIdentificationData idInfo) {
        LOGGER.enter("TahitiAssociationHandler.getAssociatedData(" + node + "," + idInfo + ")");
        try {
            while (!NodeAssociationsManager.isWriteLockForAssociationsAvailable()) {
                Thread.sleep(100L);
            }
            if (node.getDeviceSubTypes().contains(NodeSubTypeMapper.BS_BMP_SUBTYPE.toString())) {
                try {
                    ILODataManager iLODataManager = new ILODataManager(node);
                    super.performCCLASSBladeILOAssociations(iLODataManager, node, "MgmtProcToServer_IPF");
                    LOGGER.fine("**********SUCCESSFULLY PERFORMED ASSOCIATIONS FOR ILO " + node.getWorkingAddress() + "**********");
                }
                catch (HandlerException e) {
                    LOGGER.error("****************UNABLE TO ASSOCIATE ILO " + node.getWorkingAddress() + " WITH ITS ENCLOSURE. PLEASE ENSURE ILO XML HAS GOT ENCLOSURE UUID, RACK UUID AND RACK TOPOLOGY IN IT****************");
                    LOGGER.error("HandlerException in TahitiAssociationHandler.performMPAssociation: " + e);
                    LOGGER.exception((Throwable)e);
                }
                catch (ILOException e) {
                    LOGGER.error("********ERROR IN PARSING ILO XML. PLEASE ENSURE ILO " + node.getWorkingAddress() + " IS UP AND HAS GOT LATEST FIRMWARE INSTALLED IN IT*********");
                    LOGGER.error("ILOException in TahitiAssociationHandler.performMPAssociation: " + e);
                    LOGGER.exception((Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("****************TahitiAssociationHandler.getAssociatedData UNABLE TO GET RELATIONSHIP LOCK FOR ILO " + node.getWorkingAddress() + " PLEASE DISCOVER THIS ILO AFTER SOMETIME****************");
            LOGGER.error("InterruptedException in TahitiAssociationHandler.getAssociationData: " + e);
            LOGGER.exception((Throwable)e);
        }
        finally {
            NodeAssociationsManager.releaseWriteLock();
        }
        LOGGER.exit("TahitiAssociationHandler.getAssociationData(" + node + "," + idInfo + ")");
    }

    void storeAttributes(MxNode iLOMxNode, Blade blade) {
        LOGGER.enter("TahitiAssociationHandler.storeAttributes(" + iLOMxNode + "," + blade + ")");
        String serverUUID = blade.getUUID();
        try {
            if (serverUUID != null && serverUUID.length() > 0) {
                LOGGER.fine("TahitiAssociationHandler.storeAttributes Storing Unique identifier of the Server on the ILO MxNode,This will let the association to happen when the server is disovered after ILO." + serverUUID);
                String srvUniqueIdent = UniqueIdentifierUtility.normalizeUniqueID((String)serverUUID, (boolean)false, (boolean)true);
                if (srvUniqueIdent != null && srvUniqueIdent.length() > 0) {
                    iLOMxNode.setClientAttribute(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), srvUniqueIdent);
                    MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), iLOMxNode, false);
                    LOGGER.fine("Unique Identifer of the server is set on the ILO Node,Assocaition will be formed using Unique Identifer when serveris discovered." + blade.getBSN());
                }
            } else if (blade.getBSN() != null && blade.getBSN().length() > 0) {
                iLOMxNode.setClientAttribute(this.myNodeRelationshipManager.getAssociatedSerialNumberDevicePropertyString(), blade.getBSN());
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), iLOMxNode, false);
                LOGGER.fine("Serial number of the server is set on the ILO Node,Assocaition will be formed using serial number when serveris discovered." + blade.getBSN());
            } else {
                LOGGER.error("The UUID and the serial number of Tahiti Server from ILO XML is null and either one of them is a must to form association between ILO and Server from ILO XML. Association failed for Server and MP.");
            }
        }
        catch (MxException me) {
            LOGGER.error("TahitiAssociationHandler.storeAttributes Failed,Association btw Server and ILOwill not happen.");
            LOGGER.exception((Throwable)me);
        }
        LOGGER.exit("TahitiAssociationHandler.storeAttributes(" + iLOMxNode + "," + blade + ")");
    }

    String getNormalisedUUID(String srvAgentUUID) {
        return UniqueIdentifierUtility.normalizeUniqueID((String)srvAgentUUID, (boolean)false, (boolean)true);
    }

    MxNode getMxNodeByUniqueIdentifier(Blade blade) {
        LOGGER.enter("IloAssociationDataHandler.getMxNodeByUniqueIdentifier(" + blade + ")");
        String serverAgentUUID = blade.getUUID();
        String srvUniqueIdent = null;
        MxNode deviceMxNode = null;
        if (serverAgentUUID != null) {
            srvUniqueIdent = UniqueIdentifierUtility.normalizeUniqueID((String)serverAgentUUID, (boolean)false, (boolean)true);
            try {
                deviceMxNode = MxNodeController.getDefaultControllerNoEx().getNodeByNormUniqueIDENT(srvUniqueIdent);
            }
            catch (MxUndefinedNodeException ex) {
                LOGGER.fine("IloAssociationDataHandler.getMxNodeByUniqueIdentifier MxUndefinedNodeException: " + (Object)((Object)ex));
                LOGGER.fine("IloAssociationDataHandler.getMxNodeByUniqueIdentifier Unable to get server node by Unique Identifier: " + srvUniqueIdent);
            }
        }
        return deviceMxNode;
    }

    void updateCCLASSBladeILOData(MxNode iLOMxNode, ILO iLO) {
    }

    public void cleanUpAssociationData(MxNode node) {
        LOGGER.enter("TahitiAssociationHandler.cleanUpAssociationData(" + node + ")");
        boolean isCleanUpReqd = false;
        if (node.getDeviceType().equalsIgnoreCase("MgmtProc") && node.getDeviceSubTypes().contains(NodeSubTypeMapper.BS_BMP_SUBTYPE.toString())) {
            isCleanUpReqd = true;
        }
        if (isCleanUpReqd) {
            LOGGER.fine("TahitiAssociationHandler.cleanUpAssociationData Performing Cleaup");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(node.getDeviceKey(), "MgmtProcToServer_IPF");
            this.myNodeRelationshipManager.deleteDimensionInformation(node.getDeviceKey(), "MgmtProcToServer_IPF");
            this.myNodeRelationshipManager.resetDeviceAssociations(node.getDeviceKey());
        }
        LOGGER.exit("TahitiAssociationHandler.cleanUpAssociationData(" + node + ")");
    }

    public NodeAssociations loadAssociationDataFromDb(MxNode node) {
        LOGGER.enter("TahitiAssociationHandler.loadAssociationDataFromDb(" + node + ")");
        NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(node.getDeviceKey(), true);
        boolean loadRequired = false;
        if (node.getDeviceType().equalsIgnoreCase("MgmtProc") && node.getDeviceSubTypes().contains(NodeSubTypeMapper.BS_BMP_SUBTYPE.toString())) {
            loadRequired = true;
        }
        if (loadRequired) {
            na = AssociationHandlerUtil.loadAssocFrmDB(node.getDeviceKey(), this.myNodeRelationshipManager);
        }
        LOGGER.exit("TahitiAssociationHandler.loadAssociationDataFromDb(" + node + ")");
        return na;
    }
}

