/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.tools.identification.associations;

import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.daemon.MxCoreTransaction;
import com.hp.mx.core.daemon.MxTransaction;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.MxUndefinedNodeException;
import com.hp.mx.core.nodemanager.NodeAssociations;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.nodemanager.NodeSubTypeMapper;
import com.hp.mx.core.querymanager.TableModelHandler;
import com.hp.mx.core.tools.identification.DeviceIdentificationData;
import com.hp.mx.core.tools.identification.associations.SnmpRackMibHandler;
import com.hp.mx.database.DatabaseManager;
import com.hp.mx.portal.utils.MonteroSNMPUtils;
import com.hp.mx.utilities.DebugSubsystem;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SwitchAssociationDataHandler
extends SnmpRackMibHandler {
    private static final DebugSubsystem LOGGER = new DebugSubsystem(SwitchAssociationDataHandler.class);
    private static int SW_PRESENT_BOTH = 3;
    private static int SW_PRESENT_LEFT_ONLY = 2;
    private static int SW_PRESENT_RIGHT_ONLY = 1;
    private static int SW_PRESENT_NONE = 0;
    private String associationType = "";

    public SwitchAssociationDataHandler(MxNode d) {
        super(d);
    }

    public void getAssociationData(MxNode d, DeviceIdentificationData idInfo) {
        LOGGER.enter("SwitchAssociationDataHandler.getAssociationData for " + d.getNameString());
        if (!d.getDeviceType().equals("Switch")) {
            LOGGER.fine(d.getNameString() + " is not a switch; clean up.");
            this.cleanUpAssociationData(d);
            return;
        }
        boolean isSNMPSupported = MonteroSNMPUtils.checkSNMP(d);
        if (!isSNMPSupported) {
            LOGGER.fine("SwicthAssociationDataHandler.getAssociationData for (" + d + ")" + "SNMP Not Supported");
            return;
        }
        String productModel = d.getModel();
        this.getRackAttributesFromTheMib();
        LOGGER.fine("SwitchAssociationDataHandler.productModel " + productModel);
        if (productModel.toLowerCase().indexOf("c-class") > -1) {
            LOGGER.fine("This is a c-Class switch hence return");
            return;
        }
        if (productModel.equalsIgnoreCase("McDATA 4Gb SAN Switch for HP p-Class BladeSystem") || productModel.equalsIgnoreCase("Brocade 4Gb SAN Switch for HP p-Class BladeSystem")) {
            this.getCommonEnclosureAttributesAndTopologyFromTheSANMib();
            d.setClientAttribute("LOCATION", "RearUpperCube");
        } else {
            this.getCommonEnclosureAttributesAndTopologyFromTheMib();
        }
        this.getSwitchAttributesFromTheMib();
        while (!NodeAssociationsManager.isWriteLockForAssociationsAvailable()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOGGER.exception("InterruptedException while waiting for association write lock");
            }
        }
        if (productModel.toUpperCase().indexOf("P-CLASS") != -1) {
            d.addDeviceSubType(NodeSubTypeMapper.PCLASS_SUBTYPE.toString());
        } else if (productModel.toUpperCase().indexOf("E-CLASS") != -1) {
            d.addDeviceSubType(NodeSubTypeMapper.ECLASS_SUBTYPE.toString());
        }
        if (this.getLeftSwitchSerialNumber() != null) {
            d.setSerialNumber(this.getLeftSwitchSerialNumber());
        } else if (this.getRightSwitchSerialNumber() != null) {
            d.setSerialNumber(this.getRightSwitchSerialNumber());
        }
        this.doRackEnclosureDeviceProcessing(d);
        this.myNodeRelationshipManager.update(this.myNodeRelationships);
        NodeAssociationsManager.releaseWriteLock();
        LOGGER.exit("SwitchAssociationDataHandler.getAssociationData for " + d.getNameString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeAssociations loadAssociationDataFromDb(MxNode device) {
        LOGGER.enter("SwitchAssociationDataHandler.loadAssociationDataFromDb for " + device.getNameString());
        Statement myStatement = null;
        Connection myConnection = null;
        ResultSet myResultSet = null;
        int deviceDbKey = device.getDeviceKey();
        NodeAssociations na = this.myNodeRelationshipManager.getNodeAssociations(deviceDbKey, true);
        try {
            myConnection = DatabaseManager.getDefaultDatabase().getConnection("DeviceAssociation.loadDeviceAssociations");
            myStatement = myConnection.createStatement();
            myResultSet = myStatement.executeQuery("select * from device_associations where devicekey1=" + deviceDbKey + " and AssociationTypeNumber='" + "SwitchToEnclosure" + "'");
            int deviceKey1 = -1;
            int deviceKey2 = -1;
            while (myResultSet.next()) {
                deviceKey1 = myResultSet.getInt(1);
                deviceKey2 = myResultSet.getInt(2);
                if (device == null || !device.getDeviceType().equals("Switch") || deviceKey1 != deviceDbKey) continue;
                na.setInContainer(true);
                na.setParent(deviceKey2);
                na.setTheAssociation(deviceKey1, deviceKey2, "SwitchToEnclosure", false);
            }
            LOGGER.fine("loaded, In container flag is now " + na.inContainer() + " parent " + na.getParent());
        }
        catch (SQLException sqle) {
            LOGGER.exception((Throwable)sqle);
        }
        finally {
            try {
                myResultSet.close();
                myStatement.close();
            }
            catch (SQLException sqlE) {
                LOGGER.exception("SQLException trying to close resultSet and statement");
            }
            this.myNodeRelationshipManager.releaseConnections(myConnection, myStatement, myResultSet);
        }
        na = this.myNodeRelationshipManager.loadDeviceDimensionInfo(deviceDbKey, na);
        this.myNodeRelationshipManager.update(na);
        LOGGER.exit("SwitchAssociationDataHandler.loadAssociationDataFromDb for " + device.getNameString());
        return na;
    }

    private void doRackEnclosureDeviceProcessing(MxNode d) {
        LOGGER.enter("SwitchAssociationDataHandler.doRackEnclosureDeviceProcessing for " + d.getNameString());
        this.myNodeRelationships.setSlotNumber(this.getSwitchSlot());
        LOGGER.finer("set slot for switch" + d.getNameString() + " : " + this.getSwitchSlot());
        this.myNodeRelationships.setSource(this.associationType);
        LOGGER.finer("set source for switch" + d.getNameString() + " : " + this.associationType);
        NodeAssociations theEnclNodeAssociations = this.getEnclosureInformation(this.getContainerEnclosureInformation(), this.getRackName(), this.getRuid());
        if (theEnclNodeAssociations != null) {
            LOGGER.finer("getEnclosureInformation did not return null");
            int deviceKey = this.device.getDeviceKey();
            int theEnclDeviceKey = theEnclNodeAssociations.getDeviceKey();
            try {
                d.setEnclosureName(MxNodeController.getDefaultControllerNoEx().getReadOnlyNodeObject(theEnclDeviceKey).getNameString());
            }
            catch (MxUndefinedNodeException e) {
                LOGGER.fine("Exception while updating enclosure name on server" + (Object)((Object)e));
                e.printStackTrace();
            }
            this.myNodeRelationships.setTheAssociation(deviceKey, theEnclDeviceKey, "SwitchToEnclosure", false);
            LOGGER.finer("set switch-encl association between " + deviceKey + " and " + theEnclDeviceKey);
            this.addDeviceToTopologyTree(theEnclNodeAssociations, deviceKey);
            if (this.getLeftSwitchPresent()) {
                theEnclNodeAssociations.setHasLeftSwitch(true);
                theEnclNodeAssociations.setHasLeftSwitchSlot(true);
            } else if (this.getRightSwitchPresent()) {
                theEnclNodeAssociations.setHasRightSwitch(true);
                theEnclNodeAssociations.setHasRightSwitchSlot(true);
            }
            this.myNodeRelationships.setInContainer(true);
            this.myNodeRelationships.setParent(theEnclDeviceKey);
            if (this.getLeftSwitchPresent() && this.getRightSwitchPresent()) {
                theEnclNodeAssociations.setSwitchApis(SW_PRESENT_BOTH);
            } else if (this.getLeftSwitchPresent() && !this.getRightSwitchPresent()) {
                theEnclNodeAssociations.setSwitchApis(SW_PRESENT_LEFT_ONLY);
            } else if (!this.getLeftSwitchPresent() && this.getRightSwitchPresent()) {
                theEnclNodeAssociations.setSwitchApis(SW_PRESENT_RIGHT_ONLY);
            } else if (!this.getLeftSwitchPresent() && !this.getRightSwitchPresent()) {
                theEnclNodeAssociations.setSwitchApis(SW_PRESENT_NONE);
            }
            LOGGER.fine("LeftSwitchPresent in Rack enclosure topology handler : " + this.getLeftSwitchPresent());
            LOGGER.fine("RightSwitchPresent in rack enclosure topology handler : " + this.getRightSwitchPresent());
            theEnclNodeAssociations.setSource("Enclosure");
            NodeAssociations theRackNodeAssociations = this.getRackInformation(this.getRackName(), this.getRuid(), theEnclDeviceKey);
            if (this.getRuid() != null) {
                this.storeTopologyInformation(this.getTopology(), this.getRuid());
            }
            if (this.getTheRackDevice() != null) {
                this.addNodeTypeSubType(this.getTheRackDevice(), NodeSubTypeMapper.PCLASS_SUBTYPE.toString());
                this.getTheRackDevice().setModel("Rack");
            }
            if (theRackNodeAssociations != null && theRackNodeAssociations != null) {
                this.addTreeNodeToTopologyTree(theRackNodeAssociations, theEnclDeviceKey, null, null);
                this.myNodeRelationshipManager.update(theRackNodeAssociations);
            }
            this.myNodeRelationshipManager.update(theEnclNodeAssociations);
            this.myNodeRelationshipManager.update(this.myNodeRelationships);
            if (this.getTheRackDevice() != null) {
                LOGGER.finer("set rack name " + this.getRackName() + " for switch " + d.getNameString());
                try {
                    NodeAssociationsManager.getDefaultManager().reLoadDeviceAssociations(this.getTheRackDevice().getDeviceKey());
                }
                catch (NodeAssociationsPersistenceException e) {
                    LOGGER.exception((Throwable)e);
                }
                this.updateDevContainerAndRoleNames(this.getTheRackDevice());
            }
            try {
                MxNodeController.getDefaultControllerNoEx().modifyNode((MxTransaction)new MxCoreTransaction(), d, false);
            }
            catch (Exception e) {
                LOGGER.exception((Throwable)e);
            }
        }
        LOGGER.exit("SwitchAssociationDataHandler.doRackEnclosureDeviceProcessing for " + d.getNameString());
    }

    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    public String getUIStringToDisplayInList(String associationType, String language) {
        return "";
    }

    public boolean shouldBeInList(String associationType) {
        return true;
    }

    public NodeAssociations buildContainerTree(NodeAssociations myAssoc, MxNode node1, MxNode node2) {
        return myAssoc;
    }

    public void cleanUpAssociationData(MxNode d) {
        LOGGER.enter("SwitchAssociationDataHandler.cleanUpAssociationData for " + d.getNameString());
        try {
            this.myNodeRelationshipManager = NodeAssociationsManager.getDefaultManager();
            int associatedDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(d.getDeviceKey(), "SwitchToEnclosure");
            int associatedRackDeviceKey = this.myNodeRelationshipManager.getAssociatedDeviceKey(associatedDeviceKey, "EnclosureToRack");
            this.myNodeRelationshipManager.deleteBothEntriesForThisDeviceAndAssocType(d.getDeviceKey(), "SwitchToEnclosure");
            this.myNodeRelationshipManager.deleteDimensionInformation(d.getDeviceKey(), this.associationType);
            this.myNodeRelationshipManager.resetDeviceAssociations(associatedDeviceKey);
            this.myNodeRelationshipManager.resetDeviceAssociations(associatedRackDeviceKey);
            TableModelHandler.notifyViewTopoHasChanged();
        }
        catch (NodeAssociationsPersistenceException nape) {
            LOGGER.exception((Throwable)nape);
        }
        LOGGER.exit("SwitchAssociationDataHandler.cleanUpAssociationData for " + d.getNameString());
    }
}

